/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.array;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.func.array.ArrayFn;
import org.basex.query.iter.Iter;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.SeqType;
import org.basex.util.Checks;
import org.basex.util.InputInfo;

public final class ArrayJoin
extends ArrayFn {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Expr expr = this.exprs[0];
        if (expr.seqType().zeroOrOne()) {
            Item item = expr.item(qc, this.info);
            return item == Empty.VALUE ? XQArray.empty() : this.toArray(item);
        }
        Iter iter = expr.iter(qc);
        Item item = iter.next();
        if (item == null) {
            return XQArray.empty();
        }
        XQArray fst = this.toArray(item);
        item = iter.next();
        if (item == null) {
            return fst;
        }
        XQArray snd = this.toArray(item);
        item = iter.next();
        if (item == null) {
            return fst.concat(snd);
        }
        ArrayBuilder builder = new ArrayBuilder().append(fst).append(snd);
        do {
            builder.append(this.toArray(item));
        } while ((item = qc.next(iter)) != null);
        return builder.freeze();
    }

    @Override
    protected Expr opt(CompileContext cc) throws QueryException {
        if (this.exprs[0].seqType().type instanceof ArrayType) {
            SeqType st;
            if (this.exprs[0] instanceof List && ((Checks<Expr>)arg -> arg == XQArray.empty()).any((Expr[])this.exprs[0].args())) {
                ExprList list = new ExprList();
                for (Expr arg2 : this.exprs[0].args()) {
                    if (arg2 == XQArray.empty()) continue;
                    list.add(arg2);
                }
                this.exprs[0] = List.get(cc, this.info, (Expr[])list.finish());
            }
            if ((st = this.exprs[0].seqType()).one()) {
                return this.exprs[0];
            }
            this.exprType.assign(st.type);
        }
        return this;
    }
}

