/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.archive;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import org.basex.io.out.ArrayOutput;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.func.archive.ArchiveIn;
import org.basex.query.func.archive.GZIPOut;
import org.basex.query.func.archive.ZIPOut;
import org.basex.util.InputInfo;

abstract class ArchiveOut
implements Closeable {
    final ArrayOutput ao = new ArrayOutput();
    final byte[] data = new byte[4096];

    ArchiveOut() {
    }

    static ArchiveOut get(String format, InputInfo ii) throws QueryException {
        try {
            if (format.equals("zip")) {
                return new ZIPOut();
            }
            if (format.equals("gzip")) {
                return new GZIPOut();
            }
        }
        catch (IOException ex) {
            throw QueryError.ARCHIVE_ERROR_X.get(ii, ex);
        }
        throw QueryError.ARCHIVE_FORMAT.get(ii, new Object[0]);
    }

    public abstract void level(int var1);

    public abstract void write(ArchiveIn var1) throws IOException;

    public abstract void write(ZipEntry var1, byte[] var2) throws IOException;

    @Override
    public abstract void close();

    final byte[] finish() {
        this.close();
        return this.ao.finish();
    }

    public final void write(ArchiveIn in, OutputStream out) throws IOException {
        int c;
        while ((c = in.read(this.data)) != -1) {
            out.write(this.data, 0, c);
        }
    }
}

