/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.basex.core.MainOptions;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.ann.Ann;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.expr.TypeCheck;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.gflwor.GFLWOR;
import org.basex.query.expr.gflwor.Let;
import org.basex.query.func.StaticFunc;
import org.basex.query.func.TypedFunc;
import org.basex.query.func.XQFunctionExpr;
import org.basex.query.scope.Scope;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.Value;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public final class Closure
extends Single
implements Scope,
XQFunctionExpr {
    private final QNm name;
    private final Var[] params;
    private SeqType declType;
    private AnnList anns;
    private boolean updating;
    private final EnumMap<Flag, Boolean> map = new EnumMap(Flag.class);
    private boolean compiled;
    private final VarScope vs;
    private final Map<Var, Expr> global;

    public Closure(InputInfo info, SeqType declType, Var[] params, Expr expr, AnnList anns, Map<Var, Expr> global, VarScope vs) {
        this(info, null, declType, params, expr, anns, global, vs);
    }

    Closure(InputInfo info, QNm name, SeqType declType, Var[] params, Expr expr, AnnList anns, Map<Var, Expr> global, VarScope vs) {
        super(info, expr, SeqType.FUNCTION_O);
        this.name = name;
        this.params = params;
        this.declType = declType == null || declType.eq(SeqType.ITEM_ZM) ? null : declType;
        this.anns = anns;
        this.global = global == null ? Collections.emptyMap() : global;
        this.vs = vs;
    }

    @Override
    public int arity() {
        return this.params.length;
    }

    @Override
    public QNm funcName() {
        return this.name;
    }

    @Override
    public QNm paramName(int pos) {
        return this.params[pos].name;
    }

    @Override
    public FuncType funcType() {
        return FuncType.get(this.anns, this.declType, this.params);
    }

    @Override
    public AnnList annotations() {
        return this.anns;
    }

    @Override
    public void comp(CompileContext cc) throws QueryException {
        this.compile(cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        if (this.compiled) {
            return this;
        }
        this.compiled = true;
        this.checkUpdating();
        for (Map.Entry<Var, Expr> entry : this.global.entrySet()) {
            Expr bound = entry.getValue().compile(cc);
            entry.setValue(bound);
            entry.getKey().refineType(bound.seqType(), cc);
        }
        cc.pushScope(this.vs);
        try {
            this.expr = this.expr.compile(cc);
        }
        catch (QueryException qe) {
            this.expr = cc.error(qe, this.expr);
        }
        finally {
            cc.removeScope(this);
        }
        this.expr.markTailCalls(cc);
        return this.optimize(cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        cc.pushScope(this.vs);
        try {
            Iterator<Map.Entry<Var, Expr>> iter = this.global.entrySet().iterator();
            HashMap<Var, Expr> add = null;
            int limit = cc.qc.context.options.get(MainOptions.INLINELIMIT);
            while (iter.hasNext()) {
                Closure cl;
                Map.Entry<Var, Expr> entry = iter.next();
                Var var = entry.getKey();
                Expr ex = entry.getValue();
                Expr inline = null;
                if (ex instanceof Value) {
                    inline = var.checkType((Value)ex, cc.qc, true);
                } else if (ex instanceof Closure && !(cl = (Closure)ex).has(Flag.NDT) && cl.global.size() < 5 && this.expr.count(var) != VarUsage.MORE_THAN_ONCE && cl.exprSize() < limit) {
                    cc.info("inline %", entry);
                    for (Map.Entry<Var, Expr> expr2 : cl.global.entrySet()) {
                        Var var2 = cc.copy(expr2.getKey(), null);
                        if (add == null) {
                            add = new HashMap<Var, Expr>();
                        }
                        add.put(var2, expr2.getValue());
                        expr2.setValue(new VarRef(cl.info, var2).optimize(cc));
                    }
                    inline = cl;
                }
                if (inline == null) continue;
                this.expr = new InlineContext(var, inline, cc).inline(this.expr);
                iter.remove();
            }
            if (add != null) {
                this.global.putAll(add);
            }
        }
        catch (QueryException qe) {
            this.expr = cc.error(qe, this.expr);
        }
        finally {
            cc.removeScope(this);
        }
        SeqType st = this.expr.seqType();
        SeqType dt = this.declType == null || st.instanceOf(this.declType) ? st : this.declType;
        this.exprType.assign(FuncType.get(this.anns, dt, this.params));
        return this.global.isEmpty() && this.expr.size() <= 262144L ? cc.preEval(this) : this;
    }

    @Override
    public VarUsage count(Var var) {
        Expr ex;
        VarUsage all = VarUsage.NEVER;
        Iterator<Expr> iterator = this.global.values().iterator();
        while (iterator.hasNext() && (all = all.plus((ex = iterator.next()).count(var))) != VarUsage.MORE_THAN_ONCE) {
        }
        return all;
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        boolean changed = false;
        for (Map.Entry<Var, Expr> entry : this.global.entrySet()) {
            Expr inlined = entry.getValue().inline(ic);
            if (inlined == null) continue;
            changed = true;
            entry.setValue(inlined);
        }
        if (!changed) {
            return null;
        }
        this.map.clear();
        return this.optimize(ic.cc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        VarScope innerScope = new VarScope(this.vs.sc);
        HashMap<Var, Expr> outer = new HashMap<Var, Expr>();
        this.global.forEach((key, value) -> outer.put((Var)key, value.copy(cc, vm)));
        cc.pushScope(innerScope);
        try {
            IntObjMap<Var> innerVars = new IntObjMap<Var>();
            this.vs.copy(cc, innerVars);
            HashMap<Var, Expr> nl = new HashMap<Var, Expr>();
            outer.forEach((key, value) -> nl.put((Var)innerVars.get(key.id), (Expr)value));
            Var[] prms = (Var[])this.params.clone();
            int pl = prms.length;
            for (int p = 0; p < pl; ++p) {
                prms[p] = innerVars.get(prms[p].id);
            }
            Expr ex = this.expr.copy(cc, innerVars);
            ex.markTailCalls(null);
            Closure closure = this.copyType(new Closure(this.info, this.name, this.declType, prms, ex, this.anns, nl, cc.vs()));
            return closure;
        }
        finally {
            cc.removeScope();
        }
    }

    @Override
    public Expr inline(Expr[] exprs, CompileContext cc) throws QueryException {
        if (!StaticFunc.inline(cc, this.anns, this.expr) || this.expr.has(Flag.CTX)) {
            return null;
        }
        cc.info("inline %", this);
        LinkedList<Clause> clauses = new LinkedList<Clause>();
        IntObjMap<Var> vm = new IntObjMap<Var>();
        int pl = this.params.length;
        for (int p = 0; p < pl; ++p) {
            clauses.add(new Let(cc.copy(this.params[p], vm), exprs[p]).optimize(cc));
        }
        for (Map.Entry<Var, Expr> entry : this.global.entrySet()) {
            clauses.add(new Let(cc.copy(entry.getKey(), vm), entry.getValue()).optimize(cc));
        }
        Expr body = this.expr.copy(cc, vm).optimize(cc);
        Expr rtrn = this.declType == null ? body : new TypeCheck(this.vs.sc, this.info, body, this.declType, true).optimize(cc);
        return clauses.isEmpty() ? rtrn : new GFLWOR(this.info, clauses, rtrn).optimize(cc);
    }

    @Override
    public FuncItem item(QueryContext qc, InputInfo ii) throws QueryException {
        Expr checked;
        Expr body;
        if (this.global.isEmpty()) {
            body = this.expr;
        } else {
            LinkedList<Clause> clauses = new LinkedList<Clause>();
            for (Map.Entry<Var, Expr> entry : this.global.entrySet()) {
                clauses.add(new Let(entry.getKey(), entry.getValue().value(qc)));
            }
            body = new GFLWOR(this.info, clauses, this.expr);
        }
        SeqType argType = body.seqType();
        if (this.declType == null || argType.instanceOf(this.declType)) {
            checked = body;
        } else if (body instanceof FuncItem && this.declType.type instanceof FuncType) {
            if (!this.declType.occ.check(1L)) {
                throw QueryError.typeError(body, this.declType, null, this.info, true);
            }
            checked = ((FuncItem)body).coerceTo((FuncType)this.declType.type, qc, this.info, true);
        } else if (body instanceof Value) {
            Value value = (Value)body;
            checked = this.declType.instance(value) ? value : this.declType.promote(value, null, qc, this.vs.sc, this.info, false);
        } else {
            if (argType.type.instanceOf(this.declType.type) && argType.occ.intersect(this.declType.occ) == null && !body.has(Flag.NDT)) {
                throw QueryError.typeError(body, this.declType, null, this.info, true);
            }
            checked = new TypeCheck(this.vs.sc, this.info, body, this.declType, true);
        }
        FuncType type = (FuncType)this.seqType().type;
        return new FuncItem(this.vs.sc, this.anns, this.name, this.params, type, checked, this.vs.stackSize(), this.info);
    }

    @Override
    public boolean has(Flag ... flags) {
        if (Flag.UPD.in(flags)) {
            return false;
        }
        ArrayList<Flag> flgs = new ArrayList<Flag>();
        for (Object flag2 : flags) {
            if (this.map.containsKey(flag2)) continue;
            this.map.put((Flag)((Object)flag2), Boolean.FALSE);
            flgs.add((Flag)((Object)flag2));
        }
        for (Flag flag : flgs) {
            Object flag2;
            boolean f = false;
            flag2 = this.global.values().iterator();
            while (flag2.hasNext()) {
                Expr ex = (Expr)flag2.next();
                f = f || ex.has(flag);
            }
            this.map.put(flag, f || this.expr.has(flag));
        }
        for (Object flag2 : flags) {
            if (!this.map.get(flag2).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        for (Expr ex : this.global.values()) {
            if (ex.inlineable(ic)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(ASTVisitor visitor) {
        for (Map.Entry<Var, Expr> entry : this.global.entrySet()) {
            if (entry.getValue().accept(visitor) && visitor.declared(entry.getKey())) continue;
            return false;
        }
        for (Var var : this.params) {
            if (visitor.declared(var)) continue;
            return false;
        }
        return this.expr.accept(visitor);
    }

    @Override
    public void checkUp() throws QueryException {
        this.checkUpdating();
        if (this.updating) {
            this.expr.checkUp();
            if (this.declType != null && !this.declType.zero()) {
                throw QueryError.UUPFUNCTYPE.get(this.info, new Object[0]);
            }
        }
    }

    @Override
    public boolean vacuous() {
        return this.declType != null && this.declType.zero() && !this.has(Flag.UPD);
    }

    @Override
    public boolean vacuousBody() {
        return this.vacuous();
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        for (Expr ex : this.global.values()) {
            if (ex.accept(visitor)) continue;
            return false;
        }
        return visitor.inlineFunc(this);
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (Expr ex : this.global.values()) {
            size += ex.exprSize();
        }
        return size + this.expr.exprSize();
    }

    @Override
    public boolean compiled() {
        return this.compiled;
    }

    public Iterator<Map.Entry<Var, Expr>> globalBindings() {
        return this.global.entrySet().iterator();
    }

    void adoptSignature(FuncType ft) {
        this.anns = ft.anns;
        int pl = this.params.length;
        for (int p = 0; p < pl; ++p) {
            this.params[p].declType = ft.argTypes[p];
        }
        SeqType dt = ft.declType;
        if (!dt.eq(SeqType.ITEM_ZM)) {
            this.declType = dt;
        }
    }

    private void checkUpdating() throws QueryException {
        this.updating = this.expr.has(Flag.UPD);
        boolean updAnn = this.anns.contains(Annotation.UPDATING);
        if (this.updating != updAnn) {
            if (!updAnn) {
                this.anns.add(new Ann(this.info, Annotation.UPDATING, new Item[0]));
            } else if (!this.expr.vacuous()) {
                throw QueryError.UPEXPECTF.get(this.info, new Object[0]);
            }
        }
    }

    public static Closure undeclaredLiteral(QNm name, int arity, QueryContext qc, StaticContext sc, InputInfo ii) throws QueryException {
        VarScope vs = new VarScope(sc);
        Var[] params = new Var[arity];
        Expr[] args = new Expr[arity];
        for (int a = 0; a < arity; ++a) {
            params[a] = vs.addNew(new QNm("arg" + (a + 1), ""), null, true, qc, ii);
            args[a] = new VarRef(ii, params[a]);
        }
        TypedFunc tf = qc.funcs.undeclaredFuncCall(name, args, sc, ii);
        return new Closure(ii, name, null, params, tf.func, new AnnList(), null, vs);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public void plan(QueryPlan plan) {
        ArrayList list = new ArrayList();
        this.global.forEach((key, value) -> {
            list.add(key);
            list.add(value);
        });
        FElem elem = plan.create(this, new Object[0]);
        int pl = this.params.length;
        for (int p = 0; p < pl; ++p) {
            plan.addAttribute(elem, "arg" + p, this.params[p].name.string());
        }
        plan.add(elem, list.toArray());
    }

    @Override
    public void plan(QueryString qs) {
        boolean inlined;
        boolean bl = inlined = !this.global.isEmpty();
        if (inlined) {
            qs.token("((: inline-closure :)");
            this.global.forEach((k, v) -> qs.token("let").token(k).token(":=").token(v));
            qs.token("return");
        }
        qs.token("function").params(this.params);
        qs.token("as").token(this.declType != null ? this.declType : SeqType.ITEM_ZM).brace(this.expr);
        if (inlined) {
            qs.token(')');
        }
    }
}

