/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import java.util.ArrayList;
import org.basex.data.Data;
import org.basex.index.name.Names;
import org.basex.index.path.PathNode;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.CmpPos;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Preds;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.CachedStep;
import org.basex.query.expr.path.IterLastStep;
import org.basex.query.expr.path.IterPosStep;
import org.basex.query.expr.path.IterStep;
import org.basex.query.expr.path.KindTest;
import org.basex.query.expr.path.NamePart;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.Test;
import org.basex.query.expr.path.UnionTest;
import org.basex.query.func.Function;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.Check;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntObjMap;

public abstract class Step
extends Preds {
    public Test test;
    public Axis axis;

    public static Expr get(CompileContext cc, Expr root, InputInfo ii, Expr ... preds) throws QueryException {
        return Step.get(cc, root, ii, KindTest.NOD, preds);
    }

    public static Expr get(CompileContext cc, Expr root, InputInfo ii, Test test, Expr ... preds) throws QueryException {
        return Step.get(cc, root, ii, Axis.SELF, test, preds);
    }

    public static Expr get(CompileContext cc, Expr root, InputInfo ii, Axis axis, Test test, Expr ... preds) throws QueryException {
        return new CachedStep(ii, axis, test, preds).optimize(root, cc);
    }

    public static Step get(InputInfo ii, Axis axis, Test test, Expr ... preds) {
        if (preds.length == 1 && Function.LAST.is(preds[0])) {
            return new IterLastStep(ii, axis, test, preds);
        }
        boolean pos = false;
        for (Expr pred : preds) {
            if (pred instanceof CmpPos && ((CmpPos)((Object)pred)).simple() || Step.numeric(pred)) {
                pos = true;
                continue;
            }
            if (!Step.mayBePositional(pred)) continue;
            return new CachedStep(ii, axis, test, preds);
        }
        return pos ? new IterPosStep(ii, axis, test, preds) : new IterStep(ii, axis, test, preds);
    }

    Step(InputInfo info, Axis axis, Test test, Expr ... preds) {
        super(info, SeqType.get(axis == Axis.ATTRIBUTE ? NodeType.ATTRIBUTE : test.type, axis == Axis.SELF && test == KindTest.NOD && preds.length == 0 ? Occ.EXACTLY_ONE : (axis == Axis.SELF || axis == Axis.PARENT || axis == Axis.ATTRIBUTE && test instanceof NameTest && ((NameTest)test).part == NamePart.FULL ? Occ.ZERO_OR_ONE : Occ.ZERO_OR_MORE), test instanceof KindTest ? null : test), preds);
        this.axis = axis;
        this.test = test;
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        return this.optimize(null, cc);
    }

    final Expr optimize(Expr expr, CompileContext cc) throws QueryException {
        Type rtype;
        Type type;
        Expr ex = expr != null ? expr : cc.qc.focus.value;
        this.type(ex);
        if (ex != null && (type = this.seqType().type).intersect(rtype = ex.seqType().type) == null) {
            Axis old = this.axis;
            if (this.axis == Axis.DESCENDANT_OR_SELF) {
                this.axis = Axis.DESCENDANT;
            } else if (this.axis == Axis.ANCESTOR_OR_SELF) {
                this.axis = Axis.ANCESTOR;
            }
            if (this.axis != old) {
                cc.info("rewrite %: %", new Object[]{old, this});
            }
        }
        if (this.noMatches() || ex != null && this.test.noMatches(ex.data())) {
            cc.info("remove step without results: %", this);
            return cc.emptySeq(this);
        }
        return this.simplify(cc, this) ? cc.emptySeq(this) : this.copyType(Step.get(this.info, this.axis, this.test, this.exprs));
    }

    @Override
    protected final void type(Expr expr) {
        if (expr != null && this.axis == Axis.SELF && this.test instanceof KindTest) {
            Type type = expr.seqType().type;
            if (this.test == KindTest.NOD) {
                this.exprType.assign(type);
            } else if (type == this.test.type && this.exprs.length == 0) {
                this.exprType.assign(Occ.EXACTLY_ONE);
            }
        }
    }

    @Override
    public final Expr inline(InlineContext ic) throws QueryException {
        return ic.var != null && ic.cc.ok(this, () -> ic.inline(this.exprs)) ? this.optimize(ic.cc) : null;
    }

    @Override
    public final Value value(QueryContext qc) throws QueryException {
        return this.iter(qc).value(qc, this);
    }

    @Override
    public abstract Step copy(CompileContext var1, IntObjMap<Var> var2);

    final ArrayList<PathNode> nodes(ArrayList<PathNode> nodes, Data data) {
        if (this.exprs.length != 0 || data.defaultNs() == null) {
            return null;
        }
        if (this.axis != Axis.ATTRIBUTE && this.axis != Axis.CHILD && this.axis != Axis.DESCENDANT && this.axis != Axis.DESCENDANT_OR_SELF && this.axis != Axis.SELF) {
            return null;
        }
        if (this.test.type == NodeType.PROCESSING_INSTRUCTION || this.test instanceof UnionTest) {
            return null;
        }
        int name = 0;
        if (this.test instanceof NameTest) {
            NamePart part = ((NameTest)this.test).part();
            if (part == NamePart.LOCAL) {
                Names names = this.test.type == NodeType.ATTRIBUTE ? data.attrNames : data.elemNames;
                name = names.id(((NameTest)this.test).local);
            } else if (part != null) {
                return null;
            }
        }
        int kind = ANode.kind(this.test.type);
        ArrayList<PathNode> tmp = new ArrayList<PathNode>();
        for (PathNode pn : nodes) {
            if (!(this.axis != Axis.SELF && this.axis != Axis.DESCENDANT_OR_SELF || kind != -1 && (kind != pn.kind || name != 0 && name != pn.name) || tmp.contains(pn))) {
                tmp.add(pn);
            }
            if (this.axis == Axis.SELF) continue;
            this.add(pn, tmp, name, kind);
        }
        return tmp;
    }

    private void add(PathNode node, ArrayList<PathNode> nodes, int name, int kind) {
        for (PathNode pn : node.children) {
            if (this.axis == Axis.DESCENDANT || this.axis == Axis.DESCENDANT_OR_SELF) {
                this.add(pn, nodes, name, kind);
            }
            if ((kind != -1 || !(pn.kind != 3 ^ this.axis == Axis.ATTRIBUTE)) && (kind != pn.kind || name != 0 && name != pn.name) || nodes.contains(pn)) continue;
            nodes.add(pn);
        }
    }

    private boolean noMatches() {
        NodeType type = this.test.type;
        if (type.oneOf(NodeType.NODE, NodeType.SCHEMA_ATTRIBUTE, NodeType.SCHEMA_ELEMENT)) {
            return false;
        }
        switch (this.axis) {
            case ATTRIBUTE: {
                return type != NodeType.ATTRIBUTE;
            }
            case ANCESTOR: 
            case PARENT: {
                return type.oneOf(NodeType.LEAF_TYPES);
            }
            case CHILD: 
            case DESCENDANT: 
            case FOLLOWING: 
            case FOLLOWING_SIBLING: 
            case PRECEDING: 
            case PRECEDING_SIBLING: {
                return type.oneOf(NodeType.ATTRIBUTE, NodeType.DOCUMENT_NODE_ELEMENT, NodeType.DOCUMENT_NODE, NodeType.NAMESPACE_NODE);
            }
        }
        return false;
    }

    final boolean emptyStep(NodeType inputType) {
        NodeType type = this.test.type;
        if (inputType.instanceOf(NodeType.DOCUMENT_NODE) && ((Check)() -> {
            switch (this.axis) {
                case SELF: 
                case ANCESTOR_OR_SELF: {
                    return !type.oneOf(NodeType.NODE, NodeType.DOCUMENT_NODE);
                }
                case CHILD: 
                case DESCENDANT: {
                    return type.oneOf(NodeType.DOCUMENT_NODE, NodeType.ATTRIBUTE);
                }
                case DESCENDANT_OR_SELF: {
                    return type == NodeType.ATTRIBUTE;
                }
            }
            return true;
        }).ok()) {
            return true;
        }
        switch (this.axis) {
            case SELF: {
                return type != NodeType.NODE && !type.instanceOf(inputType);
            }
            case ATTRIBUTE: 
            case CHILD: 
            case DESCENDANT: {
                return inputType.oneOf(NodeType.LEAF_TYPES);
            }
            case DESCENDANT_OR_SELF: {
                return inputType.oneOf(NodeType.LEAF_TYPES) && type != NodeType.NODE && !type.instanceOf(inputType);
            }
            case FOLLOWING_SIBLING: 
            case PRECEDING_SIBLING: {
                return inputType == NodeType.ATTRIBUTE;
            }
            case PARENT: {
                return inputType == NodeType.ATTRIBUTE && type == NodeType.DOCUMENT_NODE;
            }
        }
        return false;
    }

    final Step addPredicates(Expr ... preds) {
        this.exprType.assign(this.seqType().union(Occ.ZERO));
        return this.copyType(Step.get(this.info, this.axis, this.test, ExprList.concat(this.exprs, preds)));
    }

    final ANode checkNode(QueryContext qc) throws QueryException {
        Value value = qc.focus.value;
        if (value instanceof ANode) {
            return (ANode)value;
        }
        throw value == null ? QueryError.NOCTX_X.get(this.info, this) : QueryError.STEPNODE_X_X_X.get(this.info, this, value.type, value);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        for (Expr pred : this.exprs) {
            visitor.enterFocus();
            if (!pred.accept(visitor)) {
                return false;
            }
            visitor.exitFocus();
        }
        return true;
    }

    @Override
    public int exprSize() {
        int size = 1;
        for (Expr pred : this.exprs) {
            size += pred.exprSize();
        }
        return size;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Step)) {
            return false;
        }
        Step st = (Step)obj;
        return this.axis == st.axis && this.test.equals(st.test) && super.equals(obj);
    }

    @Override
    public final void plan(QueryPlan plan) {
        plan.add(plan.create(this, "axis", this.axis.name, "test", this.test.toString(false)), this.exprs);
    }

    @Override
    public void plan(QueryString qs) {
        TokenBuilder tb = new TokenBuilder();
        if (this.test == KindTest.NOD) {
            if (this.axis == Axis.PARENT) {
                tb.add("..");
            }
            if (this.axis == Axis.SELF) {
                tb.add(46);
            }
        }
        if (tb.isEmpty()) {
            java.util.function.Function<Test, TokenBuilder> add = t -> {
                if (this.axis == Axis.ATTRIBUTE && t instanceof NameTest) {
                    return tb.add(64).add(t.toString(false));
                }
                if (this.axis != Axis.CHILD) {
                    tb.add((Object)this.axis).add("::");
                }
                return tb.add(t.toString(this.test.type == NodeType.ATTRIBUTE));
            };
            if (this.test instanceof UnionTest) {
                tb.add(40);
                for (Test t2 : ((UnionTest)this.test).tests) {
                    add.apply(t2).add(" | ");
                }
                tb.delete(tb.size() - 3, tb.size()).add(41);
            } else {
                add.apply(this.test);
            }
        }
        qs.token(tb.finish());
        super.plan(qs);
    }
}

