/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.path;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import org.basex.data.Data;
import org.basex.index.path.PathIndex;
import org.basex.index.path.PathNode;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryException;
import org.basex.query.QueryFunction;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.ContextValue;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Filter;
import org.basex.query.expr.List;
import org.basex.query.expr.ParseExpr;
import org.basex.query.expr.Preds;
import org.basex.query.expr.SimpleMap;
import org.basex.query.expr.Union;
import org.basex.query.expr.index.IndexAccess;
import org.basex.query.expr.index.IndexDb;
import org.basex.query.expr.index.IndexDynDb;
import org.basex.query.expr.index.IndexStaticDb;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.CachedPath;
import org.basex.query.expr.path.InvDocTest;
import org.basex.query.expr.path.IterPath;
import org.basex.query.expr.path.KindTest;
import org.basex.query.expr.path.MixedPath;
import org.basex.query.expr.path.NamePart;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.SingleIterPath;
import org.basex.query.expr.path.Step;
import org.basex.query.expr.path.Test;
import org.basex.query.func.Function;
import org.basex.query.func.util.UtilReplicate;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.index.IndexInfo;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dummy;
import org.basex.query.value.item.QNm;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.Array;
import org.basex.util.Check;
import org.basex.util.Checks;
import org.basex.util.InputInfo;
import org.basex.util.Util;

public abstract class Path
extends ParseExpr {
    public Expr root;
    public Expr[] steps;
    protected Data data;

    protected Path(InputInfo info, Type type, Expr root, Expr ... steps) {
        super(info, SeqType.get(type, Occ.ZERO_OR_MORE));
        this.root = root;
        this.steps = steps;
    }

    public static Expr get(CompileContext cc, InputInfo ii, Expr root, Expr ... steps) throws QueryException {
        return Path.get(ii, root, steps).optimize(cc);
    }

    public static Expr get(InputInfo ii, Expr root, Expr ... steps) {
        boolean single;
        boolean axes = true;
        ExprList tmp = new ExprList(steps.length);
        for (Expr step : steps) {
            Expr expr = step;
            if (expr instanceof ContextValue) {
                expr = Step.get(((ContextValue)expr).info, Axis.SELF, KindTest.NOD, new Expr[0]);
            } else if (expr instanceof Filter) {
                Filter f = (Filter)expr;
                if (f.root instanceof ContextValue) {
                    expr = Step.get(f.info, Axis.SELF, KindTest.NOD, f.exprs);
                }
            }
            tmp.add(expr);
            axes = axes && expr instanceof Step;
        }
        Expr rt = root instanceof ContextValue || root instanceof Dummy ? null : root;
        Expr[] stps = (Expr[])tmp.finish();
        boolean bl = single = rt == null && stps.length == 1;
        if (axes) {
            if (Path.iterative(root, stps)) {
                if (single && !stps[0].has(Flag.POS)) {
                    return new SingleIterPath(ii, stps[0]);
                }
                return new IterPath(ii, rt, stps);
            }
            return new CachedPath(ii, rt, stps);
        }
        if (single && stps[0].seqType().instanceOf(SeqType.ANY_ATOMIC_TYPE_ZM)) {
            return stps[0];
        }
        return new MixedPath(ii, rt, stps);
    }

    @Override
    public final void checkUp() throws QueryException {
        this.checkNoUp(this.root);
        int ss = this.steps.length;
        for (int s = 0; s < ss - 1; ++s) {
            this.checkNoUp(this.steps[s]);
        }
        this.steps[ss - 1].checkUp();
    }

    @Override
    public final Expr compile(CompileContext cc) throws QueryException {
        Expr rt;
        if (this.root != null) {
            this.root = this.root.compile(cc);
            rt = this.root;
        } else {
            rt = cc.qc.focus.value;
        }
        cc.get(rt, () -> {
            for (Expr step : this.steps) {
                try {
                    step = step.compile(cc);
                }
                catch (QueryException ex) {
                    step = cc.error(ex, step);
                }
                this.steps[s] = step;
                cc.updateFocus(step);
            }
            return null;
        });
        return this.optimize(cc);
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        Expr expr;
        if (this.root == null && !cc.nestedFocus()) {
            this.root = cc.qc.focus.value;
        }
        if ((expr = this.simplify(cc)) != this) {
            return expr;
        }
        expr = this.flatten(cc);
        if (expr == this) {
            expr = this.toUnion(cc);
        }
        if (expr == this) {
            expr = this.mergeSteps(cc);
        }
        if (expr == this) {
            expr = this.movePredicates(cc);
        }
        if (expr != this) {
            return expr.optimize(cc);
        }
        Expr rt = this.root != null ? this.root : cc.qc.focus.value;
        this.seqType(rt);
        expr = this.removeEmpty(cc, rt);
        if (expr == this) {
            expr = this.toMap(cc);
        }
        if (expr == this) {
            expr = this.index(cc, rt);
        }
        if (expr == this) {
            expr = this.children(cc, rt);
        }
        if (expr != this) {
            return expr;
        }
        return this.copyType(Path.get(this.info, this.root == null && rt instanceof Dummy ? rt : this.root, this.steps));
    }

    @Override
    public final Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        Expr last;
        if ((mode == CompileContext.Simplify.EBV || mode == CompileContext.Simplify.PREDICATE) && (last = this.steps[this.steps.length - 1]) instanceof Step) {
            Expr s;
            Step step = (Step)last;
            if (step.exprs.length == 1 && step.seqType().type instanceof NodeType && !step.exprs[0].seqType().mayBeNumber() && (s = step.flattenEbv(this, true, cc)) != step) {
                step.exprs = new Expr[0];
                return cc.simplify(this, s);
            }
        }
        return super.simplifyFor(mode, cc);
    }

    @Override
    public final boolean has(Flag ... flags) {
        if (Flag.CTX.in(flags) && (this.root == null || this.root.has(Flag.CTX))) {
            return true;
        }
        if (Flag.POS.in(flags) && this.root != null && this.root.has(Flag.POS)) {
            return true;
        }
        Flag[] flgs = Flag.POS.remove(Flag.CTX.remove(flags));
        if (flgs.length != 0) {
            for (Expr step : this.steps) {
                if (!step.has(flgs)) continue;
                return true;
            }
            return this.root != null && this.root.has(flgs);
        }
        return false;
    }

    private Step axisStep(int index) {
        return this.steps[index] instanceof Step ? (Step)this.steps[index] : null;
    }

    public boolean simple() {
        int n = 0;
        Expr[] exprArray = this.steps;
        int n2 = exprArray.length;
        if (n < n2) {
            Expr step = exprArray[n];
            if (!(step instanceof Step)) {
                return false;
            }
            Axis axis = ((Step)step).axis;
            return axis == Axis.SELF || axis == Axis.CHILD || axis == Axis.ATTRIBUTE;
        }
        return true;
    }

    private Expr flatten(CompileContext cc) {
        boolean changed = false;
        ExprList tmp = new ExprList(this.steps.length);
        Expr rt = this.root;
        if (rt instanceof Path) {
            Path path = (Path)rt;
            tmp.add(path.steps);
            rt = path.root;
            Object[] objectArray = new Object[2];
            objectArray[0] = path::description;
            objectArray[1] = path;
            cc.info("flatten nested %: %", objectArray);
            changed = true;
        }
        for (Expr step : this.steps) {
            Expr expr = step;
            if (expr instanceof Path) {
                Path path = (Path)expr;
                if (path.root != null && !(path.root instanceof ContextValue)) {
                    tmp.add(path.root);
                }
                int pl = path.steps.length - 1;
                for (int i = 0; i < pl; ++i) {
                    tmp.add(path.steps[i]);
                }
                expr = path.steps[pl];
                Object[] objectArray = new Object[2];
                objectArray[0] = path::description;
                objectArray[1] = path;
                cc.info("flatten nested %: %", objectArray);
                changed = true;
            }
            tmp.add(expr);
        }
        return changed ? Path.get(this.info, rt, (Expr[])tmp.finish()) : this;
    }

    private Expr simplify(CompileContext cc) throws QueryException {
        if (this.root != null && this.root.seqType().zero()) {
            return cc.replaceWith(this, this.root);
        }
        int sl = this.steps.length;
        boolean removed = false;
        ExprList list = new ExprList(sl);
        for (int s = 0; s < sl; ++s) {
            Expr expr;
            Step st = this.axisStep(s);
            if (st != null && st.exprs.length == 0 && st.test instanceof KindTest) {
                Type type;
                Expr prev;
                Expr expr2 = prev = list.isEmpty() ? this.root : (Expr)list.peek();
                if (prev != null && (type = prev.seqType().type).instanceOf(st.test.type) && (st.axis == Axis.SELF || st.axis == Axis.DESCENDANT_OR_SELF && type.oneOf(NodeType.LEAF_TYPES) || st.axis == Axis.ANCESTOR_OR_SELF && type.instanceOf(NodeType.DOCUMENT_NODE))) {
                    removed = true;
                    continue;
                }
            }
            if ((expr = this.steps[s]) == Empty.VALUE) {
                return cc.emptySeq(this);
            }
            list.add(expr);
            if (!expr.seqType().zero() || s + 1 >= sl) continue;
            cc.info("simplify %: %", this::description, this);
            break;
        }
        if (removed && (list.isEmpty() || !(((Expr)list.get((int)0)).seqType().type instanceof NodeType))) {
            if (this.root == null) {
                this.root = ContextValue.get(cc, this.info);
            }
            if (!this.root.ddo()) {
                this.root = cc.simplify(this.root, cc.function(Function._UTIL_DDO, this.info, this.root));
            }
        }
        this.steps = (Expr[])list.finish();
        return this.steps.length == 0 ? cc.replaceWith(this, this.root) : this;
    }

    public final ArrayList<PathNode> pathNodes(Expr rt) {
        if (rt == null || !rt.seqType().type.instanceOf(NodeType.DOCUMENT_NODE) || this.data == null || !this.data.meta.uptodate) {
            return null;
        }
        ArrayList<PathNode> nodes = this.data.paths.root();
        int sl = this.steps.length;
        for (int s = 0; s < sl; ++s) {
            Step curr = this.axisStep(s);
            if (curr == null) {
                return null;
            }
            if ((nodes = curr.nodes(nodes, this.data)) != null) continue;
            return null;
        }
        return nodes;
    }

    private static boolean iterative(Expr root, Expr ... steps) {
        if (root == null || !root.ddo()) {
            return false;
        }
        SeqType st = root.seqType();
        boolean atMostOne = st.zeroOrOne();
        boolean sameDepth = atMostOne || st.type.instanceOf(NodeType.DOCUMENT_NODE);
        for (Expr expr : steps) {
            Step step = (Step)expr;
            switch (step.axis) {
                case ATTRIBUTE: 
                case SELF: {
                    break;
                }
                case PARENT: 
                case FOLLOWING_SIBLING: {
                    if (atMostOne) break;
                    return false;
                }
                case CHILD: {
                    if (sameDepth) break;
                    return false;
                }
                case DESCENDANT: 
                case DESCENDANT_OR_SELF: {
                    if (!sameDepth) {
                        return false;
                    }
                    sameDepth = false;
                    break;
                }
                case ANCESTOR: 
                case ANCESTOR_OR_SELF: 
                case PRECEDING: 
                case PRECEDING_SIBLING: {
                    return false;
                }
                case FOLLOWING: {
                    if (!atMostOne) {
                        return false;
                    }
                    sameDepth = false;
                    break;
                }
                default: {
                    throw Util.notExpected();
                }
            }
            atMostOne &= step.seqType().zeroOrOne();
        }
        return true;
    }

    private void seqType(Expr rt) {
        if (rt != null) {
            this.data = rt.data();
        }
        SeqType st = this.steps[this.steps.length - 1].seqType();
        Occ occ = Occ.ZERO_OR_MORE;
        long size = this.size(rt);
        if (size == -1L && rt != null) {
            size = rt.size();
            occ = rt.seqType().occ;
            for (Expr step : this.steps) {
                long sz = step.size();
                size = size != -1L && sz != -1L ? size * sz : -1L;
                occ = occ.union(step.seqType().occ);
            }
            if (size > 1L) {
                size = -1L;
            }
        }
        this.exprType.assign(st, occ, size);
    }

    private long size(Expr rt) {
        if (this.root != null && this.root.size() == 0L) {
            return 0L;
        }
        for (Expr step : this.steps) {
            if (step.size() != 0L) continue;
            return 0L;
        }
        if (rt == null || !rt.seqType().type.instanceOf(NodeType.DOCUMENT_NODE) || this.data == null || !this.data.meta.uptodate || (long)this.data.meta.ndocs != rt.size()) {
            return -1L;
        }
        ArrayList<PathNode> nodes = this.data.paths.root();
        long lastSize = 1L;
        int sl = this.steps.length;
        for (int s = 0; s < sl; ++s) {
            Step curr = this.axisStep(s);
            if (curr != null) {
                if ((nodes = curr.nodes(nodes, this.data)) != null) continue;
                return -1L;
            }
            if (s + 1 == sl) {
                lastSize = this.steps[s].size();
                if (lastSize != -1L) continue;
                return -1L;
            }
            return -1L;
        }
        long size = 0L;
        for (PathNode pn : nodes) {
            size += (long)pn.stats.count;
        }
        return size * lastSize;
    }

    private ArrayList<PathNode> pathNodes(int last) {
        if (this.data == null || !this.data.meta.uptodate) {
            return null;
        }
        ArrayList<PathNode> nodes = this.data.paths.root();
        for (int s = 0; s <= last; ++s) {
            boolean desc;
            Step curr = this.axisStep(s);
            if (curr == null) {
                return null;
            }
            boolean bl = desc = curr.axis == Axis.DESCENDANT;
            if (!desc && curr.axis != Axis.CHILD || !(curr.test instanceof NameTest)) {
                return null;
            }
            NameTest test = (NameTest)curr.test;
            if (test.part() != NamePart.LOCAL) {
                return null;
            }
            int name = this.data.elemNames.id(test.qname.local());
            ArrayList<PathNode> tmp = new ArrayList<PathNode>();
            for (PathNode node : PathIndex.desc(nodes, desc)) {
                if (node.kind != 1 || name != node.name) continue;
                if (!tmp.isEmpty() && ((PathNode)tmp.get(0)).level() != node.level()) {
                    return null;
                }
                tmp.add(node);
            }
            if (tmp.isEmpty()) {
                return null;
            }
            nodes = tmp;
        }
        return nodes;
    }

    private Expr removeEmpty(CompileContext cc, Expr rt) {
        Check emptySteps = () -> {
            Expr prev = rt;
            for (Expr step : this.steps) {
                Type type;
                if (step instanceof Step && prev != null && (type = prev.seqType().type) instanceof NodeType && ((Step)step).emptyStep((NodeType)type)) {
                    return true;
                }
                prev = step;
            }
            return false;
        };
        ArrayList<PathNode> nodes = this.pathNodes(rt);
        if (nodes != null ? nodes.isEmpty() : emptySteps.ok()) {
            cc.info("remove path without results: %", this);
            return Empty.VALUE;
        }
        return this;
    }

    private Expr children(CompileContext cc, Expr rt) throws QueryException {
        if (rt == null || !rt.seqType().type.instanceOf(NodeType.DOCUMENT_NODE) || this.data == null || !this.data.meta.uptodate || this.data.defaultNs() == null) {
            return this;
        }
        int sl = this.steps.length;
        for (int s = 0; s < sl; ++s) {
            ArrayList<PathNode> nodes;
            Step prev;
            Step step = prev = s > 0 ? this.axisStep(s - 1) : null;
            if (prev != null && prev.exprs.length != 0) break;
            Step curr = this.axisStep(s);
            if (curr == null || curr.axis != Axis.DESCENDANT || curr.mayBePositional() || (nodes = this.pathNodes(s)) == null) continue;
            ArrayList<QNm> qNames = new ArrayList<QNm>();
            while (nodes.get((int)0).parent != null) {
                QNm qName = new QNm(this.data.elemNames.key(nodes.get((int)0).name));
                if (qName.hasPrefix()) {
                    return this;
                }
                for (PathNode node : nodes) {
                    if (nodes.get((int)0).name == node.name) continue;
                    qName = null;
                    break;
                }
                qNames.add(qName);
                nodes = PathIndex.parent(nodes);
            }
            cc.info("convert to child steps: %", this.steps[s]);
            int ts = qNames.size();
            Expr[] stps = new Expr[ts + sl - s - 1];
            for (int t = 0; t < ts; ++t) {
                Expr[] preds = t == ts - 1 ? ((Preds)this.steps[s]).exprs : new Expr[]{};
                QNm qName = (QNm)qNames.get(ts - t - 1);
                Test test = qName == null ? KindTest.ELM : new NameTest(qName, NamePart.LOCAL, NodeType.ELEMENT, null);
                stps[t] = Step.get(cc, this.root, curr.info, Axis.CHILD, test, preds);
            }
            while (++s < sl) {
                stps[ts++] = this.steps[s];
            }
            return Path.get(cc, this.info, this.root, stps);
        }
        return this;
    }

    private Expr toMap(CompileContext cc) throws QueryException {
        int sl = this.steps.length;
        if (this.root == null && sl == 1) {
            return this;
        }
        Expr s1 = sl > 1 ? this.steps[sl - 2] : this.root;
        Expr s2 = this.steps[sl - 1];
        Type type1 = s1.seqType().type;
        Type type2 = s2.seqType().type;
        if (!(type1 instanceof NodeType) || s2 instanceof Step || this.size() != 1L && !type2.instanceOf(AtomType.ANY_ATOMIC_TYPE) && !type2.instanceOf(SeqType.FUNCTION)) {
            return this;
        }
        if (sl > 1) {
            s1 = Path.get(cc, this.info, this.root, Arrays.copyOfRange(this.steps, 0, sl - 1));
        }
        if (s1 != null) {
            s2 = SimpleMap.get(cc, this.info, s1, s2);
        }
        return cc.replaceWith(this, s2);
    }

    private Expr index(CompileContext cc, Expr rt) throws QueryException {
        Expr resultRoot;
        Step step;
        if (rt == null || !rt.seqType().type.instanceOf(NodeType.DOCUMENT_NODE)) {
            return this;
        }
        IndexInfo index = null;
        int indexPred = 0;
        int indexStep = 0;
        int sl = this.steps.length;
        for (int s = 0; s < sl && (step = this.axisStep(s)) != null && step.axis.down && !step.mayBePositional(); ++s) {
            int el = step.exprs.length;
            if (el <= 0) continue;
            IndexDb db = this.data != null ? new IndexStaticDb(this.data, this.info) : new IndexDynDb(this.root == null ? new ContextValue(this.info) : this.root, this.info);
            for (int e = 0; e < el; ++e) {
                IndexInfo ii = new IndexInfo(db, cc, step);
                if (!step.exprs[e].indexAccessible(ii)) continue;
                if (ii.costs.results() == 0) {
                    cc.info("no index results: %", ii.step);
                    return Empty.VALUE;
                }
                if (index != null && index.costs.compareTo(ii.costs) <= 0) continue;
                index = ii;
                indexPred = e;
                indexStep = s;
            }
        }
        if (index == null || this.data != null && index.costs.tooExpensive(this.data)) {
            return this;
        }
        if (!(rt instanceof Value && !(rt instanceof Dummy) || index.enforce())) {
            return this;
        }
        cc.info(index.optInfo, new Object[0]);
        ExprList resultSteps = new ExprList();
        if (index.expr instanceof Path) {
            Path path = (Path)index.expr;
            resultRoot = path.root;
            resultSteps.add(path.steps);
        } else {
            resultRoot = index.expr;
        }
        if (index.costs.results() == 1 && resultRoot instanceof ParseExpr) {
            Occ occ = resultRoot instanceof IndexAccess ? Occ.EXACTLY_ONE : Occ.ZERO_OR_ONE;
            ((ParseExpr)resultRoot).exprType.assign(occ);
        }
        ExprList invSteps = new ExprList();
        ExprList newPreds = new ExprList();
        Test rootTest = InvDocTest.get(rt);
        if (rootTest != KindTest.DOC || this.data == null || !this.data.meta.uptodate || this.invertSteps(indexStep)) {
            for (int s = indexStep; s >= 0; --s) {
                Axis invAxis = this.axisStep((int)s).axis.invert();
                if (s == 0) {
                    if (rootTest == KindTest.DOC && (invAxis == Axis.ANCESTOR || invAxis == Axis.ANCESTOR_OR_SELF)) continue;
                    invSteps.add(Step.get(cc, resultRoot, this.info, invAxis, rootTest, new Expr[0]));
                    continue;
                }
                Step prevStep = this.axisStep(s - 1);
                Axis newAxis = prevStep.axis == Axis.ATTRIBUTE ? Axis.ATTRIBUTE : invAxis;
                Expr newStep = Step.get(cc, resultRoot, prevStep.info, newAxis, prevStep.test, prevStep.exprs);
                invSteps.add(newStep);
            }
        }
        if (!invSteps.isEmpty()) {
            newPreds.add(Path.get(this.info, null, (Expr[])invSteps.finish()));
        }
        Expr[] preds = index.step.exprs;
        int pl = preds.length;
        for (int p = 0; p < pl; ++p) {
            if (p == indexPred) continue;
            newPreds.add(preds[p]);
        }
        if (!newPreds.isEmpty()) {
            Expr step2;
            int ls = resultSteps.size() - 1;
            if (ls < 0 || !(resultSteps.get(ls) instanceof Step)) {
                step2 = Step.get(cc, resultRoot, this.info, (Expr[])newPreds.finish());
                ++ls;
            } else {
                step2 = ((Step)resultSteps.get(ls)).addPredicates((Expr[])newPreds.finish());
            }
            resultSteps.set(ls, step2);
        }
        for (int s = indexStep + 1; s < sl; ++s) {
            resultSteps.add(this.steps[s]);
        }
        return resultSteps.isEmpty() ? resultRoot : Path.get(cc, this.info, resultRoot, (Expr[])resultSteps.finish());
    }

    private boolean invertSteps(int i) {
        for (int s = i; s >= 0; --s) {
            Step step = this.axisStep(s);
            if (step.test instanceof KindTest && s != i) continue;
            if (step.axis != Axis.CHILD || s != i && step.exprs.length > 0 || !(step.test instanceof NameTest)) {
                return true;
            }
            NameTest test = (NameTest)step.test;
            if (test.part() != NamePart.LOCAL) {
                return true;
            }
            ArrayList<PathNode> pn = this.data.paths.desc(test.qname.local());
            if (pn.size() == 1 && pn.get(0).level() == s + 1) continue;
            return true;
        }
        return false;
    }

    private Expr toUnion(CompileContext cc) throws QueryException {
        Expr rt;
        QueryFunction<Expr, Expr> rewrite = step -> {
            Expr st;
            Filter filter;
            if (step instanceof List) {
                return ((List)step).toUnion(cc);
            }
            if (step instanceof Filter && !(filter = (Filter)step).mayBePositional() && filter.root instanceof List && (st = ((List)filter.root).toUnion(cc)) != filter.root) {
                return Filter.get(cc, filter.info, st, filter.exprs);
            }
            if (step instanceof UtilReplicate && ((UtilReplicate)step).once() && step.seqType().type instanceof NodeType) {
                return step.arg(0);
            }
            return step;
        };
        boolean changed = false;
        if (this.steps[0].seqType().type instanceof NodeType && (rt = rewrite.apply(this.root)) != this.root) {
            this.root = rt;
            changed = true;
        }
        return (changed |= cc.ok(this.root, () -> {
            boolean chngd = false;
            int sl = this.steps.length;
            for (int s = 0; s < sl; ++s) {
                Expr step = (Expr)rewrite.apply(this.steps[s]);
                if (step != this.steps[s]) {
                    this.steps[s] = step;
                    chngd = true;
                }
                cc.updateFocus(step);
            }
            return chngd;
        })) ? Path.get(this.info, this.root, this.steps) : this;
    }

    private Expr mergeSteps(CompileContext cc) throws QueryException {
        int sl = this.steps.length;
        ExprList stps = new ExprList(sl);
        return cc.ok(this.root, () -> {
            boolean chngd = false;
            for (int s = 0; s < sl; ++s) {
                Expr curr = this.steps[s];
                if (curr instanceof Step) {
                    Expr next = s < sl - 1 ? this.steps[s + 1] : null;
                    Step crr = (Step)curr;
                    if (crr.test == KindTest.NOD && next instanceof Step && ((Step)next).axis == Axis.ATTRIBUTE) {
                        next = Step.get(cc, null, crr.info, crr.axis, KindTest.ELM, crr.exprs);
                        curr = cc.replaceWith(curr, next);
                        chngd = true;
                    } else if (next != null && (next = Path.mergeStep(crr, next, cc)) != null) {
                        cc.info("merge: %", next);
                        curr = next;
                        chngd = true;
                        ++s;
                    }
                }
                stps.add(curr);
                cc.updateFocus(curr);
            }
            return chngd;
        }) ? Path.get(this.info, this.root, (Expr[])stps.finish()) : this;
    }

    private Expr movePredicates(CompileContext cc) throws QueryException {
        return cc.get(this.root, () -> {
            int sl = this.steps.length;
            for (int s = 0; s < sl; ++s) {
                Expr ex;
                Expr curr = this.steps[s];
                if (curr instanceof Step && (ex = this.movePredicates(cc, s)) != null) {
                    return ex;
                }
                cc.updateFocus(curr);
            }
            return this;
        });
    }

    private Expr movePredicates(CompileContext cc, int s) throws QueryException {
        int r;
        int p;
        Step step = (Step)this.steps[s];
        if (step.exprs.length != 1 || step.mayBePositional()) {
            return null;
        }
        Expr pred = step.exprs[0];
        if (!(pred instanceof Path)) {
            return null;
        }
        Path path = (Path)pred;
        if (path.root != null) {
            return null;
        }
        Expr[] predSteps = path.steps;
        int sl = this.steps.length;
        int pl = predSteps.length;
        int t = s + 1;
        for (p = 0; t < sl && p < pl && this.steps[t].equals(predSteps[p]); ++p, ++t) {
        }
        if (t == s + 1) {
            return null;
        }
        ExprList list = new ExprList();
        for (r = 0; r < s; ++r) {
            list.add(this.steps[r]);
        }
        list.add(step.copyType(Step.get(step.info, step.axis, step.test, new Expr[0])));
        for (r = s + 1; r < t - 1; ++r) {
            list.add(this.steps[r]);
        }
        if (p < pl) {
            cc.updateFocus((Expr)list.peek());
            Expr expr = Path.get(cc, this.info, null, Arrays.copyOfRange(predSteps, p, pl));
            list.add(((Step)this.steps[t - 1]).addPredicates(expr).optimize(cc));
        } else {
            list.add(this.steps[t - 1]);
        }
        for (int r2 = t; r2 < sl; ++r2) {
            list.add(this.steps[r2]);
        }
        return Path.get(this.info, this.root, (Expr[])list.finish());
    }

    private static Expr mergeStep(Step curr, Expr next, CompileContext cc) throws QueryException {
        Expr expr2;
        Filter filter;
        Step nxt;
        Step step = nxt = next instanceof Step ? (Step)next : null;
        if (nxt != null && nxt.axis == Axis.SELF && !nxt.mayBePositional()) {
            Test test = curr.test.intersect(nxt.test);
            if (test == null) {
                return null;
            }
            curr.test = test;
            return curr.addPredicates(nxt.exprs);
        }
        if (curr.axis != Axis.DESCENDANT_OR_SELF || curr.test != KindTest.NOD || curr.exprs.length > 0) {
            return null;
        }
        Predicate<Expr> simple = expr -> {
            if (expr instanceof Step) {
                Step step = (Step)expr;
                return (step.axis == Axis.CHILD || step.axis == Axis.DESCENDANT) && !step.mayBePositional();
            }
            return false;
        };
        QueryFunction<Expr, Expr> rewrite = expr -> {
            Checks<Expr> startWithChild = ex -> {
                if (!(ex instanceof Path)) {
                    return false;
                }
                Path path = (Path)ex;
                return path.root == null && simple.test(path.steps[0]);
            };
            if (expr instanceof Union) {
                Union union = (Union)expr;
                if (startWithChild.all((Expr[])union.exprs)) {
                    for (Expr path : union.exprs) {
                        ((Step)((Path)path).steps[0]).axis = Axis.DESCENDANT;
                    }
                    return union.optimize(cc);
                }
            }
            return null;
        };
        if (simple.test(nxt)) {
            nxt.axis = Axis.DESCENDANT;
            return nxt;
        }
        if (next instanceof Union) {
            return rewrite.apply(next);
        }
        if (next instanceof Filter && !(filter = (Filter)next).mayBePositional() && (expr2 = rewrite.apply(filter.root)) != null) {
            return Filter.get(cc, filter.info, expr2, filter.exprs);
        }
        return null;
    }

    @Override
    public final boolean inlineable(InlineContext ic) {
        if (ic.expr instanceof ContextValue && ic.var != null) {
            for (Expr step : this.steps) {
                if (!step.uses(ic.var)) continue;
                return false;
            }
        }
        return this.root == null || this.root.inlineable(ic);
    }

    @Override
    public final VarUsage count(Var var) {
        if (var == null) {
            return this.root == null ? VarUsage.ONCE : this.root.count(var);
        }
        VarUsage inRoot = this.root == null ? VarUsage.NEVER : this.root.count(var);
        return VarUsage.sum(var, this.steps) == VarUsage.NEVER ? inRoot : VarUsage.MORE_THAN_ONCE;
    }

    @Override
    public final Expr inline(InlineContext ic) throws QueryException {
        Expr rt;
        boolean changed = false;
        if (this.root != null) {
            Expr inlined = this.root.inline(ic);
            if (inlined != null) {
                this.root = inlined;
                changed = true;
            }
        } else if (ic.var == null) {
            this.root = ic.copy();
            changed = true;
        }
        CompileContext cc = ic.cc;
        int sl = this.steps.length;
        Expr expr = rt = this.root != null ? this.root : cc.qc.focus.value;
        if (changed) {
            for (int s = 0; s < sl; ++s) {
                Expr step = this.steps[s];
                this.steps[s] = step instanceof Step ? ((Step)step).optimize(rt, cc) : step.optimize(cc);
            }
        }
        return (changed |= ic.var != null && cc.ok(rt, () -> {
            boolean chngd = false;
            for (int s = 0; s < sl; ++s) {
                Expr step = this.steps[s].inline(ic);
                if (step != null) {
                    this.steps[s] = step;
                    chngd = true;
                }
                cc.updateFocus(this.steps[s]);
            }
            return chngd;
        })) ? this.optimize(cc) : null;
    }

    @Override
    public final boolean accept(ASTVisitor visitor) {
        if (this.root == null) {
            visitor.lock("internal:context", false);
        } else if (!this.root.accept(visitor)) {
            return false;
        }
        visitor.enterFocus();
        if (!Path.visitAll(visitor, this.steps)) {
            return false;
        }
        visitor.exitFocus();
        return true;
    }

    @Override
    public final int exprSize() {
        int size = 1;
        for (Expr step : this.steps) {
            size += step.exprSize();
        }
        return this.root == null ? size : size + this.root.exprSize();
    }

    @Override
    public final boolean equals(Object obj) {
        if (!(obj instanceof Path)) {
            return false;
        }
        Path path = (Path)obj;
        return Objects.equals(this.root, path.root) && Array.equals(this.steps, path.steps);
    }

    @Override
    public final void plan(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), new Object[]{this.root, this.steps});
    }

    @Override
    public void plan(QueryString qs) {
        if (this.root != null) {
            qs.token(this.root).token('/');
        }
        qs.tokens(this.steps, "/");
    }
}

