/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.util.Objects;
import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.index.query.StringRange;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.Expr;
import org.basex.query.expr.Single;
import org.basex.query.expr.index.StringRangeAccess;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.index.IndexInfo;
import org.basex.query.value.Value;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class CmpSR
extends Single {
    private final Collation coll;
    private final byte[] min;
    private final boolean mni;
    private final byte[] max;
    private final boolean mxi;
    private boolean single;

    private CmpSR(Expr expr, byte[] min, boolean mni, byte[] max, boolean mxi, Collation coll, InputInfo info) {
        super(info, expr, SeqType.BOOLEAN_O);
        this.coll = coll;
        this.min = min;
        this.mni = mni;
        this.max = max;
        this.mxi = mxi;
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.expr = this.expr.simplifyFor(CompileContext.Simplify.STRING, cc);
        SeqType st = this.expr.seqType();
        this.single = st.zeroOrOne() && !st.mayBeArray();
        return this.expr instanceof Value ? cc.preEval(this) : this;
    }

    static Expr get(CmpG cmp, CompileContext cc) throws QueryException {
        Expr cmp1 = cmp.exprs[0];
        Expr cmp2 = cmp.exprs[1];
        if (cmp1.has(Flag.NDT) || !(cmp2 instanceof AStr)) {
            return cmp;
        }
        byte[] d = ((AStr)cmp2).string(cmp.info);
        Expr expr = null;
        switch (cmp.op.opV) {
            case GE: {
                expr = new CmpSR(cmp1, d, true, null, true, cmp.coll, cmp.info);
                break;
            }
            case GT: {
                expr = new CmpSR(cmp1, d, false, null, true, cmp.coll, cmp.info);
                break;
            }
            case LE: {
                expr = new CmpSR(cmp1, null, true, d, true, cmp.coll, cmp.info);
                break;
            }
            case LT: {
                expr = new CmpSR(cmp1, null, true, d, false, cmp.coll, cmp.info);
                break;
            }
        }
        return expr != null ? expr.optimize(cc) : cmp;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        if (this.single) {
            Item item2 = this.expr.item(qc, this.info);
            return Bln.get(item2 != Empty.VALUE && this.eval(item2));
        }
        Iter iter = this.expr.atomIter(qc, this.info);
        while ((item = qc.next(iter)) != null) {
            if (!this.eval(item)) continue;
            return Bln.TRUE;
        }
        return Bln.FALSE;
    }

    private boolean eval(Item item) throws QueryException {
        int mx;
        int mn;
        if (!item.type.isStringOrUntyped()) {
            throw QueryError.diffError(item, Str.EMPTY, this.info);
        }
        byte[] s = item.string(this.info);
        int n = this.min == null ? 1 : (mn = this.coll == null ? Token.diff(s, this.min) : this.coll.compare(s, this.min));
        int n2 = this.max == null ? -1 : (mx = this.coll == null ? Token.diff(s, this.max) : this.coll.compare(s, this.max));
        return (this.mni ? mn >= 0 : mn > 0) && (this.mxi ? mx <= 0 : mx < 0);
    }

    @Override
    public Expr mergeEbv(Expr ex, boolean or, CompileContext cc) {
        byte[] mx;
        byte[] mn;
        if (or || !(ex instanceof CmpSR)) {
            return null;
        }
        CmpSR cmp = (CmpSR)ex;
        if (this.coll != null || !this.expr.equals(cmp.expr)) {
            return null;
        }
        byte[] byArray = this.min == null ? cmp.min : (mn = cmp.min == null ? this.min : Token.max(this.min, cmp.min));
        byte[] byArray2 = this.max == null ? cmp.max : (mx = cmp.max == null ? this.max : Token.min(this.max, cmp.max));
        if (mn != null && mx != null) {
            int d = Token.diff(mn, mx);
            if (d > 0) {
                return Bln.FALSE;
            }
            if (d == 0) {
                return this.mni && this.mxi ? new CmpG(this.expr, (Expr)Str.get(mn), CmpG.OpG.EQ, null, null, this.info) : Bln.FALSE;
            }
        }
        return new CmpSR(cmp.expr, mn, this.mni && cmp.mni, mx, this.mxi && cmp.mxi, null, this.info);
    }

    @Override
    public boolean indexAccessible(IndexInfo ii) throws QueryException {
        if (this.coll != null || this.min == null || this.max == null) {
            return false;
        }
        Data data = ii.db.data();
        if (data == null ? !ii.enforce() : data.inMemory()) {
            return false;
        }
        IndexType type = ii.type(this.expr, null);
        if (type == null) {
            return false;
        }
        StringRange sr = new StringRange(type, this.min, this.mni, this.max, this.mxi);
        ii.costs = ii.costs(data, sr);
        if (ii.costs == null) {
            return false;
        }
        TokenBuilder tb = new TokenBuilder();
        tb.add(this.mni ? 91 : 40).add(this.min).add(44).add(this.max).add(this.mxi ? 93 : 41);
        ii.create(new StringRangeAccess(this.info, sr, ii.db), true, Util.info("apply % index for %", (Object)((Object)type) + " string range", tb), this.info);
        return true;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        CmpSR cmp = new CmpSR(this.expr.copy(cc, vm), this.min, this.mni, this.max, this.mxi, this.coll, this.info);
        cmp.single = this.single;
        return this.copyType(cmp);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CmpSR)) {
            return false;
        }
        CmpSR c = (CmpSR)obj;
        return Token.eq(this.min, c.min) && this.mni == c.mni && Token.eq(this.max, c.max) && this.mxi && c.mxi && Objects.equals(this.coll, c.coll) && super.equals(obj);
    }

    @Override
    public String description() {
        return "string range comparison";
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, "min", this.min, "max", this.max, "include-min", this.mni, "include-max", this.mxi, "single", this.single), this.expr);
    }

    @Override
    public void plan(QueryString qs) {
        if (this.min != null) {
            qs.token(this.expr).token(this.mni ? ">=" : ">").quoted(this.min);
        }
        if (this.min != null && this.max != null) {
            qs.token("and");
        }
        if (this.max != null) {
            qs.token(this.expr).token(this.mxi ? "<=" : "<").quoted(this.max);
        }
    }
}

