/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.index.name.Names;
import org.basex.index.query.NumericRange;
import org.basex.index.stats.Stats;
import org.basex.index.stats.StatsType;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ItrPos;
import org.basex.query.expr.Range;
import org.basex.query.expr.Single;
import org.basex.query.expr.index.RangeAccess;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.AxisPath;
import org.basex.query.expr.path.NamePart;
import org.basex.query.expr.path.NameTest;
import org.basex.query.expr.path.Step;
import org.basex.query.func.Function;
import org.basex.query.iter.Iter;
import org.basex.query.util.Flag;
import org.basex.query.util.index.IndexCosts;
import org.basex.query.util.index.IndexInfo;
import org.basex.query.value.Value;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.RangeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.hash.IntObjMap;

public final class CmpR
extends Single {
    private static final double MAX_INTEGER = 9.007199254740992E15;
    private final double min;
    private final double max;
    private boolean single;

    private CmpR(Expr expr, double min, double max, InputInfo info) {
        super(info, expr, SeqType.BOOLEAN_O);
        this.min = min;
        this.max = max;
    }

    private static Expr get(Expr expr, double min, double max, InputInfo info) {
        return min > max ? Bln.FALSE : (min == Double.NEGATIVE_INFINITY && max == Double.POSITIVE_INFINITY ? Bln.TRUE : new CmpR(expr, min, max, info));
    }

    static Expr get(CmpG cmp, CompileContext cc) throws QueryException {
        Expr expr1 = cmp.exprs[0];
        Expr expr2 = cmp.exprs[1];
        Type type1 = expr1.seqType().type;
        Type type2 = expr2.seqType().type;
        if (cmp.has(Flag.NDT) || !type1.isNumberOrUntyped() || type1 == AtomType.DECIMAL) {
            return cmp;
        }
        if (!(expr2 instanceof ANum) || type2 == AtomType.DECIMAL && !type1.isUntyped() && !type1.instanceOf(AtomType.INTEGER)) {
            return cmp;
        }
        double d = ((ANum)expr2).dbl();
        if (d < -9.007199254740992E15 || d > 9.007199254740992E15) {
            return cmp;
        }
        double mn = d;
        double mx = d;
        switch (cmp.op) {
            case GE: {
                mx = Double.POSITIVE_INFINITY;
                break;
            }
            case GT: {
                mn = Math.nextUp(d);
                mx = Double.POSITIVE_INFINITY;
                break;
            }
            case LE: {
                mn = Double.NEGATIVE_INFINITY;
                break;
            }
            case LT: {
                mn = Double.NEGATIVE_INFINITY;
                mx = Math.nextDown(d);
                break;
            }
            default: {
                return cmp;
            }
        }
        return CmpR.get(expr1, mn, mx, cmp.info).optimize(cc);
    }

    @Override
    public Expr compile(CompileContext cc) throws QueryException {
        return super.compile(cc).optimize(cc);
    }

    @Override
    public Expr optimize(CompileContext cc) throws QueryException {
        this.expr = this.expr.simplifyFor(CompileContext.Simplify.NUMBER, cc);
        SeqType st = this.expr.seqType();
        boolean bl = this.single = st.zeroOrOne() && !st.mayBeArray();
        if (this.expr instanceof Value) {
            return cc.preEval(this);
        }
        Expr ex = this;
        if (Function.POSITION.is(this.expr)) {
            long mn = Math.max((long)Math.ceil(this.min), 1L);
            long mx = (long)Math.floor(this.max);
            ex = ItrPos.get(RangeSeq.get(mn, mx - mn + 1L, true), CmpV.OpV.EQ, this.info);
        }
        return cc.replaceWith(this, ex);
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        Item item;
        if (this.single) {
            Item item2 = this.expr.item(qc, this.info);
            return Bln.get(item2 != Empty.VALUE && this.inRange(item2.dbl(this.info)));
        }
        if (this.expr instanceof Range || this.expr instanceof RangeSeq) {
            Value value = this.expr.value(qc);
            long size = value.size();
            if (size == 0L) {
                return Bln.FALSE;
            }
            if (size == 1L) {
                return Bln.get(this.inRange(((Item)value).dbl(this.info)));
            }
            long[] range = ((RangeSeq)value).range(false);
            return Bln.get((double)range[1] >= this.min && (double)range[0] <= this.max);
        }
        Iter iter = this.expr.atomIter(qc, this.info);
        while ((item = qc.next(iter)) != null) {
            if (!this.inRange(item.dbl(this.info))) continue;
            return Bln.TRUE;
        }
        return Bln.FALSE;
    }

    private boolean inRange(double value) {
        return value >= this.min && value <= this.max;
    }

    @Override
    public Expr mergeEbv(Expr ex, boolean or, CompileContext cc) {
        if (!(ex instanceof CmpR)) {
            return null;
        }
        CmpR cmp = (CmpR)ex;
        if (!this.expr.equals(cmp.expr)) {
            return null;
        }
        if (or && (this.max < cmp.min || cmp.max < this.min)) {
            return null;
        }
        double mn = or ? Math.min(this.min, cmp.min) : Math.max(this.min, cmp.min);
        double mx = or ? Math.max(this.max, cmp.max) : Math.min(this.max, cmp.max);
        return CmpR.get(this.expr, mn, mx, this.info);
    }

    @Override
    public boolean indexAccessible(IndexInfo ii) throws QueryException {
        int mxl;
        Data data = ii.db.data();
        if (data == null ? !ii.enforce() : data.inMemory()) {
            return false;
        }
        IndexType type = ii.type(this.expr, null);
        if (type == null) {
            return false;
        }
        Stats key = this.key(ii, type);
        if (key == null) {
            return false;
        }
        NumericRange nr = new NumericRange(type, Math.max(this.min, key.min), Math.min(this.max, key.max));
        if (nr.min > nr.max || nr.max < key.min || nr.min > key.max) {
            ii.costs = IndexCosts.get(0);
            return true;
        }
        ii.costs = ii.costs(data, nr);
        if (ii.costs == null) {
            return false;
        }
        int mnl = this.min >= 0.0 && (double)((long)this.min) == this.min ? Token.token(this.min).length : -1;
        int n = mxl = this.max >= 0.0 && (double)((long)this.max) == this.max ? Token.token(this.max).length : -1;
        if (mnl != mxl || mnl == -1) {
            return false;
        }
        if (this.min == Double.NEGATIVE_INFINITY && this.max == Double.POSITIVE_INFINITY || Token.token((int)nr.min).length != Token.token((int)nr.max).length) {
            return false;
        }
        TokenBuilder tb = new TokenBuilder();
        tb.add(91).add(this.min).add(44).add(this.max).add(93);
        ii.create(new RangeAccess(this.info, nr, ii.db), true, Util.info("apply % index for %", "range", tb), this.info);
        return true;
    }

    private Stats key(IndexInfo ii, IndexType type) {
        Data data = ii.db.data();
        if (!(data != null && data.meta.uptodate && data.nspaces.isEmpty() && this.expr instanceof AxisPath)) {
            return null;
        }
        NameTest test = ii.test;
        if (test == null) {
            Step step;
            AxisPath path = (AxisPath)this.expr;
            int st = path.steps.length - 1;
            if (type == IndexType.TEXT) {
                step = st == 0 ? ii.step : path.step(st - 1);
            } else {
                step = path.step(st);
                if (step.axis != Axis.ATTRIBUTE || step.exprs.length > 0) {
                    return null;
                }
            }
            if (!(step.test instanceof NameTest)) {
                return null;
            }
            test = (NameTest)step.test;
            if (test.part() != NamePart.LOCAL) {
                return null;
            }
        }
        Names names = type == IndexType.TEXT ? data.elemNames : data.attrNames;
        Stats stats = names.stats(names.id(test.qname.local()));
        return stats == null || StatsType.isNumeric(stats.type) ? stats : null;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjMap<Var> vm) {
        CmpR cmp = new CmpR(this.expr.copy(cc, vm), this.min, this.max, this.info);
        cmp.single = this.single;
        return this.copyType(cmp);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CmpR)) {
            return false;
        }
        CmpR c = (CmpR)obj;
        return this.min == c.min && this.max == c.max && super.equals(obj);
    }

    @Override
    public String description() {
        return "range comparison";
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, "min", this.min, "max", this.max, "single", this.single), this.expr);
    }

    @Override
    public void plan(QueryString qs) {
        if (this.min == this.max) {
            qs.token(this.expr).token("=").token(this.min);
        } else {
            if (this.min != Double.NEGATIVE_INFINITY) {
                qs.token(this.expr).token(">=").token(this.min);
            }
            if (this.min != Double.NEGATIVE_INFINITY && this.max != Double.POSITIVE_INFINITY) {
                qs.token("and");
            }
            if (this.max != Double.POSITIVE_INFINITY) {
                qs.token(this.expr).token("<=").token(this.max);
            }
        }
    }
}

