/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import org.basex.index.IndexType;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryFunction;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.expr.Arith;
import org.basex.query.expr.Calc;
import org.basex.query.expr.Cmp;
import org.basex.query.expr.CmpHashG;
import org.basex.query.expr.CmpIR;
import org.basex.query.expr.CmpR;
import org.basex.query.expr.CmpSR;
import org.basex.query.expr.CmpSimpleG;
import org.basex.query.expr.CmpV;
import org.basex.query.expr.Expr;
import org.basex.query.expr.List;
import org.basex.query.func.Function;
import org.basex.query.func.fn.FnTokenize;
import org.basex.query.iter.Iter;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.index.IndexInfo;
import org.basex.query.value.item.ANum;
import org.basex.query.value.item.AStr;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Dur;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.var.Var;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;

public class CmpG
extends Cmp {
    OpG op;
    private boolean check = true;

    public CmpG(Expr expr1, Expr expr2, OpG op, Collation coll, StaticContext sc, InputInfo info) {
        super(info, expr1, expr2, coll, SeqType.BOOLEAN_O, sc);
        this.op = op;
    }

    @Override
    public final Expr optimize(CompileContext cc) throws QueryException {
        Expr expr = this.emptyExpr();
        if (expr != this) {
            return cc.replaceWith(this, cc.function(Function.BOOLEAN, this.info, expr));
        }
        Type t1 = this.exprs[0].seqType().type;
        Type t2 = this.exprs[1].seqType().type;
        if (t1.isStringOrUntyped() && t2.isStringOrUntyped()) {
            this.simplifyAll(CompileContext.Simplify.STRING, cc);
        } else if (t1.isNumber() && t2.isNumber()) {
            this.simplifyAll(CompileContext.Simplify.NUMBER, cc);
        }
        if (this.swap()) {
            cc.info("swap operands: %", this);
            this.op = this.op.swap();
        }
        for (int e = 0; e < 2; ++e) {
            this.exprs[e] = this.exprs[e].simplifyFor(CompileContext.Simplify.DISTINCT, cc);
        }
        expr = this.opt(cc);
        if (expr == this) {
            expr = this.optArith(cc);
        }
        if (expr == this) {
            expr = CmpIR.get(this, false, cc);
        }
        if (expr == this) {
            expr = CmpR.get(this, cc);
        }
        if (expr == this) {
            expr = CmpSR.get(this, cc);
        }
        if (expr == this) {
            Expr expr1 = this.exprs[0];
            Expr expr2 = this.exprs[1];
            SeqType st1 = expr1.seqType();
            SeqType st2 = expr2.seqType();
            Type type1 = st1.type;
            Type type2 = st2.type;
            this.check = !(type1 == type2 && !AtomType.ANY_ATOMIC_TYPE.instanceOf(type1) && (type1.isSortable() || this.op != OpG.EQ && this.op != OpG.NE) || type1.isUntyped() || type2.isUntyped() || type1.instanceOf(AtomType.STRING) && type2.instanceOf(AtomType.STRING) || type1.instanceOf(AtomType.NUMERIC) && type2.instanceOf(AtomType.NUMERIC) || type1.instanceOf(AtomType.DURATION) && type2.instanceOf(AtomType.DURATION));
            CmpHashG hash = null;
            if (st1.zeroOrOne() && !st1.mayBeArray() && st2.zeroOrOne() && !st2.mayBeArray()) {
                if (!(this instanceof CmpSimpleG)) {
                    expr = new CmpSimpleG(expr1, expr2, this.op, this.coll, this.sc, this.info);
                }
            } else if (this.op == OpG.EQ && this.coll == null && (type1.isNumber() && type2.isNumber() || type1.isStringOrUntyped() && type2.isStringOrUntyped()) && !st2.zeroOrOne()) {
                hash = this instanceof CmpHashG ? (CmpHashG)this : new CmpHashG(expr1, expr2, this.op, null, this.sc, this.info);
                expr = hash;
            }
            if (this.allAreValues(false)) {
                expr = cc.preEval(expr);
                if (hash != null) {
                    cc.qc.threads.get(hash).remove();
                }
                return expr;
            }
        }
        return expr instanceof CmpG ? expr : cc.replaceWith(this, expr);
    }

    private Expr optArith(CompileContext cc) throws QueryException {
        Expr expr1 = this.exprs[0];
        Expr count = this.exprs[1];
        if (expr1 instanceof Arith && count instanceof ANum) {
            Arith arith = (Arith)expr1;
            Expr op1 = arith.arg(0);
            Expr op2 = arith.arg(1);
            if (arith.calc == Calc.MINUS && op2.seqType().instanceOf(SeqType.NUMERIC_O) && count == Int.ZERO) {
                return new CmpG(op1, op2, this.op, this.coll, this.sc, this.info).optimize(cc);
            }
            if (arith.calc != Calc.MOD && arith.calc != Calc.IDIV && op2 instanceof ANum) {
                Expr arg2 = new Arith(this.info, count, op2, arith.calc.invert()).optimize(cc);
                return new CmpG(op1, arg2, this.op, this.coll, this.sc, this.info).optimize(cc);
            }
        }
        return this;
    }

    @Override
    public Bln item(QueryContext qc, InputInfo ii) throws QueryException {
        Iter iter1 = this.exprs[0].atomIter(qc, this.info);
        long size1 = iter1.size();
        if (size1 == 0L) {
            return Bln.FALSE;
        }
        Iter iter2 = this.exprs[1].atomIter(qc, this.info);
        long size2 = iter2.size();
        return size2 == 0L ? Bln.FALSE : this.compare(iter1, iter2, size1, size2, qc);
    }

    Bln compare(Iter iter1, Iter iter2, long size1, long size2, QueryContext qc) throws QueryException {
        Item item1;
        boolean swap;
        boolean single2;
        Iter ir1 = iter1;
        Iter ir2 = iter2;
        boolean single1 = size1 == 1L;
        boolean bl = single2 = size2 == 1L;
        if (single1 && single2) {
            return Bln.get(this.eval(ir1.next(), ir2.next()));
        }
        if (single1) {
            Item item2;
            Item item12 = ir1.next();
            while ((item2 = qc.next(ir2)) != null) {
                if (!this.eval(item12, item2)) continue;
                return Bln.TRUE;
            }
            return Bln.FALSE;
        }
        if (single2) {
            Item item13;
            Item item2 = ir2.next();
            while ((item13 = qc.next(ir1)) != null) {
                if (!this.eval(item13, item2)) continue;
                return Bln.TRUE;
            }
            return Bln.FALSE;
        }
        boolean bl2 = swap = size1 > size2;
        if (swap) {
            Iter iter = ir1;
            ir1 = ir2;
            ir2 = iter;
        }
        while ((item1 = ir1.next()) != null) {
            Item item2;
            if (ir2 == null) {
                ir2 = this.exprs[swap ? 0 : 1].atomIter(qc, this.info);
            }
            while ((item2 = qc.next(ir2)) != null) {
                if (!(swap ? this.eval(item2, item1) : this.eval(item1, item2))) continue;
                return Bln.TRUE;
            }
            ir2 = null;
        }
        return Bln.FALSE;
    }

    final boolean eval(Item item1, Item item2) throws QueryException {
        Type type2;
        Type type1;
        if (!(!this.check || (type1 = item1.type) == (type2 = item2.type) || type1.isUntyped() || type2.isUntyped() || item1 instanceof ANum && item2 instanceof ANum || item1 instanceof AStr && item2 instanceof AStr || item1 instanceof Dur && item2 instanceof Dur)) {
            throw QueryError.diffError(item1, item2, this.info);
        }
        return this.op.opV.eval(item1, item2, this.coll, this.sc, this.info);
    }

    @Override
    public final CmpG invert() {
        Expr expr1 = this.exprs[0];
        Expr expr2 = this.exprs[1];
        SeqType st1 = expr1.seqType();
        SeqType st2 = expr2.seqType();
        return st1.one() && !st1.mayBeArray() && st2.one() && !st2.mayBeArray() ? new CmpG(expr1, expr2, this.op.invert(), this.coll, this.sc, this.info) : null;
    }

    @Override
    public final CmpV.OpV opV() {
        return this.op.opV;
    }

    @Override
    public Expr mergeEbv(Expr expr, boolean or, CompileContext cc) throws QueryException {
        boolean seqR2;
        OpG cmpOp;
        Expr expr2;
        boolean not2 = Function.NOT.is(expr);
        Expr expr3 = expr2 = not2 ? expr.arg(0) : expr;
        if (!(expr2 instanceof CmpG)) {
            return null;
        }
        CmpG cmp2 = (CmpG)expr2;
        OpG opG = cmpOp = not2 ? cmp2.op.invert() : cmp2.op;
        if (this.op != cmpOp || this.coll != cmp2.coll || !this.exprs[0].equals(cmp2.exprs[0])) {
            return null;
        }
        Expr exprL = this.exprs[0];
        Expr exprR1 = this.exprs[1];
        Expr exprR2 = cmp2.exprs[1];
        QueryFunction<OpG, Expr> newList = newOp -> {
            Expr exprR = List.get(cc, this.info, exprR1, exprR2);
            return new CmpG(exprL, exprR, (OpG)((Object)newOp), this.coll, this.sc, this.info).optimize(cc);
        };
        boolean seqL = !exprL.seqType().one();
        boolean seqR1 = !exprR1.seqType().one();
        boolean bl = seqR2 = !exprR2.seqType().one();
        if (or) {
            if (not2 && (seqR2 || seqL)) {
                return null;
            }
            expr2 = newList.apply(this.op);
        } else {
            if (seqL || seqR1 || seqR2 && !not2) {
                return null;
            }
            expr2 = cc.function(Function.NOT, this.info, newList.apply(this.op.invert()));
        }
        return expr2;
    }

    @Override
    public final boolean indexAccessible(IndexInfo ii) throws QueryException {
        if (this.op != OpG.EQ || this.coll != null) {
            return false;
        }
        Expr expr1 = this.exprs[0];
        IndexType type = null;
        if (Function.TOKENIZE.is(expr1)) {
            if (!expr1.arg(0).seqType().zeroOrOne() || !((FnTokenize)expr1).whitespaces()) {
                return false;
            }
            expr1 = expr1.arg(0);
            type = IndexType.TOKEN;
        }
        return ii.create(this.exprs[1], ii.type(expr1, type), false, this.info);
    }

    @Override
    public CmpG copy(CompileContext cc, IntObjMap<Var> vm) {
        CmpG cmp = new CmpG(this.exprs[0].copy(cc, vm), this.exprs[1].copy(cc, vm), this.op, this.coll, this.sc, this.info);
        cmp.check = this.check;
        return this.copyType(cmp);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof CmpG && this.op == ((CmpG)obj).op && super.equals(obj);
    }

    @Override
    public String description() {
        return (Object)((Object)this.op) + " comparison";
    }

    @Override
    public final void plan(QueryPlan plan) {
        plan.add(plan.create(this, "op", this.op.name), this.exprs);
    }

    @Override
    public final void plan(QueryString qs) {
        qs.tokens(this.exprs, " " + (Object)((Object)this.op) + ' ', true);
    }

    public static enum OpG {
        LE("<=", CmpV.OpV.LE){

            @Override
            public OpG swap() {
                return GE;
            }

            @Override
            public OpG invert() {
                return GT;
            }
        }
        ,
        LT("<", CmpV.OpV.LT){

            @Override
            public OpG swap() {
                return GT;
            }

            @Override
            public OpG invert() {
                return GE;
            }
        }
        ,
        GE(">=", CmpV.OpV.GE){

            @Override
            public OpG swap() {
                return LE;
            }

            @Override
            public OpG invert() {
                return LT;
            }
        }
        ,
        GT(">", CmpV.OpV.GT){

            @Override
            public OpG swap() {
                return LT;
            }

            @Override
            public OpG invert() {
                return LE;
            }
        }
        ,
        EQ("=", CmpV.OpV.EQ){

            @Override
            public OpG swap() {
                return EQ;
            }

            @Override
            public OpG invert() {
                return NE;
            }
        }
        ,
        NE("!=", CmpV.OpV.NE){

            @Override
            public OpG swap() {
                return NE;
            }

            @Override
            public OpG invert() {
                return EQ;
            }
        };

        public static final OpG[] VALUES;
        public final String name;
        public final CmpV.OpV opV;

        private OpG(String name, CmpV.OpV opV) {
            this.name = name;
            this.opV = opV;
        }

        public abstract OpG swap();

        public abstract OpG invert();

        public String toString() {
            return this.name;
        }

        static OpG get(CmpV.OpV opV) {
            for (OpG value : VALUES) {
                if (value.opV != opV) continue;
                return value;
            }
            return null;
        }

        static {
            VALUES = OpG.values();
        }
    }
}

