/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ann;

import org.basex.query.QueryText;
import org.basex.query.func.FuncDefinition;
import org.basex.query.util.NSGlobal;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.SeqType;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenObjMap;

public enum Annotation {
    PUBLIC("public()", Annotation.arg(new SeqType[0]), QueryText.XQ_URI, false),
    PRIVATE("private()", Annotation.arg(new SeqType[0]), QueryText.XQ_URI, false),
    UPDATING("updating()", Annotation.arg(new SeqType[0]), QueryText.XQ_URI, false),
    _BASEX_LAZY("lazy()", Annotation.arg(new SeqType[0]), QueryText.BASEX_URI),
    _BASEX_INLINE("inline([limit])", Annotation.arg(SeqType.INTEGER_O), QueryText.BASEX_URI),
    _BASEX_LOCK("lock(key)", Annotation.arg(SeqType.STRING_O), QueryText.BASEX_URI),
    _INPUT_CSV("csv(option[,...])", Annotation.arg(SeqType.STRING_O), QueryText.INPUT_URI),
    _INPUT_HTML("html(option[,...])", Annotation.arg(SeqType.STRING_O), QueryText.INPUT_URI),
    _INPUT_JSON("json(option[,...])", Annotation.arg(SeqType.STRING_O), QueryText.INPUT_URI),
    _INPUT_TEXT("text(option[,...])", Annotation.arg(SeqType.STRING_O), QueryText.INPUT_URI),
    _OUTPUT_ALLOW_DUPLICATE_NAMES("allow-duplicate-names(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_BYTE_ORDER_MARK("byte-order-mark(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_CDATA_SECTION_ELEMENTS("cdata-section-elements(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_CSV("csv(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_DOCTYPE_PUBLIC("doctype-public(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_DOCTYPE_SYSTEM("doctype-system(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_ENCODING("encoding(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_ESCAPE_URI_ATTRIBUTES("escape-uri-attributes(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_HTML_VERSION("html-version(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_INCLUDE_CONTENT_TYPE("include-content-type(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_INDENT("indent(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_INDENTS("indents(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_ITEM_SEPARATOR("item-separator(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_JSON("json(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_JSON_NODE_OUTPUT_METHOD("json-node-output-method(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_MEDIA_TYPE("media-type(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_METHOD("method(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_NEWLINE("newline(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_NORMALIZATION_FORM("normalization-form(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_OMIT_XML_DECLARATION("omit-xml-declaration(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_PARAMETER_DOCUMENT("parameter-document(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_STANDALONE("standalone(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_SUPPRESS_INDENTATION("suppress-indentation(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_TABULATOR("tabulator(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_UNDECLARE_PREFIXES("undeclare-prefixes(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_USE_CHARACTER_MAPS("use-character-maps(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _OUTPUT_VERSION("version(value)", Annotation.arg(SeqType.STRING_O), QueryText.OUTPUT_URI),
    _PERM_CHECK("check([path[,map]])", Annotation.arg(SeqType.STRING_O, SeqType.STRING_O), QueryText.PERM_URI),
    _PERM_ALLOW("allow(name[,...])", Annotation.arg(SeqType.STRING_O), QueryText.PERM_URI, false),
    _REST_PATH("path(path)", Annotation.arg(SeqType.STRING_O), QueryText.REST_URI),
    _REST_ERROR("error(code[,...])", Annotation.arg(SeqType.STRING_O), QueryText.REST_URI, false),
    _REST_CONSUMES("consumes(type[,...])", Annotation.arg(SeqType.STRING_O), QueryText.REST_URI, false),
    _REST_PRODUCES("produces(type[,...])", Annotation.arg(SeqType.STRING_O), QueryText.REST_URI, false),
    _REST_QUERY_PARAM("query-param(name,variable[,default,...])", Annotation.arg(SeqType.STRING_O, SeqType.STRING_O, SeqType.ITEM_O), QueryText.REST_URI, false),
    _REST_FORM_PARAM("form-param(name,variable[,default,...])", Annotation.arg(SeqType.STRING_O, SeqType.STRING_O, SeqType.ITEM_O), QueryText.REST_URI, false),
    _REST_HEADER_PARAM("header-param(name,variable[,default,...])", Annotation.arg(SeqType.STRING_O, SeqType.STRING_O, SeqType.ITEM_O), QueryText.REST_URI, false),
    _REST_COOKIE_PARAM("cookie-param(name,variable[,default,...])", Annotation.arg(SeqType.STRING_O, SeqType.STRING_O, SeqType.ITEM_O), QueryText.REST_URI, false),
    _REST_ERROR_PARAM("error-param(name,variable[,default,...])", Annotation.arg(SeqType.STRING_O, SeqType.STRING_O, SeqType.ITEM_O), QueryText.REST_URI, false),
    _REST_METHOD("method(name[,body])", Annotation.arg(SeqType.STRING_O, SeqType.STRING_O), QueryText.REST_URI, false),
    _REST_SINGLE("single([key])", Annotation.arg(SeqType.STRING_O), QueryText.REST_URI),
    _REST_GET("GET()", Annotation.arg(new SeqType[0]), QueryText.REST_URI),
    _REST_POST("POST([body])", Annotation.arg(SeqType.STRING_O), QueryText.REST_URI),
    _REST_PUT("PUT([body])", Annotation.arg(SeqType.STRING_O), QueryText.REST_URI),
    _REST_DELETE("DELETE()", Annotation.arg(new SeqType[0]), QueryText.REST_URI),
    _REST_HEAD("HEAD()", Annotation.arg(new SeqType[0]), QueryText.REST_URI),
    _REST_OPTIONS("OPTIONS()", Annotation.arg(new SeqType[0]), QueryText.REST_URI),
    _UNIT_AFTER("after([function])", Annotation.arg(SeqType.STRING_O), QueryText.UNIT_URI),
    _UNIT_AFTER_MODULE("after-module()", Annotation.arg(new SeqType[0]), QueryText.UNIT_URI),
    _UNIT_BEFORE("before([function])", Annotation.arg(SeqType.STRING_O), QueryText.UNIT_URI),
    _UNIT_BEFORE_MODULE("before-module()", Annotation.arg(new SeqType[0]), QueryText.UNIT_URI),
    _UNIT_IGNORE("ignore([message])", Annotation.arg(SeqType.STRING_O), QueryText.UNIT_URI),
    _UNIT_TEST("test(['expected',error])", Annotation.arg(SeqType.STRING_O, SeqType.STRING_O), QueryText.UNIT_URI),
    _WS_CONNECT("connect(path)", Annotation.arg(SeqType.STRING_O), QueryText.WS_URI),
    _WS_MESSAGE("message(path,message)", Annotation.arg(SeqType.STRING_O, SeqType.STRING_O), QueryText.WS_URI),
    _WS_CLOSE("close(path)", Annotation.arg(SeqType.STRING_O), QueryText.WS_URI),
    _WS_HEADER_PARAM("header-param(name,variable[,default,...])", Annotation.arg(SeqType.STRING_O, SeqType.STRING_O, SeqType.ITEM_O), QueryText.WS_URI, false),
    _WS_ERROR("error(path,message)", Annotation.arg(SeqType.STRING_O, SeqType.STRING_O), QueryText.WS_URI);

    public final SeqType[] args;
    public final byte[] uri;
    public final int[] minMax;
    public final boolean single;
    private final String desc;
    public static final Annotation[] VALUES;
    private static final TokenObjMap<Annotation> MAP;

    private Annotation(String desc, SeqType[] args, byte[] uri) {
        this(desc, args, uri, true);
    }

    private Annotation(String desc, SeqType[] args, byte[] uri, boolean single) {
        this.desc = desc;
        this.args = args;
        this.uri = uri;
        this.single = single;
        this.minMax = FuncDefinition.minMax(desc, args);
    }

    public static Annotation get(QNm name) {
        return MAP.get(name.id());
    }

    private static SeqType[] arg(SeqType ... arg) {
        return arg;
    }

    public byte[] local() {
        return Token.token(this.desc.substring(0, this.desc.indexOf(40)));
    }

    public QNm qname() {
        return new QNm(this.id(), this.uri);
    }

    public byte[] id() {
        TokenBuilder tb = new TokenBuilder();
        if (!Token.eq(this.uri, QueryText.XQ_URI)) {
            tb.add(NSGlobal.prefix(this.uri)).add(58);
        }
        return tb.add(this.local()).finish();
    }

    public String toString() {
        TokenBuilder tb = new TokenBuilder().add(37);
        if (!Token.eq(this.uri, QueryText.XQ_URI)) {
            tb.add(NSGlobal.prefix(this.uri)).add(58);
        }
        return tb.add(this.desc.replace("()", "")).toString();
    }

    static {
        VALUES = Annotation.values();
        MAP = new TokenObjMap();
        for (Annotation sig : VALUES) {
            MAP.put(new QNm(sig.local(), sig.uri).id(), sig);
        }
    }
}

