/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.basex.core.BaseXException;
import org.basex.core.MainOptions;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryParser;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.options.Option;

final class QueryOptions {
    private final QueryContext qc;
    private final HashMap<Option<?>, Object> cachedOpts = new HashMap();
    private final HashMap<Option<?>, Object> localOpts = new HashMap();
    private MainOptions dummyOptions;

    QueryOptions(QueryContext qc) {
        this.qc = qc;
    }

    void add(String name, byte[] value, QueryParser parser) throws QueryException {
        String key = name.toUpperCase(Locale.ENGLISH);
        Option<?> opt = this.qc.context.options.option(key);
        if (opt == null) {
            throw QueryError.BASEX_OPTIONS1_X.get(parser.info(), name);
        }
        if (this.dummyOptions == null) {
            this.dummyOptions = new MainOptions(false);
        }
        try {
            this.dummyOptions.assign(key, Token.string(value));
        }
        catch (BaseXException ex) {
            Util.debug(ex);
            throw QueryError.BASEX_OPTIONS_X_X.get(parser.info(), key, value);
        }
        this.localOpts.put(opt, this.dummyOptions.get(opt));
    }

    void compile() {
        this.dummyOptions = null;
        MainOptions options = this.qc.context.options;
        for (Map.Entry<Option<?>, Object> entry : this.localOpts.entrySet()) {
            Option<?> option = entry.getKey();
            this.cachedOpts.put(option, options.get(option));
            options.put(option, entry.getValue());
        }
    }

    void close() {
        this.cachedOpts.forEach(this.qc.context.options::put);
    }
}

