/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import java.io.Closeable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.basex.build.json.JsonOptions;
import org.basex.build.json.JsonParserOptions;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.jobs.Job;
import org.basex.core.locks.LockList;
import org.basex.core.locks.Locks;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.io.parse.json.JsonConverter;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.CompileContext;
import org.basex.query.QueryCompiler;
import org.basex.query.QueryDateTime;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryFocus;
import org.basex.query.QueryFunction;
import org.basex.query.QueryIOException;
import org.basex.query.QueryInfo;
import org.basex.query.QueryOptions;
import org.basex.query.QueryParser;
import org.basex.query.QueryPlan;
import org.basex.query.QueryProcessor;
import org.basex.query.QueryResources;
import org.basex.query.QueryThreads;
import org.basex.query.StaticContext;
import org.basex.query.func.StaticFuncs;
import org.basex.query.func.XQFunction;
import org.basex.query.func.java.JavaCall;
import org.basex.query.iter.Iter;
import org.basex.query.scope.AModule;
import org.basex.query.scope.LibraryModule;
import org.basex.query.scope.MainModule;
import org.basex.query.scope.StaticScope;
import org.basex.query.up.Updates;
import org.basex.query.util.Flag;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.ft.FTPosData;
import org.basex.query.util.hash.QNmMap;
import org.basex.query.util.list.ItemList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Atm;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.seq.DBNodes;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.ListType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.query.var.QueryStack;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.query.var.Variables;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTOpt;
import org.basex.util.hash.TokenMap;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public final class QueryContext
extends Job
implements Closeable {
    public final QueryStack stack = new QueryStack();
    public final Variables vars = new Variables();
    public final StaticFuncs funcs = new StaticFuncs();
    private final QNmMap<Value> bindings = new QNmMap();
    private final HashMap<String, Object> props;
    public final QueryContext parent;
    public final QueryInfo info;
    public final Context context;
    public QueryResources resources;
    public Updates updates;
    final QueryOptions options = new QueryOptions(this);
    public final QueryThreads threads = new QueryThreads();
    public QueryFocus focus = new QueryFocus();
    public QueryDateTime dateTime;
    public FTPosData ftPosData = Prop.gui ? new FTPosData() : null;
    public FTLexer ftLexer;
    private FTOpt ftOpt;
    public int ftPos;
    public boolean scoring;
    public TokenObjMap<Collation> collations;
    public final LockList locks = new LockList();
    public int tailCalls;
    public int maxCalls;
    private XQFunction tailFunc;
    private Value[] args;
    public int varIDs;
    public final TokenMap modParsed = new TokenMap();
    final TokenMap modDeclared = new TokenMap();
    final TokenList modStack = new TokenList();
    public MainModule ctxItem;
    public MainModule root;
    private SerializerOptions serParams;
    private boolean defaultOutput;
    private boolean compiled;
    private boolean closed;

    public QueryContext(QueryContext parent) {
        this(parent.context, parent, parent.info, parent.props);
        parent.pushJob(this);
        this.resources = parent.resources;
        this.updates = parent.updates;
    }

    public QueryContext(Context context) {
        this(context, null, null, new HashMap<String, Object>());
        this.resources = new QueryResources(this);
    }

    private QueryContext(Context context, QueryContext parent, QueryInfo info, HashMap<String, Object> props) {
        this.context = context;
        this.parent = parent;
        this.info = info != null ? info : new QueryInfo(this);
        this.props = props;
    }

    public AModule parse(String query, String uri) throws QueryException {
        return this.parse(query, QueryProcessor.isLibrary(query), uri);
    }

    public AModule parse(String query, boolean library, String uri) throws QueryException {
        return library ? this.parseLibrary(query, uri) : this.parseMain(query, uri);
    }

    public MainModule parseMain(String query, String uri) throws QueryException {
        return this.parseMain(query, uri, null);
    }

    public MainModule parseMain(String query, String uri, StaticContext sc) throws QueryException {
        this.info.query = query;
        QueryParser qp = new QueryParser(query, uri, this, sc);
        this.root = qp.parseMain();
        if (this.updating && !qp.sc.mixUpdates) {
            this.updating = this.root.expr.has(Flag.UPD);
        }
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibraryModule parseLibrary(String query, String uri) throws QueryException {
        this.info.query = query;
        try {
            LibraryModule libraryModule = new QueryParser(query, uri, this, null).parseLibrary(true);
            return libraryModule;
        }
        finally {
            this.updating = false;
        }
    }

    public void mainModule(MainModule rt) {
        this.root = rt;
        this.updating = rt.expr.has(Flag.UPD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile() throws QueryException {
        this.checkStop();
        if (this.compiled) {
            return;
        }
        this.info.runtime = false;
        CompileContext cc = new CompileContext(this);
        try {
            MainOptions mopts = this.context.options;
            if (this.root != null && this.parent == null) {
                for (Map.Entry<String, String> entry : mopts.toMap(MainOptions.BINDINGS).entrySet()) {
                    String key = entry.getKey();
                    Atm value = new Atm(entry.getValue());
                    if (key.isEmpty()) {
                        if (this.ctxItem != null) continue;
                        this.context(value, this.root.sc);
                        continue;
                    }
                    QNm name = QueryContext.qname(key, this.root.sc);
                    if (this.bindings.contains(name)) continue;
                    this.bind(name, value);
                }
            }
            this.options.compile();
            this.maxCalls = mopts.get(MainOptions.TAILCALLS);
            this.vars.bindExternal(this, this.bindings);
            if (this.ctxItem != null) {
                try {
                    this.ctxItem.comp(cc);
                    this.focus.value = this.ctxItem.value(this);
                }
                catch (QueryException ex) {
                    throw ex.error() == QueryError.NOCTX_X ? QueryError.CIRCCTX.get(this.ctxItem.info, new Object[0]) : ex;
                }
            } else {
                DBNodes nodes = this.context.current();
                if (nodes != null) {
                    String name = nodes.data().meta.name;
                    if (!this.context.perm(Perm.READ, name)) {
                        throw QueryError.BASEX_PERMISSION_X_X.get(null, new Object[]{Perm.READ, name});
                    }
                    this.focus.value = this.resources.compile(nodes);
                }
            }
            if (this.focus.value != null && this.root.sc != null && this.root.sc.contextType != null) {
                this.focus.value = this.root.sc.contextType.promote(this.focus.value, null, this, this.root.sc, null, true);
            }
            try {
                if (this.root != null) {
                    QueryCompiler.compile(cc, this.root);
                } else {
                    this.funcs.compile(cc);
                }
            }
            catch (StackOverflowError ex) {
                Util.debug(ex);
                throw QueryError.BASEX_OVERFLOW.get(null, ex);
            }
        }
        finally {
            this.info.runtime = true;
            this.compiled = true;
        }
    }

    public Iter iter() throws QueryException {
        this.compile();
        return this.updating ? this.update().iter() : this.root.iter(this);
    }

    public Value value() throws QueryException {
        this.compile();
        return this.updating ? this.update() : this.root.value(this);
    }

    public Item next(Iter iter) throws QueryException {
        this.checkStop();
        return iter.next();
    }

    public synchronized Updates updates() {
        if (this.updates == null) {
            this.updates = new Updates(false);
        }
        return this.updates;
    }

    @Override
    public void addLocks() {
        LockList list;
        Locks l = this.jc().locks;
        LockList lockList = list = this.updating ? l.writes : l.reads;
        if (this.root == null || !this.root.databases(l, this) || this.ctxItem != null && !this.ctxItem.databases(l, this)) {
            list.addGlobal();
        } else {
            list.add(this.locks);
        }
    }

    public void putProperty(String key, Object value) {
        this.props.put(key, value);
    }

    public Object getProperty(String key) {
        return this.props.get(key);
    }

    public void context(Object value, String type, StaticContext sc) throws QueryException {
        this.context(this.cast(value, type), sc);
    }

    public void context(Value value, StaticContext sc) {
        this.ctxItem = MainModule.get(new VarScope(sc), value, null, null, null);
    }

    public void bind(String name, Object value, String type, StaticContext sc) throws QueryException {
        this.bind(name, this.cast(value, type), sc);
    }

    public void bind(String name, Value value, StaticContext sc) throws QueryException {
        this.bind(QueryContext.qname(name, sc), value);
    }

    public void bind(QNm name, Value value) {
        this.bindings.put(name, value);
    }

    public void evalInfo(String string) {
        QueryContext qc = this;
        while (qc.parent != null) {
            qc = qc.parent;
        }
        qc.info.evalInfo(string);
    }

    public String info() {
        return this.info.toString(this);
    }

    public SerializerOptions serParams() {
        if (this.serParams == null) {
            this.serParams = new SerializerOptions(this.context.options.get(MainOptions.SERIALIZER));
            this.defaultOutput = this.root != null;
        }
        return this.serParams;
    }

    public FTOpt ftOpt() {
        if (this.ftOpt == null) {
            this.ftOpt = new FTOpt();
        }
        return this.ftOpt;
    }

    public void ftOpt(FTOpt opt) {
        this.ftOpt = opt;
    }

    public FElem plan(boolean full) {
        QueryPlan plan = new QueryPlan(this.compiled, this.closed, full);
        if (this.root != null) {
            for (StaticScope staticScope : QueryCompiler.usedDecls(this.root)) {
                staticScope.plan(plan);
            }
            this.root.plan(plan);
        } else {
            this.funcs.plan(plan);
            this.vars.plan(plan);
        }
        return plan.root();
    }

    public void updating() {
        this.updating = true;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.parent == null) {
            this.resources.close();
            this.threads.close();
        } else {
            this.parent.updates = this.updates;
            this.parent.popJob();
        }
        this.options.close();
    }

    @Override
    public String shortInfo() {
        return Text.SAVE;
    }

    public Value get(Var var) {
        return this.stack.get(var);
    }

    public void set(Var var, Value value) throws QueryException {
        this.stack.set(var, value, this);
    }

    public void registerTailCall(XQFunction fn, Value[] arg) {
        this.tailFunc = fn;
        this.args = arg;
    }

    public XQFunction pollTailCall() {
        XQFunction fn = this.tailFunc;
        this.tailFunc = null;
        return fn;
    }

    public Value[] pollTailArgs() {
        Value[] as = this.args;
        this.args = null;
        return as;
    }

    public QueryDateTime dateTime() throws QueryException {
        if (this.dateTime == null) {
            this.dateTime = new QueryDateTime();
        }
        return this.dateTime;
    }

    public String toString() {
        return this.root != null ? QueryInfo.usedDecls(this.root) : this.info.query;
    }

    Value cache(int max) throws QueryException {
        ItemList items;
        Item item;
        int mx = max >= 0 ? max : Integer.MAX_VALUE;
        Iter iter = this.iter();
        Data data = this.resources.globalData();
        if (this.defaultOutput && data != null) {
            IntList pres = new IntList();
            while ((item = this.next(iter)) != null && item.data() == data && pres.size() < mx) {
                pres.add(((DBNode)item).pre());
            }
            int ps = pres.size();
            if (item == null || ps == mx) {
                return ps == 0 ? Empty.VALUE : new DBNodes(data, pres.finish()).ftpos(this.ftPosData);
            }
            items = new ItemList();
            for (int p = 0; p < ps; ++p) {
                items.add(new DBNode(data, pres.get(p)));
            }
            items.add(item);
        } else {
            items = new ItemList();
        }
        while ((item = this.next(iter)) != null && items.size() < mx) {
            item.cache(false, null);
            items.add(item);
        }
        return items.value();
    }

    private Value update() throws QueryException {
        try {
            Value value = this.root.value(this);
            if (this.updates == null || this.parent != null) {
                return value;
            }
            HashSet<Data> datas = this.updates.prepare(this);
            StringList dbs = this.updates.databases();
            QueryFunction<Item, Item> materialize = item -> {
                Data data = item.data();
                boolean copy = data != null && (datas.contains(data) || !data.inMemory() && dbs.contains(data.meta.name));
                Item it = item.materialize(this, copy);
                if (it == null) {
                    throw QueryError.BASEX_FUNCTION_X.get(null, item);
                }
                return it;
            };
            ValueBuilder vb = new ValueBuilder(this);
            for (Item item2 : value) {
                this.checkStop();
                vb.add(materialize.apply(item2));
            }
            for (Item item2 : this.updates.output(true)) {
                this.checkStop();
                vb.add(materialize.apply(item2));
            }
            if (this.context.data() != null) {
                this.context.invalidate();
            }
            this.updates.apply(this);
            return vb.value((Type)null);
        }
        catch (StackOverflowError ex) {
            Util.debug(ex);
            throw QueryError.BASEX_OVERFLOW.get(null, new Object[0]);
        }
    }

    private Value cast(Object value, String type) throws QueryException {
        Type tp;
        StaticContext sc = this.root != null ? this.root.sc : new StaticContext(this);
        E[] object = value;
        if (object instanceof String) {
            String string = (String)object;
            StringList strings = new StringList(1L);
            if (string.indexOf(1) == -1) {
                strings.add(string);
            } else {
                strings.add(string.split("\u0001"));
                object = strings.toArray();
            }
            if (string.indexOf(2) != -1) {
                ValueBuilder vb = new ValueBuilder(this);
                for (String str : strings) {
                    int i = str.indexOf(2);
                    String val = i == -1 ? str : str.substring(0, i);
                    String tp2 = i == -1 ? type : str.substring(i + 1);
                    vb.add(this.cast(val, tp2));
                }
                return vb.value();
            }
        }
        if (type == null || type.isEmpty()) {
            return object instanceof Value ? (Value)object : JavaCall.toValue(object, this, sc);
        }
        if (type.equalsIgnoreCase(MainOptions.MainParser.JSON.name())) {
            try {
                JsonParserOptions jp = new JsonParserOptions();
                jp.set(JsonOptions.FORMAT, JsonOptions.JsonFormat.XQUERY);
                return JsonConverter.get(jp).convert(object.toString(), "");
            }
            catch (QueryIOException ex) {
                throw ex.getCause();
            }
        }
        if (type.equals("empty-sequence()")) {
            return Empty.VALUE;
        }
        QNm nm = new QNm(Token.token(type.replaceAll("\\(.*?\\)$", "")), sc);
        if (!nm.hasURI() && nm.hasPrefix()) {
            throw QueryError.NOURI_X.get(null, new Object[]{nm.string()});
        }
        if (Strings.endsWith(type, ')')) {
            Type type2 = tp = nm.eq(AtomType.ITEM.qname()) ? AtomType.ITEM : NodeType.find(nm);
            if (tp == null) {
                tp = FuncType.find(nm);
            }
        } else {
            tp = ListType.find(nm);
            if (tp == null) {
                tp = AtomType.find(nm, false);
            }
        }
        if (tp == null) {
            throw QueryError.WHICHTYPE_X.get(null, type);
        }
        if (object instanceof Value) {
            Value vl = (Value)object;
            if (vl.isItem()) {
                return tp.cast((Item)vl, this, sc, null);
            }
            ValueBuilder vb = new ValueBuilder(this);
            for (Item item : vl) {
                vb.add(tp.cast(item, this, sc, null));
            }
            return vb.value(tp);
        }
        if (object instanceof String[]) {
            ValueBuilder vb = new ValueBuilder(this);
            for (String string : (String[])object) {
                vb.add(tp.cast(string, this, sc, null));
            }
            return vb.value(tp);
        }
        return tp.cast(object, this, sc, null);
    }

    private static QNm qname(String name, StaticContext sc) throws QueryException {
        return QNm.resolve(Token.token(Strings.startsWith(name, '$') ? name.substring(1) : name), sc);
    }
}

