/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import org.basex.build.json.JsonOptions;
import org.basex.build.json.JsonParserOptions;
import org.basex.io.parse.json.JsonConstants;
import org.basex.io.parse.json.JsonConverter;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.node.FElem;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.hash.TokenObjMap;
import org.basex.util.list.ByteList;

abstract class JsonXmlConverter
extends JsonConverter {
    private final TokenObjMap<TypeCache> names = new TokenObjMap();
    private final boolean merge = this.jopts.get(JsonOptions.MERGE);
    private final boolean strings = this.jopts.get(JsonOptions.STRINGS);
    FDoc doc;
    FElem curr;

    JsonXmlConverter(JsonParserOptions opts) {
        super(opts);
    }

    @Override
    final void init(String uri) {
        this.doc = new FDoc(uri);
    }

    final FElem element() {
        if (this.curr == null) {
            this.curr = new FElem(JsonConstants.JSON);
        }
        return this.curr;
    }

    @Override
    FDoc finish() {
        FElem elem = this.element();
        if (this.merge) {
            ByteList[] types = new ByteList[JsonConstants.ATTRS.length];
            block0: for (TypeCache arr : this.names.values()) {
                if (arr == null) continue;
                int tl = JsonConstants.TYPES.length;
                for (int i = 0; i < tl; ++i) {
                    if (arr.type != JsonConstants.TYPES[i] || !this.strings && arr.type == JsonConstants.STRING) continue;
                    if (types[i] == null) {
                        types[i] = new ByteList();
                    } else {
                        types[i].add(32);
                    }
                    types[i].add(arr.name);
                    continue block0;
                }
            }
            int tl = types.length;
            for (int t = 0; t < tl; ++t) {
                if (types[t] == null) continue;
                elem.add(JsonConstants.ATTRS[t], types[t].finish());
            }
        }
        return this.doc.add(elem);
    }

    final void addType(FElem elem, byte[] name, byte[] type) {
        if (this.merge) {
            if (name != null && !Token.contains(name, 32)) {
                if (this.names.contains(name)) {
                    TypeCache arr = this.names.get(name);
                    if (arr != null && arr.type == type) {
                        arr.add(elem);
                    } else {
                        if (arr != null) {
                            for (int i = 0; i < arr.size; ++i) {
                                this.addType(arr.vals[i], arr.type);
                            }
                            this.names.put(name, null);
                        }
                        this.addType(elem, type);
                    }
                } else {
                    this.names.put(name, new TypeCache(name, type, elem));
                }
            } else {
                this.addType(elem, type);
            }
        } else {
            this.addType(elem, type);
        }
    }

    private void addType(FElem elem, byte[] type) {
        if (this.strings || type != JsonConstants.STRING) {
            elem.add(JsonConstants.TYPE, type);
        }
    }

    private static final class TypeCache {
        private final byte[] type;
        private final byte[] name;
        private FElem[] vals = new FElem[8];
        private int size;

        private TypeCache(byte[] nm, byte[] tp, FElem nd) {
            this.name = nm;
            this.type = tp;
            this.vals[0] = nd;
            this.size = 1;
        }

        private void add(FElem nd) {
            if (this.size == this.vals.length) {
                this.vals = Array.copy(this.vals, new FElem[Array.newCapacity(this.size)]);
            }
            this.vals[this.size++] = nd;
        }
    }
}

