/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.tree;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.SwingUtilities;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPopup;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewNotifier;
import org.basex.gui.view.ViewRect;
import org.basex.gui.view.tree.TreeBorder;
import org.basex.gui.view.tree.TreeConstants;
import org.basex.gui.view.tree.TreeRect;
import org.basex.gui.view.tree.TreeRects;
import org.basex.gui.view.tree.TreeSubtree;
import org.basex.query.value.seq.DBNodes;
import org.basex.util.Token;
import org.basex.util.list.IntList;

public final class TreeView
extends View {
    private TreeSubtree sub;
    private TreeRects tr;
    private int fontHeight;
    private int mousePosX = -1;
    private int mousePosY = -1;
    private int width = -1;
    private int height = -1;
    private int start;
    private BufferedImage treeImage;
    private boolean refreshedFocus;
    private int levelDistance;
    private BufferedImage markedImage;
    private boolean selection;
    private ViewRect selectRect;
    private int nodeHeight;
    private int topMargin;
    private double treedist;
    private TreeRect frect;
    private int flv = -1;
    private int frn;
    private int fpre;
    private TreeConstants.Refresh paintType = TreeConstants.Refresh.INIT;
    private int[] roots;
    private boolean nes;
    private boolean inFocus;
    private boolean showAtts;
    private boolean slimToText;

    public TreeView(ViewNotifier notifier) {
        super("tree", notifier);
        new BaseXPopup(this, GUIConstants.POPUP);
    }

    @Override
    public void refreshContext(boolean more, boolean quick) {
        this.paintType = this.sub == null ? TreeConstants.Refresh.INIT : TreeConstants.Refresh.CONTEXT;
        this.repaint();
    }

    @Override
    public void refreshFocus() {
        this.refreshedFocus = true;
        this.repaint();
    }

    @Override
    public void refreshInit() {
        if (!this.visible()) {
            return;
        }
        this.paintType = TreeConstants.Refresh.INIT;
        this.repaint();
    }

    @Override
    public void refreshLayout() {
        this.paintType = TreeConstants.Refresh.RESIZE;
        this.repaint();
    }

    @Override
    public void refreshMark() {
        if (this.nes) {
            return;
        }
        this.markNodes();
        this.repaint();
    }

    @Override
    public void refreshUpdate() {
        this.paintType = TreeConstants.Refresh.INIT;
        this.repaint();
    }

    @Override
    public boolean visible() {
        boolean v = this.gui.gopts.get(GUIOptions.SHOWTREE);
        if (!v) {
            this.sub = null;
            this.tr = null;
            this.paintType = TreeConstants.Refresh.INIT;
        }
        return v;
    }

    @Override
    public void visible(boolean v) {
        this.gui.gopts.set(GUIOptions.SHOWTREE, v);
    }

    @Override
    protected boolean db() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        Context c = this.gui.context;
        Data data = c.data();
        if (data == null) {
            return;
        }
        if (this.showAttsChanged()) {
            this.paintType = TreeConstants.Refresh.INIT;
        } else if (this.slimToTextChanged() && this.paintType == TreeConstants.Refresh.VOID) {
            this.paintType = TreeConstants.Refresh.RESIZE;
        }
        super.paintComponent(g);
        this.gui.painting = true;
        try {
            boolean winChange;
            DBNodes nodes = this.gui.context.current();
            this.roots = nodes.pres();
            int rl = this.roots.length;
            if (rl == 0) {
                return;
            }
            for (int i = 0; !this.showAtts && i < rl && this.roots[i] < data.meta.size; ++i) {
                if (data.kind(this.roots[i]) != 3) continue;
                this.drawMessage(g, (byte)1);
                return;
            }
            BaseXLayout.antiAlias(g);
            g.setFont(GUIConstants.font);
            this.fontHeight = g.getFontMetrics().getHeight();
            if (this.paintType == TreeConstants.Refresh.INIT) {
                this.sub = new TreeSubtree(data, this.showAtts);
                this.tr = new TreeRects(this);
            }
            this.tr.nodes = nodes;
            this.tr.g = g;
            if (this.paintType == TreeConstants.Refresh.INIT || this.paintType == TreeConstants.Refresh.CONTEXT) {
                this.sub.generateBorders(data, this.roots);
            }
            if ((winChange = this.windowSizeChanged()) && this.paintType == TreeConstants.Refresh.VOID || this.paintType == TreeConstants.Refresh.INIT || this.paintType == TreeConstants.Refresh.CONTEXT || this.paintType == TreeConstants.Refresh.RESIZE) {
                this.treedist = this.tr.generateRects(this.sub, this.start, this.width, this.slimToText);
                boolean bl = this.nes = this.treedist == -1.0;
                if (!this.nes) {
                    this.markedImage = null;
                    this.setLevelDistance();
                    this.createMainImage();
                    if (!this.gui.context.marked.isEmpty()) {
                        this.markNodes();
                    }
                }
            }
            if (this.nes) {
                this.drawMessage(g, (byte)0);
                return;
            }
            g.drawImage(this.treeImage, 0, 0, this.width, this.height, this);
            if (this.selection) {
                if (this.selectRect != null) {
                    int x = this.selectRect.w < 0 ? this.selectRect.x + this.selectRect.w : this.selectRect.x;
                    int y = this.selectRect.h < 0 ? this.selectRect.y + this.selectRect.h : this.selectRect.y;
                    int w = Math.abs(this.selectRect.w);
                    int h = Math.abs(this.selectRect.h);
                    g.setColor(GUIConstants.colormark1);
                    g.drawRect(x, y, w, h);
                }
                this.markNodes();
            }
            if (this.markedImage != null) {
                g.drawImage(this.markedImage, 0, 0, this.width, this.height, this);
            }
            boolean bl = this.inFocus = this.paintType == TreeConstants.Refresh.VOID && this.focus();
            if (this.inFocus && !winChange) {
                int f;
                if (!this.refreshedFocus && this.tr.bigRect(this.sub, this.frn, this.flv) && (f = this.getMostSizedNode(data, this.frn, this.flv, this.frect, this.fpre)) >= 0) {
                    this.fpre = f;
                }
                this.highlightNode(g, this.frn, this.flv, this.frect, this.fpre, -1, TreeConstants.Draw.HIGHLIGHT);
                this.refreshedFocus = false;
            }
            this.paintType = TreeConstants.Refresh.VOID;
        }
        finally {
            this.gui.painting = false;
        }
    }

    private void createMainImage() {
        this.treeImage = this.createImage();
        Graphics tg = this.treeImage.getGraphics();
        int rl = this.roots.length;
        tg.setFont(GUIConstants.font);
        BaseXLayout.antiAlias(tg);
        for (int rn = 0; rn < rl; ++rn) {
            int h = this.sub.subtreeHeight(rn);
            for (int lv = 0; lv < h; ++lv) {
                boolean big = this.tr.bigRect(this.sub, rn, lv);
                TreeRect[] lr = this.tr.treeRectsPerLevel(rn, lv);
                int ll = lr.length;
                for (int i = 0; i < ll; ++i) {
                    TreeRect r = lr[i];
                    int pre = this.sub.prePerIndex(rn, lv, i);
                    this.drawRectangle(tg, rn, lv, r, pre, TreeConstants.Draw.RECTANGLE);
                }
                if (!big) continue;
                TreeRect r = lr[0];
                int ww = r.x + r.w - 1;
                int x = r.x + 1;
                this.drawBigRectSquares(tg, lv, x, ww, 4);
            }
            TreeRect rr = this.tr.treeRectPerIndex(rn, 0, 0);
            this.highlightDescendants(tg, rn, 0, rr, this.roots[rn], TreeView.getRectCenter(rr), TreeConstants.Draw.CONNECTION);
        }
    }

    private void drawMessage(Graphics g, byte t) {
        int mw = this.width >> 1;
        int mh = this.height >> 1;
        String message = "";
        switch (t) {
            case 0: {
                message = Text.NO_PIXELS;
                break;
            }
            case 1: {
                message = "Enable attributes in Tree Options.";
            }
        }
        int x = mw - (BaseXLayout.width(g, message) >> 1);
        int y = mh + this.fontHeight;
        g.setColor(GUIConstants.TEXT);
        g.drawString(message, x, y);
    }

    private void drawBigRectSquares(Graphics g, int lv, int x, int w, int ss) {
        int xx = x;
        int y = this.getYperLevel(lv);
        int nh = this.nodeHeight;
        g.setColor(GUIConstants.color(7));
        while (nh > 0) {
            if ((nh -= ss) < 0) {
                nh = 0;
            }
            g.drawLine(xx, y + nh, w, y + nh);
        }
        while (xx < w) {
            xx = xx + ss - 1 < w ? xx + ss : xx + ss - 1;
            g.drawLine(xx, y, xx, y + this.nodeHeight);
        }
    }

    private boolean marked(int x, int y) {
        if (this.markedImage != null) {
            int h = this.markedImage.getHeight();
            int w = this.markedImage.getWidth();
            if (y >= h || y < 0 || x >= w || x < 0) {
                return false;
            }
            Color markc = new Color(this.markedImage.getRGB(x, y));
            return markc.getRed() > 0 && markc.getBlue() == 0 && markc.getGreen() == 0;
        }
        return false;
    }

    private void drawRectangle(Graphics g, int rn, int lv, TreeRect r, int pre, TreeConstants.Draw t) {
        boolean fill;
        Color fillColor;
        int y = this.getYperLevel(lv);
        int h = this.nodeHeight;
        int xx = r.x;
        int ww = r.w;
        boolean marked = this.marked(xx, y);
        boolean big = this.tr.bigRect(this.sub, rn, lv);
        boolean border = false;
        boolean label = !big && this.fontHeight <= h + 2;
        Color borderColor = null;
        Color textColor = GUIConstants.TEXT;
        switch (t) {
            case RECTANGLE: {
                borderColor = TreeView.getColorPerLevel(lv, false);
                fillColor = TreeView.getColorPerLevel(lv, true);
                border = true;
                fill = true;
                break;
            }
            case HIGHLIGHT: {
                borderColor = GUIConstants.color4;
                int alpha = -587202560;
                int rgb = GUIConstants.lgray.getRGB();
                fillColor = new Color(rgb + -587202560, true);
                if (h > 4) {
                    border = true;
                }
                fill = !big && !marked;
                break;
            }
            case MARK: {
                borderColor = h > 2 && r.w > 4 ? GUIConstants.colormark1A : GUIConstants.colormark1;
                fillColor = GUIConstants.colormark1;
                border = true;
                fill = true;
                break;
            }
            case DESCENDANTS: {
                int alphaD = -587202560;
                int rgbD = GUIConstants.color(6).getRGB();
                fillColor = new Color(rgbD + -587202560, true);
                borderColor = GUIConstants.color(8);
                textColor = GUIConstants.BACK;
                fill = !marked;
                border = true;
                if (h >= 4) break;
                borderColor = fillColor = GUIConstants.color(7);
                label = false;
                break;
            }
            default: {
                fillColor = GUIConstants.color(6);
                textColor = GUIConstants.BACK;
                fill = !big && !marked;
                boolean bl = border = !big;
                if (h >= 4) break;
                fillColor = GUIConstants.color(7);
                borderColor = GUIConstants.color(8);
                label = false;
            }
        }
        if (border) {
            g.setColor(borderColor);
            g.drawRect(xx, y, ww, h);
        }
        if (fill) {
            g.setColor(fillColor);
            g.fillRect(xx + 1, y + 1, ww - 1, h - 1);
        }
        if (label && fill) {
            g.setColor(textColor);
            this.drawRectangleText(g, lv, r, pre);
        }
    }

    private void drawRectangleText(Graphics g, int lv, TreeRect r, int pre) {
        String s = Token.string(this.tr.text(pre)).trim();
        if (r.w < BaseXLayout.width(g, s) && r.w < BaseXLayout.width(g, ".." + s.substring(s.length() - 1)) + 4) {
            return;
        }
        int x = r.x;
        int y = this.getYperLevel(lv);
        int rm = x + r.w / 2;
        int tw = BaseXLayout.width(g, s);
        if (tw > r.w) {
            s = s + "..";
            while ((tw = BaseXLayout.width(g, s)) + 4 > r.w && s.length() > 3) {
                s = s.substring(0, (s.length() - 2) / 2) + "..";
            }
        }
        double yy = (double)y + ((double)this.nodeHeight + (double)this.fontHeight * 0.5) / 2.0;
        g.drawString(s, (int)((double)rm - (double)tw / 2.0 + 2.0), (int)yy);
    }

    private static Color getColorPerLevel(int l, boolean fill) {
        int till = Math.min(l, 4);
        return GUIConstants.color(fill ? till : till + 2);
    }

    private void markSelectedNodes() {
        int x = this.selectRect.w < 0 ? this.selectRect.x + this.selectRect.w : this.selectRect.x;
        int y = this.selectRect.h < 0 ? this.selectRect.y + this.selectRect.h : this.selectRect.y;
        int w = Math.abs(this.selectRect.w);
        int h = Math.abs(this.selectRect.h);
        int t = y + h;
        int size = this.sub.maxSubtreeHeight();
        IntList list = new IntList();
        int rl = this.roots.length;
        int rs = this.treePerX(x);
        int re = this.treePerX(x + w);
        for (int r = Math.max(rs, 0); r <= re; ++r) {
            for (int i = 0; i < size; ++i) {
                int yL = this.getYperLevel(i);
                if (i >= this.sub.subtreeHeight(r) || yL < y && yL + this.nodeHeight < y || yL > t && yL + this.nodeHeight > t) continue;
                TreeRect[] rlv = this.tr.treeRectsPerLevel(r, i);
                int s = this.sub.levelSize(r, i);
                if (this.tr.bigRect(this.sub, r, i)) {
                    if (rl > 1) {
                        TreeBorder tb = this.sub.treeBorder(r, i);
                        int si = tb.size;
                        for (int n = 0; n < si; ++n) {
                            list.add(this.sub.prePerIndex(r, i, n));
                        }
                        continue;
                    }
                    int mw = rlv[0].w;
                    int sPrePos = (int)((double)(s * (x - this.start)) / (double)mw);
                    int ePrePos = (int)((double)(s * (x - this.start + w)) / (double)mw);
                    if (sPrePos < 0) {
                        sPrePos = 0;
                    }
                    if (ePrePos >= s) {
                        ePrePos = s - 1;
                    }
                    do {
                        list.add(this.sub.prePerIndex(r, i, sPrePos));
                    } while (sPrePos++ < ePrePos);
                    continue;
                }
                for (int j = 0; j < s; ++j) {
                    TreeRect rect = rlv[j];
                    if (!rect.contains(x, w)) continue;
                    list.add(this.sub.prePerIndex(r, i, j));
                }
            }
        }
        this.gui.notify.mark(new DBNodes(this.gui.context.data(), list.finish()), (View)this);
    }

    private BufferedImage createImage() {
        return new BufferedImage(Math.max(1, this.width), Math.max(1, this.height), 3);
    }

    private void markNodes() {
        this.markedImage = this.createImage();
        Graphics mg = this.markedImage.getGraphics();
        BaseXLayout.antiAlias(mg);
        mg.setFont(GUIConstants.font);
        int[] marked = this.gui.context.marked.pres();
        if (marked.length == 0) {
            return;
        }
        int rl = this.roots.length;
        for (int rn = 0; rn < rl; ++rn) {
            int ml = marked.length;
            LinkedList<Integer> marklink = new LinkedList<Integer>();
            for (int m = 0; m < ml; ++m) {
                marklink.add(m, marked[m]);
            }
            for (int lv = 0; lv < this.sub.subtreeHeight(rn); ++lv) {
                TreeRect rect;
                int pre;
                int y = this.getYperLevel(lv);
                ListIterator li = marklink.listIterator();
                if (this.tr.bigRect(this.sub, rn, lv)) {
                    while (li.hasNext()) {
                        pre = (Integer)li.next();
                        rect = this.tr.searchRect(this.sub, rn, lv, pre);
                        int ix = this.sub.preIndex(rn, lv, pre);
                        if (ix <= -1) continue;
                        li.remove();
                        int x = (int)((double)(rect.w * ix) / (double)this.sub.levelSize(rn, lv));
                        mg.setColor(GUIConstants.colormark1);
                        mg.fillRect(rect.x + x, y, 2, this.nodeHeight + 1);
                    }
                    continue;
                }
                while (li.hasNext()) {
                    pre = (Integer)li.next();
                    rect = this.tr.searchRect(this.sub, rn, lv, pre);
                    if (rect == null) continue;
                    li.remove();
                    this.drawRectangle(mg, rn, lv, rect, pre, TreeConstants.Draw.MARK);
                }
            }
        }
    }

    private int getBigRectPosition(int rn, int lv, int pre, TreeRect r) {
        int idx = this.sub.preIndex(rn, lv, pre);
        double ratio = (double)idx / (double)this.sub.levelSize(rn, lv);
        return r.x + (int)Math.round((double)r.w * ratio) + 1;
    }

    private int drawNodeInBigRectangle(Graphics g, int rn, int lv, TreeRect r, int pre) {
        int y = this.getYperLevel(lv);
        int np = this.getBigRectPosition(rn, lv, pre, r);
        g.setColor(GUIConstants.color(7));
        g.drawLine(np, y, np, y + this.nodeHeight);
        return np;
    }

    private void drawParentConnection(Graphics g, int lv, TreeRect r, int px, int brx) {
        int y = this.getYperLevel(lv);
        g.setColor(GUIConstants.color(7));
        g.drawLine(px, this.getYperLevel(lv + 1) - 1, brx == -1 ? (2 * r.x + r.w) / 2 : brx, y + this.nodeHeight + 1);
    }

    private void highlightNode(Graphics g, int rn, int lv, TreeRect r, int pre, int px, TreeConstants.Draw t) {
        int rc;
        if (lv == -1) {
            return;
        }
        boolean big = this.tr.bigRect(this.sub, rn, lv);
        boolean root = this.roots[rn] == pre;
        int h = this.sub.subtreeHeight(rn);
        Data d = this.gui.context.data();
        int k = d.kind(pre);
        int size = d.size(pre, k);
        if (big) {
            rc = this.drawNodeInBigRectangle(g, rn, lv, r, pre);
        } else {
            this.drawRectangle(g, rn, lv, r, pre, t);
            rc = TreeView.getRectCenter(r);
        }
        if (px > -1 && this.levelDistance >= 5) {
            this.drawParentConnection(g, lv, r, px, rc);
        }
        if (!root) {
            int lvp = lv - 1;
            int par = d.parent(pre, k);
            TreeRect parRect = this.tr.searchRect(this.sub, rn, lvp, par);
            if (parRect == null) {
                return;
            }
            this.highlightNode(g, rn, lvp, parRect, par, rc, TreeConstants.Draw.PARENT);
        }
        if ((t == TreeConstants.Draw.CONNECTION || t == TreeConstants.Draw.HIGHLIGHT) && size > 1 && lv + 1 < h) {
            this.highlightDescendants(g, rn, lv, r, pre, rc, t);
        }
        if (t == TreeConstants.Draw.HIGHLIGHT) {
            this.drawThumbnails(g, lv, pre, r, root);
        }
    }

    private void drawThumbnails(Graphics g, int lv, int pre, TreeRect r, boolean root) {
        int x = r.x;
        int y = this.getYperLevel(lv);
        int h = this.nodeHeight;
        String s = Token.string(this.tr.text(pre));
        int w = BaseXLayout.width(g, s);
        g.setColor(GUIConstants.color(8));
        int fh = this.fontHeight;
        if (root) {
            g.fillRect(x, y + h, w + 2, fh + 2);
            g.setColor(GUIConstants.color(6));
            g.drawRect(x - 1, y + h + 1, w + 3, fh + 1);
            g.setColor(GUIConstants.BACK);
            g.drawString(s, r.x + 1, (int)((double)(y + h) + (double)fh) - 2);
        } else {
            g.fillRect(r.x, y - fh, w + 2, fh);
            g.setColor(GUIConstants.color(6));
            g.drawRect(r.x - 1, y - fh - 1, w + 3, fh + 1);
            g.setColor(GUIConstants.BACK);
            g.drawString(s, r.x + 1, (int)((double)y - (double)h / (double)fh) - 2);
        }
    }

    private void highlightDescendants(Graphics g, int rn, int lv, TreeRect r, int pre, int px, TreeConstants.Draw t) {
        Data d = this.gui.context.data();
        boolean big = this.tr.bigRect(this.sub, rn, lv);
        if (!big && t != TreeConstants.Draw.CONNECTION) {
            this.drawRectangle(g, rn, lv, r, pre, t);
        }
        int lvd = lv + 1;
        TreeBorder[] sbo = this.sub.subtree(d, pre);
        if (this.sub.subtreeHeight(rn) >= lvd && sbo.length >= 2) {
            if (this.tr.bigRect(this.sub, rn, lvd)) {
                this.drawBigRectDescendants(g, rn, lvd, sbo, px, t);
            } else {
                TreeBorder bo = sbo[1];
                TreeBorder bos = this.sub.treeBorder(rn, lvd);
                int bs = bo.start >= bos.start ? bo.start - bos.start : bo.start;
                for (int j = 0; j < bo.size; ++j) {
                    int dp = this.sub.prePerIndex(rn, lvd, j + bs);
                    TreeRect dr = this.tr.treeRectPerIndex(rn, lvd, j + bs);
                    if (this.levelDistance >= 5) {
                        this.drawDescendantsConn(g, lvd, dr, px, t);
                    }
                    this.highlightDescendants(g, rn, lvd, dr, dp, TreeView.getRectCenter(dr), t == TreeConstants.Draw.CONNECTION ? TreeConstants.Draw.CONNECTION : TreeConstants.Draw.DESCENDANTS);
                }
            }
        }
    }

    private static int getRectCenter(TreeRect r) {
        return (2 * r.x + r.w) / 2;
    }

    private void drawBigRectDescendants(Graphics g, int rn, int lv, TreeBorder[] subt, int parc, TreeConstants.Draw t) {
        int lvv = lv;
        int cen = parc;
        int sl = subt.length;
        for (int i = 1; i < sl && this.tr.bigRect(this.sub, rn, lvv); ++i) {
            TreeBorder bos = this.sub.treeBorder(rn, lvv);
            TreeBorder bo = subt[i];
            TreeRect r = this.tr.treeRectPerIndex(rn, lvv, 0);
            int bs = bo.start - bos.start;
            double sti = (double)bs / (double)bos.size;
            double eni = (double)(bs + bo.size) / (double)bos.size;
            int df = r.x + (int)((double)r.w * sti);
            int dt = r.x + (int)((double)r.w * eni);
            int ww = Math.max(dt - df, 2);
            if (this.levelDistance >= 5) {
                this.drawDescendantsConn(g, lvv, new TreeRect(df, ww), cen, t);
            }
            cen = (2 * df + ww) / 2;
            if (t != TreeConstants.Draw.CONNECTION) {
                g.setColor(GUIConstants.color(7));
                if (this.nodeHeight > 2) {
                    g.drawRect(df, this.getYperLevel(lvv) + 1, ww, this.nodeHeight - 2);
                } else {
                    g.drawRect(df, this.getYperLevel(lvv), ww, this.nodeHeight);
                }
            }
            if (lvv + 1 < this.sub.subtreeHeight(rn) && !this.tr.bigRect(this.sub, rn, lvv + 1)) {
                Data d = this.gui.context.data();
                for (int j = bs; j < bs + bo.size; ++j) {
                    int pre = this.sub.prePerIndex(rn, lvv, j);
                    int pos = this.getBigRectPosition(rn, lvv, pre, r);
                    int k = d.kind(pre);
                    int s = d.size(pre, k);
                    if (s <= 1) continue;
                    this.highlightDescendants(g, rn, lvv, r, pre, pos, t == TreeConstants.Draw.HIGHLIGHT || t == TreeConstants.Draw.DESCENDANTS ? TreeConstants.Draw.DESCENDANTS : TreeConstants.Draw.CONNECTION);
                }
            }
            ++lvv;
        }
    }

    private static Color getConnectionColor(TreeConstants.Draw type) {
        int index;
        int alpha;
        if (type == TreeConstants.Draw.CONNECTION) {
            alpha = 0x20000000;
            index = 4;
        } else {
            alpha = 0x60000000;
            index = 8;
        }
        return new Color(GUIConstants.color(index).getRGB() + alpha, true);
    }

    private void drawDescendantsConn(Graphics g, int lv, TreeRect r, int parc, TreeConstants.Draw t) {
        int pary = this.getYperLevel(lv - 1) + this.nodeHeight;
        int prey = this.getYperLevel(lv) - 1;
        int boRight = r.x + r.w + 2 - 2;
        int boLeft = r.x + 2;
        int boTop = prey + 1;
        Color c = TreeView.getConnectionColor(t);
        g.setColor(c);
        if (boRight - boLeft > 2) {
            g.fillPolygon(new int[]{parc, boRight, boLeft}, new int[]{pary, boTop, boTop}, 3);
        } else {
            g.drawLine((boRight + boLeft) / 2, boTop, parc, pary);
        }
    }

    private boolean focus() {
        if (this.refreshedFocus) {
            this.fpre = this.gui.context.focused;
            int rl = this.roots.length;
            for (int r = 0; r < rl; ++r) {
                for (int i = 0; i < this.sub.subtreeHeight(r); ++i) {
                    if (this.tr.bigRect(this.sub, r, i)) {
                        int index = this.sub.preIndex(r, i, this.fpre);
                        if (index <= -1) continue;
                        this.frn = r;
                        this.frect = this.tr.treeRectsPerLevel(r, i)[0];
                        this.flv = i;
                        return true;
                    }
                    TreeRect rect = this.tr.searchRect(this.sub, r, i, this.fpre);
                    if (rect == null) continue;
                    this.frn = r;
                    this.frect = rect;
                    this.flv = i;
                    return true;
                }
            }
        } else {
            int lv = this.levelPerY(this.mousePosY);
            if (lv < 0) {
                return false;
            }
            int mx = this.mousePosX;
            this.frn = this.treePerX(mx);
            int rn = this.frn;
            int h = this.sub.subtreeHeight(rn);
            if (h < 0 || lv >= h) {
                return false;
            }
            TreeRect[] rL = this.tr.treeRectsPerLevel(rn, lv);
            int rl = rL.length;
            for (int l = 0; l < rl; ++l) {
                int pre;
                TreeRect r = rL[l];
                if (!r.contains(mx)) continue;
                this.frect = r;
                this.flv = lv;
                this.fpre = pre = this.tr.bigRect(this.sub, rn, lv) ? this.tr.prePerXPos(this.sub, rn, lv, mx) : this.sub.prePerIndex(rn, lv, l);
                this.gui.notify.focus(pre, this);
                this.refreshedFocus = false;
                return true;
            }
        }
        this.refreshedFocus = false;
        return false;
    }

    private int getYperLevel(int level) {
        return level * this.nodeHeight + level * this.levelDistance + this.topMargin;
    }

    private int treePerX(int x) {
        return (int)((double)(x - this.start) / this.treedist);
    }

    private int levelPerY(int y) {
        double f = (double)(y - this.topMargin) / ((double)this.levelDistance + (double)this.nodeHeight);
        double b = (double)this.nodeHeight / (double)(this.levelDistance + this.nodeHeight);
        return f <= (double)((int)f) + b ? (int)f : -1;
    }

    private void setLevelDistance() {
        double ld;
        int dist;
        int h = this.height - 9;
        int lvs = 0;
        int rl = this.roots.length;
        for (int r = 0; r < rl; ++r) {
            int th = this.sub.subtreeHeight(r);
            if (th <= lvs) continue;
            lvs = th;
        }
        int nh = (int)((double)GUIConstants.fontSize * 1.4);
        int n = dist = nh <= 8 ? 2 : 16;
        while (true) {
            if ((ld = (double)(h - lvs * nh) / ((double)lvs - 1.0)) >= (double)dist || nh < 1) break;
            --nh;
        }
        this.levelDistance = Math.max(2, Math.min(100, (int)ld));
        this.nodeHeight = nh;
        this.topMargin = Math.max(6, (h - (this.levelDistance * (lvs - 1) + lvs * nh)) / 2);
    }

    private boolean showAttsChanged() {
        GUIOptions gopts = this.gui.gopts;
        if (gopts.get(GUIOptions.TREEATTS) == this.showAtts) {
            return false;
        }
        this.showAtts = !this.showAtts;
        return true;
    }

    private boolean slimToTextChanged() {
        GUIOptions gopts = this.gui.gopts;
        if (gopts.get(GUIOptions.TREESLIMS) == this.slimToText) {
            return false;
        }
        this.slimToText = !this.slimToText;
        return true;
    }

    private boolean windowSizeChanged() {
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.width > -1 && this.height > -1 && h == this.height && w == this.width + 8) {
            return false;
        }
        this.height = h;
        this.start = 4;
        this.width = w - 8;
        return true;
    }

    private int getHitBigRectNodesNum(int rn, int lv, TreeRect r) {
        int w = r.w;
        int ls = this.sub.levelSize(rn, lv);
        return Math.max(ls / Math.max(w, 1), 1);
    }

    private int getMostSizedNode(Data d, int rn, int lv, TreeRect r, int p) {
        int size = this.getHitBigRectNodesNum(rn, lv, r);
        int idx = this.sub.preIndex(rn, lv, p);
        if (idx < 0) {
            return -1;
        }
        int dpre = -1;
        int si = 0;
        for (int i = 0; i < size; ++i) {
            int k;
            int pre = this.sub.prePerIndex(rn, lv, i + idx);
            int s = d.size(pre, k = d.kind(pre));
            if (s <= si) continue;
            si = s;
            dpre = pre;
        }
        return dpre;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.gui.updating) {
            return;
        }
        super.mouseMoved(e);
        this.mousePosX = e.getX();
        this.mousePosY = e.getY();
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.inFocus || this.frect == null) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (this.flv >= this.sub.subtreeHeight(this.frn)) {
                return;
            }
            if (this.tr.bigRect(this.sub, this.frn, this.flv)) {
                int pre;
                DBNodes ns = new DBNodes(this.gui.context.data(), new int[0]);
                int sum = this.getHitBigRectNodesNum(this.frn, this.flv, this.frect);
                int fix = this.sub.preIndex(this.frn, this.flv, this.fpre);
                if (fix + sum + 1 == this.sub.levelSize(this.frn, this.flv)) {
                    ++sum;
                }
                int[] m = new int[sum];
                for (int i = 0; i < sum && (pre = this.sub.prePerIndex(this.frn, this.flv, i + fix)) != -1; ++i) {
                    m[i] = pre;
                }
                ns.union(m);
                this.gui.notify.mark(ns, null);
            } else {
                this.gui.notify.mark(0, null);
            }
            if (e.getClickCount() > 1) {
                this.gui.notify.context(this.gui.context.marked, false, this);
                this.refreshContext(false, false);
            }
        } else if (!this.marked(this.mousePosX, this.mousePosY)) {
            this.gui.notify.mark(0, null);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.gui.updating || this.gui.context.focused == -1) {
            return;
        }
        if (e.getWheelRotation() <= 0) {
            this.gui.notify.context(new DBNodes(this.gui.context.data(), this.gui.context.focused), false, null);
        } else {
            this.gui.notify.hist(false);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.gui.updating || e.isShiftDown()) {
            return;
        }
        if (this.selection) {
            int x = e.getX();
            int y = e.getY();
            this.selectRect.w = x - this.selectRect.x;
            this.selectRect.h = y - this.selectRect.y;
        } else {
            this.selection = true;
            this.selectRect = new ViewRect();
            this.selectRect.x = e.getX();
            this.selectRect.y = e.getY();
            this.selectRect.h = 1;
            this.selectRect.w = 1;
        }
        this.markSelectedNodes();
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.gui.updating || this.gui.painting) {
            return;
        }
        this.selection = false;
        this.repaint();
    }
}

