/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.project;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Predicate;
import org.basex.io.IOFile;
import org.basex.util.Util;
import org.basex.util.list.StringList;

final class ProjectCache
implements Iterable<String> {
    private static final int MAX = 50000;
    private final StringList cache = new StringList();
    private final boolean showHidden;
    private boolean valid;

    ProjectCache(boolean showHidden) {
        this.showHidden = showHidden;
    }

    boolean valid() {
        return this.valid;
    }

    void scan(Path root, Predicate<ProjectCache> stop) throws InterruptedException {
        this.add(root, stop, new HashSet<String>());
        this.valid = true;
    }

    private void add(Path root, Predicate<ProjectCache> stop, HashSet<String> links) throws InterruptedException {
        if (stop.test(this)) {
            throw new InterruptedException();
        }
        try {
            if (Files.isSymbolicLink(root) && !links.add(root.toRealPath(new LinkOption[0]).toString())) {
                return;
            }
            ArrayList<Path> dirs = new ArrayList<Path>();
            ArrayList<IOFile> files = new ArrayList<IOFile>();
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(root);){
                for (Path path : paths) {
                    IOFile io = new IOFile(path.toFile());
                    if (io.ignore()) {
                        return;
                    }
                    if (!this.showHidden && io.isHidden()) continue;
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        dirs.add(path);
                        continue;
                    }
                    files.add(io);
                }
            }
            for (Path dir : dirs) {
                this.add(dir, stop, links);
            }
            for (IOFile file : files) {
                if (this.cache.size() == 50000) {
                    return;
                }
                this.cache.add(file.path());
            }
        }
        catch (IOException ex) {
            Util.debug(ex);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return this.cache.iterator();
    }
}

