/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view;

import org.basex.data.Data;
import org.basex.data.DataText;
import org.basex.gui.GUIOptions;
import org.basex.query.func.Function;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.list.IntList;

public final class ViewData {
    private ViewData() {
    }

    public static boolean leaf(GUIOptions opts, Data data, int pre) {
        int kind = data.kind(pre);
        if (kind == 3) {
            return true;
        }
        boolean atts = opts.get(GUIOptions.MAPATTS);
        int last = pre + (atts ? 1 : data.attSize(pre, kind));
        return last == data.meta.size || data.parent(pre, kind) >= data.parent(last, data.kind(last));
    }

    public static byte[] path(Data data, int pre) {
        if (data == null || pre >= data.meta.size) {
            return Token.EMPTY;
        }
        IntList pres = new IntList();
        int p = pre;
        int k = data.kind(p);
        while (k != 0) {
            pres.add(p);
            p = data.parent(p, k);
            k = data.kind(p);
        }
        TokenBuilder tb = new TokenBuilder();
        tb.add(Function._DB_OPEN.args(data.meta.name, Token.string(data.text(p, true))).trim());
        for (int i = pres.size() - 1; i >= 0; --i) {
            byte[] txt;
            p = pres.get(i);
            k = data.kind(p);
            switch (k) {
                case 2: {
                    txt = DataText.TEXT;
                    break;
                }
                case 4: {
                    txt = DataText.COMMENT;
                    break;
                }
                case 5: {
                    txt = DataText.PI;
                    break;
                }
                case 3: {
                    txt = Token.concat(DataText.ATT, data.name(p, k));
                    break;
                }
                default: {
                    txt = data.name(p, k);
                }
            }
            tb.add(47).add(txt);
        }
        return tb.finish();
    }

    public static byte[] text(Data data, int pre) {
        int kind = data.kind(pre);
        switch (kind) {
            case 1: {
                return data.name(pre, kind);
            }
            case 3: {
                return Token.concat(DataText.ATT, data.name(pre, kind), DataText.ATT1, data.text(pre, false), DataText.ATT2);
            }
        }
        return data.text(pre, true);
    }

    public static byte[] namedText(GUIOptions opts, Data data, int pre) {
        byte[] attr;
        int id;
        if (opts.get(GUIOptions.SHOWNAME).booleanValue() && data.kind(pre) == 1 && (id = ViewData.nameID(data)) != 0 && (attr = data.attValue(id, pre)) != null) {
            return attr;
        }
        return Token.chop(ViewData.text(data, pre), 32);
    }

    public static int nameID(Data data) {
        return data.attrNames.id(DataText.T_NAME);
    }

    public static int sizeID(Data data) {
        return data.attrNames.id(DataText.T_SIZE);
    }

    public static int parent(Data data, int pre) {
        return data.parent(pre, data.kind(pre));
    }

    public static int size(Data data, int pre) {
        return data.size(pre, data.kind(pre));
    }
}

