/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.basex.core.Context;
import org.basex.data.MetaData;
import org.basex.gui.layout.BaseXTree;
import org.basex.util.Strings;
import org.basex.util.Token;

public abstract class ResourceNode
extends DefaultMutableTreeNode
implements TreeWillExpandListener {
    public final byte[] name;
    final byte[] path;
    final BaseXTree tree;
    final Context context;
    boolean updating;

    ResourceNode(byte[] name, byte[] path, BaseXTree tree, Context context) {
        this.name = name;
        this.path = path;
        this.tree = tree;
        this.context = context;
        tree.addTreeWillExpandListener(this);
    }

    public static byte[] preparePath(byte[] path) {
        String p = MetaData.normPath(Token.string(path));
        if (Strings.endsWith(p, '/')) {
            p = p.substring(0, p.length() - 1);
        }
        return Token.concat(Token.SLASH, Token.token(p));
    }

    public final String path() {
        return Token.string(ResourceNode.preparePath(Token.concat(this.path, Token.SLASH, this.name)));
    }

    abstract void load();

    @Override
    public void treeWillExpand(TreeExpansionEvent e) {
        if (this.equals(e.getPath().getLastPathComponent())) {
            this.load();
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent e) {
    }

    @Override
    public String toString() {
        return Token.string(this.name);
    }
}

