/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URI;
import javax.swing.JComponent;
import javax.swing.JDialog;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIConstants;
import org.basex.gui.dialog.DialogMessage;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.layout.TableLayout;
import org.basex.util.Util;

public abstract class BaseXDialog
extends JDialog
implements BaseXWindow {
    public GUI gui;
    final StringBuilder mnem = new StringBuilder();
    protected boolean ok;
    protected BaseXBack panel;
    public final KeyListener keys = e -> {
        if (!BaseXKeys.modifier(e) && e.getKeyChar() != '\uffff') {
            this.action(e.getSource());
        }
    };

    protected BaseXDialog(BaseXDialog dialog, String title) {
        super(dialog, title, true);
        this.gui = dialog.gui;
        this.init();
    }

    protected BaseXDialog(GUI gui, String title) {
        this(gui, title, true);
    }

    protected BaseXDialog(GUI gui, String title, boolean modal) {
        super(gui, title, modal);
        this.gui = gui;
        this.init();
    }

    private void init() {
        this.panel = new BaseXBack(new BorderLayout()).border(10, 10, 10, 10);
        this.add((Component)this.panel, "Center");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BaseXDialog.this.cancel();
            }
        });
    }

    protected final void set(Component comp, String pos) {
        this.panel.add(comp, pos);
    }

    protected final void finish() {
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        this.setLocationRelativeTo(this.gui);
        this.setVisible(true);
    }

    public void action(Object source) {
    }

    public void cancel() {
        this.ok = false;
        this.dispose();
    }

    public void close() {
        this.ok = true;
        this.dispose();
    }

    @Override
    public void dispose() {
        if (this.gui != null && this.modal()) {
            this.gui.saveOptions();
            this.gui = null;
        }
        super.dispose();
    }

    public final boolean modal() {
        return this.getModalityType() != Dialog.ModalityType.MODELESS;
    }

    public final boolean ok() {
        return this.ok;
    }

    protected final BaseXBack okCancel() {
        return this.newButtons(Text.B_OK, Text.B_CANCEL);
    }

    public final BaseXBack newButtons(Object ... buttons) {
        BaseXBack pnl = new BaseXBack(false).border(12, 0, 0, 0).layout(new TableLayout(1, buttons.length, 8, 0));
        for (Object obj : buttons) {
            pnl.add(obj instanceof BaseXButton ? (BaseXButton)obj : new BaseXButton(this, obj.toString()));
        }
        BaseXBack but = new BaseXBack(false).layout(new BorderLayout());
        but.add((Component)pnl, "East");
        return but;
    }

    protected static void enableOK(JComponent panel, String label, boolean enabled) {
        for (Component c : panel.getComponents()) {
            if (c instanceof BaseXButton) {
                BaseXButton b = (BaseXButton)c;
                if (!b.getText().equals(label)) continue;
                b.setEnabled(enabled);
                continue;
            }
            if (!(c instanceof JComponent)) continue;
            BaseXDialog.enableOK((JComponent)c, label, enabled);
        }
    }

    public static String yesNoCancel(GUI gui, String text, String ... buttons) {
        return new DialogMessage(gui, text.trim(), GUIConstants.Msg.YESNOCANCEL, buttons).action();
    }

    public static boolean confirm(GUI gui, String text) {
        return Text.B_YES.equals(new DialogMessage(gui, text.trim(), GUIConstants.Msg.QUESTION, new String[0]).action());
    }

    public static void error(GUI gui, String text) {
        new DialogMessage(gui, text.trim(), GUIConstants.Msg.ERROR, new String[0]);
    }

    public static void browse(GUI gui, String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Exception ex) {
            Util.debug(ex);
            BaseXDialog.error(gui, Util.info(Text.H_BROWSER_ERROR_X, Text.PUBLIC_URL));
        }
    }

    @Override
    public GUI gui() {
        return this.gui;
    }

    @Override
    public BaseXDialog dialog() {
        return this;
    }

    @Override
    public BaseXDialog component() {
        return this;
    }
}

