/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.text.DecimalFormat;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXSerial;
import org.basex.gui.layout.BaseXSlider;
import org.basex.gui.layout.ColumnLayout;
import org.basex.gui.layout.RowLayout;
import org.basex.util.Performance;

final class DialogResultPrefs
extends BaseXBack {
    private static final int[] MAXRESULTS = new int[]{50000, 100000, 250000, 500000, 1000000, 2500000, Integer.MAX_VALUE};
    private static final int[] MAXTEXT = new int[]{0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, Integer.MAX_VALUE};
    private final GUI gui;
    private final BaseXSerial serial;
    private final BaseXSlider maxResults;
    private final BaseXSlider maxText;
    private final BaseXLabel labelResults;
    private final BaseXLabel labelText;

    DialogResultPrefs(BaseXDialog dialog) {
        this.border(8).setLayout(new ColumnLayout(40));
        this.gui = dialog.gui;
        int val = DialogResultPrefs.sliderIndex(this.gui.gopts.get(GUIOptions.MAXRESULTS), MAXRESULTS);
        this.maxResults = new BaseXSlider(dialog, 0, MAXRESULTS.length - 1, val);
        this.maxResults.addActionListener(e -> this.action());
        this.labelResults = new BaseXLabel(" ");
        val = DialogResultPrefs.sliderIndex(this.gui.gopts.get(GUIOptions.MAXTEXT), MAXTEXT);
        this.maxText = new BaseXSlider(dialog, 0, MAXTEXT.length - 1, val);
        this.maxText.addActionListener(e -> this.action());
        this.labelText = new BaseXLabel(" ");
        this.serial = new BaseXSerial(dialog, this.gui.context.options.get(MainOptions.SERIALIZER));
        BaseXBack p = new BaseXBack().layout(new RowLayout());
        p.add(new BaseXLabel(Text.LIMITS + ":", true, true));
        BaseXBack pp = new BaseXBack(new RowLayout());
        BaseXBack ppp = new BaseXBack(new ColumnLayout(12));
        ppp.add(this.maxResults);
        ppp.add(this.labelResults);
        pp.add(new BaseXLabel(Text.MAX_NO_OF_HITS + ":"));
        pp.add(ppp);
        ppp = new BaseXBack(new ColumnLayout(12));
        ppp.add(this.maxText);
        ppp.add(this.labelText);
        pp.add(new BaseXLabel(Text.SIZE_TEXT_RESULTS + ":"));
        pp.add(ppp);
        p.add(pp);
        this.add(p);
        this.add(this.serial);
    }

    boolean action() {
        this.gui.gopts.set(GUIOptions.MAXTEXT, MAXTEXT[this.maxText.getValue()]);
        this.gui.gopts.set(GUIOptions.MAXRESULTS, MAXRESULTS[this.maxResults.getValue()]);
        int mr = MAXRESULTS[this.maxResults.getValue()];
        this.labelResults.setText(mr == Integer.MAX_VALUE ? Text.ALL : new DecimalFormat("#,###,###").format(mr));
        int mt = MAXTEXT[this.maxText.getValue()];
        this.labelText.setText(mt == Integer.MAX_VALUE ? Text.ALL : Performance.format(mt));
        return true;
    }

    void update() {
        this.serial.init(this.gui.context.options.get(MainOptions.SERIALIZER));
    }

    void cancel() {
        this.gui.set(MainOptions.SERIALIZER, this.serial.options());
    }

    private static int sliderIndex(int value, int[] values) {
        int hl = values.length - 1;
        int i = -1;
        while (++i < hl && values[i] < value) {
        }
        return i;
    }
}

