/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.Component;
import java.io.IOException;
import org.basex.build.csv.CsvOptions;
import org.basex.build.csv.CsvParserOptions;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.dialog.DialogParser;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXCheckBox;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXDialog;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXTextField;
import org.basex.gui.layout.BaseXWindow;
import org.basex.gui.layout.ColumnLayout;
import org.basex.gui.layout.RowLayout;
import org.basex.gui.layout.TableLayout;
import org.basex.gui.text.TextPanel;
import org.basex.io.IOContent;
import org.basex.io.parse.csv.CsvConverter;
import org.basex.util.Strings;
import org.basex.util.list.StringList;

final class DialogCsvParser
extends DialogParser {
    private static final String EXAMPLE = "Name,Born?_\n\"John, Adam\\\",1984";
    private final CsvParserOptions copts;
    private final TextPanel example;
    private final BaseXCombo encoding;
    private final BaseXCheckBox header;
    private final BaseXCombo format;
    private final BaseXCombo seps;
    private final BaseXTextField sepchar;
    private final BaseXCheckBox lax;
    private final BaseXCheckBox quotes;
    private final BaseXCheckBox backslashes;

    DialogCsvParser(BaseXDialog dialog, MainOptions opts) {
        this.copts = new CsvParserOptions(opts.get(MainOptions.CSVPARSER));
        BaseXBack pp = new BaseXBack(new RowLayout(8));
        BaseXBack p = new BaseXBack(new TableLayout(4, 2, 8, 4));
        p.add(new BaseXLabel(Text.ENCODING + ":", true, true));
        this.encoding = DialogCsvParser.encoding(dialog, this.copts.get(CsvParserOptions.ENCODING));
        p.add(this.encoding);
        BaseXBack sep = new BaseXBack().layout(new ColumnLayout(6));
        StringList csv = new StringList();
        for (CsvOptions.CsvSep cs : CsvOptions.CsvSep.values()) {
            csv.add(cs.toString());
        }
        String[] sa = (String[])csv.toArray();
        this.seps = new BaseXCombo((BaseXWindow)dialog, (String[])((StringList)((Object)csv.add(""))).finish());
        sep.add(this.seps);
        String s = this.copts.get(CsvOptions.SEPARATOR);
        if (Strings.eq(s, sa)) {
            this.seps.setSelectedItem(s);
        } else {
            this.seps.setSelectedIndex(sa.length);
        }
        this.sepchar = new BaseXTextField(dialog, s);
        this.sepchar.setColumns(2);
        sep.add(this.sepchar);
        p.add(new BaseXLabel(Text.SEPARATOR, true, true));
        p.add(sep);
        p.add(new BaseXLabel(Text.FORMAT + ":", true, true));
        CsvOptions.CsvFormat[] formats = CsvOptions.CsvFormat.values();
        int fl = formats.length - 1;
        StringList frmts = new StringList(fl);
        for (int f = 0; f < fl; ++f) {
            frmts.add(formats[f].toString());
        }
        this.format = new BaseXCombo((BaseXWindow)dialog, (String[])frmts.finish());
        this.format.setSelectedItem((Object)this.copts.get(CsvOptions.FORMAT));
        p.add(this.format);
        pp.add(p);
        p = new BaseXBack(new RowLayout());
        this.header = new BaseXCheckBox(dialog, Text.FIRST_LINE_HEADER, CsvOptions.HEADER, this.copts);
        p.add(this.header);
        this.quotes = new BaseXCheckBox(dialog, Text.PARSE_QUOTES, CsvOptions.QUOTES, this.copts);
        p.add(this.quotes);
        this.backslashes = new BaseXCheckBox(dialog, Text.BACKSLASHES, CsvOptions.BACKSLASHES, this.copts);
        p.add(this.backslashes);
        this.lax = new BaseXCheckBox(dialog, Text.LAX_NAME_CONVERSION, CsvOptions.LAX, this.copts);
        p.add(this.lax);
        pp.add(p);
        this.add((Component)pp, "West");
        this.example = new TextPanel(dialog, false);
        this.add((Component)this.example, "Center");
        this.action(true);
    }

    @Override
    boolean action(boolean active) {
        try {
            boolean head = this.header.isSelected();
            this.format.setEnabled(head);
            this.lax.setEnabled(head && this.copts.get(CsvOptions.FORMAT) == CsvOptions.CsvFormat.DIRECT);
            this.example.setText(DialogCsvParser.example(MainOptions.MainParser.CSV.name(), EXAMPLE, CsvConverter.get(this.copts).convert(new IOContent(EXAMPLE)).serialize().toString()));
        }
        catch (IOException ex) {
            this.example.setText(DialogCsvParser.error(ex));
        }
        boolean fixedsep = this.seps.getSelectedIndex() < CsvOptions.CsvSep.values().length;
        this.sepchar.setEnabled(!fixedsep);
        if (fixedsep) {
            this.sepchar.setText(new String(Character.toChars(this.copts.separator())));
        }
        return fixedsep || this.sepchar.getText().length() == 1;
    }

    @Override
    void update() {
        String sep;
        String enc = this.encoding.getSelectedItem();
        this.copts.set(CsvParserOptions.ENCODING, enc.equals("UTF-8") ? null : enc);
        this.copts.set(CsvOptions.HEADER, this.header.isSelected());
        this.copts.set(CsvOptions.FORMAT, this.format.getSelectedItem());
        this.copts.set(CsvOptions.LAX, this.lax.isSelected());
        this.copts.set(CsvOptions.QUOTES, this.quotes.isSelected());
        this.copts.set(CsvOptions.BACKSLASHES, this.backslashes.isSelected());
        if (this.seps.getSelectedIndex() < CsvOptions.CsvSep.values().length) {
            sep = this.seps.getSelectedItem();
        } else {
            sep = this.sepchar.getText();
            for (CsvOptions.CsvSep cs : CsvOptions.CsvSep.values()) {
                if (!String.valueOf(cs.sep).equals(sep)) continue;
                sep = cs.toString();
            }
        }
        this.copts.set(CsvOptions.SEPARATOR, sep);
    }

    @Override
    void setOptions(GUI gui) {
        gui.set(MainOptions.CSVPARSER, this.copts);
    }
}

