/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboPopup;
import org.basex.core.parse.CommandParser;
import org.basex.data.Data;
import org.basex.gui.GUI;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXWindow;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QuerySuggest;
import org.basex.util.Strings;
import org.basex.util.list.StringList;

public final class GUIInput
extends BaseXCombo {
    private final GUI gui;
    private final BaseXCombo completions;
    private GUIInputPopup popup;
    private String pre = "";

    GUIInput(final GUI main) {
        super((BaseXWindow)main, true, new String[0]);
        this.gui = main;
        BaseXLayout.resizeFont(this, 1.3f);
        this.completions = new BaseXCombo((BaseXWindow)main, new String[0]);
        this.completions.addActionListener(e -> this.completeInput());
        this.popup = new GUIInputPopup(this.completions);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (BaseXKeys.ESCAPE.is(e)) {
                    GUIInput.this.popup.setVisible(false);
                } else if (BaseXKeys.ENTER.is(e)) {
                    if (GUIInput.this.popup.isVisible()) {
                        GUIInput.this.completeInput();
                        GUIInput.this.popup.setVisible(false);
                    } else {
                        GUIInput.this.updateHistory();
                        if (e.getModifiersEx() == 0) {
                            GUIInput.this.gui.execute();
                        }
                    }
                }
                int count = GUIInput.this.completions.getItemCount();
                if (count == 0) {
                    return;
                }
                int bi = GUIInput.this.completions.getSelectedIndex();
                if (BaseXKeys.NEXTLINE.is(e)) {
                    if (GUIInput.this.popup.isVisible()) {
                        if (++bi == count) {
                            bi = 0;
                        }
                    } else {
                        GUIInput.this.showCompletions();
                    }
                } else if (BaseXKeys.PREVLINE.is(e)) {
                    if (GUIInput.this.popup.isVisible()) {
                        if (--bi < 0) {
                            bi = count - 1;
                        }
                    } else {
                        GUIInput.this.showCompletions();
                    }
                }
                if (bi != GUIInput.this.completions.getSelectedIndex()) {
                    GUIInput.this.completions.setSelectedIndex(bi);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!BaseXKeys.NEXTLINE.is(e) && !BaseXKeys.PREVLINE.is(e)) {
                    if (BaseXKeys.modifier(e) || BaseXKeys.control(e)) {
                        return;
                    }
                    GUIInput.this.showCompletions();
                    if (((GUIInput)GUIInput.this).gui.gopts.get(GUIOptions.EXECRT).booleanValue() && !GUIInput.this.cmdMode()) {
                        main.execute();
                    }
                }
            }
        });
    }

    @Override
    public void setText(String txt) {
        super.setText(txt);
        this.completions.removeAllItems();
        this.popup.setVisible(false);
    }

    void mode(String mode) {
        int i;
        this.hint(mode + "...").setText("");
        Data data = this.gui.context.data();
        int n = i = data == null ? 2 : this.gui.gopts.get(GUIOptions.SEARCHMODE);
        this.history(i == 0 ? GUIOptions.SEARCH : (i == 1 ? GUIOptions.XQUERY : GUIOptions.COMMANDS), this.gui.gopts);
    }

    private boolean cmdMode() {
        return this.gui.gopts.get(GUIOptions.SEARCHMODE) == 2 || this.gui.context.data() == null || Strings.startsWith(this.getText(), '!');
    }

    private void completeInput() {
        int ll;
        String suffix = this.completions.getSelectedItem();
        if (suffix.isEmpty()) {
            return;
        }
        int pl = this.pre.length();
        int n = ll = pl > 0 ? (int)this.pre.charAt(pl - 1) : 32;
        if (Character.isLetter(ll) && Character.isLetter(suffix.charAt(0))) {
            this.pre = this.pre + " ";
        }
        this.setText(this.pre + suffix);
        this.showCompletions();
        if (this.gui.gopts.get(GUIOptions.EXECRT).booleanValue() && !this.cmdMode()) {
            this.gui.execute();
        }
    }

    private void showCompletions() {
        String query = this.getText();
        int mode = this.gui.gopts.get(GUIOptions.SEARCHMODE);
        if (this.cmdMode()) {
            this.cmdPopup(query);
        } else if (mode == 1 || mode == 0 && Strings.startsWith(query, '/')) {
            this.queryPopup(query);
        } else {
            this.popup.setVisible(false);
        }
    }

    private void cmdPopup(String query) {
        StringList sl;
        block2: {
            sl = null;
            boolean excl = Strings.startsWith(query, '!');
            try {
                this.pre = excl ? "!" : "";
                String suf = this.getText().substring(this.pre.length());
                CommandParser.get(suf, this.gui.context).suggest().parse();
            }
            catch (QueryException ex) {
                sl = ex.suggest();
                int marked = ex.markedColumn() + (excl ? 2 : 1);
                if (ex.markedColumn() <= -1 || marked > query.length()) break block2;
                this.pre = query.substring(0, marked);
            }
        }
        this.createCombo(sl);
    }

    private void queryPopup(String query) {
        StringList sl;
        Data data = this.gui.context.data();
        if (data == null) {
            return;
        }
        try (QueryContext qc = new QueryContext(this.gui.context);){
            QuerySuggest qs = new QuerySuggest(query, qc, data);
            qs.parseMain();
            sl = qs.complete();
            this.pre = query.substring(0, qs.mark);
        }
        catch (QueryException ex) {
            sl = ex.suggest();
            this.pre = query.substring(0, ex.column() - 1);
        }
        if (this.textField().getCaretPosition() < this.pre.length()) {
            sl = null;
        }
        this.createCombo(sl);
    }

    private void createCombo(StringList sl) {
        if (sl == null || sl.isEmpty()) {
            this.popup.setVisible(false);
            return;
        }
        if (this.completionsChanged(sl)) {
            this.completions.setItems((String[])sl.toArray());
            this.completions.setSelectedIndex(-1);
            this.popup = new GUIInputPopup(this.completions);
        }
        int w = this.getFontMetrics(this.getFont()).stringWidth(this.pre);
        this.popup.show(this, Math.min(this.getWidth(), w), this.getHeight());
    }

    private boolean completionsChanged(StringList sl) {
        if (sl.size() != this.completions.getItemCount()) {
            return true;
        }
        int is = sl.size();
        for (int i = 0; i < is; ++i) {
            if (((String)sl.get(i)).equals(this.completions.getItemAt(i))) continue;
            return true;
        }
        return false;
    }

    private static final class GUIInputPopup
    extends BasicComboPopup {
        GUIInputPopup(JComboBox<Object> combo) {
            super(combo);
            int h = combo.getMaximumRowCount();
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.getPopupHeightForRowCount(h) + 2));
        }
    }
}

