/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.users.Perm;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.IOFile;
import org.basex.io.in.BufferInput;
import org.basex.io.out.PrintOutput;
import org.basex.util.Strings;
import org.xml.sax.InputSource;

public final class Store
extends ACreate {
    public Store(String path) {
        this(path, (String)null);
    }

    public Store(String path, String input) {
        super(Perm.WRITE, true, path == null ? "" : path, input);
    }

    @Override
    protected boolean run() {
        Data data;
        boolean create = this.context.user().has(Perm.CREATE);
        String path = MetaData.normPath(this.args[0]);
        if (path == null) {
            return this.error(Text.PATH_INVALID_X, this.args[0]);
        }
        if (this.in == null) {
            IO io = IO.get(this.args[1]);
            if (!io.exists() || io.isDir()) {
                return this.error(Text.RES_NOT_FOUND_X, create ? io : this.args[1]);
            }
            this.in = io.inputSource();
            if ((path.isEmpty() || Strings.endsWith(path, '/')) && !(io instanceof IOContent)) {
                path = path + io.name();
            }
        }
        if ((data = this.context.data()).inMemory()) {
            return this.error(Text.NO_MAINMEM, new Object[0]);
        }
        final IOFile file = data.meta.binary(path);
        if (path.isEmpty() || Strings.endsWith(path, '.') || file == null) {
            return this.error(Text.PATH_INVALID_X, create ? path : this.args[0]);
        }
        return this.update(data, new ACreate.Code(){

            @Override
            boolean run() throws IOException {
                Store.store(Store.this.in, file);
                return Store.this.info(Text.QUERY_EXECUTED_X_X, new Object[]{"", Store.this.jc().performance});
            }
        });
    }

    public static void store(InputSource in, IOFile file) throws IOException {
        block30: {
            if (file.isDir()) {
                file.delete();
            }
            file.parent().md();
            try (PrintOutput po = new PrintOutput(file);){
                Reader r = in.getCharacterStream();
                InputStream is = in.getByteStream();
                String id = in.getSystemId();
                if (r != null) {
                    int c;
                    while ((c = r.read()) != -1) {
                        po.print(c);
                    }
                    break block30;
                }
                if (is != null) {
                    int b;
                    while ((b = is.read()) != -1) {
                        po.write(b);
                    }
                    break block30;
                }
                if (id == null) break block30;
                try (BufferInput bi = BufferInput.get(IO.get(id));){
                    int b;
                    while ((b = bi.read()) != -1) {
                        po.write(b);
                    }
                }
            }
        }
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init().arg("TO", 0).add(1);
    }
}

