/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.Text;
import org.basex.core.cmd.AQuery;
import org.basex.query.expr.path.Axis;
import org.basex.util.Array;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.XMLToken;
import org.basex.util.list.BoolList;
import org.basex.util.list.StringList;
import org.basex.util.list.TokenList;

public final class Find
extends AQuery {
    private final boolean root;

    public Find(String query) {
        this(query, false);
    }

    public Find(String query, boolean rt) {
        super(true, query);
        this.root = rt;
    }

    @Override
    protected boolean run() {
        String query = Find.find(this.args[0], this.context, this.root);
        boolean ok = this.query(query);
        StringBuilder sb = new StringBuilder();
        if (this.options.get(MainOptions.QUERYINFO).booleanValue()) {
            sb.append(Text.NL).append(Text.QUERY_CC).append(Text.NL).append(query).append(Text.NL);
        }
        sb.append(this.info());
        this.error(sb.toString(), new Object[0]);
        return ok;
    }

    @Override
    public boolean updating(Context ctx) {
        return this.updates(ctx, Find.find(this.args[0], ctx, this.root));
    }

    @Override
    public void addLocks() {
        this.jc().locks.reads.add("internal:context");
    }

    public static String find(String query, Context ctx, boolean root) {
        boolean r;
        if (Strings.startsWith(query, '/')) {
            return query;
        }
        boolean bl = r = root || ctx.root();
        if (query.isEmpty()) {
            return r ? "/" : ".";
        }
        String qu = query.replaceAll(" \\+", " ");
        String[] terms = Find.split(qu);
        StringBuilder pre = new StringBuilder();
        StringBuilder preds = new StringBuilder();
        for (String term : terms) {
            if (term.startsWith("@=")) {
                preds.append("[@* = \"").append(term.substring(2)).append("\"]");
                continue;
            }
            if (Strings.startsWith(term, '=')) {
                preds.append("[text() = \"").append(term.substring(1)).append("\"]");
                continue;
            }
            if (Strings.startsWith(term, '~')) {
                preds.append("[text() contains text \"").append(term.substring(1));
                preds.append("\" using fuzzy]");
                continue;
            }
            if (Strings.startsWith(term, '@')) {
                if (term.length() == 1) continue;
                preds.append("[@* contains text \"").append(term.substring(1)).append("\"]");
                term = term.substring(1);
                if (!XMLToken.isName(Token.token(term))) continue;
                pre.append(r ? "" : ".").append("//@").append(term).append(" | ");
                continue;
            }
            preds.append("[text() contains text \"").append(term).append("\"]");
            if (!XMLToken.isName(Token.token(term))) continue;
            if (r) {
                pre.append('/');
            }
            pre.append((Object)Axis.DESCENDANT).append("::*:").append(term).append(" | ");
        }
        if (pre.length() == 0 && preds.length() == 0) {
            return root ? "/" : ".";
        }
        return pre + (r ? "/" : "") + (Object)((Object)Axis.DESCENDANT_OR_SELF) + "::*" + preds;
    }

    public static String findTable(StringList filter, TokenList cols, BoolList elem, byte[] name, boolean root) {
        TokenBuilder tb = new TokenBuilder();
        int is = filter.size();
        for (int i = 0; i < is; ++i) {
            String[] spl;
            for (String s : spl = Find.split((String)filter.get(i))) {
                byte[] term = Token.trim(Token.replace(Token.token(s), 34, 32));
                if (term.length == 0) continue;
                boolean elm = elem.get(i);
                tb.add(91).add(elm ? ".//" : "@").add("*:").add((byte[])cols.get(i));
                if (term[0] == 60 || term[0] == 62) {
                    tb.add(term[0]).addLong(Find.calcNum(Token.substring(term, 1)));
                } else {
                    tb.add(" contains text \"").add(term).add(34);
                }
                tb.add(93);
            }
        }
        return tb.isEmpty() ? "/" : (root ? "/" : "") + (Object)((Object)Axis.DESCENDANT_OR_SELF) + "::*:" + Token.string(name) + tb;
    }

    private static long calcNum(byte[] tok) {
        long i;
        int tl = tok.length;
        int s1 = tok.length < 1 ? 0 : Token.lc(tok[tl - 1]);
        int s2 = tok.length < 2 ? 0 : Token.lc(tok[tl - 2]);
        int f = 0;
        if (s1 == 107) {
            --tl;
            f = 10;
        }
        if (s1 == 109) {
            --tl;
            f = 20;
        }
        if (s1 == 103) {
            --tl;
            f = 30;
        }
        if (s1 == 98 && s2 == 107) {
            tl -= 2;
            f = 10;
        }
        if (s1 == 98 && s2 == 109) {
            tl -= 2;
            f = 20;
        }
        if (s1 == 98 && s2 == 103) {
            tl -= 2;
            f = 30;
        }
        return (i = Token.toLong(tok, 0, tl) << f) == Long.MIN_VALUE ? 0L : i;
    }

    private static String[] split(String str) {
        int l = str.length();
        String[] split = new String[l];
        int s = 0;
        char delim = '\u0000';
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < l; ++i) {
            char c = str.charAt(i);
            if (delim == '\u0000') {
                if (c == '\'' || c == '\"') {
                    delim = c;
                    continue;
                }
                if (!XMLToken.isChar(c) && c != '@' && c != '=' && c != '<' && c != '>' && c != '~') {
                    if (sb.length() == 0) continue;
                    split[s++] = sb.toString();
                    sb.setLength(0);
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == delim) {
                delim = '\u0000';
                if (sb.length() == 0) continue;
                split[s++] = sb.toString();
                sb.setLength(0);
                continue;
            }
            if (c == '\'' || c == '\"') continue;
            sb.append(c);
        }
        if (sb.length() != 0) {
            split[s++] = sb.toString();
        }
        return Array.copyOf(split, s);
    }
}

