/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Context;
import org.basex.core.Databases;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.core.cmd.ACreate;
import org.basex.core.locks.Locks;
import org.basex.core.parse.CmdBuilder;
import org.basex.core.parse.Commands;
import org.basex.data.Data;
import org.basex.io.IOFile;
import org.basex.util.list.StringList;

public final class DropDB
extends ACreate {
    public DropDB(String name) {
        super(name);
    }

    @Override
    protected boolean run() {
        String pattern = this.args[0];
        if (!Databases.validPattern(pattern)) {
            return this.error(Text.NAME_INVALID_X, pattern);
        }
        StringList dbs = this.context.listDBs(pattern);
        if (dbs.isEmpty()) {
            return this.info(Text.NO_DB_DROPPED, new Object[0]);
        }
        boolean ok = true;
        for (String db : dbs) {
            DropDB.close(this.context, db);
            if (this.context.pinned(db)) {
                this.info(Text.DB_PINNED_X, db);
                ok = false;
                continue;
            }
            if (!DropDB.drop(db, this.soptions)) {
                this.info(Text.DB_NOT_DROPPED_X, db);
                ok = false;
                continue;
            }
            this.info(Text.DB_DROPPED_X, db);
        }
        return ok;
    }

    public static synchronized boolean drop(Data data, StaticOptions sopts) {
        if (data.inMemory()) {
            return true;
        }
        data.close();
        return DropDB.drop(data.meta.name, sopts);
    }

    public static synchronized boolean drop(String db, StaticOptions sopts) {
        IOFile dbpath = sopts.dbPath(db);
        return dbpath.exists() && dbpath.delete();
    }

    public static synchronized boolean drop(IOFile path, String pat) {
        boolean ok = true;
        for (IOFile f : path.children()) {
            ok &= !f.name().matches(pat) || f.delete();
        }
        return ok;
    }

    @Override
    public boolean newData(Context ctx) {
        return DropDB.close(ctx, this.args[0]);
    }

    @Override
    public void addLocks() {
        Locks locks = this.jc().locks;
        if (!this.addLocks(locks.writes, 0)) {
            locks.writes.addGlobal();
        }
    }

    @Override
    public void build(CmdBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.DROP) + " " + (Object)((Object)Commands.CmdDrop.DB)).args();
    }
}

