/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core;

import java.util.HashSet;
import java.util.regex.Pattern;
import org.basex.core.StaticOptions;
import org.basex.io.IOFile;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.list.StringList;

public final class Databases {
    public static final String DBCHARS = "-+=~!#$%^&()[]{}@'`";
    private static final String DATE = "\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}";
    private static final String REGEXCHARS = "-+=~!#$%^&()[]{}@'`".replaceAll("(.)", "\\\\$1");
    private static final Pattern ZIPPATTERN = Pattern.compile("-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}\\.zip$");
    private static final Pattern REGEX = Pattern.compile(".*[*?,].*");
    private final StaticOptions soptions;

    Databases(StaticOptions soptions) {
        this.soptions = soptions;
    }

    public StringList list() {
        return this.list(true, null);
    }

    StringList listDBs(String pattern) {
        return this.list(false, pattern);
    }

    private StringList list(boolean backup, String pattern) {
        Pattern pt = pattern == null ? null : Databases.regex(pattern);
        IOFile[] files = this.soptions.dbPath().children();
        StringList list = new StringList(files.length);
        HashSet<String> map = new HashSet<String>(files.length);
        for (IOFile file : files) {
            String name = file.name();
            String add = null;
            if (backup && name.endsWith(".zip")) {
                String n = ZIPPATTERN.split(name)[0];
                if (!n.equals(name)) {
                    add = n;
                }
            } else if (file.isDir() && !Strings.startsWith(name, '.')) {
                add = name;
            }
            if (add == null || pt != null && !pt.matcher(add).matches() || !map.add(add)) continue;
            list.add(add);
        }
        return list.sort(false);
    }

    public static Pattern regex(String pattern) {
        return Databases.regex(pattern, "");
    }

    private static Pattern regex(String pattern, String suffix) {
        if (pattern == null) {
            return null;
        }
        String nm = REGEX.matcher(pattern).matches() ? IOFile.regex(pattern) : pattern.replaceAll("([" + REGEXCHARS + "])", "\\\\$1") + suffix;
        return Pattern.compile(nm, Prop.CASE ? 0 : 2);
    }

    public StringList backups() {
        StringList backups = new StringList();
        for (IOFile file : this.soptions.dbPath().children()) {
            String name = file.name();
            if (!name.endsWith(".zip")) continue;
            backups.add(name.substring(0, name.lastIndexOf(46)));
        }
        return backups;
    }

    public StringList backups(String db) {
        StringList backups = new StringList();
        IOFile path = this.soptions.dbPath(db + ".zip");
        if (path.exists()) {
            backups.add(db);
        } else {
            Pattern regex = Databases.regex(db, "-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}\\.zip");
            for (IOFile file : this.soptions.dbPath().children()) {
                String name = file.name();
                if (!regex.matcher(name).matches()) continue;
                backups.add(name.substring(0, name.lastIndexOf(46)));
            }
        }
        return backups.sort(Prop.CASE, false);
    }

    public static String name(String backup) {
        return Pattern.compile("-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}$").split(backup)[0];
    }

    public static String date(String backup) {
        return backup.replaceAll("^.+-(\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2})$", "$1");
    }

    public static boolean validChar(int ch, boolean firstLast) {
        return Token.letterOrDigit(ch) || DBCHARS.indexOf(ch) != -1 || !firstLast && ch == 46;
    }

    public static boolean validName(String name) {
        return Databases.valid(name, false);
    }

    public static boolean validPattern(String pattern) {
        return Databases.valid(pattern, true);
    }

    private static boolean valid(String name, boolean glob) {
        if (name == null) {
            return false;
        }
        int nl = name.length();
        for (int n = 0; n < nl; ++n) {
            char ch = name.charAt(n);
            if (glob && (ch == '?' || ch == '*' || ch == ',') || Databases.validChar(ch, n == 0 || n + 1 == nl)) continue;
            return false;
        }
        return nl != 0;
    }
}

