/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.dom;

import java.util.Iterator;
import org.basex.api.dom.BXAttr;
import org.basex.api.dom.BXComm;
import org.basex.api.dom.BXDoc;
import org.basex.api.dom.BXElem;
import org.basex.api.dom.BXNList;
import org.basex.api.dom.BXNNode;
import org.basex.api.dom.BXPI;
import org.basex.api.dom.BXText;
import org.basex.io.IO;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FAttr;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;

public abstract class BXNode
implements Node {
    private static final short[] TYPES = new short[]{9, 1, 3, 2, 8, 7, 4, 11};
    private static final String[] NAMES = new String[]{"#document", null, "#text", null, "#comment", null, "#cdata-section", "#document-fragment"};
    final ANode nd;

    BXNode(ANode nd) {
        this.nd = nd;
    }

    public static BXNode get(ANode node) {
        if (node == null) {
            return null;
        }
        switch (node.nodeType()) {
            case DOCUMENT_NODE: {
                return new BXDoc(node);
            }
            case ELEMENT: {
                return new BXElem(node);
            }
            case TEXT: {
                return new BXText(node);
            }
            case COMMENT: {
                return new BXComm(node);
            }
            case PROCESSING_INSTRUCTION: {
                return new BXPI(node);
            }
            case ATTRIBUTE: {
                return new BXAttr(new FAttr(node.qname(), node.string()));
            }
        }
        return null;
    }

    @Override
    public String getNodeName() {
        return NAMES[this.kind()];
    }

    @Override
    public final short getNodeType() {
        return TYPES[this.kind()];
    }

    int kind() {
        return this.nd.kind();
    }

    @Override
    public String getNodeValue() {
        return null;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public final BXNode cloneNode(boolean deep) {
        return this.nd.toJava();
    }

    @Override
    public final short compareDocumentPosition(Node node) {
        return (short)Integer.compare(this.nd.diff(((BXNode)node).nd), 0);
    }

    @Override
    public BXNNode getAttributes() {
        return null;
    }

    @Override
    public final String getBaseURI() {
        return IO.get(Token.string(this.nd.baseURI())).url();
    }

    @Override
    public BXNList getChildNodes() {
        return new BXNList(BXNode.finish(this.nd.childIter()));
    }

    @Override
    public BXNode getFirstChild() {
        return BXNode.get(this.nd.childIter().next());
    }

    @Override
    public final BXNode getLastChild() {
        ANode node = null;
        Iterator<ANode> iterator = this.nd.childIter().iterator();
        while (iterator.hasNext()) {
            ANode n;
            node = n = iterator.next();
        }
        return node != null ? BXNode.get(node) : null;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public BXNode getNextSibling() {
        return BXNode.get(this.nd.followingSiblingIter().next());
    }

    @Override
    public BXNode getPreviousSibling() {
        return BXNode.get(this.nd.precedingSiblingIter().next());
    }

    @Override
    public final BXNode getParentNode() {
        return BXNode.get(this.nd.parent());
    }

    @Override
    public final boolean hasChildNodes() {
        return this.getFirstChild() != null;
    }

    @Override
    public final boolean isSameNode(Node node) {
        return node instanceof BXNode && ((BXNode)node).nd.is(this.nd);
    }

    @Override
    public BXDoc getOwnerDocument() {
        ANode p;
        ANode n = this.nd;
        while ((p = n.parent()) != null) {
            n = p;
        }
        return n.type == NodeType.DOCUMENT_NODE ? (BXDoc)BXNode.get(n) : null;
    }

    @Override
    public final boolean hasAttributes() {
        return this.getAttributes().getLength() != 0;
    }

    @Override
    public final Object getFeature(String feature, String version) {
        return null;
    }

    @Override
    public final String getPrefix() {
        return null;
    }

    @Override
    public final String getTextContent() {
        return Token.string(this.nd.string());
    }

    @Override
    public final BXNode appendChild(Node node) {
        throw BXNode.readOnly();
    }

    @Override
    public final Object getUserData(String name) {
        return null;
    }

    @Override
    public final boolean isSupported(String name, String version) {
        return false;
    }

    @Override
    public final BXNode insertBefore(Node node, Node ref) {
        throw BXNode.readOnly();
    }

    @Override
    public final boolean isDefaultNamespace(String uri) {
        throw BXNode.notImplemented();
    }

    @Override
    public final boolean isEqualNode(Node cmp) {
        throw BXNode.notImplemented();
    }

    @Override
    public final String lookupNamespaceURI(String prefix) {
        throw BXNode.notImplemented();
    }

    @Override
    public final String lookupPrefix(String uri) {
        throw BXNode.notImplemented();
    }

    @Override
    public final void normalize() {
        throw BXNode.readOnly();
    }

    @Override
    public final BXNode removeChild(Node node) {
        throw BXNode.readOnly();
    }

    @Override
    public final BXNode replaceChild(Node node, Node old) {
        throw BXNode.readOnly();
    }

    @Override
    public final void setNodeValue(String value) {
        throw BXNode.readOnly();
    }

    @Override
    public final void setPrefix(String prefix) {
        throw BXNode.readOnly();
    }

    @Override
    public final void setTextContent(String value) {
        throw BXNode.readOnly();
    }

    @Override
    public final Object setUserData(String name, Object value, UserDataHandler handler) {
        throw BXNode.readOnly();
    }

    public final String toString() {
        return '[' + this.getNodeName() + ": " + this.getNodeValue() + ']';
    }

    final BXNList getElements(String name) {
        ANodeList nb = new ANodeList();
        byte[] nm = "*".equals(name) ? null : Token.token(name);
        for (ANode n : this.nd.descendantIter()) {
            if (n.type != NodeType.ELEMENT || nm != null && !Token.eq(nm, n.name())) continue;
            nb.add(n.finish());
        }
        return new BXNList(nb);
    }

    static ANodeList finish(BasicNodeIter iter) {
        ANodeList nl = new ANodeList();
        for (ANode n : iter) {
            nl.add(n.finish());
        }
        return nl;
    }

    public final ANode getNode() {
        return this.nd;
    }

    static DOMException readOnly() {
        return new DOMException(7, "DOM implementation is read-only.");
    }

    static UnsupportedOperationException notImplemented() {
        return new UnsupportedOperationException();
    }
}

