/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.common;

import ModelInterface.InterfaceMain;
import ModelInterface.common.FileChooser;
import ModelInterface.common.RecentFilesList;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.filechooser.FileFilter;

public class AWTFileChooserWrapper
implements FileChooser {
    @Override
    public File[] doFilePrompt(Component component, String string, int n, File file, FileFilter fileFilter) {
        return this.doFilePrompt(component, string, n, file, fileFilter, null, null);
    }

    @Override
    public File[] doFilePrompt(Component component, String string, int n, File file, final FileFilter fileFilter, ActionListener actionListener, String string2) {
        FileDialog fileDialog = null;
        if (component instanceof Frame) {
            fileDialog = new FileDialog((Frame)component, string);
        } else if (component instanceof Dialog) {
            fileDialog = new FileDialog((Dialog)component, string);
        } else {
            System.out.println("WARNING: This FileChooser does not support a parent Component of such a type.");
            fileDialog = new FileDialog((Frame)InterfaceMain.getInstance().getFrame(), string);
        }
        if (!file.isDirectory()) {
            fileDialog.setDirectory(file.getParent());
            fileDialog.setFile(file.getName());
        } else {
            fileDialog.setDirectory(file.getAbsolutePath());
        }
        if (n == 0) {
            fileDialog.setMode(0);
        } else if (n == 1) {
            fileDialog.setMode(1);
        } else {
            System.out.println("Invalid load/save flag");
            assert (false);
        }
        fileDialog.setFilenameFilter(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return fileFilter != null ? fileFilter.accept(new File(file, string)) : true;
            }
        });
        String string3 = "false";
        if (fileFilter != null && fileFilter.getDescription().startsWith("Directory")) {
            string3 = "true";
            fileDialog.setMode(0);
        }
        System.setProperty("apple.awt.fileDialogForDirectories", string3);
        fileDialog.setVisible(true);
        System.setProperty("apple.awt.fileDialogForDirectories", "false");
        String string4 = fileDialog.getFile();
        if (string4 == null) {
            return null;
        }
        File[] fileArray = new File[]{new File(fileDialog.getDirectory(), string4)};
        if (actionListener != null && string2 != null) {
            RecentFilesList.getInstance().addFile(fileArray, actionListener, string2);
        }
        return fileArray;
    }
}

