/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2.undo;

import ModelInterface.ModelGUI2.tables.BaseTableModel;
import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.w3c.dom.Node;

public class TableUndoableEdit
extends AbstractUndoableEdit {
    private BaseTableModel bt;
    private int row;
    private int col;
    private Node n;
    private String oldVal;
    private Map<String, Node> data;
    private String key;

    public TableUndoableEdit(BaseTableModel baseTableModel, int n, int n2, Node node, String string, Map<String, Node> map, String string2) {
        this.bt = baseTableModel;
        this.row = n;
        this.col = n2;
        this.n = node;
        this.oldVal = string;
        this.data = map;
        this.key = string2;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return "Edit Cell Value";
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.canUndo()) {
            if (this.oldVal != null) {
                String string = this.n.getNodeValue();
                this.n.setNodeValue(this.oldVal);
                this.oldVal = string;
            } else {
                this.data.put(this.key, null);
            }
        } else {
            throw new CannotUndoException();
        }
        this.bt.fireTableCellUpdated(this.row, this.col);
    }

    @Override
    public void redo() throws CannotRedoException {
        if (this.canRedo()) {
            if (this.oldVal != null) {
                String string = this.n.getNodeValue();
                this.n.setNodeValue(this.oldVal);
                this.oldVal = string;
            } else {
                this.data.put(this.key, this.n);
            }
        } else {
            throw new CannotRedoException();
        }
        this.bt.fireTableCellUpdated(this.row, this.col);
    }
}

