/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2.undo;

import ModelInterface.ModelGUI2.DbViewer;
import ModelInterface.ModelGUI2.ScenarioListItem;
import ModelInterface.ModelGUI2.undo.MiAbstractUndoableEdit;
import ModelInterface.ModelGUI2.xmldb.XMLDB;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.value.node.ANode;

public class RenameScenarioUndoableEdit
extends MiAbstractUndoableEdit {
    private DbViewer viewer;
    private ScenarioListItem oldName;
    private String newName;

    public RenameScenarioUndoableEdit(DbViewer dbViewer, ScenarioListItem scenarioListItem, String string) {
        this.viewer = dbViewer;
        this.oldName = scenarioListItem;
        this.newName = string;
        this.doRename(scenarioListItem.getScnName(), string);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public String getUndoPresentationName() {
        return super.getUndoPresentationName() + " Rename Scenario " + this.newName;
    }

    @Override
    public String getRedoPresentationName() {
        return super.getRedoPresentationName() + " Rename Scenario " + this.oldName.getScnName();
    }

    @Override
    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this.doRename(this.newName, this.oldName.getScnName());
    }

    @Override
    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this.doRename(this.oldName.getScnName(), this.newName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRename(String string, String string2) {
        try (QueryProcessor queryProcessor = XMLDB.getInstance().createQuery("/scenario[@date='" + this.oldName.getScnDate() + "' and @name='" + string + "']/@name", null, null, null);){
            Iter iter = queryProcessor.iter();
            ANode aNode = (ANode)iter.next();
            XMLDB.getInstance().setValue(aNode, string2);
            this.viewer.resetScenarioList();
        }
    }
}

