/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2.undo;

import ModelInterface.ModelGUI2.QueryTreeModel;
import ModelInterface.ModelGUI2.undo.MiAbstractUndoableEdit;
import java.util.ArrayList;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreePath;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class QueryAddRemoveUndoableEdit
extends MiAbstractUndoableEdit {
    private QueryTreeModel qt;
    private TreePath path;
    private QueryTreeModel.QueryGroup parent;
    private int[] indices;
    private Object[] children;
    private boolean isInsert;

    public QueryAddRemoveUndoableEdit(TreeModelEvent treeModelEvent, boolean bl) {
        this.isInsert = bl;
        this.qt = (QueryTreeModel)treeModelEvent.getSource();
        this.path = treeModelEvent.getTreePath();
        this.parent = (QueryTreeModel.QueryGroup)this.path.getLastPathComponent();
        this.indices = treeModelEvent.getChildIndices();
        this.children = treeModelEvent.getChildren();
        this.addListener(this.qt);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public String getPresentationName() {
        if (this.isInsert) {
            return "Create Query " + this.children[0].toString();
        }
        if (this.children.length == 1) {
            return "Remove Query " + this.children[0].toString();
        }
        return "Remove All Queries";
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.canUndo()) {
            if (this.isInsert) {
                this.doRemove();
            } else {
                this.doAdd();
            }
        } else {
            throw new CannotUndoException();
        }
        this.fireUndoPerformed(this, this);
    }

    @Override
    public void redo() throws CannotRedoException {
        if (this.canRedo()) {
            if (this.isInsert) {
                this.doAdd();
            } else {
                this.doRemove();
            }
        } else {
            throw new CannotRedoException();
        }
        this.fireRedoPerformed(this, this);
    }

    private void doAdd() {
        ArrayList arrayList = this.parent.getQueryList();
        for (int i = 0; i < this.indices.length; ++i) {
            arrayList.add(this.indices[i], this.children[i]);
        }
        this.qt.fireTreeNodesInserted(this, this.path, this.indices, this.children);
    }

    private void doRemove() {
        ArrayList arrayList = this.parent.getQueryList();
        for (int i = 0; i < this.indices.length; ++i) {
            arrayList.remove(this.indices[i]);
        }
        this.qt.fireTreeNodesRemoved(this, this.path, this.indices, this.children);
    }
}

