/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2.undo;

import ModelInterface.ModelGUI2.queries.QueryGenerator;
import ModelInterface.ModelGUI2.undo.MiAbstractUndoableEdit;
import ModelInterface.ModelGUI2.undo.MiUndoableEditListener;
import ModelInterface.common.DataPair;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class EditQueryUndoableEdit
extends MiAbstractUndoableEdit {
    private QueryGenerator qg;
    private boolean hasSetOldValues;
    private boolean hasSetNewValues;
    private boolean hasRealChanges;
    private String oldTitle;
    private String oldAxis1Name;
    private DataPair<String, String> oldNodeLevel;
    private String oldAxis2Name;
    private DataPair<String, String> oldYearLevel;
    private String oldVar;
    private String oldLabelColumnName;
    private String oldXPath;
    private boolean oldSumAll;
    private boolean oldGroup;
    private boolean oldBuildSingleList;
    private String oldComments;
    private String newTitle;
    private String newAxis1Name;
    private DataPair<String, String> newNodeLevel;
    private String newAxis2Name;
    private DataPair<String, String> newYearLevel;
    private String newVar;
    private String newLabelColumnName;
    private String newXPath;
    private boolean newSumAll;
    private boolean newGroup;
    private boolean newBuildSingleList;
    private String newComments;

    public EditQueryUndoableEdit(QueryGenerator queryGenerator, MiUndoableEditListener miUndoableEditListener) {
        this.qg = queryGenerator;
        this.hasSetNewValues = false;
        this.hasSetOldValues = false;
        this.hasRealChanges = false;
        this.addListener(miUndoableEditListener);
        if (this.qg.hasSingleQueryExtension() && this.qg.getSingleQueryExtension() != null) {
            this.addListener(this.qg.getSingleQueryExtension());
        }
    }

    public void setOldValues(QueryGenerator queryGenerator) {
        this.oldTitle = queryGenerator.toString();
        this.oldAxis1Name = queryGenerator.getAxis1Name();
        this.oldAxis2Name = queryGenerator.getAxis2Name();
        this.oldNodeLevel = queryGenerator.getNodeLevelPair();
        this.oldYearLevel = queryGenerator.getYearLevelPair();
        this.oldVar = queryGenerator.getVariable();
        this.oldLabelColumnName = queryGenerator.getChartLabelColumnName();
        this.oldXPath = queryGenerator.getXPath();
        this.oldSumAll = queryGenerator.isSumAll();
        this.oldGroup = queryGenerator.isGroup();
        this.oldBuildSingleList = queryGenerator.isBuildList();
        this.oldComments = queryGenerator.getRealComments();
        this.hasSetOldValues = true;
    }

    public void setNewValues(QueryGenerator queryGenerator) {
        this.newTitle = queryGenerator.toString();
        boolean bl = !this.doDiffCheck(this.oldTitle, this.newTitle);
        this.hasRealChanges = this.hasRealChanges || bl;
        this.newAxis1Name = queryGenerator.getAxis1Name();
        bl = !this.doDiffCheck(this.oldAxis1Name, this.newAxis1Name);
        this.hasRealChanges = this.hasRealChanges || bl;
        this.newAxis2Name = queryGenerator.getAxis2Name();
        bl = !this.doDiffCheck(this.oldAxis2Name, this.newAxis2Name);
        this.hasRealChanges = this.hasRealChanges || bl;
        this.newNodeLevel = queryGenerator.getNodeLevelPair();
        bl = !this.doDiffCheck(this.oldNodeLevel.getKey(), this.newNodeLevel.getKey());
        this.hasRealChanges = this.hasRealChanges || bl;
        bl = !this.doDiffCheck(this.oldNodeLevel.getValue(), this.newNodeLevel.getValue());
        this.hasRealChanges = this.hasRealChanges || bl;
        this.newYearLevel = queryGenerator.getYearLevelPair();
        bl = !this.doDiffCheck(this.oldYearLevel.getKey(), this.newYearLevel.getKey());
        this.hasRealChanges = this.hasRealChanges || bl;
        bl = !this.doDiffCheck(this.oldYearLevel.getValue(), this.newYearLevel.getValue());
        this.hasRealChanges = this.hasRealChanges || bl;
        this.newVar = queryGenerator.getVariable();
        bl = !this.doDiffCheck(this.oldVar, this.newVar);
        this.hasRealChanges = this.hasRealChanges || bl;
        this.newLabelColumnName = queryGenerator.getChartLabelColumnName();
        bl = !this.doDiffCheck(this.oldLabelColumnName, this.newLabelColumnName);
        this.hasRealChanges = this.hasRealChanges || bl;
        this.newXPath = queryGenerator.getXPath();
        bl = !this.doDiffCheck(this.oldXPath, this.newXPath);
        this.hasRealChanges = this.hasRealChanges || bl;
        this.newSumAll = queryGenerator.isSumAll();
        bl = this.oldSumAll != this.newSumAll;
        this.hasRealChanges = this.hasRealChanges || bl;
        this.newGroup = queryGenerator.isGroup();
        bl = this.oldGroup != this.newGroup;
        this.hasRealChanges = this.hasRealChanges || bl;
        this.newBuildSingleList = queryGenerator.isBuildList();
        bl = this.oldBuildSingleList != this.newBuildSingleList;
        this.hasRealChanges = this.hasRealChanges || bl;
        this.newComments = queryGenerator.getRealComments();
        bl = !this.doDiffCheck(this.oldComments, this.newComments);
        this.hasRealChanges = this.hasRealChanges || bl;
        this.hasSetNewValues = true;
    }

    private boolean doDiffCheck(Object object, Object object2) {
        return object == null && (object2 == null || object2.equals("")) || object2.equals(object);
    }

    public boolean hasRealChanges() {
        if (!this.hasSetOldValues || !this.hasSetNewValues) {
            return false;
        }
        return this.hasRealChanges;
    }

    public boolean didXPathChange() {
        return !this.doDiffCheck(this.oldXPath, this.newXPath);
    }

    public boolean didNodeLevelChange() {
        return !this.doDiffCheck(this.oldNodeLevel.getKey(), this.newNodeLevel.getKey()) || !this.doDiffCheck(this.oldNodeLevel.getValue(), this.newNodeLevel.getValue());
    }

    @Override
    public boolean canUndo() {
        return this.hasSetOldValues;
    }

    @Override
    public boolean canRedo() {
        return this.hasSetNewValues;
    }

    @Override
    public String getPresentationName() {
        return "Edit Query " + this.qg.toString();
    }

    @Override
    public void undo() throws CannotUndoException {
        if (this.canUndo()) {
            if (this.didNodeLevelChange() || this.didXPathChange()) {
                this.qg.resetCollapseOnList();
            }
        } else {
            throw new CannotUndoException();
        }
        this.qg.setTitle(this.oldTitle);
        this.qg.setAxis1Name(this.oldAxis1Name);
        this.qg.setAxis2Name(this.oldAxis2Name);
        this.qg.setNodeLevel(this.oldNodeLevel);
        this.qg.setYearLevel(this.oldYearLevel);
        this.qg.setVariable(this.oldVar);
        this.qg.setCharLabelColumnName(this.oldLabelColumnName);
        this.qg.setXPath(this.oldXPath);
        this.qg.setSumAll(this.oldSumAll);
        this.qg.setGroup(this.oldGroup);
        this.qg.setBuildList(this.oldBuildSingleList);
        this.qg.setComments(this.oldComments);
        this.fireUndoPerformed(this, this);
    }

    @Override
    public void redo() throws CannotRedoException {
        if (this.canRedo()) {
            if (this.didNodeLevelChange() || this.didXPathChange()) {
                this.qg.resetCollapseOnList();
            }
        } else {
            throw new CannotRedoException();
        }
        this.qg.setTitle(this.newTitle);
        this.qg.setAxis1Name(this.newAxis1Name);
        this.qg.setAxis2Name(this.newAxis2Name);
        this.qg.setNodeLevel(this.newNodeLevel);
        this.qg.setYearLevel(this.newYearLevel);
        this.qg.setVariable(this.newVar);
        this.qg.setCharLabelColumnName(this.newLabelColumnName);
        this.qg.setXPath(this.newXPath);
        this.qg.setSumAll(this.newSumAll);
        this.qg.setGroup(this.newGroup);
        this.qg.setBuildList(this.newBuildSingleList);
        this.qg.setComments(this.newComments);
        this.fireRedoPerformed(this, this);
    }
}

