/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2.tables;

import ModelInterface.InterfaceMain;
import ModelInterface.ModelGUI2.DOMmodel;
import ModelInterface.ModelGUI2.Documentation;
import ModelInterface.ModelGUI2.queries.QueryGenerator;
import ModelInterface.ModelGUI2.tables.BaseTableModel;
import ModelInterface.ModelGUI2.tables.CopyPaste;
import ModelInterface.ModelGUI2.tables.NewDataTableModel;
import ModelInterface.ModelGUI2.tables.TableSorter;
import ModelInterface.ModelGUI2.xmldb.DbProcInterrupt;
import ModelInterface.ModelGUI2.xmldb.XMLDB;
import ModelInterface.common.DataPair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.basex.api.dom.BXNode;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.value.node.ANode;
import org.jfree.chart.JFreeChart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MultiTableModel
extends BaseTableModel {
    private static final long serialVersionUID = 1L;
    Vector tables;
    TableRenderer tableRenderer;
    TableEditor tableEditor;
    QueryGenerator qg;

    public MultiTableModel(TreePath treePath, Document document, String string, Documentation documentation) {
        super(treePath, document, string, documentation);
        this.wild = this.chooseTableHeaders(treePath);
        this.wild.set(0, ((DOMmodel.DOMNodeAdapter)this.wild.get(0)).getNode().getNodeName());
        this.wild.set(1, ((DOMmodel.DOMNodeAdapter)this.wild.get(1)).getNode().getNodeName());
        this.wild.add("");
        this.buildTable(this.treePathtoXPath(treePath, document.getDocumentElement(), 0));
        this.tableEditor = new TableEditor();
        this.tableRenderer = new TableRenderer();
        this.activeRows = new Vector(this.tables.size());
        for (int i = 0; i < this.tables.size(); ++i) {
            this.activeRows.add(new Integer(i));
        }
    }

    @Override
    public void flip(int n, int n2) {
        ((NewDataTableModel)((JTable)((JScrollPane)this.getValueAt(n, n2)).getViewport().getView()).getModel()).flip(n, n2);
    }

    @Override
    protected void buildTable(XPathExpression xPathExpression) {
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)xPathExpression.evaluate(this.doc.getDocumentElement(), XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
        }
        xPathExpression = null;
        TreeSet<Object> treeSet = new TreeSet<Object>();
        TreeSet<Object> treeSet2 = new TreeSet<Object>();
        this.tableFilterMaps = new LinkedHashMap();
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            Object[] objectArray = this.getRegionAndYearFromNode(node.getParentNode(), this.tableFilterMaps);
            treeSet.add(objectArray[0]);
            treeSet2.add(objectArray[1]);
            this.addToDataTree(node, treeMap).put((String)objectArray[0] + ";" + (String)objectArray[1], node);
            if (this.units != null) continue;
            this.units = ((Element)node.getParentNode()).getAttribute("unit");
        }
        this.recAddTables(treeMap, null, treeSet, treeSet2, "");
    }

    private Object[] getRegionAndYearFromNode(Node node, Map map) {
        Vector<String> vector = new Vector<String>(2, 0);
        do {
            String string;
            Map map2;
            if (node.getNodeName().equals((String)this.wild.get(0)) || node.getNodeName().equals((String)this.wild.get(1))) {
                vector.add(this.getOneAttrVal(node));
                continue;
            }
            if (!node.hasAttributes() || (map2 = map.containsKey(node.getNodeName()) ? (Map)map.get(node.getNodeName()) : new HashMap()).containsKey(string = this.getOneAttrVal(node))) continue;
            map2.put(string, new Boolean(true));
            map.put(node.getNodeName(), map2);
        } while ((node = node.getParentNode()).getNodeType() != 9);
        return vector.toArray();
    }

    private Map addToDataTree(Node node, Map map) {
        if (node.getNodeType() == 9) {
            return map;
        }
        Map map2 = this.addToDataTree(node.getParentNode(), map);
        if ((((String)this.wild.get(0)).matches(".*[Ss]ector") || ((String)this.wild.get(1)).matches(".*[Ss]ector")) && node.getNodeName().equals(".*[Ss]ector")) {
            return map2;
        }
        if (node.hasAttributes() && !node.getNodeName().equals((String)this.wild.get(0)) && !node.getNodeName().equals((String)this.wild.get(1))) {
            String string = this.getOneAttrVal(node);
            string = node.getNodeName() + "@" + string;
            if (!map2.containsKey(string)) {
                map2.put(string, new TreeMap());
            }
            return (Map)map2.get(string);
        }
        return map2;
    }

    private void recAddTables(Map map, Map.Entry entry, Set set, Set set2, String string) {
        for (Map.Entry entry2 : map.entrySet()) {
            if (entry2.getValue() instanceof Node || entry2.getValue() instanceof Double || entry2.getValue() instanceof String) {
                NewDataTableModel newDataTableModel;
                if (entry2.getValue() instanceof Double || entry2.getValue() instanceof String) {
                    newDataTableModel = new NewDataTableModel(set, this.qg.getAxis1Name(), set2, this.qg.getVariable(), this.title, (Map)entry.getValue(), this.doc, null, this.qg.shouldAppendRewriteValues() ? this.qg.getNodeLevelRewriteMap().values() : null);
                    newDataTableModel.setColNameIndex(this.qg.getChartLabelColumnName());
                } else {
                    newDataTableModel = new NewDataTableModel(set, (String)this.wild.get(0), set2, (String)this.wild.get(1), this.title, (Map)entry.getValue(), this.doc, this.documentation, null);
                }
                newDataTableModel.units = this.units;
                if (this.tables == null) {
                    this.tables = new Vector();
                }
                String string2 = string.replace("/", ",   ").replace("@", ": ");
                string2 = string2.substring(2, string2.length());
                this.tables.add(string2);
                JFrame jFrame = InterfaceMain.getInstance().getFrame();
                if (jFrame == null) {
                    this.tables.add(newDataTableModel);
                } else {
                    JTable jTable = newDataTableModel.getAsSortedTable();
                    jTable.setAutoResizeMode(0);
                    jTable.setCellSelectionEnabled(true);
                    Iterator iterator = set.iterator();
                    int n = 1;
                    while (iterator.hasNext()) {
                        TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
                        tableColumn.setPreferredWidth(((String)iterator.next()).length() * 5 + 30);
                        if (this.qg == null) {
                            tableColumn.setCellRenderer(newDataTableModel.getCellRenderer(0, n));
                        }
                        ++n;
                    }
                    CopyPaste copyPaste = new CopyPaste(jTable);
                    JScrollPane jScrollPane = new JScrollPane(jTable, 21, 31);
                    JComponent jComponent = jScrollPane;
                    if (entry2.getValue() instanceof Double || entry2.getValue() instanceof String) {
                        Dimension dimension;
                        Object object;
                        JSplitPane jSplitPane = new JSplitPane();
                        JLabel jLabel = new JLabel();
                        try {
                            object = newDataTableModel.createChart(0, 0);
                            dimension = newDataTableModel.getChartDimensions((JFreeChart)object);
                            BufferedImage bufferedImage = object.createBufferedImage((int)dimension.getWidth(), (int)dimension.getHeight());
                            jLabel.setIcon(new ImageIcon(bufferedImage));
                        }
                        catch (Exception exception) {
                            jLabel.setText("Cannot Create Chart");
                        }
                        jSplitPane.setLeftComponent(jScrollPane);
                        object = new JPanel();
                        ((Container)object).setLayout(new BoxLayout((Container)object, 1));
                        ((Container)object).add(jLabel);
                        ((Container)object).add(Box.createVerticalGlue());
                        jSplitPane.setRightComponent((Component)object);
                        jScrollPane.setPreferredSize(jTable.getPreferredSize());
                        jComponent = jSplitPane;
                        dimension = jComponent.getPreferredSize();
                        dimension.setSize(dimension.getWidth(), Math.max(jLabel.getMinimumSize().getHeight(), jTable.getMinimumSize().getHeight()));
                        jComponent.setPreferredSize(dimension);
                        jSplitPane.setDividerLocation(jFrame.getWidth() - (int)jLabel.getMinimumSize().getWidth() - 30);
                    }
                    this.tables.add(jComponent);
                }
                return;
            }
            this.recAddTables((Map)entry2.getValue(), entry2, set, set2, string + '/' + (String)entry2.getKey());
        }
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        return this.tableEditor;
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        return this.tableRenderer;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        return this.activeRows.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.tables.get((Integer)this.activeRows.get(n));
    }

    @Override
    public String getColumnName(int n) {
        return this.title;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n % 2 != 0;
    }

    @Override
    protected void doFilter(Vector vector) {
        Iterator iterator;
        StringBuffer stringBuffer = new StringBuffer("^/");
        for (int i = vector.size() - 1; i >= 0; --i) {
            iterator = ((Map)this.tableFilterMaps.get(vector.get(i))).entrySet().iterator();
            if (iterator.hasNext()) {
                stringBuffer.append((String)vector.get(i)).append("@(");
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    if (!((Boolean)entry.getValue()).booleanValue()) continue;
                    stringBuffer.append(entry.getKey()).append("|");
                }
                if (stringBuffer.charAt(stringBuffer.length() - 1) == '|') {
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1).append(")/");
                    continue;
                }
                stringBuffer.append(")/");
                continue;
            }
            stringBuffer.append((String)vector.get(i)).append("/");
        }
        stringBuffer.append("$");
        String string = stringBuffer.toString();
        System.out.println("Regex is: " + string);
        iterator = new Vector();
        for (int i = 0; i < this.tables.size(); i += 2) {
            if (!((String)this.tables.get(i)).matches(string)) continue;
            ((Vector)((Object)iterator)).add(new Integer(i));
            ((Vector)((Object)iterator)).add(new Integer(i + 1));
        }
        this.activeRows = iterator;
    }

    @Override
    public JFreeChart createChart(int n, int n2) {
        return ((NewDataTableModel)((JTable)((JScrollPane)this.getValueAt(n, n2)).getViewport().getView()).getModel()).createChart(n, n2);
    }

    public MultiTableModel(QueryGenerator queryGenerator, Object[] objectArray, Object[] objectArray2, DbProcInterrupt dbProcInterrupt) throws Exception {
        int n;
        this.qg = queryGenerator;
        this.title = queryGenerator.toString();
        this.wild = new ArrayList();
        this.wild.add(queryGenerator.getNodeLevel());
        this.wild.add(queryGenerator.getYearLevel());
        System.out.println("Before Function: " + System.currentTimeMillis());
        boolean bl = objectArray2.length == 1 && objectArray2[0].equals("Global");
        this.buildTable(XMLDB.getInstance().createQuery(queryGenerator, objectArray, objectArray2, dbProcInterrupt), queryGenerator.isSumAll(), bl);
        this.tableEditor = new TableEditor();
        this.tableRenderer = new TableRenderer();
        this.activeRows = new Vector(this.tables.size());
        for (n = 0; n < this.tables.size(); ++n) {
            this.activeRows.add(new Integer(n));
        }
        this.title = "<html><body><b>" + this.title + "</b> Comments: " + this.qg.getComments();
        n = this.getRowCount() / 2;
        this.title = n > 1 ? this.title + " (" + n + " Tables)" : this.title + " (1 Table)";
        this.title = this.title + "</body></html>";
    }

    private void buildTable(QueryProcessor queryProcessor, boolean bl, boolean bl2) throws Exception {
        Object object;
        System.out.println("In Function: " + System.currentTimeMillis());
        Iter iter = queryProcessor.iter();
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        treeSet.addAll(this.getDefaultYearList());
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        Map<String, String> map = this.qg.getNodeLevelRewriteMap();
        DataPair<String, String> dataPair = new DataPair<String, String>();
        try {
            ANode aNode;
            while ((aNode = (ANode)iter.next()) != null) {
                object = BXNode.get((ANode)aNode);
                dataPair.setKey(null);
                dataPair.setValue(null);
                Map object2 = this.qg.addToDataTree(aNode.parent(), linkedHashMap, dataPair, bl2);
                if (dataPair.getKey() == null || dataPair.getValue() == null) {
                    throw new Exception("<html><body>Could not determine how to categorize the results.<br> Please check your axis node values.</body></html>");
                }
                if (bl) {
                    dataPair.setValue("All " + this.qg.getNodeLevel());
                }
                if (map != null && map.containsKey(dataPair.getValue())) {
                    dataPair.setValue(map.get(dataPair.getValue()));
                    if (dataPair.getValue().equals("")) continue;
                }
                if ((this.units = (String)object2.get("Units;" + dataPair.getValue())) == null) {
                    this.units = XMLDB.getAttrMap((Node)BXNode.get((ANode)aNode.parent())).get("unit");
                    if (this.units == null) {
                        this.units = "None Specified";
                    }
                }
                treeSet.add(dataPair.getKey());
                treeSet2.add(dataPair.getValue());
                double d = Double.parseDouble(object.getNodeValue());
                String string = dataPair.getKey() + ";" + dataPair.getValue();
                Double d2 = (Double)object2.get(string);
                object2.put(string, d2 == null ? d : d2 + d);
                string = dataPair.getKey() + ";Total";
                d2 = (Double)object2.get(string);
                object2.put(string, d2 == null ? d : d2 + d);
                object2.put("Units;" + dataPair.getValue(), this.units);
                object2.put("Units;Total", this.units);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            queryProcessor.close();
        }
        if (linkedHashMap.isEmpty()) {
            throw new Exception("The query returned no results.");
        }
        if (this.qg.shouldAppendRewriteValues()) {
            for (String string : map.values()) {
                if (string.equals("")) continue;
                treeSet2.add(string);
            }
        }
        object = new LinkedHashSet(treeSet2);
        object.add("Total");
        treeSet.add("Units");
        if (this.remove1975) {
            treeSet.remove("1975");
        }
        System.out.println("After build Tree: " + System.currentTimeMillis());
        this.recAddTables(linkedHashMap, null, treeSet, (Set)object, "");
        System.out.println("After Add table: " + System.currentTimeMillis());
    }

    @Override
    public void exportToExcel(HSSFSheet hSSFSheet, HSSFWorkbook hSSFWorkbook, HSSFPatriarch hSSFPatriarch) {
        HSSFRow hSSFRow = hSSFSheet.createRow(hSSFSheet.getLastRowNum() + 1);
        hSSFRow.createCell((short)0).setCellValue(this.getColumnName(0));
        for (int i = 0; i < this.getRowCount(); i += 2) {
            hSSFRow = hSSFSheet.createRow(hSSFSheet.getLastRowNum() + 1);
            hSSFRow.createCell((short)0).setCellValue(this.getValueAt(i, 0).toString());
            this.getModelAt(i + 1).exportToExcel(hSSFSheet, hSSFWorkbook, hSSFPatriarch);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BaseTableModel) || object == null) {
            return false;
        }
        if (object instanceof NewDataTableModel) {
            for (int i = 1; i < this.getRowCount(); i += 2) {
                if (this.getModelAt(i) != object) continue;
                return true;
            }
        }
        return false;
    }

    private BaseTableModel getModelAt(int n) {
        Object object = this.getValueAt(n, 0);
        if (object instanceof BaseTableModel) {
            return (BaseTableModel)object;
        }
        object = object instanceof JSplitPane ? ((JScrollPane)((JSplitPane)object).getLeftComponent()).getViewport().getView() : ((JScrollPane)object).getViewport().getView();
        return (BaseTableModel)((TableSorter)((JTable)object).getModel()).getTableModel();
    }

    @Override
    protected Node getNodeAt(int n, int n2) {
        return null;
    }

    @Override
    public void annotate(int[] nArray, int[] nArray2, Documentation documentation) {
        JTable jTable = (JTable)((JScrollPane)this.getValueAt(nArray[0], nArray2[0])).getViewport().getView();
        ((BaseTableModel)jTable.getModel()).annotate(jTable.getSelectedRows(), jTable.getSelectedColumns(), documentation);
    }

    @Override
    public String exportToText(char c) {
        String string = System.getProperty("line.separator");
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.qg.toString() + " Comments: ";
        String string3 = this.qg.getRealComments();
        if (string3 == null) {
            string3 = "None";
        }
        string2 = string2 + string3;
        int n = this.getRowCount() / 2;
        string2 = n > 1 ? string2 + " (" + n + " Tables)" : string2 + " (1 Table)";
        if (string2.indexOf(c) != -1) {
            string2 = '\"' + string2 + '\"';
        }
        stringBuilder.append(string2).append(string);
        for (int i = 0; i < this.getRowCount(); i += 2) {
            String string4 = this.getValueAt(i, 0).toString();
            if (string4.indexOf(c) != -1) {
                string4 = '\"' + string4 + '\"';
            }
            stringBuilder.append(string4).append(string).append(this.getModelAt(i + 1).exportToText(c));
        }
        return stringBuilder.toString();
    }

    private class TableRenderer
    implements TableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n % 2 == 0) {
                Component component = new DefaultTableCellRenderer().getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (jTable.getRowHeight(n) != 16) {
                    jTable.setRowHeight(n, 16);
                }
                component.setBackground(new Color(240, 214, 19));
                return component;
            }
            JComponent jComponent = (JComponent)object;
            if (jTable.getRowHeight(n) != (int)jComponent.getPreferredSize().getHeight() + 30) {
                jTable.setRowHeight(n, (int)jComponent.getPreferredSize().getHeight() + 30);
            }
            return jComponent;
        }
    }

    private class TableEditor
    implements TableCellEditor {
        private Vector<CellEditorListener> editListeners = new Vector();

        @Override
        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.editListeners.remove(cellEditorListener);
        }

        @Override
        public Object getCellEditorValue() {
            System.out.println("Cell Editor Value");
            return "I DON'T KNOW";
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        @Override
        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.editListeners.add(cellEditorListener);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return (JComponent)object;
        }

        private void fireEditingStopped() {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = 0; i < this.editListeners.size(); ++i) {
                this.editListeners.get(i).editingStopped(changeEvent);
            }
        }

        private void fireEditingCanceled() {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = 0; i < this.editListeners.size(); ++i) {
                this.editListeners.get(i).editingCanceled(changeEvent);
            }
        }
    }
}

