/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2.queries;

import ModelInterface.InterfaceMain;
import ModelInterface.ModelGUI2.queries.ClimateQueryBuilder;
import ModelInterface.ModelGUI2.queries.CostCurveQueryBuilder;
import ModelInterface.ModelGUI2.queries.DemandComponentsQueryBuilder;
import ModelInterface.ModelGUI2.queries.DemographicsQueryBuilder;
import ModelInterface.ModelGUI2.queries.EmissionsQueryBuilder;
import ModelInterface.ModelGUI2.queries.GDPQueryBuilder;
import ModelInterface.ModelGUI2.queries.InputOutputQueryBuilder;
import ModelInterface.ModelGUI2.queries.InputQueryBuilder;
import ModelInterface.ModelGUI2.queries.JComponentAdapter;
import ModelInterface.ModelGUI2.queries.JListAdapter;
import ModelInterface.ModelGUI2.queries.LandAllocatorQueryBuilder;
import ModelInterface.ModelGUI2.queries.MarketQueryBuilder;
import ModelInterface.ModelGUI2.queries.QueryBuilder;
import ModelInterface.ModelGUI2.queries.ResourceQueryBuilder;
import ModelInterface.ModelGUI2.queries.SAMQueryBuilder;
import ModelInterface.ModelGUI2.queries.SingleQueryExtension;
import ModelInterface.ModelGUI2.queries.SupplyDemandQueryBuilder;
import ModelInterface.ModelGUI2.undo.EditQueryUndoableEdit;
import ModelInterface.ModelGUI2.undo.MiUndoableEditListener;
import ModelInterface.ModelGUI2.xmldb.QueryRow;
import ModelInterface.ModelGUI2.xmldb.XMLDB;
import ModelInterface.common.DataPair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.JTextComponent;
import org.basex.api.dom.BXNode;
import org.basex.query.value.node.ANode;
import org.basex.query.value.type.NodeType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QueryGenerator
implements Serializable {
    String xPath;
    String var;
    boolean sumAll;
    boolean group;
    boolean isSumable;
    boolean buildSingleQueryList;
    String title;
    public static Vector<String> sumableList;
    public static List<String> hasYearList;
    String axis1Name;
    String axis2Name;
    boolean isRunFunction;
    Map<String, Map<String, String>> labelRewriteMap;
    private boolean doAppendRewriteValues = false;
    Map<String, List<String>> showAttrMap;
    DataPair<String, String> nodeLevel;
    DataPair<String, String> yearLevel;
    List<String> collapseOnList;
    private QueryBuilder qb;
    int currSel;
    String labelColumnName;
    String comments;
    private transient SingleQueryExtension singleExtension;

    public QueryGenerator() {
        this.qb = null;
        this.isSumable = false;
        this.buildSingleQueryList = true;
        this.xPath = "";
        this.sumAll = false;
        this.labelRewriteMap = null;
        this.showAttrMap = new TreeMap<String, List<String>>();
        this.isRunFunction = false;
        this.getQueryDialog();
    }

    public QueryGenerator(Node node) {
        this.showAttrMap = new TreeMap<String, List<String>>();
        this.qb = node.getNodeName().equals(MarketQueryBuilder.xmlName) ? new MarketQueryBuilder(this) : (node.getNodeName().equals(SupplyDemandQueryBuilder.xmlName) ? new SupplyDemandQueryBuilder(this) : (node.getNodeName().equals(DemographicsQueryBuilder.xmlName) ? new DemographicsQueryBuilder(this) : (node.getNodeName().equals(ResourceQueryBuilder.xmlName) ? new ResourceQueryBuilder(this) : (node.getNodeName().equals(EmissionsQueryBuilder.xmlName) ? new EmissionsQueryBuilder(this) : (node.getNodeName().equals(CostCurveQueryBuilder.xmlName) ? new CostCurveQueryBuilder(this) : (node.getNodeName().equals(GDPQueryBuilder.xmlName) ? new GDPQueryBuilder(this) : (node.getNodeName().equals(ClimateQueryBuilder.xmlName) ? new ClimateQueryBuilder(this) : (node.getNodeName().equals(LandAllocatorQueryBuilder.xmlName) ? new LandAllocatorQueryBuilder(this) : (node.getNodeName().equals(InputQueryBuilder.xmlName) ? new InputQueryBuilder(this) : (node.getNodeName().equals(InputOutputQueryBuilder.xmlName) ? new InputOutputQueryBuilder(this) : (node.getNodeName().equals(DemandComponentsQueryBuilder.xmlName) ? new DemandComponentsQueryBuilder(this) : (node.getNodeName().equals(SAMQueryBuilder.xmlName) ? new SAMQueryBuilder(this) : null))))))))))));
        this.title = ((Element)node).getAttribute("title");
        if (this.qb == null) {
            System.out.println("Didn't find builder for " + this.title + " query going to use defaults");
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            if (nodeList.item(i).getNodeName().equals("axis1")) {
                this.nodeLevel = this.parseAxisLevel(nodeList.item(i).getFirstChild().getNodeValue());
                this.axis1Name = ((Element)nodeList.item(i)).getAttribute("name");
                continue;
            }
            if (nodeList.item(i).getNodeName().equals("axis2")) {
                this.yearLevel = this.parseAxisLevel(nodeList.item(i).getFirstChild().getNodeValue());
                this.axis2Name = ((Element)nodeList.item(i)).getAttribute("name");
                continue;
            }
            if (nodeList.item(i).getNodeName().equals("chartLabelColumn")) {
                this.labelColumnName = nodeList.item(i).getFirstChild().getNodeValue();
                continue;
            }
            if (nodeList.item(i).getNodeName().equals("comments")) {
                object = nodeList.item(i).getFirstChild();
                if (object == null) continue;
                this.comments = object.getNodeValue();
                continue;
            }
            if (nodeList.item(i).getNodeName().equals("labelRewriteList")) {
                this.doAppendRewriteValues = Boolean.valueOf(((Element)nodeList.item(i)).getAttribute("append-values"));
                object = nodeList.item(i).getChildNodes();
                this.labelRewriteMap = new HashMap<String, Map<String, String>>(object.getLength());
                for (int j = 0; j < object.getLength(); ++j) {
                    NodeList nodeList2 = object.item(j).getChildNodes();
                    HashMap<String, String> hashMap = new HashMap<String, String>(nodeList2.getLength());
                    for (int k = 0; k < nodeList2.getLength(); ++k) {
                        Element element = (Element)nodeList2.item(k);
                        hashMap.put(element.getAttribute("from"), element.getAttribute("to"));
                    }
                    this.labelRewriteMap.put(((Element)object.item(j)).getAttribute("name"), hashMap);
                }
                continue;
            }
            if (nodeList.item(i).getNodeName().equals("showAttribute")) {
                List<Object> list;
                object = ((Element)nodeList.item(i)).getAttribute("level");
                if (this.showAttrMap.containsKey(object)) {
                    list = this.showAttrMap.get(object);
                } else {
                    list = new Vector();
                    this.showAttrMap.put((String)object, list);
                }
                list.add(((Element)nodeList.item(i)).getAttribute("attribute-name"));
                continue;
            }
            if (!nodeList.item(i).getNodeName().equals("xPath")) continue;
            this.var = ((Element)nodeList.item(i)).getAttribute("dataName");
            this.sumAll = ((Element)nodeList.item(i)).getAttribute("sumAll").equals("true");
            this.group = ((Element)nodeList.item(i)).getAttribute("group").equals("true");
            this.buildSingleQueryList = ((Element)nodeList.item(i)).getAttribute("buildList").equals("") || ((Element)nodeList.item(i)).getAttribute("buildList").equals("true");
            this.xPath = nodeList.item(i).getFirstChild().getNodeValue();
        }
        this.setIsRunFunction();
    }

    protected void getQueryDialog() {
        final QueryGenerator queryGenerator = this;
        JFrame jFrame = InterfaceMain.getInstance().getFrame();
        final JDialog jDialog = new JDialog(jFrame, "Create Query", true);
        jDialog.setSize(500, 400);
        jDialog.setLocation(100, 100);
        jDialog.setResizable(false);
        final LinkedHashMap<String, Boolean> linkedHashMap = new LinkedHashMap<String, Boolean>();
        linkedHashMap.put("SupplyDemand", new Boolean(false));
        linkedHashMap.put("Market", new Boolean(false));
        linkedHashMap.put("Demographics", new Boolean(false));
        linkedHashMap.put("Resource", new Boolean(false));
        linkedHashMap.put("Emissions", new Boolean(false));
        linkedHashMap.put("Cost Curves", new Boolean(false));
        linkedHashMap.put("GDP", new Boolean(false));
        linkedHashMap.put("Climate", new Boolean(false));
        linkedHashMap.put("LandAllocator", new Boolean(false));
        linkedHashMap.put("Query Group", new Boolean(false));
        final Vector vector = new Vector(linkedHashMap.keySet().size(), 0);
        for (int i = 0; i < vector.capacity(); ++i) {
            vector.add(null);
        }
        final JComponentAdapter[] jComponentAdapterArray = new JComponentAdapter[]{new JListAdapter(new JList())};
        final JScrollPane jScrollPane = new JScrollPane(jComponentAdapterArray[0].getModel());
        ((JList)jComponentAdapterArray[0].getModel()).setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = new DefaultListCellRenderer().getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (((String)object).startsWith("Group")) {
                    component.setBackground(bl ? Color.BLUE : Color.GREEN);
                }
                return component;
            }
        });
        final JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(2);
        this.currSel = 0;
        final JButton jButton = new JButton(" Cancel ");
        final JButton jButton2 = new JButton(" < Back ");
        final JButton jButton3 = new JButton(" Next > ");
        JButton jButton4 = new JButton("Get New Variables");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                XMLDB.getInstance().addVarMetaData();
            }
        });
        final Container container = jDialog.getContentPane();
        JPanel jPanel = new JPanel();
        final JPanel jPanel2 = new JPanel();
        final JPanel jPanel3 = new JPanel();
        final JTextField jTextField = new JTextField();
        jTextField.setPreferredSize(new Dimension(30, 12));
        final EventListener[] eventListenerArray = new EventListener[]{null};
        final ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (QueryGenerator.this.currSel != 1) {
                    return;
                }
                if (jComponentAdapterArray[0].getSelectedRows().length > 0) {
                    if (jComponentAdapterArray[0].getSelectedRows()[0] == linkedHashMap.keySet().size() - 1) {
                        jButton3.setEnabled(false);
                        jButton.setText("Finished");
                    } else {
                        jButton3.setEnabled(true);
                        jButton.setText(" Cancel ");
                    }
                } else {
                    jButton3.setEnabled(false);
                }
            }
        };
        jComponentAdapterArray[0].addSelectionListener(listSelectionListener);
        jButton2.setMnemonic(66);
        jButton3.setMnemonic(78);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!jButton.getText().equals(" Cancel ")) {
                    if (QueryGenerator.this.qb != null) {
                        QueryGenerator.this.qb.doFinish(jComponentAdapterArray[0]);
                    } else {
                        QueryGenerator.this.xPath = "Query Group";
                    }
                }
                jDialog.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                --QueryGenerator.this.currSel;
                if (QueryGenerator.this.currSel == 1) {
                    jComponentAdapterArray[0].removeSelectionListener(eventListenerArray[0]);
                    jComponentAdapterArray[0].addSelectionListener(listSelectionListener);
                    QueryGenerator.this.qb = null;
                    QueryGenerator.this.updateList(linkedHashMap, jComponentAdapterArray[0], jLabel);
                } else if (QueryGenerator.this.currSel != 0) {
                    JComponentAdapter jComponentAdapter = QueryGenerator.this.qb.doBack(jComponentAdapterArray[0], jLabel);
                    if (jComponentAdapter != jComponentAdapterArray[0]) {
                        jComponentAdapterArray[0].removeSelectionListener(eventListenerArray[0]);
                        jComponentAdapterArray[0] = jComponentAdapter;
                        jScrollPane.getViewport().setView(jComponentAdapterArray[0].getModel());
                        eventListenerArray[0] = QueryGenerator.this.qb.getListSelectionListener(jComponentAdapterArray[0], jButton3, jButton);
                        jComponentAdapterArray[0].addSelectionListener(eventListenerArray[0]);
                    }
                } else {
                    container.remove(jPanel2);
                    container.add(jPanel3);
                    jDialog.repaint();
                }
                if (!jButton3.isEnabled()) {
                    jButton3.setEnabled(true);
                    jButton.setText(" Cancel ");
                }
                if (QueryGenerator.this.currSel == 0) {
                    jButton2.setEnabled(false);
                }
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ++QueryGenerator.this.currSel;
                jButton3.setEnabled(false);
                if (QueryGenerator.this.currSel == 1) {
                    QueryGenerator.this.title = jTextField.getText();
                    container.remove(jPanel3);
                    container.add(jPanel2);
                    QueryGenerator.this.updateList(linkedHashMap, jComponentAdapterArray[0], jLabel);
                } else if (QueryGenerator.this.currSel == 2) {
                    int n;
                    Object[] objectArray = jComponentAdapterArray[0].getSelectedValues();
                    Iterator iterator = linkedHashMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        iterator.next().setValue(new Boolean(false));
                    }
                    for (n = 0; n < objectArray.length; ++n) {
                        linkedHashMap.put(objectArray[n], new Boolean(true));
                    }
                    jComponentAdapterArray[0].removeSelectionListener(listSelectionListener);
                    n = jComponentAdapterArray[0].getSelectedRows()[0];
                    if (vector.get(n) == null) {
                        switch (n) {
                            case 0: {
                                vector.set(n, new SupplyDemandQueryBuilder(queryGenerator));
                                break;
                            }
                            case 1: {
                                vector.set(n, new MarketQueryBuilder(queryGenerator));
                                break;
                            }
                            case 2: {
                                vector.set(n, new DemographicsQueryBuilder(queryGenerator));
                                break;
                            }
                            case 3: {
                                vector.set(n, new ResourceQueryBuilder(queryGenerator));
                                break;
                            }
                            case 4: {
                                vector.set(n, new EmissionsQueryBuilder(queryGenerator));
                                break;
                            }
                            case 5: {
                                vector.set(n, new CostCurveQueryBuilder(queryGenerator));
                                break;
                            }
                            case 6: {
                                vector.set(n, new GDPQueryBuilder(queryGenerator));
                                break;
                            }
                            case 7: {
                                vector.set(n, new ClimateQueryBuilder(queryGenerator));
                                break;
                            }
                            case 8: {
                                vector.set(n, new LandAllocatorQueryBuilder(queryGenerator));
                                break;
                            }
                            default: {
                                System.out.println("Couldn't make type, index: " + n);
                            }
                        }
                    }
                    QueryGenerator.this.qb = (QueryBuilder)vector.get(n);
                    JComponentAdapter jComponentAdapter = QueryGenerator.this.qb.doNext(jComponentAdapterArray[0], jLabel);
                    if (jComponentAdapter != jComponentAdapterArray[0]) {
                        jComponentAdapterArray[0] = jComponentAdapter;
                        jScrollPane.getViewport().setView(jComponentAdapterArray[0].getModel());
                    }
                    eventListenerArray[0] = QueryGenerator.this.qb.getListSelectionListener(jComponentAdapterArray[0], jButton3, jButton);
                    jComponentAdapterArray[0].addSelectionListener(eventListenerArray[0]);
                } else {
                    JComponentAdapter jComponentAdapter = QueryGenerator.this.qb.doNext(jComponentAdapterArray[0], jLabel);
                    if (jComponentAdapter != jComponentAdapterArray[0]) {
                        jComponentAdapterArray[0].removeSelectionListener(eventListenerArray[0]);
                        jComponentAdapterArray[0] = jComponentAdapter;
                        jScrollPane.getViewport().setView(jComponentAdapterArray[0].getModel());
                        eventListenerArray[0] = QueryGenerator.this.qb.getListSelectionListener(jComponentAdapterArray[0], jButton3, jButton);
                        jComponentAdapterArray[0].addSelectionListener(eventListenerArray[0]);
                    }
                }
                if (!jButton2.isEnabled()) {
                    jButton2.setEnabled(true);
                }
            }
        });
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add(jButton4);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton2);
        jButton2.setEnabled(false);
        jPanel.add(jButton3);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel.add(jButton);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add(Box.createVerticalGlue());
        jPanel2.add(jLabel);
        jPanel2.add(Box.createVerticalStrut(10));
        jScrollPane.setPreferredSize(new Dimension(150, 750));
        jPanel2.add(jScrollPane);
        jPanel2.add(Box.createVerticalStrut(10));
        jPanel2.add(new JSeparator(0));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel jLabel2 = new JLabel("Please enter a title for the query");
        jPanel3.add(jLabel2);
        jPanel3.add(Box.createVerticalStrut(10));
        jPanel3.add(jTextField);
        jPanel3.add(Box.createVerticalGlue());
        jPanel3.add(Box.createVerticalStrut(260));
        jPanel3.add(new JSeparator(0));
        container.add((Component)jPanel3, "Center");
        container.add((Component)jPanel, "Last");
        jDialog.setContentPane(container);
        jDialog.setVisible(true);
    }

    private void updateList(Map map, JComponentAdapter jComponentAdapter, JLabel jLabel) {
        jLabel.setText("Select type: ");
        jComponentAdapter.setSelectionMode(0);
        Vector<Integer> vector = new Vector<Integer>();
        String[] stringArray = map.keySet().toArray(new String[0]);
        ((JList)jComponentAdapter.getModel()).setListData(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!((Boolean)map.get(stringArray[i])).booleanValue()) continue;
            vector.addElement(new Integer(i));
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        vector = null;
        jComponentAdapter.setSelectedRows(nArray);
    }

    private String expandGroupName(String string) {
        return null;
    }

    public String getXPath() {
        return this.xPath;
    }

    public void setXPath(String string) {
        this.xPath = string;
        this.setIsRunFunction();
    }

    public String getVariable() {
        return this.var;
    }

    public void setVariable(String string) {
        this.var = string;
    }

    public String getNodeLevel() {
        return this.nodeLevel.getKey();
    }

    public DataPair<String, String> getNodeLevelPair() {
        return this.nodeLevel;
    }

    public void setNodeLevel(String string) {
        this.nodeLevel.setKey(string);
    }

    public void setNodeLevel(DataPair<String, String> dataPair) {
        this.nodeLevel = dataPair;
    }

    public String getAxis1Name() {
        return this.axis1Name;
    }

    public void setAxis1Name(String string) {
        this.axis1Name = string;
    }

    public String getAxis2Name() {
        return this.axis2Name;
    }

    public void setAxis2Name(String string) {
        this.axis2Name = string;
    }

    public boolean isSumAll() {
        return this.sumAll;
    }

    public void setSumAll(boolean bl) {
        this.sumAll = bl;
    }

    public boolean isGroup() {
        return this.group;
    }

    public void setGroup(boolean bl) {
        this.group = bl;
    }

    public boolean isBuildList() {
        return this.buildSingleQueryList;
    }

    public void setBuildList(boolean bl) {
        if (this.singleExtension != null) {
            this.singleExtension.setEnabled(bl);
        }
        this.buildSingleQueryList = bl;
    }

    public Node getAsNode(Document document) {
        Object object;
        Element element = this.qb == null ? document.createElement("query") : document.createElement(this.qb.getXMLName());
        element.setAttribute("title", this.title);
        Element element2 = document.createElement("axis1");
        element2.setAttribute("name", this.axis1Name);
        element2.appendChild(document.createTextNode(this.displayAxisLevel(this.nodeLevel)));
        element.appendChild(element2);
        element2 = document.createElement("axis2");
        element2.setAttribute("name", this.axis2Name);
        element2.appendChild(document.createTextNode(this.displayAxisLevel(this.yearLevel)));
        element.appendChild(element2);
        if (this.labelColumnName != null && !this.labelColumnName.equals("")) {
            element2 = document.createElement("chartLabelColumn");
            element2.appendChild(document.createTextNode(this.labelColumnName));
            element.appendChild(element2);
        }
        element2 = document.createElement("xPath");
        element2.setAttribute("dataName", this.var);
        if (this.sumAll) {
            element2.setAttribute("sumAll", "true");
        } else {
            element2.setAttribute("sumAll", "false");
        }
        if (this.group) {
            element2.setAttribute("group", "true");
        } else {
            element2.setAttribute("group", "false");
        }
        if (this.buildSingleQueryList) {
            element2.setAttribute("buildList", "true");
        } else {
            element2.setAttribute("buildList", "false");
        }
        element2.appendChild(!this.isRunFunction ? document.createTextNode(this.xPath) : document.createCDATASection(this.xPath));
        element.appendChild(element2);
        element2 = document.createElement("comments");
        element2.appendChild(document.createTextNode(this.comments != null ? this.comments : ""));
        element.appendChild(element2);
        if (this.labelRewriteMap != null) {
            element2 = document.createElement("labelRewriteList");
            element2.setAttribute("append-values", Boolean.toString(this.doAppendRewriteValues));
            for (Map.Entry<String, Object> entry : this.labelRewriteMap.entrySet()) {
                object = document.createElement("level");
                object.setAttribute("name", entry.getKey());
                for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                    Element element3 = document.createElement("rewrite");
                    element3.setAttribute("from", (String)entry2.getKey());
                    element3.setAttribute("to", (String)entry2.getValue());
                    object.appendChild(element3);
                }
                element2.appendChild((Node)object);
            }
            element.appendChild(element2);
        }
        for (Map.Entry<String, List<String>> entry : this.showAttrMap.entrySet()) {
            object = entry.getValue().iterator();
            while (object.hasNext()) {
                element2 = document.createElement("showAttribute");
                element2.setAttribute("level", entry.getKey());
                element2.setAttribute("attribute-name", (String)object.next());
                element.appendChild(element2);
            }
        }
        return element;
    }

    public boolean isValid() {
        return this.title != null && this.yearLevel != null && this.nodeLevel != null && this.var != null && this.axis1Name != null && this.axis2Name != null;
    }

    public String toString() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getComments() {
        return this.comments != null && !this.comments.equals("") ? this.comments : "<i>None</i>";
    }

    public String getRealComments() {
        return this.comments;
    }

    public void setComments(String string) {
        this.comments = string;
    }

    public String getYearLevel() {
        return this.yearLevel.getKey();
    }

    public DataPair<String, String> getYearLevelPair() {
        return this.yearLevel;
    }

    public void setYearLevel(String string) {
        this.yearLevel.setKey(string);
    }

    public void setYearLevel(DataPair<String, String> dataPair) {
        this.yearLevel = dataPair;
    }

    public String getChartLabelColumnName() {
        return this.labelColumnName;
    }

    public void setCharLabelColumnName(String string) {
        this.labelColumnName = string;
    }

    public String getCompleteXPath(Object[] objectArray) {
        if (this.qb != null) {
            return this.qb.getCompleteXPath(objectArray);
        }
        return this.defaultCompleteXPath(objectArray);
    }

    public Map addToDataTree(ANode aNode, Map map, DataPair<String, String> dataPair, boolean bl) throws Exception {
        if (this.qb != null) {
            return this.qb.addToDataTree(aNode, map, dataPair, bl);
        }
        return this.defaultAddToDataTree(aNode, map, dataPair, bl);
    }

    Map defaultAddToDataTree(ANode aNode, Map map, DataPair<String, String> dataPair, boolean bl) throws Exception {
        BXNode bXNode = BXNode.get((ANode)aNode);
        if (bXNode.getNodeType() == 9) {
            return map;
        }
        Map map2 = this.defaultAddToDataTree(aNode.parent(), map, dataPair, bl);
        String string = bXNode.getNodeName();
        Map<String, String> map3 = !this.isRunFunction ? XMLDB.getAttrMapWithCache((Node)bXNode) : XMLDB.getAttrMap((Node)bXNode);
        String string2 = map3.get("type");
        if (string2 == null) {
            string2 = string;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.nodeLevel.getKey().equals(string2) || this.nodeLevel.getKey().equals(string)) {
            bl2 = true;
            if (!this.showAttrMap.containsKey(string2)) {
                dataPair.setValue(map3.get(this.nodeLevel.getValue() != null ? this.nodeLevel.getValue() : "name"));
            } else {
                dataPair.setValue(XMLDB.getAllAttr(map3, this.showAttrMap.get(string2)));
            }
        }
        if (this.yearLevel.getKey().equals(string2) || this.yearLevel.getKey().equals(string)) {
            bl3 = true;
            dataPair.setKey(map3.get(this.yearLevel.getValue() != null ? this.yearLevel.getValue() : "year"));
        }
        if (!(bl2 || bl3 || bl && string2.equals("region") || map3.isEmpty() || this.getCollapseOnList().contains(string2))) {
            Map<String, String> map4;
            String string3 = XMLDB.getAllAttr(map3, this.showAttrMap.get(string2));
            if (this.labelRewriteMap != null && this.labelRewriteMap.containsKey(string2) && (map4 = this.labelRewriteMap.get(string2)).containsKey(string3)) {
                string3 = map4.get(string3);
            }
            if (!map2.containsKey(string3 = string2 + "@" + string3)) {
                map2.put(string3, new TreeMap());
            }
            map2 = (Map)map2.get(string3);
        }
        return map2;
    }

    public void addToDataTree(ANode aNode, ListIterator<QueryRow> listIterator, boolean bl) throws Exception {
        if (this.qb != null) {
            this.qb.addToDataTree(aNode, listIterator, bl);
        } else {
            this.defaultAddToDataTree(aNode, listIterator, bl);
        }
    }

    public void defaultAddToDataTree(ANode aNode, ListIterator<QueryRow> listIterator, boolean bl) throws Exception {
        Object object;
        Object object2;
        QueryRow queryRow = null;
        if (listIterator.hasNext()) {
            queryRow = listIterator.next();
            if (queryRow.id != null && queryRow.id.is(aNode)) {
                return;
            }
            queryRow = new QueryRow(aNode);
            listIterator.set(queryRow);
        } else {
            queryRow = new QueryRow(aNode);
            listIterator.add(queryRow);
        }
        BXNode bXNode = BXNode.get((ANode)aNode);
        String string = bXNode.getNodeName();
        Map<String, String> map = !this.isRunFunction ? XMLDB.getAttrMapWithCache((Node)bXNode) : XMLDB.getAttrMap((Node)bXNode);
        String string2 = map.get("type");
        if (string2 == null) {
            string2 = string;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.nodeLevel.getKey().equals(string2) || this.nodeLevel.getKey().equals(string)) {
            bl2 = true;
            queryRow.key = this.axis1Name;
            queryRow.value = !this.showAttrMap.containsKey(string2) ? map.get(this.nodeLevel.getValue() != null ? this.nodeLevel.getValue() : "name") : XMLDB.getAllAttr(map, this.showAttrMap.get(string2));
            if (this.labelRewriteMap != null && this.labelRewriteMap.containsKey(string2) && (object2 = this.labelRewriteMap.get(string2)).containsKey(queryRow.value)) {
                queryRow.value = (String)object2.get(queryRow.value);
            }
        }
        if (this.yearLevel.getKey().equals(string2) || this.yearLevel.getKey().equals(string)) {
            bl3 = true;
            if (bl2) {
                queryRow = new QueryRow(aNode);
                if (listIterator.hasNext()) {
                    listIterator.next();
                    listIterator.set(queryRow);
                } else {
                    listIterator.add(queryRow);
                }
            }
            queryRow.key = this.axis2Name;
            queryRow.value = map.get(this.yearLevel.getValue() != null ? this.yearLevel.getValue() : "year");
        }
        if (!(bl2 || bl3 || bl && string2.equals("region") || map.isEmpty() || this.getCollapseOnList().contains(string2) || (object2 = XMLDB.getAllAttr(map, this.showAttrMap.get(string2))) == "")) {
            if (this.labelRewriteMap != null && this.labelRewriteMap.containsKey(string2) && (object = this.labelRewriteMap.get(string2)).containsKey(object2)) {
                object2 = (String)object.get(object2);
            }
            queryRow.key = string2;
            queryRow.value = object2;
        }
        if ((object2 = aNode.parent()).nodeType() != NodeType.DOCUMENT_NODE) {
            this.defaultAddToDataTree((ANode)object2, listIterator, bl);
        } else {
            while (listIterator.hasNext()) {
                object = listIterator.next();
                if (((QueryRow)object).key != null && ((QueryRow)object).key.equals("Units")) continue;
                listIterator.remove();
            }
        }
    }

    protected String defaultCompleteXPath(Object[] objectArray) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray.length == 0 || objectArray[0].equals("Global")) {
            stringBuffer.append("region/");
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!bl) {
                    stringBuffer.append("region[ ");
                    bl = true;
                } else {
                    stringBuffer.append(" or ");
                }
                stringBuffer.append("(@name='").append(objectArray[i]).append("')");
            }
            if (bl) {
                stringBuffer.append(" ]/");
            }
        }
        return stringBuffer.append(this.xPath).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean editDialog(final MiUndoableEditListener miUndoableEditListener) {
        final Object object = new Object();
        String string = this.title;
        final JDialog jDialog = new JDialog(InterfaceMain.getInstance().getFrame(), "Edit Query", false);
        final QueryGenerator queryGenerator = this;
        jDialog.setResizable(false);
        JButton jButton = new JButton("Cancel");
        JButton jButton2 = new JButton("  OK  ");
        JPanel jPanel = new JPanel();
        final JTextField jTextField = new JTextField(this.title, 30);
        final JTextField jTextField2 = new JTextField(this.axis1Name, 15);
        final JTextField jTextField3 = new JTextField(this.displayAxisLevel(this.nodeLevel), 20);
        final JTextField jTextField4 = new JTextField(this.axis2Name, 15);
        final JTextField jTextField5 = new JTextField(this.displayAxisLevel(this.yearLevel), 20);
        final JTextField jTextField6 = new JTextField(this.var, 20);
        final JTextComponent jTextComponent = this.xPath.contains("\n") ? new JTextArea(this.xPath, 6, 50) : new JTextField(this.xPath, 50);
        final JCheckBox jCheckBox = new JCheckBox("Sum All", this.sumAll);
        final JCheckBox jCheckBox2 = new JCheckBox("Group", this.group);
        final JCheckBox jCheckBox3 = new JCheckBox("Build List", this.buildSingleQueryList);
        final JTextField jTextField7 = new JTextField(this.labelColumnName, 15);
        final JTextArea jTextArea = new JTextArea(this.comments, 4, 45);
        jTextField.setMaximumSize(jTextField.getPreferredSize());
        jTextField2.setMaximumSize(jTextField2.getPreferredSize());
        jTextField3.setMaximumSize(jTextField3.getPreferredSize());
        jTextField4.setMaximumSize(jTextField4.getPreferredSize());
        jTextField5.setMaximumSize(jTextField5.getPreferredSize());
        jTextField6.setMaximumSize(jTextField6.getPreferredSize());
        jTextComponent.setMaximumSize(jTextComponent.getPreferredSize());
        jTextField7.setMaximumSize(jTextField7.getPreferredSize());
        Component component = Box.createRigidArea(new Dimension(20, 10));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add(new JLabel("Title: "));
        jPanel2.add(component);
        jPanel2.add(jTextField);
        jPanel2.add(component);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jCheckBox);
        jPanel2.add(component);
        jPanel2.add(jCheckBox2);
        jPanel2.add(component);
        jPanel2.add(jCheckBox3);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add(new JLabel("Y-Axis Name: "));
        jPanel2.add(component);
        jPanel2.add(jTextField2);
        jPanel2.add(component);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(new JLabel("  Y-Axis Node: "));
        jPanel2.add(component);
        jPanel2.add(jTextField3);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add(new JLabel("X-Axis Name: "));
        jPanel2.add(component);
        jPanel2.add(jTextField4);
        jPanel2.add(component);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(new JLabel("  X-Axis Node: "));
        jPanel2.add(component);
        jPanel2.add(jTextField5);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add(new JLabel("Data Name: "));
        jPanel2.add(component);
        jPanel2.add(jTextField6);
        jPanel2.add(component);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(new JLabel("Chart Label Column: "));
        jPanel2.add(component);
        jPanel2.add(jTextField7);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(Box.createRigidArea(new Dimension(2, 2)));
        jPanel3.add(new JLabel("XPATH: "));
        jPanel3.add(Box.createVerticalGlue());
        jPanel2.add(jPanel3);
        jPanel2.add(component);
        jPanel2.add(Box.createHorizontalGlue());
        if (jTextComponent instanceof JTextArea) {
            jPanel2.add(new JScrollPane(jTextComponent));
        } else {
            jPanel2.add(jTextComponent);
        }
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(Box.createRigidArea(new Dimension(2, 2)));
        jPanel3.add(new JLabel("Comments: "));
        jPanel3.add(Box.createVerticalGlue());
        jPanel2.add(jPanel3);
        jPanel2.add(component);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(new JScrollPane(jTextArea));
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton2);
        jPanel2.add(component);
        jPanel2.add(jButton);
        jPanel.add(jPanel2);
        final boolean[] blArray = new boolean[]{false};
        jButton2.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditQueryUndoableEdit editQueryUndoableEdit = new EditQueryUndoableEdit(queryGenerator, miUndoableEditListener);
                editQueryUndoableEdit.setOldValues(queryGenerator);
                QueryGenerator.this.title = jTextField.getText();
                QueryGenerator.this.axis1Name = jTextField2.getText();
                QueryGenerator.this.nodeLevel = QueryGenerator.this.parseAxisLevel(jTextField3.getText());
                QueryGenerator.this.axis2Name = jTextField4.getText();
                QueryGenerator.this.yearLevel = QueryGenerator.this.parseAxisLevel(jTextField5.getText());
                QueryGenerator.this.var = jTextField6.getText();
                QueryGenerator.this.labelColumnName = jTextField7.getText();
                QueryGenerator.this.xPath = jTextComponent.getText();
                QueryGenerator.this.setIsRunFunction();
                QueryGenerator.this.sumAll = jCheckBox.isSelected();
                QueryGenerator.this.group = jCheckBox2.isSelected();
                QueryGenerator.this.setBuildList(jCheckBox3.isSelected());
                QueryGenerator.this.comments = jTextArea.getText();
                editQueryUndoableEdit.setNewValues(queryGenerator);
                if (editQueryUndoableEdit.hasRealChanges()) {
                    if (editQueryUndoableEdit.didNodeLevelChange() || editQueryUndoableEdit.didXPathChange()) {
                        QueryGenerator.this.resetCollapseOnList();
                    }
                    if (QueryGenerator.this.hasSingleQueryExtension()) {
                        QueryGenerator.this.singleExtension.undoPerformed(new UndoableEditEvent(editQueryUndoableEdit, editQueryUndoableEdit));
                    }
                    InterfaceMain.getInstance().getUndoManager().addEdit(editQueryUndoableEdit);
                    InterfaceMain.getInstance().refreshUndoRedo();
                    blArray[0] = true;
                } else {
                    editQueryUndoableEdit.die();
                }
                Object object2 = object;
                synchronized (object2) {
                    object.notifyAll();
                }
                jDialog.dispose();
            }
        });
        jButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object2 = object;
                synchronized (object2) {
                    object.notifyAll();
                }
                jDialog.dispose();
            }
        });
        jDialog.getContentPane().add(jPanel);
        jDialog.pack();
        jDialog.setVisible(true);
        try {
            Object object2 = object;
            synchronized (object2) {
                object.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return blArray[0];
    }

    public List<String> getCollapseOnList() {
        if (this.collapseOnList == null) {
            this.createCollapseList(this.qb != null ? this.qb.getDefaultCollpaseList() : new Vector());
        }
        return this.collapseOnList;
    }

    private void createCollapseList(List<String> list) {
        this.collapseOnList = list;
        Matcher matcher = Pattern.compile("[^\\/]*@type\\s*=\\s*'([\\w-]+)'\\s*(\\(:\\s*collapse\\s*:\\))?[^\\/]*\\/").matcher(this.xPath);
        boolean bl = false;
        while (matcher.find()) {
            bl = true;
            if (matcher.group(2) == null) {
                this.collapseOnList.remove(matcher.group(1));
                continue;
            }
            if (this.collapseOnList.contains(matcher.group(1))) continue;
            this.collapseOnList.add(matcher.group(1));
        }
        if (!bl) {
            // empty if block
        }
    }

    public void resetCollapseOnList() {
        this.collapseOnList = null;
    }

    private DataPair<String, String> parseAxisLevel(String string) {
        int n = string.indexOf(64);
        if (n == -1) {
            return new DataPair<String, Object>(string, null);
        }
        return new DataPair<String, String>(string.substring(0, n - 1), string.substring(n + 1, string.length() - 1));
    }

    private String displayAxisLevel(DataPair<String, String> dataPair) {
        if (dataPair.getValue() == null) {
            return dataPair.getKey();
        }
        return dataPair.getKey() + "[@" + dataPair.getValue() + "]";
    }

    public String getNodeLevelPath() {
        if (this.qb != null) {
            return this.qb.getNodeLevelPath();
        }
        return this.defaultGetNodeLevelPath();
    }

    public String getForNodeLevelPath(List<String> list) {
        if (this.qb != null) {
            return this.qb.getForNodeLevelPath(list);
        }
        return this.defaultGetForNodeLevelPath(list);
    }

    public String defaultGetNodeLevelPath() {
        String string = this.nodeLevel.getValue();
        if (string == null) {
            string = "name";
        }
        if (!this.nodeLevel.getKey().equals("keyword")) {
            String string2 = "/ancestor::*[@type='" + this.nodeLevel.getKey() + "'";
            if (!this.shouldUseOnlyType(this.nodeLevel.getKey())) {
                string2 = string2 + " or local-name()='" + this.nodeLevel.getKey() + "'";
            }
            string2 = string2 + "]/@" + string;
            return string2;
        }
        return "/parent::*/following-sibling::keyword/@" + this.nodeLevel.getValue();
    }

    public String defaultGetForNodeLevelPath(List<String> list) {
        String string = this.nodeLevel.getValue();
        if (this.nodeLevel.getKey().equals("keyword")) {
            return "[parent::*/following-sibling::keyword/@" + this.nodeLevel.getValue() + "='" + list.get(0) + "']";
        }
        String[] stringArray = list.get(0).split("/");
        if (string == null) {
            string = "name";
        }
        StringBuilder stringBuilder = new StringBuilder("[ancestor::*[(@type='");
        stringBuilder.append(this.nodeLevel.getKey());
        if (this.shouldUseOnlyType(this.nodeLevel.getKey())) {
            stringBuilder.append("') and (@");
        } else {
            stringBuilder.append("' or local-name()='");
            stringBuilder.append(this.nodeLevel.getKey()).append("') and (@");
        }
        if (list.size() == 1) {
            stringBuilder.append(string).append("='").append(stringArray[stringArray.length - 1]).append("')]");
        } else {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append("@").append(string).append("='").append(iterator.next()).append("' or ");
            }
            stringBuilder.replace(stringBuilder.length() - 4, stringBuilder.length(), ")]");
        }
        for (int i = 0; i < stringArray.length - 1; ++i) {
            int n = stringArray[i].indexOf(58);
            String string2 = stringArray[i].substring(0, n);
            String string3 = stringArray[i].substring(n + 2, stringArray[i].length());
            stringBuilder.append("][ancestor::*[(@type='");
            stringBuilder.append(string2);
            if (this.shouldUseOnlyType(string2)) {
                stringBuilder.append("') and @");
            } else {
                stringBuilder.append("' or local-name()='");
                stringBuilder.append(string2).append("') and @");
            }
            stringBuilder.append("name='").append(string3).append("']");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private boolean shouldUseOnlyType(String string) {
        return string.equals("sector") || string.equals("subsector") || string.equals("technology") || string.equals("input") || string.equals("output") || string.equals("GHG");
    }

    public boolean hasSingleQueryExtension() {
        return this.singleExtension != null && this.singleExtension.isInitialized();
    }

    public SingleQueryExtension getSingleQueryExtension() {
        if (this.singleExtension == null && this.buildSingleQueryList) {
            this.singleExtension = new SingleQueryExtension(this);
        }
        return this.singleExtension;
    }

    public void resetQueryBuilder() {
        if (this.qb == null) {
            return;
        }
        this.qb.setQueryGenerator(this);
    }

    public int getStorageHashCode() {
        return this.xPath.hashCode() ^ this.nodeLevel.hashCode();
    }

    public Map<String, String> getNodeLevelRewriteMap() {
        return this.labelRewriteMap == null ? null : this.labelRewriteMap.get(this.nodeLevel.getKey());
    }

    private void setIsRunFunction() {
        this.isRunFunction = this.xPath.matches("(?s).*:run.*\\(\\s*\\(:scenarios:\\)\\s*,\\s*\\(:regions:\\).*");
    }

    public boolean isRunFunctionQuery() {
        return this.isRunFunction;
    }

    public boolean shouldAppendRewriteValues() {
        return this.getNodeLevelRewriteMap() != null && this.doAppendRewriteValues;
    }
}

