/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2.queries;

import ModelInterface.ModelGUI2.queries.JComponentAdapter;
import ModelInterface.ModelGUI2.queries.QueryBuilder;
import ModelInterface.ModelGUI2.queries.QueryGenerator;
import ModelInterface.ModelGUI2.xmldb.XMLDB;
import ModelInterface.common.DataPair;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.basex.api.dom.BXNode;
import org.basex.query.value.node.ANode;
import org.w3c.dom.Node;

public class DemographicsQueryBuilder
extends QueryBuilder {
    public static Map<String, Boolean> varList;
    protected Map popList = null;
    protected Map cohortList = null;
    protected Map genderList = new LinkedHashMap();
    public static String xmlName;

    public DemographicsQueryBuilder(QueryGenerator queryGenerator) {
        super(queryGenerator);
        this.genderList.put("male", new Boolean(false));
        this.genderList.put("female", new Boolean(false));
    }

    private boolean isPopMiniCAMSelected() {
        if (this.popList == null) {
            return false;
        }
        Object v = this.popList.get("populationMiniCAM");
        return v != null && (Boolean)v != false;
    }

    private boolean isTotalPopulation() {
        if (varList == null) {
            return false;
        }
        Boolean bl = varList.get("total-population");
        return bl != null && bl != false;
    }

    @Override
    public EventListener getListSelectionListener(final JComponentAdapter jComponentAdapter, final JButton jButton, final JButton jButton2) {
        this.queryFunctions.removeAllElements();
        this.queryFunctions.add("distinct-values");
        this.queryFilter = "/scenario/world/*[@type = 'region']/demographics/";
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int[] nArray = jComponentAdapter.getSelectedRows();
                if (nArray.length == 0 && DemographicsQueryBuilder.this.qg.currSel != 0) {
                    jButton.setEnabled(false);
                    jButton2.setText(" Cancel ");
                } else if (DemographicsQueryBuilder.this.qg.currSel < 5) {
                    if ((((String)jComponentAdapter.getSelectedValues()[0]).equals("populationMiniCAM") || DemographicsQueryBuilder.this.isTotalPopulation()) && DemographicsQueryBuilder.this.qg.currSel == 3) {
                        jButton.setEnabled(false);
                        jButton2.setText("Finished");
                    } else {
                        jButton.setEnabled(true);
                    }
                } else if (DemographicsQueryBuilder.this.qg.currSel == 5) {
                    jButton.setEnabled(false);
                    jButton2.setText("Finished");
                }
            }
        };
    }

    @Override
    public JComponentAdapter doNext(JComponentAdapter jComponentAdapter, JLabel jLabel) {
        this.updateSelected(jComponentAdapter);
        if (this.qg.currSel == 3) {
            for (Map.Entry<String, Boolean> entry : varList.entrySet()) {
                if (!entry.getValue().booleanValue()) continue;
                this.qg.var = entry.getKey();
                this.qg.isSumable = QueryGenerator.sumableList.contains(this.qg.var);
            }
        }
        return this.updateList(jComponentAdapter, jLabel);
    }

    @Override
    public JComponentAdapter doBack(JComponentAdapter jComponentAdapter, JLabel jLabel) {
        if (this.qg.currSel == 3) {
            this.cohortList = null;
        }
        return this.updateList(jComponentAdapter, jLabel);
    }

    @Override
    public void doFinish(JComponentAdapter jComponentAdapter) {
        ++this.qg.currSel;
        this.updateSelected(jComponentAdapter);
        --this.qg.currSel;
        this.createXPath();
        this.queryFunctions = null;
        this.queryFilter = null;
    }

    @Override
    public boolean isAtEnd() {
        return this.qg.currSel == 3 && this.isPopMiniCAMSelected() || this.qg.currSel == 5;
    }

    @Override
    public JComponentAdapter updateList(JComponentAdapter jComponentAdapter, JLabel jLabel) {
        Vector<Integer> vector;
        Map map = null;
        switch (this.qg.currSel) {
            case 2: {
                jComponentAdapter.setSelectionMode(0);
                map = varList;
                jLabel.setText("Select Variable:");
                break;
            }
            case 3: {
                jComponentAdapter.setSelectionMode(0);
                if (this.popList == null) {
                    vector = this.queryFunctions;
                    this.queryFunctions = new Vector(1, 0);
                    this.queryFunctions.add(XMLDB.getInstance().getQueryFunctionAsDistinctNames());
                    this.popList = this.createList("*", false);
                    this.queryFunctions = vector;
                }
                map = this.popList;
                jLabel.setText("Select Population Type:");
                break;
            }
            case 4: {
                jComponentAdapter.setSelectionMode(2);
                if (this.cohortList == null) {
                    this.cohortList = this.createList("*/ageCohort/@ageGroup", false);
                    this.cohortList.putAll(this.createList("*/ageCohort/group/@name", true));
                }
                map = this.cohortList;
                jLabel.setText("Select Age Cohorts:");
                break;
            }
            case 5: {
                map = this.genderList;
                jLabel.setText("Select Genders: ");
                break;
            }
            default: {
                System.out.println("Error currSel: " + this.qg.currSel);
            }
        }
        vector = new Vector<Integer>();
        String[] stringArray = map.keySet().toArray(new String[0]);
        ((JList)jComponentAdapter.getModel()).setListData(stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!((Boolean)map.get(stringArray[i])).booleanValue()) continue;
            vector.addElement(new Integer(i));
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        map = null;
        vector = null;
        jComponentAdapter.setSelectedRows(nArray);
        return jComponentAdapter;
    }

    @Override
    public void updateSelected(JComponentAdapter jComponentAdapter) {
        Object[] objectArray = jComponentAdapter.getSelectedValues();
        Map map = null;
        switch (this.qg.currSel) {
            case 2: {
                return;
            }
            case 3: {
                map = varList;
                break;
            }
            case 4: {
                map = this.popList;
                break;
            }
            case 5: {
                map = this.cohortList;
                break;
            }
            case 6: {
                map = this.genderList;
                break;
            }
            default: {
                System.out.println("Error currSel: " + this.qg.currSel);
            }
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            iterator.next().setValue(new Boolean(false));
        }
        for (int i = 0; i < objectArray.length; ++i) {
            map.put(objectArray[i], new Boolean(true));
        }
    }

    private String expandGroupName(String string) {
        return null;
    }

    private void createXPath() {
        this.qg.xPath = this.createListPath(0);
        if (this.isPopMiniCAMSelected()) {
            this.qg.yearLevel = new DataPair<String, String>("populationMiniCAM", "year");
            this.qg.nodeLevel = new DataPair<String, String>("region", "name");
        } else if (this.popList.get("populationSGMFixed") != null && ((Boolean)this.popList.get("populationSGMFixed")).booleanValue()) {
            this.qg.yearLevel = new DataPair<String, String>("populationSGMFixed", "year");
            this.qg.nodeLevel = new DataPair<String, String>("ageCohort", "ageGroup");
        } else {
            this.qg.yearLevel = new DataPair<String, String>("populationSGMRate", "year");
            this.qg.nodeLevel = new DataPair<String, String>("ageCohort", "ageGroup");
        }
        if (this.isTotalPopulation()) {
            this.qg.nodeLevel = new DataPair<String, String>("region", "name");
        }
        this.qg.axis1Name = this.qg.nodeLevel.getKey();
        this.qg.axis2Name = "Year";
        this.qg.group = true;
    }

    @Override
    public String createListPath(int n) {
        StringBuffer stringBuffer = new StringBuffer("demographics/");
        boolean bl = false;
        for (Map.Entry entry : this.popList.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            stringBuffer.append(entry.getKey()).append("/");
            break;
        }
        if (this.isPopMiniCAMSelected() || this.isTotalPopulation()) {
            return stringBuffer.append(this.qg.var).append("/node()").toString();
        }
        stringBuffer.append("ageCohort");
        for (Map.Entry entry : this.cohortList.entrySet()) {
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            if (!bl) {
                stringBuffer.append("[ ");
                bl = true;
            } else {
                stringBuffer.append(" or ");
            }
            if (((String)entry.getKey()).startsWith("Group:")) {
                stringBuffer.append(this.expandGroupName(((String)entry.getKey()).substring(7)));
                continue;
            }
            stringBuffer.append("(@ageGroup='" + entry.getKey() + "')");
        }
        if (bl) {
            stringBuffer.append(" ]/");
        } else {
            stringBuffer.append("/");
        }
        if (this.popList.get("populationSGMFixed") != null && ((Boolean)this.popList.get("populationSGMFixed")).booleanValue()) {
            boolean bl2 = (Boolean)this.genderList.get("male");
            boolean bl3 = (Boolean)this.genderList.get("female");
            if (bl2 && bl3) {
                stringBuffer.append("*/");
            } else if (bl2) {
                stringBuffer.append("male/");
            } else {
                stringBuffer.append("female/");
            }
        } else {
            bl = false;
            stringBuffer.append("gender");
            for (Map.Entry entry : this.genderList.entrySet()) {
                if (!((Boolean)entry.getValue()).booleanValue()) continue;
                if (!bl) {
                    stringBuffer.append("[ ");
                    bl = true;
                } else {
                    stringBuffer.append(" or ");
                }
                stringBuffer.append("(@type = '" + entry.getKey() + "')");
            }
            if (bl) {
                stringBuffer.append(" ]/");
            } else {
                stringBuffer.append("/");
            }
        }
        stringBuffer.append(this.qg.var).append("/node()");
        System.out.println("The xpath is: " + stringBuffer.toString());
        return stringBuffer.toString();
    }

    private Map createList(String string, boolean bl) {
        return null;
    }

    @Override
    public String getXMLName() {
        return xmlName;
    }

    @Override
    public List<String> getDefaultCollpaseList() {
        Vector<String> vector = new Vector<String>();
        vector.add("total-population");
        return vector;
    }

    @Override
    public Map addToDataTree(ANode aNode, Map map, DataPair<String, String> dataPair, boolean bl) throws Exception {
        BXNode bXNode = BXNode.get((ANode)aNode);
        if (bXNode.getNodeType() == 9) {
            return map;
        }
        Map map2 = this.addToDataTree(aNode.parent(), map, dataPair, bl);
        String string = bXNode.getNodeName();
        Map<String, String> map3 = XMLDB.getAttrMap((Node)bXNode);
        String string2 = map3.get("type");
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.qg.nodeLevel.getKey().equals(string2)) {
            bl2 = true;
            if (this.qg.nodeLevel.getKey().equals("region") && bl) {
                dataPair.setValue("Global");
            } else {
                dataPair.setValue(map3.get(this.qg.nodeLevel.getValue() != null ? this.qg.nodeLevel.getValue() : "name"));
            }
        } else if (string.equals(this.qg.nodeLevel.getKey())) {
            bl2 = true;
            dataPair.setValue(map3.get(this.qg.nodeLevel.getValue() != null ? this.qg.nodeLevel.getValue() : "ageGroup"));
        }
        if (string.equals(this.qg.yearLevel.getKey())) {
            bl3 = true;
            dataPair.setKey(map3.get(this.qg.yearLevel.getValue() != null ? this.qg.yearLevel.getValue() : "year"));
        }
        if (string2 == null) {
            string2 = string;
        }
        if (string2.equals("male") || string2.equals("female")) {
            Map<String, String> map4;
            String string3 = string2;
            if (this.qg.labelRewriteMap != null && this.qg.labelRewriteMap.containsKey(string2) && (map4 = this.qg.labelRewriteMap.get(string2)).containsKey(string3)) {
                string3 = map4.get(string3);
            }
            if (!map2.containsKey(string3 = string2 + "@" + string3)) {
                map2.put(string3, new TreeMap());
            }
            map2 = (Map)map2.get(string3);
        } else if (!(bl2 || bl3 || map3.isEmpty() || this.qg.getCollapseOnList().contains(string2))) {
            Map<String, String> map5;
            String string4 = XMLDB.getAllAttr(map3, null);
            if (this.qg.labelRewriteMap != null && this.qg.labelRewriteMap.containsKey(string2) && (map5 = this.qg.labelRewriteMap.get(string2)).containsKey(string4)) {
                string4 = map5.get(string4);
            }
            if (!map2.containsKey(string4 = string2 + "@" + string4)) {
                map2.put(string4, new TreeMap());
            }
            map2 = (Map)map2.get(string4);
        }
        return map2;
    }

    static {
        xmlName = "demographicsQuery";
    }
}

