/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2.csvconv;

import ModelInterface.ModelGUI2.csvconv.Header;
import ModelInterface.ModelGUI2.csvconv.Headers;
import ModelInterface.common.DataPair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMTreeBuilder {
    private Document doc = null;
    private Headers head;
    private Map<String, Map<String, String>> lookUpMap;
    private boolean buildMap = false;
    private final Map<String, String> renameNodeMap = new HashMap<String, String>();
    private boolean renameNodeNames = false;
    private final Map<String, Set<String>> equivMap = new TreeMap<String, Set<String>>();
    private Map<String, Set<String>> equivNameLookup = new TreeMap<String, Set<String>>();
    private boolean addTagEquiv = false;

    public DOMTreeBuilder() {
        this.lookUpMap = new HashMap<String, Map<String, String>>();
    }

    public void setHeader(String string) throws Exception {
        if (this.renameNodeNames) {
            this.doRenameNodes(this.doc.getDocumentElement());
            this.renameNodeNames = false;
        }
        if (this.addTagEquiv) {
            this.buildEquivalenceLists();
            this.addTagEquiv = false;
        }
        if (string.matches(".*MAP,.*")) {
            this.buildMap = true;
            string = string.substring(string.indexOf(",") + 1);
        } else {
            this.buildMap = false;
        }
        if (string.matches(".*NODE_RENAME.*")) {
            this.renameNodeNames = true;
            this.head = null;
            return;
        }
        if (string.matches(".*NODE_EQUIVALENCE.*")) {
            this.addTagEquiv = true;
            this.head = null;
            return;
        }
        this.head = new Headers(string);
        if (!this.buildMap && this.doc == null) {
            DOMImplementation dOMImplementation = null;
            try {
                dOMImplementation = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
                return;
            }
            this.doc = dOMImplementation.createDocument(null, this.head.getRoot().getChildName(), null);
        }
    }

    public void addToTree(ArrayList<String> arrayList) throws Exception {
        if (this.renameNodeNames) {
            this.addToRenameMap(arrayList);
            return;
        }
        if (this.addTagEquiv) {
            if (arrayList.size() < 2) {
                System.out.println("Error not enough data to create equivalence.");
                return;
            }
            String string = arrayList.get(0);
            Set<String> set = this.equivMap.get(string);
            if (set == null) {
                set = new HashSet<String>();
            }
            for (int i = 1; i < arrayList.size(); ++i) {
                set.add(arrayList.get(i));
            }
            this.equivMap.put(string, set);
            return;
        }
        if (this.head == null && !this.buildMap) {
            System.out.println("Warning, no header set, skipping data");
            return;
        }
        if (this.buildMap) {
            this.addToMap(arrayList);
        } else {
            this.makeTree(this.doc.getDocumentElement(), this.head.getRoot(), arrayList);
        }
    }

    public Document getDoc() {
        if (this.renameNodeNames) {
            this.doRenameNodes(this.doc.getDocumentElement());
            this.renameNodeNames = false;
        }
        return this.doc;
    }

    private void addToMap(List<String> list) {
        Map<String, String> map = this.lookUpMap.containsKey(this.head.getHeader(0).getChildName()) ? this.lookUpMap.get(this.head.getHeader(0).getChildName()) : new HashMap<String, String>();
        if (list.size() == 3) {
            map.put(list.get(0) + "&&" + list.get(1), list.get(2));
        } else {
            map.put(list.get(0), list.get(1));
        }
        for (int i = 0; i < this.head.getNumHeaders(); ++i) {
            this.lookUpMap.put(this.head.getHeader(i).getChildName(), map);
        }
    }

    private void addToRenameMap(List<String> list) {
        this.renameNodeMap.put(list.get(0), list.get(1));
    }

    public void doRenameNodes(Node node) {
        String string = this.renameNodeMap.get(node.getNodeName());
        if (string != null) {
            node = this.doc.renameNode(node, "", string);
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            this.doRenameNodes(nodeList.item(i));
        }
    }

    private void buildEquivalenceLists() {
        this.equivNameLookup = new TreeMap<String, Set<String>>();
        for (Set<String> set : this.equivMap.values()) {
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                this.equivNameLookup.put(iterator.next(), set);
            }
        }
    }

    private void convertData(Element element, Element element2) {
        Map<String, String> map = this.lookUpMap.get(element.getNodeName());
        if (map == null) {
            return;
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            String string = map.get(node.getNodeName() + node.getNodeValue());
            if (string != null) {
                node.setNodeValue(string);
                continue;
            }
            string = map.get(element2.getAttribute(node.getNodeName()) + "&&" + node.getNodeName() + node.getNodeValue());
            if (string == null) continue;
            node.setNodeValue(string);
        }
    }

    private boolean compareHelper(Element element, Element element2) {
        Object object;
        if (!(element.getTagName().equals(element2.getTagName()) || (object = this.equivNameLookup.get(element.getTagName())) != null && object.contains(element2.getTagName()))) {
            return false;
        }
        object = element.getAttributes();
        NamedNodeMap namedNodeMap = element2.getAttributes();
        if (object.getLength() != namedNodeMap.getLength()) {
            return false;
        }
        for (int i = 0; i < object.getLength(); ++i) {
            String string = object.item(i).getNodeName();
            if (element.getAttribute(string).equals(element2.getAttribute(string))) continue;
            return false;
        }
        return true;
    }

    private Node compare(Element element, Element element2) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() == 3 || !this.compareHelper((Element)nodeList.item(i), element2)) continue;
            return nodeList.item(i);
        }
        return null;
    }

    private static boolean mergeNode(Element element, Element element2) {
        int n;
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (n = 0; n < namedNodeMap.getLength(); ++n) {
            if (!element2.hasAttribute(namedNodeMap.item(n).getNodeName())) continue;
            return false;
        }
        for (n = 0; n < namedNodeMap.getLength(); ++n) {
            Node node = namedNodeMap.item(n);
            element2.setAttribute(node.getNodeName(), node.getNodeValue());
        }
        return true;
    }

    private static Node hasTextData(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            return nodeList.item(i);
        }
        return null;
    }

    private void makeTree(Node node, Header header, List<String> list) {
        List<Header> list2 = this.head.getChildHeaders(header);
        List<DataPair<List<Header>, Node>> list3 = this.getMultiHeaderList(list2);
        Iterator<Header> iterator = list2.iterator();
        while (iterator.hasNext()) {
            Node node2 = node;
            Header header2 = iterator.next();
            int n = header2.getReadColumnPos();
            String string = null;
            if (n != -1) {
                string = list.get(n);
            }
            for (DataPair<List<Header>, Node> dataPair : list3) {
                if (!dataPair.getKey().contains(header2)) continue;
                Element element = (Element)header2.getChildEntity().doCreate(this.doc, string, (Element)dataPair.getValue());
                dataPair.getKey().remove(header2);
                if (dataPair.getKey().size() == 0) {
                    if (header2.doesSpecifyParent()) {
                        node2 = this.getRealParent(node, header2);
                    }
                    this.convertData(element, (Element)node2);
                    Node node3 = this.compare((Element)node2, element);
                    if (node3 == null) {
                        node2.appendChild(element);
                        this.makeTree(element, header2, list);
                        if (!header2.isCompleteGPPath()) continue;
                        node2.removeChild(element);
                        continue;
                    }
                    if (DOMTreeBuilder.hasTextData(node3) != null) {
                        DOMTreeBuilder.hasTextData(node3).setNodeValue(element.getFirstChild().getNodeValue());
                    }
                    this.makeTree(node3, header2, list);
                    continue;
                }
                dataPair.setValue(element);
            }
        }
    }

    private Node getRealParent(Node node, Header header) {
        Object object;
        Object object2 = node;
        boolean bl = false;
        boolean bl2 = false;
        if (header.hasGrandParent()) {
            object = new Stack<Node>();
            ((Stack)object).push(object2);
            Node node2 = object2;
            while (!(node2 = node2.getParentNode()).getNodeName().equals(header.getGrandParentEntity().getName())) {
                ((Stack)object).push(node2);
            }
            Element element = (Element)header.getGrandParentEntity().doCreate(this.doc, null, null);
            this.convertData(element, (Element)node2.getParentNode());
            bl2 = DOMTreeBuilder.mergeNode((Element)node2, element);
            object2 = this.compare((Element)node2.getParentNode(), element);
            if (object2 == null) {
                node2.getParentNode().appendChild(element);
                object2 = element;
                bl = true;
            }
            while (!((Stack)object).empty()) {
                node2 = (Node)((Stack)object).pop();
                if (bl) {
                    node2 = node2.cloneNode(false);
                    object2.appendChild(node2);
                } else {
                    Node node3 = this.compare((Element)object2, (Element)node2);
                    if (node3 == null) {
                        node2 = node2.cloneNode(false);
                        object2.appendChild(node2);
                    } else {
                        node2 = node3;
                    }
                }
                object2 = node2;
            }
        }
        if (header.getParentEntity().doesSpecifyAttrValue()) {
            object = (Element)header.getParentEntity().doCreate(this.doc, null, null);
            node = object2.getParentNode();
            this.convertData((Element)object, (Element)node);
            if (bl || bl2 && !object2.hasChildNodes()) {
                node.removeChild((Node)object2);
            }
            if ((object2 = this.compare((Element)node, (Element)object)) == null) {
                node.appendChild((Node)object);
                object2 = object;
            }
        }
        return object2;
    }

    private List<DataPair<List<Header>, Node>> getMultiHeaderList(List<Header> list) {
        List list2;
        Iterator<List<Object>> iterator;
        ArrayList<DataPair<List<Header>, Node>> arrayList = new ArrayList<DataPair<List<Header>, Node>>();
        ArrayList<Iterator<List<Object>>> arrayList2 = new ArrayList<Iterator<List<Object>>>();
        for (Header object : list) {
            List<Object> list3;
            boolean arrayList3 = false;
            iterator = arrayList2.iterator();
            while (!arrayList3 && iterator.hasNext()) {
                list3 = (ArrayList<Header>)iterator.next();
                Header header = (Header)((List)list3.get(0)).get(0);
                if ((object.hasGrandParent() || header.hasGrandParent()) && (!object.hasGrandParent() || !object.getGrandParentEntity().equals(header.getGrandParentEntity())) || !object.getParentEntity().equals(header.getParentEntity()) || !object.getChildName().equals(header.getChildName())) continue;
                Object i = list3.iterator();
                while (!arrayList3 && i.hasNext()) {
                    list2 = (List)i.next();
                    if (!object.getChildEntity().getAttrNames().equals(((Header)list2.get(0)).getChildEntity().getAttrNames())) continue;
                    list2.add(object);
                    arrayList3 = true;
                }
                if (arrayList3) continue;
                i = new ArrayList();
                i.add(object);
                list3.add(i);
                arrayList3 = true;
            }
            if (arrayList3) continue;
            iterator = new ArrayList();
            list3 = new ArrayList<Header>();
            list3.add(object);
            iterator.add(list3);
            arrayList2.add(iterator);
        }
        for (List list4 : arrayList2) {
            ArrayList<List<Object>> arrayList3 = new ArrayList<List<Object>>();
            for (List<Object> list3 : list4) {
                int n = arrayList3.size();
                for (int i = 0; i < n || arrayList3.size() == 0; ++i) {
                    list2 = arrayList3.size() != 0 ? (List)arrayList3.get(i) : null;
                    for (int j = 0; j < list3.size(); ++j) {
                        List<Object> list5;
                        Header header = (Header)list3.get(j);
                        if (list2 != null) {
                            if (j != list3.size() - 1) {
                                list5 = DOMTreeBuilder.cloneList(list2);
                                list5.add(header);
                                arrayList3.add(list5);
                                continue;
                            }
                            list2.add(header);
                            continue;
                        }
                        list5 = new ArrayList<Header>();
                        list5.add(header);
                        arrayList3.add(list5);
                    }
                }
            }
            iterator = arrayList3.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new DataPair<List, Object>((List)iterator.next(), null));
            }
        }
        return arrayList;
    }

    private static <T> List<T> cloneList(List<T> list) {
        ArrayList<T> arrayList = new ArrayList<T>(list.size());
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    private void finalize(Node node) {
        if (node.getNodeName().indexOf(":") != -1 && node.getNodeName().indexOf(":") != 0) {
            Node node2;
            System.out.println("I am acctually in here!! curr: " + node.getNodeName());
            Element element = this.doc.createElement(node.getNodeName().substring(0, node.getNodeName().indexOf(":")));
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                element.setAttributeNode(((Element)node).removeAttributeNode((Attr)namedNodeMap.item(i)));
                --i;
            }
            node.getParentNode().replaceChild(element, node);
            while ((node2 = node.getFirstChild()) != null) {
                element.appendChild(node.removeChild(node2));
                this.finalize(node2);
            }
        } else {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.finalize(nodeList.item(i));
            }
        }
    }
}

