/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2;

import ModelInterface.InterfaceMain;
import ModelInterface.ModelGUI2.DbViewer;
import ModelInterface.ModelGUI2.QueryResultsPanel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;

public class TabCloseIcon
implements Icon {
    private static final Icon closeIcon = new ImageIcon(TabCloseIcon.class.getResource("icons/closeTab.PNG"));
    private static final Icon mPressCloseIcon = new ImageIcon(TabCloseIcon.class.getResource("icons/mPressCloseTab.PNG"));
    private static final Icon loadingIcon = new ImageIcon(TabCloseIcon.class.getResource("icons/loadTab.PNG"));
    private JTabbedPane tabPane = null;
    private Icon showingIcon = loadingIcon;
    private transient Rectangle position = null;

    public TabCloseIcon(JTabbedPane jTabbedPane) {
        this.tabPane = jTabbedPane;
        this.tabPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (!mouseEvent.isConsumed() && TabCloseIcon.this.position.contains(mouseEvent.getX(), mouseEvent.getY())) {
                    int n = TabCloseIcon.this.tabPane.indexAtLocation(mouseEvent.getX(), mouseEvent.getY());
                    QueryResultsPanel queryResultsPanel = (QueryResultsPanel)TabCloseIcon.this.tabPane.getComponentAt(n);
                    queryResultsPanel.killThread();
                    InterfaceMain.getInstance().fireProperty("Query", DbViewer.getTableModelFromComponent(queryResultsPanel), null);
                    TabCloseIcon.this.tabPane.removeMouseListener(this);
                    TabCloseIcon.this.tabPane.remove(n);
                    mouseEvent.consume();
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (!mouseEvent.isConsumed()) {
                    TabCloseIcon.this.showingIcon = closeIcon;
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (!mouseEvent.isConsumed() && TabCloseIcon.this.position.contains(mouseEvent.getX(), mouseEvent.getY())) {
                    TabCloseIcon.this.showingIcon = mPressCloseIcon;
                }
            }
        });
    }

    public void finishedLoading() {
        this.showingIcon = closeIcon;
        this.tabPane.repaint();
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        this.position = new Rectangle(n, n2, this.getIconWidth(), this.getIconHeight());
        this.showingIcon.paintIcon(component, graphics, n, n2);
    }

    @Override
    public int getIconWidth() {
        return this.showingIcon.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.showingIcon.getIconHeight();
    }
}

