/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2;

import ModelInterface.InterfaceMain;
import ModelInterface.ModelGUI2.queries.QueryGenerator;
import ModelInterface.ModelGUI2.queries.SingleQueryExtension;
import ModelInterface.ModelGUI2.undo.EditQueryUndoableEdit;
import ModelInterface.ModelGUI2.undo.MiUndoableEditListener;
import ModelInterface.ModelGUI2.undo.QueryAddRemoveUndoableEdit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QueryTreeModel
implements TreeModel,
MiUndoableEditListener {
    protected QueryGroup root;
    protected ArrayList<TreeModelListener> tmListeners;
    protected int changes;

    public QueryTreeModel(Node node) {
        this.root = new QueryGroup("queries", this.recCreateTree(node));
        this.changes = 0;
        this.tmListeners = new ArrayList();
        this.addTreeModelListener(new QueryTreeModelListener());
    }

    protected ArrayList recCreateTree(Node node) {
        NodeList nodeList = node.getChildNodes();
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeName().equals("queryGroup")) {
                arrayList.add(new QueryGroup(((Element)nodeList.item(i)).getAttribute("name"), this.recCreateTree(nodeList.item(i))));
                continue;
            }
            QueryGenerator queryGenerator = new QueryGenerator(nodeList.item(i));
            if (!queryGenerator.isValid()) continue;
            arrayList.add(queryGenerator);
        }
        return arrayList;
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.tmListeners.add(treeModelListener);
    }

    @Override
    public Object getChild(Object object, int n) {
        if (this.getChildCount(object) <= 0) {
            return null;
        }
        if (object instanceof QueryGroup) {
            return ((QueryGroup)object).getQueryList().get(n);
        }
        return ((QueryGenerator)object).getSingleQueryExtension().getSingleQueryValueAt(n);
    }

    @Override
    public int getChildCount(Object object) {
        if (!(object instanceof QueryGroup) && !(object instanceof QueryGenerator) || object == null) {
            return -1;
        }
        if (object instanceof QueryGroup) {
            return ((QueryGroup)object).getQueryList().size();
        }
        return ((QueryGenerator)object).getSingleQueryExtension().getNumValues();
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (!(object instanceof QueryGroup) && !(object instanceof QueryGenerator) || !(object2 instanceof QueryGroup) && !(object2 instanceof QueryGenerator) && !(object2 instanceof SingleQueryExtension.SingleQueryValue) || object == null || object2 == null) {
            return -1;
        }
        if (this.isLeaf(object)) {
            return -1;
        }
        if (object instanceof QueryGroup) {
            return ((QueryGroup)object).getQueryList().indexOf(object2);
        }
        return ((QueryGenerator)object).getSingleQueryExtension().getIndexOfValue((SingleQueryExtension.SingleQueryValue)object2);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof QueryGenerator) {
            if (!((QueryGenerator)object).hasSingleQueryExtension()) {
                return true;
            }
            return ((QueryGenerator)object).getSingleQueryExtension().getNumValues() == 0;
        }
        return !(object instanceof QueryGroup);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.tmListeners.remove(treeModelListener);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public void add(TreePath treePath, QueryGenerator queryGenerator) {
        this.addValue(treePath, queryGenerator);
    }

    public void add(TreePath treePath, String string) {
        this.addValue(treePath, new QueryGroup(string, new ArrayList()));
    }

    public void add(TreePath treePath, QueryGroup queryGroup) {
        this.addValue(treePath, queryGroup);
    }

    private void addValue(TreePath treePath, Object object) {
        TreePath treePath2;
        if (treePath.getLastPathComponent() instanceof QueryGroup) {
            treePath2 = treePath;
        } else if (treePath.getLastPathComponent() instanceof QueryGenerator) {
            treePath2 = treePath.getParentPath();
        } else if (treePath.getLastPathComponent() instanceof SingleQueryExtension.SingleQueryValue) {
            treePath2 = treePath.getParentPath().getParentPath();
        } else {
            System.out.println("ERROR: could not find parent, not going to add");
            return;
        }
        QueryGroup queryGroup = (QueryGroup)treePath2.getLastPathComponent();
        int[] nArray = new int[1];
        Object[] objectArray = new Object[]{object};
        nArray[0] = queryGroup.getQueryList().size();
        queryGroup.getQueryList().add(object);
        this.fireTreeNodesInserted(this, treePath2, nArray, objectArray);
    }

    public void remove(TreePath treePath) {
        Object[] objectArray = new Object[]{treePath.getLastPathComponent()};
        if (objectArray[0].equals(this.root)) {
            Object[] objectArray2 = this.root.getQueryList().toArray();
            int[] nArray = new int[objectArray2.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = 1;
            }
            this.root.getQueryList().clear();
            this.fireTreeNodesRemoved(this, treePath, nArray, objectArray2);
        } else {
            int[] nArray = new int[]{((QueryGroup)treePath.getParentPath().getLastPathComponent()).getQueryList().indexOf(objectArray[0])};
            ((QueryGroup)treePath.getParentPath().getLastPathComponent()).getQueryList().remove(nArray[0]);
            this.fireTreeNodesRemoved(this, treePath.getParentPath(), nArray, objectArray);
        }
    }

    public void doEdit(final TreePath treePath) {
        final Object[] objectArray = new Object[]{treePath.getLastPathComponent()};
        if (!(objectArray[0] instanceof QueryGenerator)) {
            return;
        }
        final QueryTreeModel queryTreeModel = this;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (((QueryGenerator)objectArray[0]).editDialog(queryTreeModel)) {
                    TreePath treePath2 = treePath.getParentPath();
                    int[] nArray = new int[]{QueryTreeModel.this.getIndexOfChild(treePath2.getLastPathComponent(), objectArray[0])};
                    QueryTreeModel.this.fireTreeNodesChanged(queryTreeModel, treePath2, nArray, objectArray);
                }
            }
        });
        thread.start();
    }

    public Node getAsNode(Document document) {
        this.addQueryGroup(document, document.getDocumentElement(), this.root);
        return document.getDocumentElement();
    }

    public void addQueryGroup(Document document, Node node, QueryGroup queryGroup) {
        for (int i = 0; i < queryGroup.getQueryList().size(); ++i) {
            Node node2;
            if (queryGroup.getQueryList().get(i) instanceof QueryGroup) {
                node2 = document.createElement("queryGroup");
                node2.setAttribute("name", ((QueryGroup)queryGroup.getQueryList().get(i)).getName());
                this.addQueryGroup(document, node2, (QueryGroup)queryGroup.getQueryList().get(i));
            } else {
                node2 = ((QueryGenerator)queryGroup.getQueryList().get(i)).getAsNode(document);
            }
            node.appendChild(node2);
        }
    }

    public void showSingleQuery(SingleQueryExtension singleQueryExtension, TreePath treePath) {
        int n = singleQueryExtension.getNumValues();
        int[] nArray = new int[n];
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
            objectArray[i] = singleQueryExtension.getSingleQueryValueAt(i);
        }
        this.fireTreeNodesInserted(singleQueryExtension, treePath, nArray, objectArray);
    }

    public void hideSingleQuery(SingleQueryExtension singleQueryExtension, TreePath treePath) {
        int n = singleQueryExtension.getNumValues();
        int[] nArray = new int[n];
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
            objectArray[i] = singleQueryExtension.getSingleQueryValueAt(i);
        }
        singleQueryExtension.resetList();
        this.fireTreeNodesRemoved(singleQueryExtension, treePath, nArray, objectArray);
    }

    public void fireTreeNodesChanged(Object object, TreePath treePath, int[] nArray, Object[] objectArray) {
        TreeModelEvent treeModelEvent = new TreeModelEvent(object, treePath, nArray, objectArray);
        Iterator<TreeModelListener> iterator = this.tmListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().treeNodesChanged(treeModelEvent);
        }
    }

    public void fireTreeNodesInserted(Object object, TreePath treePath, int[] nArray, Object[] objectArray) {
        TreeModelEvent treeModelEvent = new TreeModelEvent(object, treePath, nArray, objectArray);
        Iterator<TreeModelListener> iterator = this.tmListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().treeNodesInserted(treeModelEvent);
        }
    }

    public void fireTreeNodesRemoved(Object object, TreePath treePath, int[] nArray, Object[] objectArray) {
        TreeModelEvent treeModelEvent = new TreeModelEvent(object, treePath, nArray, objectArray);
        Iterator<TreeModelListener> iterator = this.tmListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().treeNodesRemoved(treeModelEvent);
        }
    }

    public void fireTreeStructureChanged(Object object, TreePath treePath, int[] nArray, Object[] objectArray) {
        TreeModelEvent treeModelEvent = new TreeModelEvent(object, treePath, nArray, objectArray);
        Iterator<TreeModelListener> iterator = this.tmListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().treeStructureChanged(treeModelEvent);
        }
    }

    public QueryGroup createQueryGroup(String string, ArrayList arrayList) {
        return new QueryGroup(string, arrayList);
    }

    public QueryGroup createQueryGroup(Node node) {
        String string = ((Element)node).getAttribute("name");
        if (string == null) {
            return null;
        }
        ArrayList arrayList = this.recCreateTree(node);
        if (arrayList.size() == 0) {
            return null;
        }
        return new QueryGroup(string, arrayList);
    }

    @Override
    public void undoPerformed(UndoableEditEvent undoableEditEvent) {
        if (undoableEditEvent.getEdit() instanceof QueryAddRemoveUndoableEdit || undoableEditEvent.getEdit() instanceof EditQueryUndoableEdit) {
            this.decreaseChanges();
        }
    }

    @Override
    public void redoPerformed(UndoableEditEvent undoableEditEvent) {
        if (undoableEditEvent.getEdit() instanceof QueryAddRemoveUndoableEdit || undoableEditEvent.getEdit() instanceof EditQueryUndoableEdit) {
            this.increaseChanges();
        }
    }

    private void increaseChanges() {
        ++this.changes;
        if (this.changes == 1) {
            InterfaceMain.getInstance().getSaveMenu().setEnabled(true);
            this.root.setName(this.root.getName() + "*");
            int[] nArray = new int[]{0};
            Object[] objectArray = new Object[]{this.root};
            TreePath treePath = new TreePath(this.root);
            this.fireTreeNodesChanged(this.root, treePath, nArray, objectArray);
        }
    }

    private void decreaseChanges() {
        --this.changes;
        if (!this.hasChanges()) {
            InterfaceMain.getInstance().getSaveMenu().setEnabled(false);
            this.root.setName(this.root.getName().substring(0, this.root.getName().length() - 1));
            int[] nArray = new int[]{0};
            Object[] objectArray = new Object[]{this.root};
            TreePath treePath = new TreePath(this.root);
            this.fireTreeNodesChanged(this.root, treePath, nArray, objectArray);
        }
    }

    public boolean hasChanges() {
        return this.changes != 0;
    }

    public void resetChanges() {
        while (this.hasChanges()) {
            this.decreaseChanges();
        }
    }

    protected class QueryTreeModelListener
    implements TreeModelListener {
        private UndoManager undoManager;
        private InterfaceMain main = InterfaceMain.getInstance();

        public QueryTreeModelListener() {
            this.undoManager = this.main.getUndoManager();
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            if (treeModelEvent.getSource() instanceof QueryTreeModel) {
                QueryTreeModel.this.increaseChanges();
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            if (treeModelEvent.getSource() instanceof QueryTreeModel) {
                QueryTreeModel.this.increaseChanges();
                this.addEdit(new QueryAddRemoveUndoableEdit(treeModelEvent, true));
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            if (treeModelEvent.getSource() instanceof QueryTreeModel) {
                QueryTreeModel.this.increaseChanges();
                this.addEdit(new QueryAddRemoveUndoableEdit(treeModelEvent, false));
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }

        private void addEdit(UndoableEdit undoableEdit) {
            this.undoManager.addEdit(undoableEdit);
            this.main.refreshUndoRedo();
        }
    }

    public class QueryGroup
    implements Serializable {
        ArrayList qList;
        String groupName;

        public QueryGroup(String string, ArrayList arrayList) {
            this.groupName = string;
            this.qList = arrayList;
        }

        public String getName() {
            return this.groupName;
        }

        public void setName(String string) {
            this.groupName = string;
        }

        public ArrayList getQueryList() {
            return this.qList;
        }

        public String toString() {
            return this.groupName;
        }

        public void resetQueryBuilders() {
            for (int i = 0; i < this.qList.size(); ++i) {
                if (this.qList.get(i) instanceof QueryGenerator) {
                    ((QueryGenerator)this.qList.get(i)).resetQueryBuilder();
                    continue;
                }
                ((QueryGroup)this.qList.get(i)).resetQueryBuilders();
            }
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.groupName);
            objectOutputStream.writeObject(this.qList);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.groupName = (String)objectInputStream.readObject();
            this.qList = (ArrayList)objectInputStream.readObject();
        }
    }
}

