/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2;

import ModelInterface.InterfaceMain;
import ModelInterface.ModelGUI2.queries.QueryGenerator;
import ModelInterface.ModelGUI2.tables.BaseTableModel;
import ModelInterface.ModelGUI2.tables.ComboTableModel;
import ModelInterface.ModelGUI2.tables.MultiTableModel;
import ModelInterface.ModelGUI2.xmldb.DbProcInterrupt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BatchWindow {
    private static final long serialVersionUID = -1481157258336281895L;
    final File outputFile;
    final Vector<Object[]> toRunScns;
    final Vector<String> allRegions;
    final boolean singleSheet;
    final boolean drawPics;
    final int numQueries;
    final NodeList res;
    Thread exportThread;
    final boolean overwriteFile;
    final JProgressBar progressBar;
    final Runnable increaseProgress;
    final Window progressDialog;
    final ExecutorService queryThreadPool;

    public BatchWindow(final File file, final Vector<Object[]> vector, final Vector<String> vector2, boolean bl, boolean bl2, final int n, final NodeList nodeList, final boolean bl3, int n2) {
        this.outputFile = file;
        final boolean bl4 = file.getName().endsWith(".xls");
        this.toRunScns = vector;
        this.allRegions = vector2;
        this.singleSheet = bl;
        this.drawPics = bl2;
        this.numQueries = n;
        this.res = nodeList;
        this.overwriteFile = bl3;
        this.queryThreadPool = Executors.newFixedThreadPool(n2);
        final int n3 = n * vector.size();
        if (InterfaceMain.getInstance().getFrame() == null) {
            this.progressBar = null;
            this.progressDialog = null;
        } else {
            this.progressBar = new JProgressBar(0, n3);
            this.progressDialog = BatchWindow.createProgressBarGUI2(this.progressBar, "Running Queries", "Run and Export Progress");
            WindowAdapter windowAdapter = new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    BatchWindow.this.killThread();
                }
            };
            this.progressDialog.addWindowListener(windowAdapter);
            this.progressDialog.addWindowStateListener(windowAdapter);
        }
        this.increaseProgress = new Runnable(){
            int numRun = 0;

            @Override
            public void run() {
                ++this.numRun;
                if (BatchWindow.this.progressBar != null) {
                    BatchWindow.this.progressBar.setValue(BatchWindow.this.progressBar.getValue() + 1);
                } else {
                    System.out.print("Completed ");
                    System.out.print((double)this.numRun * 100.0 / (double)n3);
                    System.out.println("% of batch queries.");
                }
            }
        };
        this.exportThread = new Thread(){

            @Override
            public void run() {
                HSSFWorkbook hSSFWorkbook = null;
                Vector<String> vector3 = new Vector<String>();
                if (this.isInterrupted()) {
                    return;
                }
                if (bl4 && file.exists() && !bl3) {
                    try {
                        hSSFWorkbook = new HSSFWorkbook((InputStream)new FileInputStream(file));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        InterfaceMain.getInstance().showMessageDialog("There was an error while trying to open " + file, "Batch Query Error", 0);
                        if (BatchWindow.this.progressDialog != null) {
                            BatchWindow.this.progressDialog.dispose();
                        }
                        return;
                    }
                }
                LinkedList<FutureQueryTask> linkedList = new LinkedList<FutureQueryTask>();
                for (Object[] objectArray : vector) {
                    for (int i = 0; i < n; ++i) {
                        QueryGenerator queryGenerator = null;
                        Node node = nodeList.item(i);
                        if (node.getNodeType() == 8) {
                            SwingUtilities.invokeLater(BatchWindow.this.increaseProgress);
                            continue;
                        }
                        vector3.clear();
                        NodeList nodeList2 = node.getChildNodes();
                        boolean bl = false;
                        boolean bl2 = false;
                        for (int j = 0; j < nodeList2.getLength(); ++j) {
                            Node node2 = nodeList2.item(j);
                            if (node2.getNodeName().equals("region")) {
                                String string = ((Element)node2).getAttribute("name");
                                if (!string.equals("Global")) {
                                    vector3.add(((Element)node2).getAttribute("name"));
                                    continue;
                                }
                                bl = true;
                                continue;
                            }
                            if (node2.getNodeName().equals("all-regions")) {
                                bl2 = true;
                                continue;
                            }
                            try {
                                queryGenerator = new QueryGenerator(node2);
                                continue;
                            }
                            catch (NullPointerException nullPointerException) {
                                nullPointerException.printStackTrace();
                                continue;
                            }
                            catch (ClassCastException classCastException) {
                                classCastException.printStackTrace();
                            }
                        }
                        boolean bl32 = false;
                        if (bl2) {
                            if (vector3.size() > 0 || bl) {
                                System.out.println("Warning: specified regions to query are overrriden by all-regions");
                            }
                            vector3.addAll(vector2);
                            bl = false;
                        }
                        if (vector3.size() > 0) {
                            FutureQueryTask futureQueryTask = new FutureQueryTask(queryGenerator, objectArray, vector3, bl32);
                            linkedList.add(futureQueryTask);
                            BatchWindow.this.queryThreadPool.execute(futureQueryTask);
                            bl32 = true;
                        }
                        if (!bl) continue;
                        vector3.clear();
                        vector3.add("Global");
                        FutureQueryTask futureQueryTask = new FutureQueryTask(queryGenerator, objectArray, vector3, bl32);
                        linkedList.add(futureQueryTask);
                        BatchWindow.this.queryThreadPool.execute(futureQueryTask);
                    }
                }
                BatchWindow.this.queryThreadPool.shutdown();
                if (bl4) {
                    BatchWindow.this.doExcelOutput(file, hSSFWorkbook, linkedList);
                } else {
                    BatchWindow.this.doCsvOutput(file, linkedList);
                }
            }
        };
        this.exportThread.start();
    }

    public static Window createProgressBarGUI2(JProgressBar jProgressBar, String string, String string2) {
        if (jProgressBar.getMaximum() == 0) {
            return null;
        }
        final JDialog jDialog = new JDialog(InterfaceMain.getInstance().getFrame(), string, false);
        jDialog.setResizable(false);
        jDialog.setAlwaysOnTop(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jProgressBar.setPreferredSize(new Dimension(200, 20));
        JLabel jLabel = new JLabel(string2);
        jPanel.add((Component)jLabel, "First");
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(jProgressBar);
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WindowEvent windowEvent = new WindowEvent(jDialog, 201);
                for (WindowListener windowListener : jDialog.getWindowListeners()) {
                    windowListener.windowClosing(windowEvent);
                }
                jDialog.dispose();
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(jPanel2);
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        jDialog.add((Component)jPanel, "First");
        jDialog.pack();
        jDialog.setVisible(true);
        return jDialog;
    }

    public void killThread() {
        this.queryThreadPool.shutdownNow();
        this.exportThread.interrupt();
    }

    public void waitForFinish() {
        try {
            this.exportThread.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExcelOutput(File file, HSSFWorkbook hSSFWorkbook, Queue<FutureQueryTask> queue) {
        HSSFSheet hSSFSheet = null;
        HSSFPatriarch hSSFPatriarch = null;
        int n = 0;
        if (hSSFWorkbook == null || file.exists() && this.overwriteFile) {
            hSSFWorkbook = new HSSFWorkbook();
        }
        try {
            Object object = this.toRunScns.iterator();
            while (object.hasNext()) {
                if (!this.singleSheet) {
                    hSSFSheet = hSSFWorkbook.createSheet("Sheet" + String.valueOf(hSSFWorkbook.getNumberOfSheets() + 1));
                    hSSFPatriarch = this.drawPics ? hSSFSheet.createDrawingPatriarch() : null;
                }
                for (int i = 0; i < this.numQueries; ++i) {
                    Node node = this.res.item(i);
                    if (node.getNodeType() == 8) continue;
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    if (this.singleSheet) {
                        hSSFSheet = hSSFWorkbook.createSheet("Sheet" + String.valueOf(hSSFWorkbook.getNumberOfSheets() + 1));
                        hSSFPatriarch = this.drawPics ? hSSFSheet.createDrawingPatriarch() : null;
                    }
                    for (int j = 0; j < 1 || !queue.isEmpty() && queue.peek().isTaskAnExtraRun(); ++j) {
                        try {
                            queue.peek().get().exportToExcel(hSSFSheet, hSSFWorkbook, hSSFPatriarch);
                            continue;
                        }
                        catch (ExecutionException executionException) {
                            executionException.printStackTrace();
                            HSSFRow hSSFRow = hSSFSheet.createRow(hSSFSheet.getLastRowNum() + 1);
                            hSSFRow.createCell((short)0).setCellValue(queue.peek().getQueryName() + " had error: " + executionException.getMessage());
                            if (queue.peek().isTaskAnExtraRun()) continue;
                            ++n;
                            continue;
                        }
                        finally {
                            queue.remove();
                        }
                    }
                }
                object.next();
            }
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            try {
                object = new FileOutputStream(file);
                hSSFWorkbook.write((OutputStream)object);
                ((FileOutputStream)object).close();
                if (n == 0) {
                    InterfaceMain.getInstance().showMessageDialog("Successfully ran batch query", "Batch Query", 1);
                } else {
                    String string = "Batch queries finished with " + n + " error" + (n == 1 ? "." : "s.");
                    InterfaceMain.getInstance().showMessageDialog(string, "Batch Query", 2);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                InterfaceMain.getInstance().showMessageDialog("There was an error while trying to write results", "Batch Query Error", 0);
            }
            finally {
                if (this.progressDialog != null) {
                    this.progressDialog.dispose();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            Iterator iterator = queue.iterator();
            while (iterator.hasNext()) {
                ((FutureQueryTask)iterator.next()).cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCsvOutput(File file, Queue<FutureQueryTask> queue) {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Object object = this.toRunScns.iterator();
            while (object.hasNext()) {
                for (int i = 0; i < this.numQueries; ++i) {
                    Node node = this.res.item(i);
                    if (node.getNodeType() == 8) continue;
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    for (int j = 0; j < 1 || !queue.isEmpty() && queue.peek().isTaskAnExtraRun(); ++j) {
                        try {
                            stringBuilder.append(queue.peek().get().exportToText(','));
                            continue;
                        }
                        catch (ExecutionException executionException) {
                            executionException.printStackTrace();
                            String string = System.getProperty("line.separator");
                            stringBuilder.append(queue.peek().getQueryName()).append(" had error: ").append(executionException.getMessage()).append(string);
                            if (queue.peek().isTaskAnExtraRun()) continue;
                            ++n;
                            continue;
                        }
                        finally {
                            queue.remove();
                        }
                    }
                }
                object.next();
            }
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            try {
                object = new PrintStream(file);
                ((PrintStream)object).print(stringBuilder.toString());
                ((PrintStream)object).close();
                if (n == 0) {
                    InterfaceMain.getInstance().showMessageDialog("Successfully ran batch query", "Batch Query", 1);
                } else {
                    String string = "Batch queries finished with " + n + " error" + (n == 1 ? "." : "s.");
                    InterfaceMain.getInstance().showMessageDialog(string, "Batch Query", 2);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                InterfaceMain.getInstance().showMessageDialog("There was an error while trying to write results", "Batch Query Error", 0);
            }
            finally {
                if (this.progressDialog != null) {
                    this.progressDialog.dispose();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            Iterator iterator = queue.iterator();
            while (iterator.hasNext()) {
                ((FutureQueryTask)iterator.next()).cancel(true);
            }
        }
    }

    private class FutureQueryTask
    implements RunnableFuture<BaseTableModel>,
    Callable<BaseTableModel> {
        final FutureTask<BaseTableModel> futureDelegate;
        final DbProcInterrupt context;
        final QueryGenerator qg;
        final Object[] scenarios;
        final Object[] regions;
        final boolean isExtraRun;

        public FutureQueryTask(QueryGenerator queryGenerator, Object[] objectArray, List<String> list, boolean bl) {
            this.qg = queryGenerator;
            this.scenarios = objectArray;
            this.regions = list.toArray();
            this.isExtraRun = bl;
            this.context = new DbProcInterrupt();
            this.futureDelegate = new FutureTask<BaseTableModel>(this);
        }

        boolean isTaskAnExtraRun() {
            return this.isExtraRun;
        }

        String getQueryName() {
            return this.qg.toString();
        }

        @Override
        public boolean cancel(boolean bl) {
            if (bl) {
                this.context.interrupt();
            }
            return this.futureDelegate.cancel(bl);
        }

        @Override
        public BaseTableModel get() throws InterruptedException, ExecutionException {
            return this.futureDelegate.get();
        }

        @Override
        public BaseTableModel get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.futureDelegate.get(l, timeUnit);
        }

        @Override
        public boolean isCancelled() {
            return this.futureDelegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.futureDelegate.isDone();
        }

        @Override
        public void run() {
            this.futureDelegate.run();
        }

        @Override
        public BaseTableModel call() throws Exception {
            try {
                if (this.qg == null || !this.qg.isValid()) {
                    throw new Exception("Could not find a valid query to run.");
                }
                if (this.regions.length == 0) {
                    throw new Exception("No regions were set to query.");
                }
                BaseTableModel baseTableModel = this.qg.isGroup() ? new MultiTableModel(this.qg, this.scenarios, this.regions, this.context) : new ComboTableModel(this.qg, this.scenarios, this.regions, null, this.context);
                return baseTableModel;
            }
            finally {
                if (!this.isExtraRun) {
                    SwingUtilities.invokeLater(BatchWindow.this.increaseProgress);
                }
            }
        }
    }
}

