/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface;

import ModelInterface.AboutDialog;
import ModelInterface.BatchRunner;
import ModelInterface.ConfigurationEditor.configurationeditor.ConfigurationEditor;
import ModelInterface.ConfigurationEditor.utils.DOMUtils;
import ModelInterface.ConfigurationEditor.utils.FileUtils;
import ModelInterface.DMsource.DMViewer;
import ModelInterface.MenuAdder;
import ModelInterface.ModelGUI2.DbViewer;
import ModelInterface.ModelGUI2.InputViewer;
import ModelInterface.ModelGUI2.XMLFilter;
import ModelInterface.PPsource.PPViewer;
import ModelInterface.common.FileChooser;
import ModelInterface.common.FileChooserFactory;
import ModelInterface.common.RecentFilesList;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InterfaceMain
implements ActionListener {
    private static final long serialVersionUID = -9137748180688015902L;
    public static final int FILE_MENU_POS = 0;
    public static final int EDIT_MENU_POS = 1;
    public static final int HELP_MENU_POS = 100;
    public static final int FILE_NEW_MENUITEM_POS = 0;
    public static final int FILE_OPEN_SUBMENU_POS = 5;
    public static final int FILE_SAVE_MENUITEM_POS = 10;
    public static final int FILE_SAVEAS_MENUITEM_POS = 11;
    public static final int FILE_QUIT_MENUITEM_POS = 50;
    public static final int EDIT_COPY_MENUITEM_POS = 10;
    public static final int EDIT_PASTE_MENUITEM_POS = 11;
    public static final int EDIT_UNDO_MENUITEM_POS = 1;
    public static final int EDIT_REDO_MENUITEM_POS = 2;
    private static File propertiesFile = new File("model_interface.properties");
    private static String oldControl;
    private static InterfaceMain main;
    private JMenuItem newMenu;
    private JMenuItem saveMenu;
    private JMenuItem saveAsMenu;
    private JMenuItem quitMenu;
    private JMenuItem copyMenu;
    private JMenuItem pasteMenu;
    private JMenuItem undoMenu;
    private JMenuItem redoMenu;
    private JMenuItem batchMenu;
    private Properties savedProperties = new Properties();
    private UndoManager undoManager;
    private List<MenuAdder> menuAdders;
    private JFrame mainFrame = null;

    public static void main(String[] stringArray) {
        Object object;
        String string;
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                if (InterfaceMain.getInstance() != null) {
                    InterfaceMain.getInstance().showMessageDialog(throwable, "Unexpected Error", 0);
                }
                throwable.printStackTrace();
            }
        });
        OptionParser optionParser = new OptionParser();
        optionParser.accepts("help", "print usage information").forHelp();
        optionParser.accepts("b", "XML batch file to process").withRequiredArg();
        optionParser.accepts("l", "log file into which to redirect ModelInterface output").withRequiredArg();
        OptionSet optionSet = null;
        try {
            optionSet = optionParser.parse(stringArray);
        }
        catch (OptionException optionException) {
            System.err.println((Object)optionException);
            System.exit(1);
        }
        if (optionSet.has("help")) {
            try {
                System.out.println("Usage: java -jar ModelInterface.jar -b <batch file> -l <log file>");
                optionParser.printHelpOn((OutputStream)System.out);
            }
            catch (Exception exception) {
                System.err.println("Failed to write usage message");
                System.exit(1);
            }
            System.exit(1);
        }
        PrintStream printStream = System.out;
        if (optionSet.has("l")) {
            string = (String)optionSet.valueOf("l");
            printStream.println("InterfaceMain: Directing stdout to " + string);
            try {
                object = new FileOutputStream(string);
                System.setOut(new PrintStream((OutputStream)object));
            }
            catch (Exception exception) {
                System.err.println("Failed to open log file '" + string + "' for writing: " + exception);
            }
        }
        if (optionSet.has("b")) {
            string = (String)optionSet.valueOf("b");
            System.out.println("InterfaceMain: batchFile: " + string);
            System.setProperty("java.awt.headless", "true");
            System.out.println("Running headless? " + GraphicsEnvironment.isHeadless());
            object = string.equals("-") ? DOMUtils.parseInputStream(System.in) : FileUtils.loadDocument(new File(string), null);
            main = new InterfaceMain();
            DbViewer dbViewer = new DbViewer();
            InputViewer inputViewer = new InputViewer();
            InterfaceMain.main.menuAdders = new ArrayList<MenuAdder>(2);
            InterfaceMain.main.menuAdders.add(dbViewer);
            InterfaceMain.main.menuAdders.add(inputViewer);
            if (object != null) {
                main.runBatch(object.getDocumentElement());
            } else {
                System.out.println("Skipping batch " + string + " due to parsing errors.");
            }
            System.setOut(printStream);
            return;
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            System.out.println("Error setting look and feel: " + exception);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InterfaceMain.createAndShowGUI();
            }
        });
    }

    private static void createAndShowGUI() {
        main = null;
        main = new InterfaceMain();
        InterfaceMain.main.mainFrame = new JFrame("Model Interface");
        if (Boolean.parseBoolean(InterfaceMain.main.savedProperties.getProperty("isMaximized", "false"))) {
            InterfaceMain.main.mainFrame.setExtendedState(6);
        }
        String string = InterfaceMain.main.savedProperties.getProperty("lastHeight", "600");
        String string2 = InterfaceMain.main.savedProperties.getProperty("lastWidth", "800");
        InterfaceMain.main.mainFrame.setSize(Integer.parseInt(string2), Integer.parseInt(string));
        InterfaceMain.main.mainFrame.setLayout(new BorderLayout());
        main.initialize();
        InterfaceMain.main.mainFrame.setVisible(true);
    }

    private InterfaceMain() {
        if (propertiesFile.exists()) {
            try {
                this.savedProperties.loadFromXML(new FileInputStream(propertiesFile));
                String string = this.savedProperties.getProperty("pretty-print", null);
                if (System.getProperty("ModelInterface.pretty-print", null) == null && string != null) {
                    System.getProperties().setProperty("ModelInterface.pretty-print", string);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        oldControl = "ModelInterface";
    }

    private void initialize() {
        MenuManager menuManager = new MenuManager(null);
        this.addWindowAdapters();
        this.addMenuItems(menuManager);
        this.addMenuAdderMenuItems(menuManager);
        this.finalizeMenu(menuManager);
    }

    public JFrame getFrame() {
        return this.mainFrame;
    }

    private void addMenuItems(MenuManager menuManager) {
        JMenu jMenu = new JMenu("File");
        menuManager.addMenuItem(jMenu, 0);
        JMenu jMenu2 = new JMenu("Open");
        jMenu2.setMnemonic(83);
        menuManager.getSubMenuManager(0).addMenuItem(jMenu2, 5);
        menuManager.getSubMenuManager(0).addSeparator(7);
        this.newMenu = new JMenuItem("New");
        menuManager.getSubMenuManager(0).addMenuItem(this.newMenu, 0);
        menuManager.getSubMenuManager(0).addSeparator(0);
        this.newMenu.setEnabled(false);
        this.saveMenu = new JMenuItem("Save");
        menuManager.getSubMenuManager(0).addMenuItem(this.saveMenu, 10);
        this.saveMenu.setEnabled(false);
        this.saveAsMenu = new JMenuItem("Save As");
        menuManager.getSubMenuManager(0).addMenuItem(this.saveAsMenu, 11);
        menuManager.getSubMenuManager(0).addSeparator(11);
        this.saveAsMenu.setEnabled(false);
        this.quitMenu = this.makeMenuItem("Quit");
        menuManager.getSubMenuManager(0).addMenuItem(this.quitMenu, 50);
        menuManager.addMenuItem(new JMenu("Edit"), 1);
        this.copyMenu = new JMenuItem("Copy");
        menuManager.getSubMenuManager(1).addMenuItem(this.copyMenu, 10);
        this.pasteMenu = new JMenuItem("Paste");
        menuManager.getSubMenuManager(1).addMenuItem(this.pasteMenu, 11);
        menuManager.getSubMenuManager(1).addSeparator(11);
        this.copyMenu.setEnabled(false);
        this.pasteMenu.setEnabled(false);
        this.batchMenu = new JMenuItem("Batch File");
        this.batchMenu.setEnabled(true);
        this.batchMenu.addActionListener(this);
        menuManager.getSubMenuManager(0).addMenuItem(this.batchMenu, 5);
        menuManager.addMenuItem(new JMenu("Help"), 100);
        this.setupUndo(menuManager);
    }

    private void addMenuAdderMenuItems(MenuManager menuManager) {
        DbViewer dbViewer = new DbViewer();
        dbViewer.addMenuItems(menuManager);
        InputViewer inputViewer = new InputViewer();
        inputViewer.addMenuItems(menuManager);
        PPViewer pPViewer = new PPViewer();
        pPViewer.addMenuItems(menuManager);
        DMViewer dMViewer = new DMViewer();
        dMViewer.addMenuItems(menuManager);
        RecentFilesList recentFilesList = RecentFilesList.getInstance();
        recentFilesList.addMenuItems(menuManager);
        AboutDialog aboutDialog = new AboutDialog();
        aboutDialog.addMenuItems(menuManager);
        ConfigurationEditor configurationEditor = new ConfigurationEditor();
        configurationEditor.addMenuItems(menuManager);
        this.menuAdders = new ArrayList<MenuAdder>(6);
        this.menuAdders.add(dbViewer);
        this.menuAdders.add(inputViewer);
        this.menuAdders.add(pPViewer);
        this.menuAdders.add(dMViewer);
        this.menuAdders.add(recentFilesList);
        this.menuAdders.add(aboutDialog);
        this.menuAdders.add(configurationEditor);
    }

    private void finalizeMenu(MenuManager menuManager) {
        JMenuBar jMenuBar = menuManager.createMenu();
        this.mainFrame.setJMenuBar(jMenuBar);
    }

    private void addWindowAdapters() {
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowStateChanged(WindowEvent windowEvent) {
                InterfaceMain.this.savedProperties.setProperty("isMaximized", String.valueOf((windowEvent.getNewState() & 6) != 0));
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.out.println("Caught the window closing");
                InterfaceMain.this.fireProperty("Control", oldControl, "ModelInterface");
                if (!Boolean.parseBoolean(InterfaceMain.this.savedProperties.getProperty("isMaximized"))) {
                    InterfaceMain.this.savedProperties.setProperty("lastWidth", String.valueOf(InterfaceMain.this.mainFrame.getWidth()));
                    InterfaceMain.this.savedProperties.setProperty("lastHeight", String.valueOf(InterfaceMain.this.mainFrame.getHeight()));
                }
                try {
                    InterfaceMain.this.savedProperties.storeToXML(new FileOutputStream(propertiesFile), "TODO: add comments");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                System.exit(0);
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                System.out.println("Caught the window closed");
                InterfaceMain.this.fireProperty("Control", oldControl, "ModelInterface");
                if (!Boolean.parseBoolean(InterfaceMain.this.savedProperties.getProperty("isMaximized"))) {
                    InterfaceMain.this.savedProperties.setProperty("lastWidth", String.valueOf(InterfaceMain.this.mainFrame.getWidth()));
                    InterfaceMain.this.savedProperties.setProperty("lastHeight", String.valueOf(InterfaceMain.this.mainFrame.getHeight()));
                }
                try {
                    InterfaceMain.this.savedProperties.storeToXML(new FileOutputStream(propertiesFile), "TODO: add comments");
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                System.exit(0);
            }
        };
        this.mainFrame.addWindowListener(windowAdapter);
        this.mainFrame.addWindowStateListener(windowAdapter);
        this.mainFrame.getGlassPane().addMouseListener(new MouseAdapter(){});
        this.mainFrame.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
    }

    private JMenuItem makeMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(this);
        return jMenuItem;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Quit")) {
            this.mainFrame.dispose();
        } else if (actionEvent.getActionCommand().equals("Batch File")) {
            FileChooser fileChooser = FileChooserFactory.getFileChooser();
            final File[] fileArray = fileChooser.doFilePrompt(this.mainFrame, "Open Batch File", 0, new File(this.getProperties().getProperty("lastDirectory", ".")), new XMLFilter());
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (fileArray != null) {
                        for (File file : fileArray) {
                            Document document = FileUtils.loadDocument(file, null);
                            if (document == null) continue;
                            InterfaceMain.this.runBatch(document.getDocumentElement());
                        }
                    }
                }
            }).start();
        }
    }

    public static InterfaceMain getInstance() {
        return main;
    }

    public JMenuItem getNewMenu() {
        return this.newMenu;
    }

    public JMenuItem getSaveMenu() {
        return this.saveMenu;
    }

    public JMenuItem getSaveAsMenu() {
        return this.saveAsMenu;
    }

    public JMenuItem getQuitMenu() {
        return this.quitMenu;
    }

    public JMenuItem getCopyMenu() {
        return this.copyMenu;
    }

    public JMenuItem getPasteMenu() {
        return this.pasteMenu;
    }

    public JMenuItem getUndoMenu() {
        return this.undoMenu;
    }

    public JMenuItem getRedoMenu() {
        return this.redoMenu;
    }

    public JMenuItem getBatchMenu() {
        return this.batchMenu;
    }

    public void fireControlChange(String string) {
        System.out.println("Going to change controls");
        if (string.equals(oldControl)) {
            oldControl = oldControl + "Same";
        }
        this.fireProperty("Control", oldControl, string);
        oldControl = string;
    }

    public void fireProperty(String string, Object object, Object object2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
        for (PropertyChangeListener propertyChangeListener : this.mainFrame.getPropertyChangeListeners()) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public Properties getProperties() {
        return this.savedProperties;
    }

    private void setupUndo(MenuManager menuManager) {
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(10);
        this.undoMenu = new JMenuItem("Undo");
        menuManager.getSubMenuManager(1).addMenuItem(this.undoMenu, 1);
        this.redoMenu = new JMenuItem("Redo");
        menuManager.getSubMenuManager(1).addMenuItem(this.redoMenu, 2);
        menuManager.getSubMenuManager(1).addSeparator(2);
        this.undoMenu.setEnabled(false);
        this.redoMenu.setEnabled(false);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.startsWith("Undo")) {
                    try {
                        InterfaceMain.this.undoManager.undo();
                        InterfaceMain.this.refreshUndoRedo();
                    }
                    catch (CannotUndoException cannotUndoException) {
                        cannotUndoException.printStackTrace();
                    }
                } else if (string.startsWith("Redo")) {
                    try {
                        InterfaceMain.this.undoManager.redo();
                        InterfaceMain.this.refreshUndoRedo();
                    }
                    catch (CannotRedoException cannotRedoException) {
                        cannotRedoException.printStackTrace();
                    }
                } else {
                    System.out.println("Didn't recognize: " + string);
                }
            }
        };
        this.undoMenu.addActionListener(actionListener);
        this.redoMenu.addActionListener(actionListener);
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void refreshUndoRedo() {
        this.undoMenu.setText(this.undoManager.getUndoPresentationName());
        this.undoMenu.setEnabled(this.undoManager.canUndo());
        this.redoMenu.setText(this.undoManager.getRedoPresentationName());
        this.redoMenu.setEnabled(this.undoManager.canRedo());
    }

    public MenuAdder getMenuAdder(String string) {
        for (MenuAdder menuAdder : this.menuAdders) {
            if (!menuAdder.getClass().getName().equals(string)) continue;
            return menuAdder;
        }
        return null;
    }

    private void runBatch(Node node) {
        if (node.getNodeName().equals("queries")) {
            System.out.println("Batch queries are not yet merged with this functionality.");
            System.out.println("Please open a database then run the batch file.");
            return;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).getNodeName().equals("class")) continue;
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("name");
            MenuAdder menuAdder = this.getMenuAdder(string);
            if (menuAdder != null && menuAdder instanceof BatchRunner) {
                ((BatchRunner)((Object)menuAdder)).runBatch(element);
                continue;
            }
            this.showMessageDialog("Could not find batch runner for class " + string, "Batch File Error", 0);
        }
        this.showMessageDialog("Finished running batch file", "Batch File Complete", 1);
    }

    private static String convertMessageTypeToString(int n) {
        switch (n) {
            case 0: {
                return "ERROR";
            }
            case 1: {
                return "INFO";
            }
            case -1: {
                return "PLAIN";
            }
            case 3: {
                return "QUESTION";
            }
            case 2: {
                return "WARNING";
            }
        }
        return "UNKNOWN";
    }

    public void showMessageDialog(Object object, String string, int n) {
        if (GraphicsEnvironment.isHeadless()) {
            System.out.print(InterfaceMain.convertMessageTypeToString(n));
            System.out.print("; ");
            System.out.println(object);
        } else {
            JOptionPane.showMessageDialog(this.mainFrame, object, string, n);
        }
    }

    private static String convertOptionTypeToString(int n) {
        switch (n) {
            case 2: {
                return "CANCEL";
            }
            case -1: {
                return "CLOSED";
            }
            case 1: {
                return "NO";
            }
            case 0: {
                return "YES";
            }
        }
        return "UNKNOWN";
    }

    public int showConfirmDialog(Object object, String string, int n, int n2, int n3) {
        if (GraphicsEnvironment.isHeadless()) {
            System.out.print("YES/NO/CANCEL");
            System.out.print("; ");
            System.out.print(object);
            System.out.print("; ");
            System.out.println(InterfaceMain.convertOptionTypeToString(n3));
            return n3;
        }
        return JOptionPane.showConfirmDialog(this.mainFrame, object, string, n, n2);
    }

    public class MenuManager {
        private JMenuItem menuValue;
        private Map<Integer, MenuManager> subItems;
        private SortedSet<Integer> sepList;

        MenuManager(JMenuItem jMenuItem) {
            this.menuValue = jMenuItem;
            this.sepList = null;
            this.subItems = jMenuItem == null || jMenuItem instanceof JMenu ? new TreeMap<Integer, MenuManager>() : null;
        }

        public void addSeparator(int n) {
            if (this.sepList == null) {
                this.sepList = new TreeSet<Integer>();
            }
            this.sepList.add(n);
        }

        public int addMenuItem(JMenuItem jMenuItem, int n) {
            if (this.subItems.containsKey(n)) {
                return this.addMenuItem(jMenuItem, n + 1);
            }
            this.subItems.put(n, new MenuManager(jMenuItem));
            return n;
        }

        public MenuManager getSubMenuManager(int n) {
            if (!this.subItems.containsKey(n)) {
                return null;
            }
            return this.subItems.get(n);
        }

        JMenuBar createMenu() {
            JMenuBar jMenuBar = new JMenuBar();
            Object[] objectArray = this.subItems.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                jMenuBar.add(this.subItems.get(objectArray[i]).createSubMenu());
            }
            return jMenuBar;
        }

        private JMenuItem createSubMenu() {
            if (this.subItems == null) {
                return this.menuValue;
            }
            Object[] objectArray = this.subItems.keySet().toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                if (this.sepList != null && !this.sepList.isEmpty() && (Integer)objectArray[i] > this.sepList.first()) {
                    ((JMenu)this.menuValue).addSeparator();
                    this.sepList.remove(this.sepList.first());
                }
                this.menuValue.add(this.subItems.get(objectArray[i]).createSubMenu());
            }
            return this.menuValue;
        }
    }
}

