/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.utils;

import ModelInterface.ConfigurationEditor.utils.FileUtils;
import ModelInterface.ConfigurationEditor.utils.Messages;
import ModelInterface.InterfaceMain;
import java.awt.Container;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public final class DOMUtils {
    private DOMUtils() {
    }

    public static int getNumberOfElementChildren(Node node) {
        if (node == null) {
            Logger.global.log(Level.WARNING, "Cannot count the number of children of a null element.");
            return 0;
        }
        int n = 0;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            ++n;
        }
        return n;
    }

    public static Node addNodesForXPath(Document document, String string) {
        if (document == null) {
            Logger.global.log(Level.WARNING, "Cannot add nodes for a null document.");
            return null;
        }
        String[] stringArray = string.split("/+");
        XPathFactory xPathFactory = XPathFactory.newInstance();
        Node node = null;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            Node node2;
            stringBuilder.append("/").append(stringArray[i]);
            NodeList nodeList = DOMUtils.executeQuery(document, stringBuilder.toString(), xPathFactory);
            Node node3 = nodeList.item(0);
            if (node3 == null) {
                node2 = DOMUtils.constructNode(document, stringArray[i]);
                if (node2 == null) break;
                if (node == null) {
                    document.appendChild(node2);
                } else {
                    node.appendChild(node2);
                }
                node = node2;
                continue;
            }
            node2 = nodeList.item(1);
            if (node2 == null) {
                node = node3;
                continue;
            }
            Logger.global.log(Level.WARNING, "Cannot add nodes for XPath with multiple results.");
            break;
        }
        NodeList nodeList = DOMUtils.executeQuery(document, string, xPathFactory);
        return nodeList.item(0);
    }

    private static NodeList executeQuery(Document document, String string, XPathFactory xPathFactory) {
        try {
            return (NodeList)xPathFactory.newXPath().evaluate(string, document.getDocumentElement(), XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
            return null;
        }
    }

    static Node constructNode(Document document, String string) {
        String[] stringArray = string.split("\\[");
        Element element = document.createElement(stringArray[0]);
        if (stringArray.length > 1) {
            int n;
            int n2 = stringArray[1].indexOf(64);
            int n3 = stringArray[1].indexOf(61);
            String string2 = stringArray[1].substring(n2 + 1, n3);
            int n4 = stringArray[1].indexOf(61);
            String string3 = stringArray[1].substring(n4 + 2, (n = stringArray[1].indexOf(93)) - 1);
            if (string3.equals("null")) {
                Logger.global.log(Level.WARNING, Messages.getString("FileUtils.31"));
                return null;
            }
            Attr attr = document.createAttribute(string2);
            attr.setNodeValue(string3);
            element.getAttributes().setNamedItem(attr);
        }
        return element;
    }

    public static boolean serialize(Document document, Container container) {
        if (document == null) {
            Logger.global.log(Level.WARNING, "Cannot serialize a null document.");
            return false;
        }
        DOMImplementation dOMImplementation = document.getImplementation();
        DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)dOMImplementation.getFeature("LS", "3.0");
        LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
        if (lSSerializer.getDomConfig().canSetParameter("format-pretty-print", "true")) {
            lSSerializer.getDomConfig().setParameter("format-pretty-print", "true");
        } else {
            Logger.global.log(Level.INFO, "DOM serializer does not support pretty-print");
        }
        if (!document.getDocumentElement().getAttribute("needs-save").equals("true")) {
            System.out.println("Saving an unmodified document. needs-save: " + document.getDocumentElement().getAttribute("needs-save"));
        }
        document.getDocumentElement().removeAttribute("needs-save");
        String string = lSSerializer.writeToString(document);
        try {
            File file = FileUtils.getDocumentFile(document);
            assert (file != null);
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string);
            fileWriter.close();
        }
        catch (IOException iOException) {
            Logger.global.throwing("DOMUtils", "serialize", iOException);
            String string2 = Messages.getString("DOMUtils.22") + iOException.getMessage() + ".";
            String string3 = Messages.getString("DOMUtils.24");
            JOptionPane.showMessageDialog(container, string2, string3, 0);
            return false;
        }
        document.getDocumentElement().setAttribute("document-saved", "true");
        return true;
    }

    public static Node getResultNodeFromQuery(Document document, String string) {
        if (document == null) {
            return null;
        }
        assert (string != null);
        XPathFactory xPathFactory = XPathFactory.newInstance();
        NodeList nodeList = DOMUtils.executeQuery(document, string, xPathFactory);
        Node node = null;
        int n = 0;
        while (true) {
            Node node2;
            if ((node2 = nodeList.item(n++)) != null && node != null) {
                Logger.global.log(Level.INFO, Messages.getString("DOMUtils.10") + string);
            }
            if (node2 == null) break;
            node = node2;
        }
        return node;
    }

    public static String getNameAttrValue(Node node) {
        if (node == null) {
            return null;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        Node node2 = namedNodeMap.getNamedItem("name");
        if (node2 == null) {
            return null;
        }
        return node2.getNodeValue();
    }

    public static void setNameAttrValue(Node node, String string) {
        Attr attr = node.getOwnerDocument().createAttribute("name");
        attr.setNodeValue(string);
        node.getAttributes().setNamedItem(attr);
    }

    public static int getDOMIndexOfObject(Node node, Object object) {
        if (node == null) {
            Logger.global.log(Level.WARNING, "Cannot get the DOM index because parent node is null.");
            return -1;
        }
        if (!(object instanceof Node)) {
            Logger.global.log(Level.WARNING, Messages.getString("DOMListModel.22"));
            return -1;
        }
        String string = DOMUtils.getNameAttrValue((Node)object);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string2 = DOMUtils.getNameAttrValue(nodeList.item(i));
            if (string2 == null || !string2.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static int getDOMIndexForListIndex(Node node, int n) {
        if (node == null) {
            Logger.global.log(Level.WARNING, "Cannot convert list index to DOM index because the parent node is null.");
            return -1;
        }
        if (n < 0) {
            Logger.global.log(Level.WARNING, "Illegal negative list index passed as argument to DOM index conversion.");
            return -1;
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            int n2 = -1;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() == 1) {
                    ++n2;
                }
                if (n2 != n) continue;
                return i;
            }
        }
        return -1;
    }

    public static Element createElement(Node node, String string, Object object, boolean bl) {
        if (node == null) {
            Logger.global.log(Level.WARNING, "Cannot create element because the parent is null.");
            return null;
        }
        if (object == null) {
            Logger.global.log(Level.WARNING, "Cannot create element because the object to wrap is null.");
            return null;
        }
        Element element = node.getOwnerDocument().createElement(string);
        element.setAttribute("name", object.toString());
        if (bl) {
            element.setTextContent(object.toString());
        }
        return element;
    }

    public static Node getItemBefore(Node node, Node node2) {
        int n = DOMUtils.getDOMIndexOfObject(node, node2);
        NodeList nodeList = node.getChildNodes();
        for (int i = n - 1; i >= 0; --i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            return nodeList.item(i);
        }
        return null;
    }

    public static Node getItemAfter(Node node, Node node2) {
        int n = DOMUtils.getDOMIndexOfObject(node, node2);
        NodeList nodeList = node.getChildNodes();
        for (int i = n + 1; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            return nodeList.item(i);
        }
        return null;
    }

    public static int getListIndexOfObject(Node node, Object object) {
        if (node == null) {
            Logger.global.log(Level.WARNING, Messages.getString("DOMListModel.23"));
            return 0;
        }
        if (!(object instanceof Node)) {
            Logger.global.log(Level.WARNING, Messages.getString("DOMListModel.24"));
        }
        String string = DOMUtils.getNameAttrValue((Node)object);
        NodeList nodeList = node.getChildNodes();
        int n = -1;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            ++n;
            String string2 = DOMUtils.getNameAttrValue(nodeList.item(i));
            if (string2 == null || !string2.equals(string)) continue;
            return n;
        }
        return -1;
    }

    public static boolean isTextContentTrue(Node node) {
        if (node.getTextContent() == null) {
            Logger.global.log(Level.WARNING, "No text content for node.");
            return false;
        }
        if (node.getTextContent().equals("1")) {
            return true;
        }
        if (node.getTextContent().equals("0")) {
            return false;
        }
        Logger.global.log(Level.WARNING, "Unknown text value contained in node.");
        return false;
    }

    public static Document parseInputStream(InputStream inputStream) {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = documentBuilder.parse(inputStream);
            return document;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            InterfaceMain.getInstance().showMessageDialog(exception.getMessage(), "Could not parse input stream", 0);
        }
        finally {
            return document;
        }
    }
}

