/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.guicomponents;

import ModelInterface.ConfigurationEditor.guihelpers.XMLFileFilter;
import ModelInterface.ConfigurationEditor.utils.ExeFileFilter;
import ModelInterface.ConfigurationEditor.utils.FileUtils;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class PropertiesTextField
extends JPanel {
    private static final long serialVersionUID = 723135424936504399L;
    private final transient String mLabelText;
    private final transient String mPropertyID;
    private final transient Properties mProperties;
    private final transient String mFileType;

    public PropertiesTextField(String string, String string2, Properties properties, String string3) {
        this.mLabelText = string;
        this.mPropertyID = string2;
        this.mProperties = properties;
        this.mFileType = string3;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this, 0));
        JLabel jLabel = new JLabel(this.mLabelText + ":", 4);
        jLabel.setPreferredSize(new Dimension(150, 20));
        this.add(jLabel);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        final JTextField jTextField = new JTextField();
        assert (this.mProperties != null);
        assert (this.mPropertyID != null && this.mPropertyID.length() > 0);
        jTextField.setText(this.mProperties.getProperty(this.mPropertyID));
        jTextField.setPreferredSize(new Dimension(400, 20));
        jTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                PropertiesTextField.this.mProperties.setProperty(PropertiesTextField.this.mPropertyID, jTextField.getText());
            }
        });
        this.add(jTextField);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        if (this.mFileType != null) {
            JButton jButton = new JButton();
            jButton.setText("Select...");
            jButton.setToolTipText("Select the value for the property.");
            final PropertiesTextField propertiesTextField = this;
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FileFilter fileFilter = null;
                    if (PropertiesTextField.this.mFileType.equals("exe")) {
                        fileFilter = new ExeFileFilter();
                    } else if (PropertiesTextField.this.mFileType.equals("xml")) {
                        fileFilter = new XMLFileFilter();
                    } else {
                        Logger.global.log(Level.SEVERE, "Unknown filter type.");
                    }
                    File file = FileUtils.selectFile(propertiesTextField, fileFilter, jTextField.getText(), false);
                    if (file != null) {
                        String string = file.getAbsolutePath();
                        jTextField.setText(string);
                        PropertiesTextField.this.mProperties.setProperty(PropertiesTextField.this.mPropertyID, string);
                    }
                }
            });
            this.add(jButton);
        }
    }
}

