/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.configurationeditor;

import ModelInterface.ConfigurationEditor.actions.RunAction;
import ModelInterface.ConfigurationEditor.configurationeditor.ConfigurationEditor;
import ModelInterface.ConfigurationEditor.utils.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ModelRunner
implements Runnable {
    private final transient File mExecutableFile;
    private final transient File mTempConfLocation;
    private final transient ConfigurationEditor mParentEditor;
    private final transient RunAction mSourceAction;
    private transient boolean mModelRunning = false;

    public ModelRunner(File file, File file2, ConfigurationEditor configurationEditor, RunAction runAction) {
        this.mExecutableFile = file;
        this.mTempConfLocation = file2;
        this.mParentEditor = configurationEditor;
        this.mSourceAction = runAction;
    }

    @Override
    public synchronized void run() {
        this.mSourceAction.setModelRunning(true);
        String string = this.mExecutableFile.getParent();
        Logger.global.log(Level.INFO, Messages.getString("RunAction.12") + this.mExecutableFile.getAbsolutePath() + " -C" + this.mTempConfLocation.getAbsolutePath() + Messages.getString("ModelRunner.0") + string);
        ProcessBuilder processBuilder = new ProcessBuilder(this.mExecutableFile.getAbsolutePath(), "-C" + this.mTempConfLocation.getAbsolutePath());
        processBuilder.directory(new File(string));
        try {
            Process process = processBuilder.start();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream());
            BufferedInputStream bufferedInputStream2 = new BufferedInputStream(process.getErrorStream());
            this.mModelRunning = true;
            OutputWatcher outputWatcher = new OutputWatcher(process, bufferedInputStream, bufferedInputStream2);
            outputWatcher.start();
            process.waitFor();
            int n = process.exitValue();
            process.destroy();
            Logger.global.log(Level.INFO, Messages.getString("ModelRunner.3") + n + ".");
            this.mModelRunning = false;
        }
        catch (IOException iOException) {
            String string2 = Messages.getString("RunAction.15");
            String string3 = Messages.getString("RunAction.16") + iOException.getMessage() + ".";
            JOptionPane.showMessageDialog(this.mParentEditor, string3, string2, 0);
        }
        catch (InterruptedException interruptedException) {
            Logger.global.log(Level.WARNING, Messages.getString("ModelRunner.5") + interruptedException.getMessage());
        }
        this.mSourceAction.setModelRunning(false);
    }

    private final class OutputWindowCloseListener
    implements WindowListener,
    ActionListener {
        private final transient Process mProcess;
        private final transient Component mComponent;

        public OutputWindowCloseListener(Process process, Component component) {
            this.mProcess = process;
            this.mComponent = component;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.endProcessAndClose();
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.endProcessAndClose();
        }

        private void endProcessAndClose() {
            Logger.global.log(Level.INFO, "Output window closed, attempting to stop the model.");
            ModelRunner.this.mModelRunning = false;
            this.mProcess.destroy();
            this.mComponent.setVisible(false);
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }
    }

    private final class OutputWatcher
    extends Thread {
        private final transient Process mProcess;
        private final transient InputStream mModelOutput;
        private final transient InputStream mModelError;

        public OutputWatcher(Process process, InputStream inputStream, InputStream inputStream2) {
            this.mProcess = process;
            this.mModelOutput = inputStream;
            this.mModelError = inputStream2;
        }

        @Override
        public void run() {
            JDialog jDialog = this.createOutputDialog();
            jDialog.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            JTextArea jTextArea = this.createOutputArea();
            JScrollPane jScrollPane = this.createOutputScrollPane(jTextArea);
            jDialog.add((Component)jScrollPane, gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.gridx = -1;
            jDialog.add((Component)this.createTerminateButton(), gridBagConstraints2);
            jDialog.add((Component)this.createSaveButton(jTextArea), gridBagConstraints2);
            gridBagConstraints2.fill = 2;
            jDialog.add((Component)this.createCloseButton(jDialog), gridBagConstraints2);
            jDialog.pack();
            jDialog.setVisible(true);
            this.setPriority(1);
            byte[] byArray = new byte[100];
            while (ModelRunner.this.mModelRunning) {
                try {
                    OutputWatcher.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    Logger.global.throwing("Interrupted Exception", "ModelRunner", interruptedException);
                    ModelRunner.this.mModelRunning = false;
                }
                try {
                    this.updateOutputWindow(jTextArea, jScrollPane, this.mModelOutput, byArray);
                    this.updateOutputWindow(jTextArea, jScrollPane, this.mModelError, byArray);
                }
                catch (IOException iOException) {
                    Logger.global.throwing("Interrupted Exception", "ModelRunner", iOException);
                    ModelRunner.this.mModelRunning = false;
                    this.mProcess.destroy();
                }
            }
            Logger.global.log(Level.INFO, "Output watching loop exited. Thread finished.");
        }

        private void updateOutputWindow(JTextArea jTextArea, JScrollPane jScrollPane, InputStream inputStream, byte[] byArray) throws IOException {
            int n;
            if (inputStream.available() > 0 && (n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                String string = new String(byArray, 0, n);
                SwingUtilities.invokeLater(new ScreenPrinter(jScrollPane, jTextArea, string));
            }
        }

        private JButton createTerminateButton() {
            JButton jButton = new JButton("Terminate");
            jButton.setToolTipText("Terminate the model run.");
            jButton.addActionListener(new TerminateButtonListener(jButton));
            return jButton;
        }

        private JButton createSaveButton(final JTextArea jTextArea) {
            JButton jButton = new JButton("Save output to clipboard");
            jButton.setToolTipText("Save output to the clipboard.");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    jTextArea.selectAll();
                    String string = jTextArea.getSelectedText();
                    StringSelection stringSelection = new StringSelection(string);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, stringSelection);
                }
            });
            return jButton;
        }

        private JButton createCloseButton(JDialog jDialog) {
            JButton jButton = new JButton("Close");
            jButton.setToolTipText("Terminate and close the output window.");
            jButton.addActionListener(new OutputWindowCloseListener(this.mProcess, jDialog));
            return jButton;
        }

        private JScrollPane createOutputScrollPane(JTextArea jTextArea) {
            JScrollPane jScrollPane = new JScrollPane(jTextArea, 20, 30);
            jScrollPane.setAutoscrolls(true);
            jScrollPane.addMouseMotionListener(new ScrollPaneScroller());
            return jScrollPane;
        }

        private JTextArea createOutputArea() {
            JTextArea jTextArea = new JTextArea();
            jTextArea.setEditable(false);
            return jTextArea;
        }

        private JDialog createOutputDialog() {
            JDialog jDialog = new JDialog(ModelRunner.this.mParentEditor, Messages.getString("ModelRunner.2"), false);
            jDialog.setLayout(new BoxLayout(jDialog.getContentPane(), 1));
            jDialog.setDefaultCloseOperation(0);
            jDialog.addWindowListener(new OutputWindowCloseListener(this.mProcess, jDialog));
            jDialog.setPreferredSize(new Dimension(400, 400));
            return jDialog;
        }

        private final class ScrollPaneScroller
        extends MouseMotionAdapter {
            private ScrollPaneScroller() {
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                Rectangle rectangle = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), 1, 1);
                ((JScrollPane)mouseEvent.getSource()).scrollRectToVisible(rectangle);
            }
        }

        private final class ScreenPrinter
        implements Runnable {
            private final transient JScrollPane mPane;
            private final transient JTextArea mArea;
            private final transient String mOutput;

            public ScreenPrinter(JScrollPane jScrollPane, JTextArea jTextArea, String string) {
                this.mPane = jScrollPane;
                this.mArea = jTextArea;
                this.mOutput = string;
            }

            @Override
            public synchronized void run() {
                this.mArea.append(this.mOutput);
                Rectangle rectangle = this.mArea.getBounds();
                Rectangle rectangle2 = this.mPane.getViewportBorderBounds();
                Rectangle rectangle3 = new Rectangle(rectangle.y + rectangle.height, rectangle2.x, 1, 1);
                this.mPane.scrollRectToVisible(rectangle3);
            }
        }

        private final class TerminateButtonListener
        implements ActionListener {
            private transient JButton mButton;

            public TerminateButtonListener(JButton jButton) {
                this.mButton = jButton;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Logger.global.log(Level.INFO, "Terminate button pressed, attempting to stop the model.");
                ModelRunner.this.mModelRunning = false;
                OutputWatcher.this.mProcess.destroy();
                this.mButton.setEnabled(false);
            }
        }
    }
}

