/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.configurationeditor;

import ModelInterface.ConfigurationEditor.configurationeditor.AbstractEditorPanel;
import ModelInterface.ConfigurationEditor.configurationeditor.BatchEditorCreator;
import ModelInterface.ConfigurationEditor.guicomponents.DOMButtonModel;
import ModelInterface.ConfigurationEditor.guicomponents.DOMTextFieldFactory;
import ModelInterface.ConfigurationEditor.guihelpers.FieldButtonEnabler;
import ModelInterface.ConfigurationEditor.guihelpers.XMLFileFilter;
import ModelInterface.ConfigurationEditor.utils.FileUtils;
import ModelInterface.ConfigurationEditor.utils.Messages;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BatchOptionsPanel
extends AbstractEditorPanel {
    private static final long serialVersionUID = -3437736790254135793L;

    public BatchOptionsPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.setToolTipText(Messages.getString("ConfigurationEditor.138"));
        final JLabel jLabel = new JLabel(Messages.getString("ConfigurationEditor.124"));
        final JTextField jTextField = this.createBatchFileField();
        final JButton jButton = this.createBatchFileEditButton(jTextField);
        jTextField.getDocument().addDocumentListener(new FieldButtonEnabler(jButton));
        final JButton jButton2 = this.createBatchFileSelectButton(jTextField);
        final JButton jButton3 = this.createBatchFileNewButton(jTextField);
        final JCheckBox jCheckBox = this.createBatchCheckBox();
        jCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = jCheckBox.isSelected();
                jLabel.setEnabled(bl);
                jTextField.setEnabled(bl);
                jButton2.setEnabled(bl);
                jButton3.setEnabled(bl);
                jButton.setEnabled(bl && jTextField.getText().length() > 0);
            }
        });
        this.add((Component)jCheckBox, null);
        this.add((Component)jLabel, null);
        this.add((Component)jTextField, null);
        this.add((Component)jButton2, null);
        this.add((Component)jButton, null);
        this.add((Component)jButton3, null);
    }

    private JTextField createBatchFileField() {
        DOMTextFieldFactory dOMTextFieldFactory = new DOMTextFieldFactory();
        this.addPropertyChangeListener("document-replaced", dOMTextFieldFactory);
        JTextField jTextField = dOMTextFieldFactory.createTextField("Files", "BatchFileName");
        jTextField.setPreferredSize(new Dimension(200, 20));
        jTextField.setToolTipText(Messages.getString("ConfigurationEditor.141"));
        return jTextField;
    }

    private JButton createBatchFileSelectButton(final JTextField jTextField) {
        JButton jButton = new JButton(Messages.getString("ConfigurationEditor.142"));
        jButton.setToolTipText(Messages.getString("ConfigurationEditor.143"));
        jButton.setMnemonic(83);
        final Container container = this.getTopLevelAncestor();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = FileUtils.selectFile(container, new XMLFileFilter(), jTextField.getText(), false);
                if (file != null) {
                    jTextField.setText(file.getAbsolutePath());
                }
            }
        });
        return jButton;
    }

    private JButton createBatchFileNewButton(final JTextField jTextField) {
        JButton jButton = new JButton(Messages.getString("ConfigurationEditor.145"));
        jButton.setToolTipText(Messages.getString("ConfigurationEditor.146"));
        jButton.setMnemonic(78);
        final Container container = this.getTopLevelAncestor();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = FileUtils.selectFile(container, new XMLFileFilter(), jTextField.getText(), true);
                if (file != null) {
                    jTextField.setText(file.getAbsolutePath());
                    SwingUtilities.invokeLater(new BatchEditorCreator(file, true));
                }
            }
        });
        return jButton;
    }

    private JButton createBatchFileEditButton(final JTextField jTextField) {
        JButton jButton = new JButton(Messages.getString("ConfigurationEditor.149"));
        jButton.setToolTipText(Messages.getString("ConfigurationEditor.150"));
        jButton.setMnemonic(69);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(jTextField.getText());
                SwingUtilities.invokeLater(new BatchEditorCreator(file, false));
            }
        });
        return jButton;
    }

    private JCheckBox createBatchCheckBox() {
        JCheckBox jCheckBox = new JCheckBox(Messages.getString("ConfigurationEditor.16"));
        DOMButtonModel dOMButtonModel = new DOMButtonModel(null, "/Configuration/Bools", "Value", "BatchMode", false);
        jCheckBox.setModel(dOMButtonModel);
        this.addPropertyChangeListener("document-replaced", dOMButtonModel);
        jCheckBox.setMnemonic(66);
        jCheckBox.setToolTipText(Messages.getString("ConfigurationEditor.17"));
        return jCheckBox;
    }
}

