/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.actions;

import ModelInterface.ConfigurationEditor.guicomponents.PropertiesTextField;
import ModelInterface.ConfigurationEditor.utils.FileUtils;
import ModelInterface.ConfigurationEditor.utils.Messages;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ShowPreferencesAction
extends AbstractAction {
    private static final long serialVersionUID = -5299525135551340917L;
    private final transient Frame mParentFrame;

    public ShowPreferencesAction(Frame frame) {
        super("Show Preferences...");
        this.mParentFrame = frame;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JDialog jDialog = this.createPreferencesDialog();
        jDialog.pack();
        jDialog.setVisible(true);
    }

    private JDialog createPreferencesDialog() {
        JDialog jDialog = new JDialog(this.mParentFrame, Messages.getString("ShowPreferencesAction.3"), true);
        jDialog.setContentPane(this.createPreferencesDialogFrame(jDialog));
        return jDialog;
    }

    private JPanel createPreferencesDialogFrame(final JDialog jDialog) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        Properties properties = FileUtils.getInitializedProperties(jPanel);
        PropertiesTextField propertiesTextField = new PropertiesTextField("Executable File", "executable-path", properties, "exe");
        jPanel.add((Component)propertiesTextField, gridBagConstraints);
        PropertiesTextField propertiesTextField2 = new PropertiesTextField("Configuration Template", "template-path", properties, "xml");
        jPanel.add((Component)propertiesTextField2, gridBagConstraints);
        PropertiesTextField propertiesTextField3 = new PropertiesTextField("Log File Location", "log-conf-path", properties, "xml");
        jPanel.add((Component)propertiesTextField3, gridBagConstraints);
        JButton jButton = new JButton(Messages.getString("ShowPreferencesAction.19"));
        jButton.setToolTipText(Messages.getString("ShowPreferencesAction.10"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 18;
        jPanel.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton();
        jButton2.setText(Messages.getString("ShowPreferencesAction.18"));
        jButton2.setToolTipText(Messages.getString("ShowPreferencesAction.13"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        gridBagConstraints.gridx = -1;
        jPanel.add((Component)jButton2, gridBagConstraints);
        return jPanel;
    }
}

