/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.actions;

import ModelInterface.ConfigurationEditor.configurationeditor.ConfigurationEditor;
import ModelInterface.ConfigurationEditor.configurationeditor.ModelRunner;
import ModelInterface.ConfigurationEditor.utils.DOMUtils;
import ModelInterface.ConfigurationEditor.utils.FileUtils;
import ModelInterface.ConfigurationEditor.utils.Messages;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RunAction
extends AbstractAction {
    private static final long serialVersionUID = -3368634278919104142L;
    private static final String mTempConfFile = "configuration_temp.xml";
    private final transient ConfigurationEditor mParentEditor;
    private transient boolean mModelRunning = false;

    public RunAction(ConfigurationEditor configurationEditor) {
        super("Run");
        this.mParentEditor = configurationEditor;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isModelRunning()) {
            String string = Messages.getString("RunAction.7");
            String string2 = Messages.getString("RunAction.6");
            JOptionPane.showMessageDialog(this.mParentEditor, string, string2, 0);
            return;
        }
        Properties properties = FileUtils.getInitializedProperties(this.mParentEditor);
        String string = properties.getProperty("executable-path");
        if (string == null) {
            String string3 = Messages.getString("RunAction.8");
            String string4 = Messages.getString("RunAction.9");
            JOptionPane.showMessageDialog(this.mParentEditor, string3, string4, 0);
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            String string5 = Messages.getString("RunAction.10");
            String string6 = Messages.getString("RunAction.11");
            JOptionPane.showMessageDialog(this.mParentEditor, string5, string6, 0);
            return;
        }
        assert (this.mParentEditor.getDocument() != null);
        DOMImplementation dOMImplementation = null;
        try {
            dOMImplementation = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Logger.global.log(Level.SEVERE, "Failed to create DOM implementation necessary to create the document.");
            return;
        }
        Document document = dOMImplementation.createDocument(null, null, null);
        Node node = this.mParentEditor.getDocument().getDocumentElement().cloneNode(true);
        document.adoptNode(node);
        document.appendChild(node);
        File file2 = new File(mTempConfFile);
        FileUtils.setDocumentFile(document, file2);
        DOMUtils.serialize(document, this.mParentEditor);
        Thread thread = new Thread(new ModelRunner(file, file2, this.mParentEditor, this));
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isModelRunning() {
        RunAction runAction = this;
        synchronized (runAction) {
            return this.mModelRunning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModelRunning(boolean bl) {
        Logger.global.log(Level.INFO, "Setting model running to:" + bl);
        RunAction runAction = this;
        synchronized (runAction) {
            this.mModelRunning = bl;
        }
    }
}

