import * as cdk from '@aws-cdk/core';
/**
 * Manages a User within Azure Active Directory.
 *
 * -> **NOTE:** If you're authenticating using a Service Principal then it must have permissions to `Directory.ReadWrite.All` within the `Windows Azure Active Directory` API.
 *
 * @schema CfnUserProps
 */
export interface CfnUserProps {
    /**
     * `true` if the account should be enabled, otherwise `false`.
     *
     * Defaults to `true`.
     *
     * @default true`.
     * @schema CfnUserProps#AccountEnabled
     */
    readonly accountEnabled?: boolean;
    /**
     * The city in which the user is located.
     *
     * @schema CfnUserProps#City
     */
    readonly city?: string;
    /**
     * The company name which the user is associated.
     *
     * This property can be useful for describing the company that an external user comes from.
     *
     * @schema CfnUserProps#CompanyName
     */
    readonly companyName?: string;
    /**
     * The country/region in which the user is located;
     *
     * for example, “US” or “UK”.
     *
     * @schema CfnUserProps#Country
     */
    readonly country?: string;
    /**
     * The name for the department in which the user works.
     *
     * @schema CfnUserProps#Department
     */
    readonly department?: string;
    /**
     * The name to display in the address book for the user.
     *
     * @schema CfnUserProps#DisplayName
     */
    readonly displayName: string;
    /**
     * `true` if the User is forced to change the password during the next sign-in.
     *
     * Defaults to `false`.
     *
     * @default false`.
     * @schema CfnUserProps#ForcePasswordChange
     */
    readonly forcePasswordChange?: boolean;
    /**
     * The given name (first name) of the user.
     *
     * @schema CfnUserProps#GivenName
     */
    readonly givenName?: string;
    /**
     * The value used to associate an on-premise Active Directory user account with their Azure AD user object.
     *
     * Deprecated in favour of `onpremises_immutable_id`.
     *
     * @schema CfnUserProps#ImmutableId
     */
    readonly immutableId?: string;
    /**
     * The user’s job title.
     *
     * @schema CfnUserProps#JobTitle
     */
    readonly jobTitle?: string;
    /**
     * The mail alias for the user.
     *
     * Defaults to the user name part of the User Principal Name.
     *
     * @default the user name part of the User Principal Name.
     * @schema CfnUserProps#MailNickname
     */
    readonly mailNickname?: string;
    /**
     * The primary cellular telephone number for the user.
     *
     * Deprecated in favour of `mobile_phone`.
     *
     * @schema CfnUserProps#Mobile
     */
    readonly mobile?: string;
    /**
     * The primary cellular telephone number for the user.
     *
     * @schema CfnUserProps#MobilePhone
     */
    readonly mobilePhone?: string;
    /**
     * The office location in the user's place of business.
     *
     * @schema CfnUserProps#OfficeLocation
     */
    readonly officeLocation?: string;
    /**
     * The value used to associate an on-premise Active Directory user account with their Azure AD user object.
     *
     * This must be specified if you are using a federated domain for the user's userPrincipalName (UPN) property when creating a new user account.
     *
     * @schema CfnUserProps#OnpremisesImmutableId
     */
    readonly onpremisesImmutableId?: string;
    /**
     * The password for the User.
     *
     * The password must satisfy minimum requirements as specified by the password policy. The maximum length is 256 characters.
     *
     * @schema CfnUserProps#Password
     */
    readonly password: string;
    /**
     * The office location in the user's place of business.
     *
     * Deprecated in favour of `office_location`.
     *
     * @schema CfnUserProps#PhysicalDeliveryOfficeName
     */
    readonly physicalDeliveryOfficeName?: string;
    /**
     * The postal code for the user's postal address.
     *
     * The postal code is specific to the user's country/region. In the United States of America, this attribute contains the ZIP code.
     *
     * @schema CfnUserProps#PostalCode
     */
    readonly postalCode?: string;
    /**
     * The state or province in the user's address.
     *
     * @schema CfnUserProps#State
     */
    readonly state?: string;
    /**
     * The street address of the user's place of business.
     *
     * @schema CfnUserProps#StreetAddress
     */
    readonly streetAddress?: string;
    /**
     * The user's surname (family name or last name).
     *
     * @schema CfnUserProps#Surname
     */
    readonly surname?: string;
    /**
     * The usage location of the User.
     *
     * Required for users that will be assigned licenses due to legal requirement to check for availability of services in countries. The usage location is a two letter country code (ISO standard 3166). Examples include: `NO`, `JP`, and `GB`. Cannot be reset to null once set.
     *
     * @schema CfnUserProps#UsageLocation
     */
    readonly usageLocation?: string;
    /**
     * The User Principal Name of the User.
     *
     * @schema CfnUserProps#UserPrincipalName
     */
    readonly userPrincipalName: string;
}
/**
 * Converts an object of type 'CfnUserProps' to JSON representation.
 */
export declare function toJson_CfnUserProps(obj: CfnUserProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `TF::AzureAD::User`.
 *
 * @external
 * @cloudformationResource TF::AzureAD::User
 * @link https://github.com/iann0036/cfn-tf-custom-types.git
 */
export declare class CfnUser extends cdk.CfnResource {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "TF::AzureAD::User";
    /**
     * Resource props.
     *
     * @external
     */
    readonly props: CfnUserProps;
    /**
     * Attribute `TF::AzureAD::User.tfcfnid`.
     *
     * @external
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrTfcfnid: string;
    /**
     * Attribute `TF::AzureAD::User.Id`.
     *
     * @external
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrId: string;
    /**
     * Attribute `TF::AzureAD::User.Mail`.
     *
     * @external
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrMail: string;
    /**
     * Attribute `TF::AzureAD::User.ObjectId`.
     *
     * @external
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrObjectId: string;
    /**
     * Attribute `TF::AzureAD::User.OnpremisesSamAccountName`.
     *
     * @external
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrOnpremisesSamAccountName: string;
    /**
     * Attribute `TF::AzureAD::User.OnpremisesUserPrincipalName`.
     *
     * @external
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrOnpremisesUserPrincipalName: string;
    /**
     * Attribute `TF::AzureAD::User.UserType`.
     *
     * @external
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrUserType: string;
    /**
     * Create a new `TF::AzureAD::User`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnUserProps);
}
