from collections import namedtuple, OrderedDict

Atom = namedtuple(
    'Atom', 'atomic_number symbol mass_number atomic_mass natural_abundance')

atoms = {"H": Atom(atomic_number=1, symbol='H', mass_number='1', atomic_mass=1.007825032239, natural_abundance=0.9998857),
         "D": Atom(atomic_number=1, symbol='D', mass_number='2', atomic_mass=2.0141017781212, natural_abundance=0.0001157),
         "T": Atom(atomic_number=1, symbol='T', mass_number='3', atomic_mass=3.016049277924, natural_abundance=None),
         "3He": Atom(atomic_number=2, symbol='He', mass_number='3', atomic_mass=3.016029320125, natural_abundance=1.343e-06),
         "He": Atom(atomic_number=2, symbol='He', mass_number='4', atomic_mass=4.002603254136, natural_abundance=0.999998663),
         "6Li": Atom(atomic_number=3, symbol='Li', mass_number='6', atomic_mass=6.015122887416, natural_abundance=0.07594),
         "7Li": Atom(atomic_number=3, symbol='Li', mass_number='7', atomic_mass=7.016003436645, natural_abundance=0.92414),
         "9Be": Atom(atomic_number=4, symbol='Be', mass_number='9', atomic_mass=9.01218306582, natural_abundance=1.0),
         "10B": Atom(atomic_number=5, symbol='B', mass_number='10', atomic_mass=10.0129369541, natural_abundance=0.1997),
         "11B": Atom(atomic_number=5, symbol='B', mass_number='11', atomic_mass=11.0093053645, natural_abundance=0.8017),
         "C": Atom(atomic_number=6, symbol='C', mass_number='12', atomic_mass=12.0, natural_abundance=0.98938),
         "13C": Atom(atomic_number=6, symbol='C', mass_number='13', atomic_mass=13.0033548350723, natural_abundance=0.01078),
         "14C": Atom(atomic_number=6, symbol='C', mass_number='14', atomic_mass=14.00324198844, natural_abundance=None),
         "N": Atom(atomic_number=7, symbol='N', mass_number='14', atomic_mass=14.003074004432, natural_abundance=0.996362),
         "15N": Atom(atomic_number=7, symbol='N', mass_number='15', atomic_mass=15.0001088988864, natural_abundance=0.003642),
         "O": Atom(atomic_number=8, symbol='O', mass_number='16', atomic_mass=15.9949146195717, natural_abundance=0.9975716),
         "17O": Atom(atomic_number=8, symbol='O', mass_number='17', atomic_mass=16.9991317565069, natural_abundance=0.000381),
         "18O": Atom(atomic_number=8, symbol='O', mass_number='18', atomic_mass=17.9991596128676, natural_abundance=0.0020514),
         "F": Atom(atomic_number=9, symbol='F', mass_number='19', atomic_mass=18.9984031627392, natural_abundance=1.0),
         "20Ne": Atom(atomic_number=10, symbol='Ne', mass_number='20', atomic_mass=19.992440176217, natural_abundance=0.90483),
         "21Ne": Atom(atomic_number=10, symbol='Ne', mass_number='21', atomic_mass=20.99384668541, natural_abundance=0.00271),
         "22Ne": Atom(atomic_number=10, symbol='Ne', mass_number='22', atomic_mass=21.99138511418, natural_abundance=0.09253),
         "23Na": Atom(atomic_number=11, symbol='Na', mass_number='23', atomic_mass=22.989769282019, natural_abundance=1.0),
         "24Mg": Atom(atomic_number=12, symbol='Mg', mass_number='24', atomic_mass=23.98504169714, natural_abundance=0.78994),
         "25Mg": Atom(atomic_number=12, symbol='Mg', mass_number='25', atomic_mass=24.9858369765, natural_abundance=0.10001),
         "26Mg": Atom(atomic_number=12, symbol='Mg', mass_number='26', atomic_mass=25.98259296831, natural_abundance=0.11013),
         "27Al": Atom(atomic_number=13, symbol='Al', mass_number='27', atomic_mass=26.9815385311, natural_abundance=1.0),
         "28Si": Atom(atomic_number=14, symbol='Si', mass_number='28', atomic_mass=27.9769265346544, natural_abundance=0.9222319),
         "29Si": Atom(atomic_number=14, symbol='Si', mass_number='29', atomic_mass=28.9764946649052, natural_abundance=0.046858),
         "30Si": Atom(atomic_number=14, symbol='Si', mass_number='30', atomic_mass=29.97377013623, natural_abundance=0.0309211),
         "P": Atom(atomic_number=15, symbol='P', mass_number='31', atomic_mass=30.973761998427, natural_abundance=1.0),
         "S": Atom(atomic_number=16, symbol='S', mass_number='32', atomic_mass=31.972071174414, natural_abundance=0.949926),
         "33S": Atom(atomic_number=16, symbol='S', mass_number='33', atomic_mass=32.971458909815, natural_abundance=0.00752),
         "34S": Atom(atomic_number=16, symbol='S', mass_number='34', atomic_mass=33.96786700447, natural_abundance=0.042524),
         "36S": Atom(atomic_number=16, symbol='S', mass_number='36', atomic_mass=35.967080712, natural_abundance=0.00011),
         "35Cl": Atom(atomic_number=17, symbol='Cl', mass_number='35', atomic_mass=34.96885268237, natural_abundance=0.75761),
         "37Cl": Atom(atomic_number=17, symbol='Cl', mass_number='37', atomic_mass=36.96590260255, natural_abundance=0.24241),
         "36Ar": Atom(atomic_number=18, symbol='Ar', mass_number='36', atomic_mass=35.96754510528, natural_abundance=0.00333621),
         "38Ar": Atom(atomic_number=18, symbol='Ar', mass_number='38', atomic_mass=37.9627321121, natural_abundance=0.0006297),
         "40Ar": Atom(atomic_number=18, symbol='Ar', mass_number='40', atomic_mass=39.962383123724, natural_abundance=0.99603525),
         "K": Atom(atomic_number=19, symbol='K', mass_number='39', atomic_mass=38.963706486449, natural_abundance=0.93258144),
         "40K": Atom(atomic_number=19, symbol='K', mass_number='40', atomic_mass=39.9639981666, natural_abundance=0.0001171),
         "41K": Atom(atomic_number=19, symbol='K', mass_number='41', atomic_mass=40.961825257941, natural_abundance=0.06730244),
         "Ca": Atom(atomic_number=20, symbol='Ca', mass_number='40', atomic_mass=39.96259086322, natural_abundance=0.96941156),
         "42Ca": Atom(atomic_number=20, symbol='Ca', mass_number='42', atomic_mass=41.9586178316, natural_abundance=0.0064723),
         "43Ca": Atom(atomic_number=20, symbol='Ca', mass_number='43', atomic_mass=42.9587664424, natural_abundance=0.001351),
         "44Ca": Atom(atomic_number=20, symbol='Ca', mass_number='44', atomic_mass=43.9554815635, natural_abundance=0.0208611),
         "46Ca": Atom(atomic_number=20, symbol='Ca', mass_number='46', atomic_mass=45.953689024, natural_abundance=4.3e-05),
         "48Ca": Atom(atomic_number=20, symbol='Ca', mass_number='48', atomic_mass=47.9525227613, natural_abundance=0.0018721),
         "45Sc": Atom(atomic_number=21, symbol='Sc', mass_number='45', atomic_mass=44.9559082877, natural_abundance=1.0),
         "46Ti": Atom(atomic_number=22, symbol='Ti', mass_number='46', atomic_mass=45.9526277235, natural_abundance=0.08253),
         "47Ti": Atom(atomic_number=22, symbol='Ti', mass_number='47', atomic_mass=46.9517587938, natural_abundance=0.07442),
         "48Ti": Atom(atomic_number=22, symbol='Ti', mass_number='48', atomic_mass=47.9479419838, natural_abundance=0.73723),
         "49Ti": Atom(atomic_number=22, symbol='Ti', mass_number='49', atomic_mass=48.9478656839, natural_abundance=0.05412),
         "50Ti": Atom(atomic_number=22, symbol='Ti', mass_number='50', atomic_mass=49.9447868939, natural_abundance=0.05182),
         "50V": Atom(atomic_number=23, symbol='V', mass_number='50', atomic_mass=49.9471560195, natural_abundance=0.002504),
         "V": Atom(atomic_number=23, symbol='V', mass_number='51', atomic_mass=50.9439570494, natural_abundance=0.997504),
         "50Cr": Atom(atomic_number=24, symbol='Cr', mass_number='50', atomic_mass=49.9460418394, natural_abundance=0.0434513),
         "52Cr": Atom(atomic_number=24, symbol='Cr', mass_number='52', atomic_mass=51.9405062363, natural_abundance=0.8378918),
         "53Cr": Atom(atomic_number=24, symbol='Cr', mass_number='53', atomic_mass=52.9406481562, natural_abundance=0.0950117),
         "54Cr": Atom(atomic_number=24, symbol='Cr', mass_number='54', atomic_mass=53.9388791661, natural_abundance=0.023657),
         "55Mn": Atom(atomic_number=25, symbol='Mn', mass_number='55', atomic_mass=54.9380439148, natural_abundance=1.0),
         "54Fe": Atom(atomic_number=26, symbol='Fe', mass_number='54', atomic_mass=53.9396089953, natural_abundance=0.0584535),
         "Fe": Atom(atomic_number=26, symbol='Fe', mass_number='56', atomic_mass=55.9349363349, natural_abundance=0.9175436),
         "57Fe": Atom(atomic_number=26, symbol='Fe', mass_number='57', atomic_mass=56.9353928449, natural_abundance=0.021191),
         "58Fe": Atom(atomic_number=26, symbol='Fe', mass_number='58', atomic_mass=57.9332744353, natural_abundance=0.002824),
         "59Co": Atom(atomic_number=27, symbol='Co', mass_number='59', atomic_mass=58.9331942956, natural_abundance=1.0),
         "58Ni": Atom(atomic_number=28, symbol='Ni', mass_number='58', atomic_mass=57.9353424152, natural_abundance=0.6807719),
         "60Ni": Atom(atomic_number=28, symbol='Ni', mass_number='60', atomic_mass=59.9307858852, natural_abundance=0.2622315),
         "61Ni": Atom(atomic_number=28, symbol='Ni', mass_number='61', atomic_mass=60.9310555752, natural_abundance=0.01139913),
         "62Ni": Atom(atomic_number=28, symbol='Ni', mass_number='62', atomic_mass=61.9283453755, natural_abundance=0.0363464),
         "64Ni": Atom(atomic_number=28, symbol='Ni', mass_number='64', atomic_mass=63.9279668258, natural_abundance=0.00925519),
         "63Cu": Atom(atomic_number=29, symbol='Cu', mass_number='63', atomic_mass=62.9295977256, natural_abundance=0.691515),
         "65Cu": Atom(atomic_number=29, symbol='Cu', mass_number='65', atomic_mass=64.9277897071, natural_abundance=0.308515),
         "64Zn": Atom(atomic_number=30, symbol='Zn', mass_number='64', atomic_mass=63.9291420171, natural_abundance=0.491775),
         "66Zn": Atom(atomic_number=30, symbol='Zn', mass_number='66', atomic_mass=65.9260338194, natural_abundance=0.277398),
         "67Zn": Atom(atomic_number=30, symbol='Zn', mass_number='67', atomic_mass=66.9271277596, natural_abundance=0.040416),
         "68Zn": Atom(atomic_number=30, symbol='Zn', mass_number='68', atomic_mass=67.9248445598, natural_abundance=0.184563),
         "70Zn": Atom(atomic_number=30, symbol='Zn', mass_number='70', atomic_mass=69.925319221, natural_abundance=0.00611),
         "69Ga": Atom(atomic_number=31, symbol='Ga', mass_number='69', atomic_mass=68.925573513, natural_abundance=0.601089),
         "71Ga": Atom(atomic_number=31, symbol='Ga', mass_number='71', atomic_mass=70.9247025887, natural_abundance=0.398929),
         "70Ge": Atom(atomic_number=32, symbol='Ge', mass_number='70', atomic_mass=69.924248759, natural_abundance=0.205727),
         "72Ge": Atom(atomic_number=32, symbol='Ge', mass_number='72', atomic_mass=71.92207582681, natural_abundance=0.274532),
         "73Ge": Atom(atomic_number=32, symbol='Ge', mass_number='73', atomic_mass=72.92345895661, natural_abundance=0.077512),
         "74Ge": Atom(atomic_number=32, symbol='Ge', mass_number='74', atomic_mass=73.92117776113, natural_abundance=0.36502),
         "76Ge": Atom(atomic_number=32, symbol='Ge', mass_number='76', atomic_mass=75.92140272619, natural_abundance=0.077312),
         "75As": Atom(atomic_number=33, symbol='As', mass_number='75', atomic_mass=74.9215945795, natural_abundance=1.0),
         "74Se": Atom(atomic_number=34, symbol='Se', mass_number='74', atomic_mass=73.92247593415, natural_abundance=0.00894),
         "76Se": Atom(atomic_number=34, symbol='Se', mass_number='76', atomic_mass=75.91921370417, natural_abundance=0.093729),
         "77Se": Atom(atomic_number=34, symbol='Se', mass_number='77', atomic_mass=76.91991415467, natural_abundance=0.076316),
         "78Se": Atom(atomic_number=34, symbol='Se', mass_number='78', atomic_mass=77.917309282, natural_abundance=0.237728),
         "80Se": Atom(atomic_number=34, symbol='Se', mass_number='80', atomic_mass=79.916521813, natural_abundance=0.496141),
         "82Se": Atom(atomic_number=34, symbol='Se', mass_number='82', atomic_mass=81.916699515, natural_abundance=0.087322),
         "79Br": Atom(atomic_number=35, symbol='Br', mass_number='79', atomic_mass=78.918337614, natural_abundance=0.50697),
         "81Br": Atom(atomic_number=35, symbol='Br', mass_number='81', atomic_mass=80.916289714, natural_abundance=0.49317),
         "78Kr": Atom(atomic_number=36, symbol='Kr', mass_number='78', atomic_mass=77.9203649476, natural_abundance=0.003553),
         "80Kr": Atom(atomic_number=36, symbol='Kr', mass_number='80', atomic_mass=79.9163780875, natural_abundance=0.022861),
         "82Kr": Atom(atomic_number=36, symbol='Kr', mass_number='82', atomic_mass=81.9134827394, natural_abundance=0.1159331),
         "83Kr": Atom(atomic_number=36, symbol='Kr', mass_number='83', atomic_mass=82.9141271632, natural_abundance=0.1150019),
         "84Kr": Atom(atomic_number=36, symbol='Kr', mass_number='84', atomic_mass=83.911497728244, natural_abundance=0.5698715),
         "86Kr": Atom(atomic_number=36, symbol='Kr', mass_number='86', atomic_mass=85.910610626941, natural_abundance=0.1727941),
         "85Rb": Atom(atomic_number=37, symbol='Rb', mass_number='85', atomic_mass=84.911789737954, natural_abundance=0.72172),
         "87Rb": Atom(atomic_number=37, symbol='Rb', mass_number='87', atomic_mass=86.90918053106, natural_abundance=0.27832),
         "84Sr": Atom(atomic_number=38, symbol='Sr', mass_number='84', atomic_mass=83.913419113, natural_abundance=0.00561),
         "86Sr": Atom(atomic_number=38, symbol='Sr', mass_number='86', atomic_mass=85.909260612, natural_abundance=0.09861),
         "87Sr": Atom(atomic_number=38, symbol='Sr', mass_number='87', atomic_mass=86.908877512, natural_abundance=0.07001),
         "88Sr": Atom(atomic_number=38, symbol='Sr', mass_number='88', atomic_mass=87.905612512, natural_abundance=0.82581),
         "89Y": Atom(atomic_number=39, symbol='Y', mass_number='89', atomic_mass=88.905840324, natural_abundance=1.0),
         "90Zr": Atom(atomic_number=40, symbol='Zr', mass_number='90', atomic_mass=89.90469772, natural_abundance=0.51454),
         "91Zr": Atom(atomic_number=40, symbol='Zr', mass_number='91', atomic_mass=90.90563962, natural_abundance=0.11225),
         "92Zr": Atom(atomic_number=40, symbol='Zr', mass_number='92', atomic_mass=91.90503472, natural_abundance=0.17158),
         "94Zr": Atom(atomic_number=40, symbol='Zr', mass_number='94', atomic_mass=93.90631082, natural_abundance=0.173828),
         "96Zr": Atom(atomic_number=40, symbol='Zr', mass_number='96', atomic_mass=95.908271421, natural_abundance=0.02809),
         "93Nb": Atom(atomic_number=41, symbol='Nb', mass_number='93', atomic_mass=92.90637302, natural_abundance=1.0),
         "92Mo": Atom(atomic_number=42, symbol='Mo', mass_number='92', atomic_mass=91.9068079684, natural_abundance=0.14533),
         "94Mo": Atom(atomic_number=42, symbol='Mo', mass_number='94', atomic_mass=93.9050849048, natural_abundance=0.09159),
         "95Mo": Atom(atomic_number=42, symbol='Mo', mass_number='95', atomic_mass=94.9058387747, natural_abundance=0.158411),
         "96Mo": Atom(atomic_number=42, symbol='Mo', mass_number='96', atomic_mass=95.9046761247, natural_abundance=0.166715),
         "97Mo": Atom(atomic_number=42, symbol='Mo', mass_number='97', atomic_mass=96.9060181249, natural_abundance=0.096014),
         "98Mo": Atom(atomic_number=42, symbol='Mo', mass_number='98', atomic_mass=97.9054048249, natural_abundance=0.243937),
         "100Mo": Atom(atomic_number=42, symbol='Mo', mass_number='100', atomic_mass=99.907471811, natural_abundance=0.098231),
         "97Tc": Atom(atomic_number=43, symbol='Tc', mass_number='97', atomic_mass=96.90636674, natural_abundance=None),
         "98Tc": Atom(atomic_number=43, symbol='Tc', mass_number='98', atomic_mass=97.907212436, natural_abundance=None),
         "99Tc": Atom(atomic_number=43, symbol='Tc', mass_number='99', atomic_mass=98.90625081, natural_abundance=None),
         "96Ru": Atom(atomic_number=44, symbol='Ru', mass_number='96', atomic_mass=95.9075902549, natural_abundance=0.055414),
         "98Ru": Atom(atomic_number=44, symbol='Ru', mass_number='98', atomic_mass=97.905286869, natural_abundance=0.01873),
         "99Ru": Atom(atomic_number=44, symbol='Ru', mass_number='99', atomic_mass=98.905934111, natural_abundance=0.127614),
         "100Ru": Atom(atomic_number=44, symbol='Ru', mass_number='100', atomic_mass=99.904214311, natural_abundance=0.12607),
         "101Ru": Atom(atomic_number=44, symbol='Ru', mass_number='101', atomic_mass=100.905576912, natural_abundance=0.17062),
         "102Ru": Atom(atomic_number=44, symbol='Ru', mass_number='102', atomic_mass=101.904344112, natural_abundance=0.315514),
         "104Ru": Atom(atomic_number=44, symbol='Ru', mass_number='104', atomic_mass=103.905427528, natural_abundance=0.186227),
         "103Rh": Atom(atomic_number=45, symbol='Rh', mass_number='103', atomic_mass=102.905498026, natural_abundance=1.0),
         "102Pd": Atom(atomic_number=46, symbol='Pd', mass_number='102', atomic_mass=101.905602228, natural_abundance=0.01021),
         "104Pd": Atom(atomic_number=46, symbol='Pd', mass_number='104', atomic_mass=103.904030514, natural_abundance=0.11148),
         "105Pd": Atom(atomic_number=46, symbol='Pd', mass_number='105', atomic_mass=104.905079612, natural_abundance=0.22338),
         "106Pd": Atom(atomic_number=46, symbol='Pd', mass_number='106', atomic_mass=105.903480412, natural_abundance=0.27333),
         "108Pd": Atom(atomic_number=46, symbol='Pd', mass_number='108', atomic_mass=107.903891612, natural_abundance=0.26469),
         "110Pd": Atom(atomic_number=46, symbol='Pd', mass_number='110', atomic_mass=109.9051722075, natural_abundance=0.11729),
         "107Ag": Atom(atomic_number=47, symbol='Ag', mass_number='107', atomic_mass=106.905091626, natural_abundance=0.518398),
         "109Ag": Atom(atomic_number=47, symbol='Ag', mass_number='109', atomic_mass=108.904755314, natural_abundance=0.481618),
         "106Cd": Atom(atomic_number=48, symbol='Cd', mass_number='106', atomic_mass=105.906459912, natural_abundance=0.01256),
         "108Cd": Atom(atomic_number=48, symbol='Cd', mass_number='108', atomic_mass=107.904183412, natural_abundance=0.00893),
         "110Cd": Atom(atomic_number=48, symbol='Cd', mass_number='110', atomic_mass=109.9030066161, natural_abundance=0.124918),
         "111Cd": Atom(atomic_number=48, symbol='Cd', mass_number='111', atomic_mass=110.9041828761, natural_abundance=0.128012),
         "112Cd": Atom(atomic_number=48, symbol='Cd', mass_number='112', atomic_mass=111.902762876, natural_abundance=0.241321),
         "113Cd": Atom(atomic_number=48, symbol='Cd', mass_number='113', atomic_mass=112.9044081345, natural_abundance=0.122212),
         "114Cd": Atom(atomic_number=48, symbol='Cd', mass_number='114', atomic_mass=113.9033650943, natural_abundance=0.287342),
         "116Cd": Atom(atomic_number=48, symbol='Cd', mass_number='116', atomic_mass=115.9047631517, natural_abundance=0.074918),
         "113In": Atom(atomic_number=49, symbol='In', mass_number='113', atomic_mass=112.9040618491, natural_abundance=0.04295),
         "115In": Atom(atomic_number=49, symbol='In', mass_number='115', atomic_mass=114.90387877612, natural_abundance=0.95715),
         "112Sn": Atom(atomic_number=50, symbol='Sn', mass_number='112', atomic_mass=111.9048238761, natural_abundance=0.00971),
         "114Sn": Atom(atomic_number=50, symbol='Sn', mass_number='114', atomic_mass=113.90278271, natural_abundance=0.00661),
         "115Sn": Atom(atomic_number=50, symbol='Sn', mass_number='115', atomic_mass=114.90334469916, natural_abundance=0.00341),
         "116Sn": Atom(atomic_number=50, symbol='Sn', mass_number='116', atomic_mass=115.901742801, natural_abundance=0.14549),
         "117Sn": Atom(atomic_number=50, symbol='Sn', mass_number='117', atomic_mass=116.9029539852, natural_abundance=0.07687),
         "118Sn": Atom(atomic_number=50, symbol='Sn', mass_number='118', atomic_mass=117.9016065754, natural_abundance=0.24229),
         "119Sn": Atom(atomic_number=50, symbol='Sn', mass_number='119', atomic_mass=118.9033111778, natural_abundance=0.08594),
         "120Sn": Atom(atomic_number=50, symbol='Sn', mass_number='120', atomic_mass=119.9022016397, natural_abundance=0.32589),
         "122Sn": Atom(atomic_number=50, symbol='Sn', mass_number='122', atomic_mass=121.903443826, natural_abundance=0.04633),
         "124Sn": Atom(atomic_number=50, symbol='Sn', mass_number='124', atomic_mass=123.905276611, natural_abundance=0.05795),
         "121Sb": Atom(atomic_number=51, symbol='Sb', mass_number='121', atomic_mass=120.90381203, natural_abundance=0.57215),
         "123Sb": Atom(atomic_number=51, symbol='Sb', mass_number='123', atomic_mass=122.904213223, natural_abundance=0.42795),
         "120Te": Atom(atomic_number=52, symbol='Te', mass_number='120', atomic_mass=119.904059333, natural_abundance=0.00091),
         "122Te": Atom(atomic_number=52, symbol='Te', mass_number='122', atomic_mass=121.903043516, natural_abundance=0.025512),
         "123Te": Atom(atomic_number=52, symbol='Te', mass_number='123', atomic_mass=122.904269816, natural_abundance=0.00893),
         "124Te": Atom(atomic_number=52, symbol='Te', mass_number='124', atomic_mass=123.902817116, natural_abundance=0.047414),
         "125Te": Atom(atomic_number=52, symbol='Te', mass_number='125', atomic_mass=124.904429916, natural_abundance=0.070715),
         "126Te": Atom(atomic_number=52, symbol='Te', mass_number='126', atomic_mass=125.903310916, natural_abundance=0.188425),
         "128Te": Atom(atomic_number=52, symbol='Te', mass_number='128', atomic_mass=127.9044612893, natural_abundance=0.31748),
         "130Te": Atom(atomic_number=52, symbol='Te', mass_number='130', atomic_mass=129.90622274812, natural_abundance=0.340862),
         "127I": Atom(atomic_number=53, symbol='I', mass_number='127', atomic_mass=126.904471939, natural_abundance=1.0),
         "124Xe": Atom(atomic_number=54, symbol='Xe', mass_number='124', atomic_mass=123.905892019, natural_abundance=0.0009523),
         "126Xe": Atom(atomic_number=54, symbol='Xe', mass_number='126', atomic_mass=125.904298338, natural_abundance=0.0008902),
         "128Xe": Atom(atomic_number=54, symbol='Xe', mass_number='128', atomic_mass=127.903531011, natural_abundance=0.0191028),
         "129Xe": Atom(atomic_number=54, symbol='Xe', mass_number='129', atomic_mass=128.90478086116, natural_abundance=0.26400682),
         "130Xe": Atom(atomic_number=54, symbol='Xe', mass_number='130', atomic_mass=129.9035093491, natural_abundance=0.04071013),
         "131Xe": Atom(atomic_number=54, symbol='Xe', mass_number='131', atomic_mass=130.9050840624, natural_abundance=0.2123243),
         "132Xe": Atom(atomic_number=54, symbol='Xe', mass_number='132', atomic_mass=131.904155085656, natural_abundance=0.26908633),
         "134Xe": Atom(atomic_number=54, symbol='Xe', mass_number='134', atomic_mass=133.905394669, natural_abundance=0.10435721),
         "136Xe": Atom(atomic_number=54, symbol='Xe', mass_number='136', atomic_mass=135.90721448411, natural_abundance=0.08857344),
         "133Cs": Atom(atomic_number=55, symbol='Cs', mass_number='133', atomic_mass=132.90545196108, natural_abundance=1.0),
         "130Ba": Atom(atomic_number=56, symbol='Ba', mass_number='130', atomic_mass=129.906320728, natural_abundance=0.001061),
         "132Ba": Atom(atomic_number=56, symbol='Ba', mass_number='132', atomic_mass=131.905061111, natural_abundance=0.001011),
         "134Ba": Atom(atomic_number=56, symbol='Ba', mass_number='134', atomic_mass=133.904508183, natural_abundance=0.0241718),
         "135Ba": Atom(atomic_number=56, symbol='Ba', mass_number='135', atomic_mass=134.9056883829, natural_abundance=0.0659212),
         "136Ba": Atom(atomic_number=56, symbol='Ba', mass_number='136', atomic_mass=135.9045757329, natural_abundance=0.0785424),
         "137Ba": Atom(atomic_number=56, symbol='Ba', mass_number='137', atomic_mass=136.905827143, natural_abundance=0.1123224),
         "138Ba": Atom(atomic_number=56, symbol='Ba', mass_number='138', atomic_mass=137.9052470031, natural_abundance=0.7169842),
         "138La": Atom(atomic_number=57, symbol='La', mass_number='138', atomic_mass=137.907114937, natural_abundance=0.000888171),
         "139La": Atom(atomic_number=57, symbol='La', mass_number='139', atomic_mass=138.906356324, natural_abundance=0.999111971),
         "136Ce": Atom(atomic_number=58, symbol='Ce', mass_number='136', atomic_mass=135.9071292141, natural_abundance=0.001852),
         "138Ce": Atom(atomic_number=58, symbol='Ce', mass_number='138', atomic_mass=137.90599111, natural_abundance=0.002512),
         "140Ce": Atom(atomic_number=58, symbol='Ce', mass_number='140', atomic_mass=139.905443123, natural_abundance=0.8845051),
         "142Ce": Atom(atomic_number=58, symbol='Ce', mass_number='142', atomic_mass=141.909250429, natural_abundance=0.1111451),
         "141Pr": Atom(atomic_number=59, symbol='Pr', mass_number='141', atomic_mass=140.907657623, natural_abundance=1.0),
         "142Nd": Atom(atomic_number=60, symbol='Nd', mass_number='142', atomic_mass=141.90772902, natural_abundance=0.271524),
         "143Nd": Atom(atomic_number=60, symbol='Nd', mass_number='143', atomic_mass=142.90982002, natural_abundance=0.1217426),
         "144Nd": Atom(atomic_number=60, symbol='Nd', mass_number='144', atomic_mass=143.91009302, natural_abundance=0.2379819),
         "145Nd": Atom(atomic_number=60, symbol='Nd', mass_number='145', atomic_mass=144.91257932, natural_abundance=0.0829312),
         "146Nd": Atom(atomic_number=60, symbol='Nd', mass_number='146', atomic_mass=145.91312262, natural_abundance=0.1718932),
         "148Nd": Atom(atomic_number=60, symbol='Nd', mass_number='148', atomic_mass=147.916899326, natural_abundance=0.0575621),
         "150Nd": Atom(atomic_number=60, symbol='Nd', mass_number='150', atomic_mass=149.920902218, natural_abundance=0.0563828),
         "145Pm": Atom(atomic_number=61, symbol='Pm', mass_number='145', atomic_mass=144.912755933, natural_abundance=None),
         "147Pm": Atom(atomic_number=61, symbol='Pm', mass_number='147', atomic_mass=146.915145019, natural_abundance=None),
         "144Sm": Atom(atomic_number=62, symbol='Sm', mass_number='144', atomic_mass=143.912006521, natural_abundance=0.03077),
         "147Sm": Atom(atomic_number=62, symbol='Sm', mass_number='147', atomic_mass=146.914904419, natural_abundance=0.149918),
         "148Sm": Atom(atomic_number=62, symbol='Sm', mass_number='148', atomic_mass=147.914829219, natural_abundance=0.11241),
         "149Sm": Atom(atomic_number=62, symbol='Sm', mass_number='149', atomic_mass=148.917192118, natural_abundance=0.13827),
         "150Sm": Atom(atomic_number=62, symbol='Sm', mass_number='150', atomic_mass=149.917282918, natural_abundance=0.07381),
         "152Sm": Atom(atomic_number=62, symbol='Sm', mass_number='152', atomic_mass=151.919739718, natural_abundance=0.267516),
         "154Sm": Atom(atomic_number=62, symbol='Sm', mass_number='154', atomic_mass=153.92221692, natural_abundance=0.227529),
         "151Eu": Atom(atomic_number=63, symbol='Eu', mass_number='151', atomic_mass=150.919857818, natural_abundance=0.47816),
         "153Eu": Atom(atomic_number=63, symbol='Eu', mass_number='153', atomic_mass=152.921238018, natural_abundance=0.52196),
         "152Gd": Atom(atomic_number=64, symbol='Gd', mass_number='152', atomic_mass=151.919799518, natural_abundance=0.00201),
         "154Gd": Atom(atomic_number=64, symbol='Gd', mass_number='154', atomic_mass=153.920874117, natural_abundance=0.02183),
         "155Gd": Atom(atomic_number=64, symbol='Gd', mass_number='155', atomic_mass=154.922630517, natural_abundance=0.148012),
         "156Gd": Atom(atomic_number=64, symbol='Gd', mass_number='156', atomic_mass=155.922131217, natural_abundance=0.20479),
         "157Gd": Atom(atomic_number=64, symbol='Gd', mass_number='157', atomic_mass=156.923968617, natural_abundance=0.15652),
         "158Gd": Atom(atomic_number=64, symbol='Gd', mass_number='158', atomic_mass=157.924112317, natural_abundance=0.24847),
         "160Gd": Atom(atomic_number=64, symbol='Gd', mass_number='160', atomic_mass=159.927062418, natural_abundance=0.218619),
         "159Tb": Atom(atomic_number=65, symbol='Tb', mass_number='159', atomic_mass=158.925354719, natural_abundance=1.0),
         "156Dy": Atom(atomic_number=66, symbol='Dy', mass_number='156', atomic_mass=155.924284717, natural_abundance=0.000563),
         "158Dy": Atom(atomic_number=66, symbol='Dy', mass_number='158', atomic_mass=157.924415931, natural_abundance=0.000953),
         "160Dy": Atom(atomic_number=66, symbol='Dy', mass_number='160', atomic_mass=159.92520462, natural_abundance=0.0232918),
         "161Dy": Atom(atomic_number=66, symbol='Dy', mass_number='161', atomic_mass=160.92694052, natural_abundance=0.1888942),
         "162Dy": Atom(atomic_number=66, symbol='Dy', mass_number='162', atomic_mass=161.92680562, natural_abundance=0.2547536),
         "163Dy": Atom(atomic_number=66, symbol='Dy', mass_number='163', atomic_mass=162.92873832, natural_abundance=0.2489642),
         "164Dy": Atom(atomic_number=66, symbol='Dy', mass_number='164', atomic_mass=163.92918192, natural_abundance=0.2826054),
         "165Ho": Atom(atomic_number=67, symbol='Ho', mass_number='165', atomic_mass=164.930328821, natural_abundance=1.0),
         "162Er": Atom(atomic_number=68, symbol='Er', mass_number='162', atomic_mass=161.92878842, natural_abundance=0.001395),
         "164Er": Atom(atomic_number=68, symbol='Er', mass_number='164', atomic_mass=163.92920882, natural_abundance=0.016013),
         "166Er": Atom(atomic_number=68, symbol='Er', mass_number='166', atomic_mass=165.930299522, natural_abundance=0.3350336),
         "167Er": Atom(atomic_number=68, symbol='Er', mass_number='167', atomic_mass=166.932054622, natural_abundance=0.228699),
         "168Er": Atom(atomic_number=68, symbol='Er', mass_number='168', atomic_mass=167.932376722, natural_abundance=0.2697818),
         "170Er": Atom(atomic_number=68, symbol='Er', mass_number='170', atomic_mass=169.935470226, natural_abundance=0.1491036),
         "169Tm": Atom(atomic_number=69, symbol='Tm', mass_number='169', atomic_mass=168.934217922, natural_abundance=1.0),
         "168Yb": Atom(atomic_number=70, symbol='Yb', mass_number='168', atomic_mass=167.933889622, natural_abundance=0.001233),
         "170Yb": Atom(atomic_number=70, symbol='Yb', mass_number='170', atomic_mass=169.934766422, natural_abundance=0.0298239),
         "171Yb": Atom(atomic_number=70, symbol='Yb', mass_number='171', atomic_mass=170.936330222, natural_abundance=0.140914),
         "172Yb": Atom(atomic_number=70, symbol='Yb', mass_number='172', atomic_mass=171.936385922, natural_abundance=0.216813),
         "173Yb": Atom(atomic_number=70, symbol='Yb', mass_number='173', atomic_mass=172.938215122, natural_abundance=0.1610363),
         "174Yb": Atom(atomic_number=70, symbol='Yb', mass_number='174', atomic_mass=173.938866422, natural_abundance=0.320268),
         "176Yb": Atom(atomic_number=70, symbol='Yb', mass_number='176', atomic_mass=175.942576424, natural_abundance=0.1299683),
         "175Lu": Atom(atomic_number=71, symbol='Lu', mass_number='175', atomic_mass=174.94077522, natural_abundance=0.9740113),
         "176Lu": Atom(atomic_number=71, symbol='Lu', mass_number='176', atomic_mass=175.94268972, natural_abundance=0.0259913),
         "174Hf": Atom(atomic_number=72, symbol='Hf', mass_number='174', atomic_mass=173.940046128, natural_abundance=0.00161),
         "176Hf": Atom(atomic_number=72, symbol='Hf', mass_number='176', atomic_mass=175.941407622, natural_abundance=0.05267),
         "177Hf": Atom(atomic_number=72, symbol='Hf', mass_number='177', atomic_mass=176.94322772, natural_abundance=0.18609),
         "178Hf": Atom(atomic_number=72, symbol='Hf', mass_number='178', atomic_mass=177.94370582, natural_abundance=0.27287),
         "179Hf": Atom(atomic_number=72, symbol='Hf', mass_number='179', atomic_mass=178.94582322, natural_abundance=0.13622),
         "180Hf": Atom(atomic_number=72, symbol='Hf', mass_number='180', atomic_mass=179.94655702, natural_abundance=0.350816),
         "180Ta": Atom(atomic_number=73, symbol='Ta', mass_number='180', atomic_mass=179.947464824, natural_abundance=0.000120132),
         "181Ta": Atom(atomic_number=73, symbol='Ta', mass_number='181', atomic_mass=180.94799582, natural_abundance=0.999879932),
         "180W": Atom(atomic_number=74, symbol='W', mass_number='180', atomic_mass=179.94671082, natural_abundance=0.00121),
         "182W": Atom(atomic_number=74, symbol='W', mass_number='182', atomic_mass=181.9482039491, natural_abundance=0.265016),
         "183W": Atom(atomic_number=74, symbol='W', mass_number='183', atomic_mass=182.950222759, natural_abundance=0.14314),
         "184W": Atom(atomic_number=74, symbol='W', mass_number='184', atomic_mass=183.9509309294, natural_abundance=0.30642),
         "186W": Atom(atomic_number=74, symbol='W', mass_number='186', atomic_mass=185.954362817, natural_abundance=0.284319),
         "185Re": Atom(atomic_number=75, symbol='Re', mass_number='185', atomic_mass=184.952954513, natural_abundance=0.37402),
         "187Re": Atom(atomic_number=75, symbol='Re', mass_number='187', atomic_mass=186.955750116, natural_abundance=0.62602),
         "184Os": Atom(atomic_number=76, symbol='Os', mass_number='184', atomic_mass=183.952488514, natural_abundance=0.00021),
         "186Os": Atom(atomic_number=76, symbol='Os', mass_number='186', atomic_mass=185.953835016, natural_abundance=0.01593),
         "187Os": Atom(atomic_number=76, symbol='Os', mass_number='187', atomic_mass=186.955747416, natural_abundance=0.01962),
         "188Os": Atom(atomic_number=76, symbol='Os', mass_number='188', atomic_mass=187.955835216, natural_abundance=0.13248),
         "189Os": Atom(atomic_number=76, symbol='Os', mass_number='189', atomic_mass=188.958144217, natural_abundance=0.16155),
         "190Os": Atom(atomic_number=76, symbol='Os', mass_number='190', atomic_mass=189.958443717, natural_abundance=0.26262),
         "192Os": Atom(atomic_number=76, symbol='Os', mass_number='192', atomic_mass=191.961477029, natural_abundance=0.407819),
         "191Ir": Atom(atomic_number=77, symbol='Ir', mass_number='191', atomic_mass=190.960589321, natural_abundance=0.3732),
         "193Ir": Atom(atomic_number=77, symbol='Ir', mass_number='193', atomic_mass=192.962921621, natural_abundance=0.6272),
         "190Pt": Atom(atomic_number=78, symbol='Pt', mass_number='190', atomic_mass=189.959929763, natural_abundance=0.000122),
         "192Pt": Atom(atomic_number=78, symbol='Pt', mass_number='192', atomic_mass=191.961038732, natural_abundance=0.0078224),
         "194Pt": Atom(atomic_number=78, symbol='Pt', mass_number='194', atomic_mass=193.96268091, natural_abundance=0.32864),
         "195Pt": Atom(atomic_number=78, symbol='Pt', mass_number='195', atomic_mass=194.96479171, natural_abundance=0.337824),
         "196Pt": Atom(atomic_number=78, symbol='Pt', mass_number='196', atomic_mass=195.9649520999, natural_abundance=0.252134),
         "198Pt": Atom(atomic_number=78, symbol='Pt', mass_number='198', atomic_mass=197.967894923, natural_abundance=0.0735613),
         "197Au": Atom(atomic_number=79, symbol='Au', mass_number='197', atomic_mass=196.9665687971, natural_abundance=1.0),
         "196Hg": Atom(atomic_number=80, symbol='Hg', mass_number='196', atomic_mass=195.965832632, natural_abundance=0.00151),
         "198Hg": Atom(atomic_number=80, symbol='Hg', mass_number='198', atomic_mass=197.9667686052, natural_abundance=0.09972),
         "199Hg": Atom(atomic_number=80, symbol='Hg', mass_number='199', atomic_mass=198.9682806446, natural_abundance=0.168722),
         "200Hg": Atom(atomic_number=80, symbol='Hg', mass_number='200', atomic_mass=199.9683265947, natural_abundance=0.231019),
         "201Hg": Atom(atomic_number=80, symbol='Hg', mass_number='201', atomic_mass=200.9703028469, natural_abundance=0.13189),
         "202Hg": Atom(atomic_number=80, symbol='Hg', mass_number='202', atomic_mass=201.9706434069, natural_abundance=0.298626),
         "204Hg": Atom(atomic_number=80, symbol='Hg', mass_number='204', atomic_mass=203.9734939853, natural_abundance=0.068715),
         "203Tl": Atom(atomic_number=81, symbol='Tl', mass_number='203', atomic_mass=202.972344614, natural_abundance=0.29521),
         "205Tl": Atom(atomic_number=81, symbol='Tl', mass_number='205', atomic_mass=204.974427814, natural_abundance=0.70481),
         "204Pb": Atom(atomic_number=82, symbol='Pb', mass_number='204', atomic_mass=203.973044013, natural_abundance=0.0141),
         "206Pb": Atom(atomic_number=82, symbol='Pb', mass_number='206', atomic_mass=205.974465713, natural_abundance=0.2411),
         "207Pb": Atom(atomic_number=82, symbol='Pb', mass_number='207', atomic_mass=206.975897313, natural_abundance=0.2211),
         "208Pb": Atom(atomic_number=82, symbol='Pb', mass_number='208', atomic_mass=207.976652513, natural_abundance=0.5241),
         "209Bi": Atom(atomic_number=83, symbol='Bi', mass_number='209', atomic_mass=208.980399116, natural_abundance=1.0),
         "209Po": Atom(atomic_number=84, symbol='Po', mass_number='209', atomic_mass=208.98243082, natural_abundance=None),
         "210Po": Atom(atomic_number=84, symbol='Po', mass_number='210', atomic_mass=209.982874113, natural_abundance=None),
         "210At": Atom(atomic_number=85, symbol='At', mass_number='210', atomic_mass=209.987147983, natural_abundance=None),
         "211At": Atom(atomic_number=85, symbol='At', mass_number='211', atomic_mass=210.98749663, natural_abundance=None),
         "211Rn": Atom(atomic_number=86, symbol='Rn', mass_number='211', atomic_mass=210.990601173, natural_abundance=None),
         "220Rn": Atom(atomic_number=86, symbol='Rn', mass_number='220', atomic_mass=220.011394123, natural_abundance=None),
         "222Rn": Atom(atomic_number=86, symbol='Rn', mass_number='222', atomic_mass=222.017578225, natural_abundance=None),
         "223Fr": Atom(atomic_number=87, symbol='Fr', mass_number='223', atomic_mass=223.019736025, natural_abundance=None),
         "223Ra": Atom(atomic_number=88, symbol='Ra', mass_number='223', atomic_mass=223.018502327, natural_abundance=None),
         "224Ra": Atom(atomic_number=88, symbol='Ra', mass_number='224', atomic_mass=224.020212023, natural_abundance=None),
         "226Ra": Atom(atomic_number=88, symbol='Ra', mass_number='226', atomic_mass=226.025410325, natural_abundance=None),
         "228Ra": Atom(atomic_number=88, symbol='Ra', mass_number='228', atomic_mass=228.031070726, natural_abundance=None),
         "227Ac": Atom(atomic_number=89, symbol='Ac', mass_number='227', atomic_mass=227.027752325, natural_abundance=None),
         "230Th": Atom(atomic_number=90, symbol='Th', mass_number='230', atomic_mass=230.033134119, natural_abundance=None),
         "232Th": Atom(atomic_number=90, symbol='Th', mass_number='232', atomic_mass=232.038055821, natural_abundance=1.0),
         "231Pa": Atom(atomic_number=91, symbol='Pa', mass_number='231', atomic_mass=231.035884224, natural_abundance=1.0),
         "233U": Atom(atomic_number=92, symbol='U', mass_number='233', atomic_mass=233.039635529, natural_abundance=None),
         "234U": Atom(atomic_number=92, symbol='U', mass_number='234', atomic_mass=234.040952319, natural_abundance=5.45e-05),
         "235U": Atom(atomic_number=92, symbol='U', mass_number='235', atomic_mass=235.043930119, natural_abundance=0.0072046),
         "236U": Atom(atomic_number=92, symbol='U', mass_number='236', atomic_mass=236.045568219, natural_abundance=None),
         "238U": Atom(atomic_number=92, symbol='U', mass_number='238', atomic_mass=238.05078842, natural_abundance=0.9927421),
         "236Np": Atom(atomic_number=93, symbol='Np', mass_number='236', atomic_mass=236.04657054, natural_abundance=None),
         "237Np": Atom(atomic_number=93, symbol='Np', mass_number='237', atomic_mass=237.048173619, natural_abundance=None),
         "238Pu": Atom(atomic_number=94, symbol='Pu', mass_number='238', atomic_mass=238.049560119, natural_abundance=None),
         "239Pu": Atom(atomic_number=94, symbol='Pu', mass_number='239', atomic_mass=239.052163619, natural_abundance=None),
         "240Pu": Atom(atomic_number=94, symbol='Pu', mass_number='240', atomic_mass=240.053813819, natural_abundance=None),
         "241Pu": Atom(atomic_number=94, symbol='Pu', mass_number='241', atomic_mass=241.056851719, natural_abundance=None),
         "242Pu": Atom(atomic_number=94, symbol='Pu', mass_number='242', atomic_mass=242.05874282, natural_abundance=None),
         "244Pu": Atom(atomic_number=94, symbol='Pu', mass_number='244', atomic_mass=244.064205356, natural_abundance=None),
         "241Am": Atom(atomic_number=95, symbol='Am', mass_number='241', atomic_mass=241.056829319, natural_abundance=None),
         "243Am": Atom(atomic_number=95, symbol='Am', mass_number='243', atomic_mass=243.061381324, natural_abundance=None),
         "243Cm": Atom(atomic_number=96, symbol='Cm', mass_number='243', atomic_mass=243.061389322, natural_abundance=None),
         "244Cm": Atom(atomic_number=96, symbol='Cm', mass_number='244', atomic_mass=244.062752819, natural_abundance=None),
         "245Cm": Atom(atomic_number=96, symbol='Cm', mass_number='245', atomic_mass=245.065491522, natural_abundance=None),
         "246Cm": Atom(atomic_number=96, symbol='Cm', mass_number='246', atomic_mass=246.067223822, natural_abundance=None),
         "247Cm": Atom(atomic_number=96, symbol='Cm', mass_number='247', atomic_mass=247.070354147, natural_abundance=None),
         "248Cm": Atom(atomic_number=96, symbol='Cm', mass_number='248', atomic_mass=248.072349956, natural_abundance=None),
         "247Bk": Atom(atomic_number=97, symbol='Bk', mass_number='247', atomic_mass=247.070307359, natural_abundance=None),
         "249Bk": Atom(atomic_number=97, symbol='Bk', mass_number='249', atomic_mass=249.074987727, natural_abundance=None),
         "249Cf": Atom(atomic_number=98, symbol='Cf', mass_number='249', atomic_mass=249.074853923, natural_abundance=None),
         "250Cf": Atom(atomic_number=98, symbol='Cf', mass_number='250', atomic_mass=250.076406222, natural_abundance=None),
         "251Cf": Atom(atomic_number=98, symbol='Cf', mass_number='251', atomic_mass=251.079588648, natural_abundance=None),
         "252Cf": Atom(atomic_number=98, symbol='Cf', mass_number='252', atomic_mass=252.081627256, natural_abundance=None),
         "252Es": Atom(atomic_number=99, symbol='Es', mass_number='252', atomic_mass=252.08298054, natural_abundance=None),
         "257Fm": Atom(atomic_number=100, symbol='Fm', mass_number='257', atomic_mass=257.095106169, natural_abundance=None),
         "258Md": Atom(atomic_number=101, symbol='Md', mass_number='258', atomic_mass=258.09843155, natural_abundance=None),
         "260Md": Atom(atomic_number=101, symbol='Md', mass_number='260', atomic_mass=260.1036534, natural_abundance=None),
         "259No": Atom(atomic_number=102, symbol='No', mass_number='259', atomic_mass=259.1010311, natural_abundance=None),
         "262Lr": Atom(atomic_number=103, symbol='Lr', mass_number='262', atomic_mass=262.1096122, natural_abundance=None),
         "267Rf": Atom(atomic_number=104, symbol='Rf', mass_number='267', atomic_mass=267.1217962, natural_abundance=None),
         "268Db": Atom(atomic_number=105, symbol='Db', mass_number='268', atomic_mass=268.1256757, natural_abundance=None),
         "271Sg": Atom(atomic_number=106, symbol='Sg', mass_number='271', atomic_mass=271.1339363, natural_abundance=None),
         "272Bh": Atom(atomic_number=107, symbol='Bh', mass_number='272', atomic_mass=272.1382658, natural_abundance=None),
         "270Hs": Atom(atomic_number=108, symbol='Hs', mass_number='270', atomic_mass=270.1342927, natural_abundance=None),
         "276Mt": Atom(atomic_number=109, symbol='Mt', mass_number='276', atomic_mass=276.1515959, natural_abundance=None),
         "281Ds": Atom(atomic_number=110, symbol='Ds', mass_number='281', atomic_mass=281.1645159, natural_abundance=None),
         "280Rg": Atom(atomic_number=111, symbol='Rg', mass_number='280', atomic_mass=280.1651461, natural_abundance=None),
         "285Cn": Atom(atomic_number=112, symbol='Cn', mass_number='285', atomic_mass=285.177126, natural_abundance=None),
         "284Nh": Atom(atomic_number=113, symbol='Nh', mass_number='284', atomic_mass=284.1787362, natural_abundance=None),
         "289Fl": Atom(atomic_number=114, symbol='Fl', mass_number='289', atomic_mass=289.190426, natural_abundance=None),
         "288Mc": Atom(atomic_number=115, symbol='Mc', mass_number='288', atomic_mass=288.1927462, natural_abundance=None),
         "293Lv": Atom(atomic_number=116, symbol='Lv', mass_number='293', atomic_mass=293.204496, natural_abundance=None),
         "292Ts": Atom(atomic_number=117, symbol='Ts', mass_number='292', atomic_mass=292.2074675, natural_abundance=None),
         "294Og": Atom(atomic_number=118, symbol='Og', mass_number='294', atomic_mass=294.2139271, natural_abundance=None)}
