# Copyright 2020 The tfaip authors. All Rights Reserved.
#
# This file is part of tfaip.
#
# tfaip is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by the
# Free Software Foundation, either version 3 of the License, or (at your
# option) any later version.
#
# tfaip is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
# more details.
#
# You should have received a copy of the GNU General Public License along with
# tfaip. If not, see http://www.gnu.org/licenses/.
# ==============================================================================
import tensorflow as tf


class NoisyIdentityInitializer(tf.keras.initializers.Initializer):
    def __init__(self, identity_weight=1, noise_weight=0.1):
        super().__init__()
        self.identity_weight = identity_weight
        self.noise_weight = noise_weight
        self.identity = tf.keras.initializers.Identity()
        self.glorot = tf.keras.initializers.GlorotUniform()

    def __call__(self, shape, dtype=None):
        return self.identity(shape, dtype) * self.identity_weight + self.glorot(shape, dtype) * self.noise_weight
