"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.timestamp_pb2
import google.protobuf.wrappers_pb2
import th2_grpc_common.common_pb2
import typing
import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _FilterParameterType:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType
class _FilterParameterTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_FilterParameterType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    NUMBER: _FilterParameterType.ValueType  # 0
    BOOLEAN: _FilterParameterType.ValueType  # 1
    STRING: _FilterParameterType.ValueType  # 2
    STRING_LIST: _FilterParameterType.ValueType  # 3
class FilterParameterType(_FilterParameterType, metaclass=_FilterParameterTypeEnumTypeWrapper):
    """Filtering data types

    """
    pass

NUMBER: FilterParameterType.ValueType  # 0
BOOLEAN: FilterParameterType.ValueType  # 1
STRING: FilterParameterType.ValueType  # 2
STRING_LIST: FilterParameterType.ValueType  # 3
global___FilterParameterType = FilterParameterType


class _TimeRelation:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType
class _TimeRelationEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_TimeRelation.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    NEXT: _TimeRelation.ValueType  # 0
    PREVIOUS: _TimeRelation.ValueType  # 1
class TimeRelation(_TimeRelation, metaclass=_TimeRelationEnumTypeWrapper):
    pass

NEXT: TimeRelation.ValueType  # 0
PREVIOUS: TimeRelation.ValueType  # 1
global___TimeRelation = TimeRelation


class EventData(google.protobuf.message.Message):
    """Full event data

    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    EVENT_ID_FIELD_NUMBER: builtins.int
    PARENT_EVENT_ID_FIELD_NUMBER: builtins.int
    BATCH_ID_FIELD_NUMBER: builtins.int
    IS_BATCHED_FIELD_NUMBER: builtins.int
    START_TIMESTAMP_FIELD_NUMBER: builtins.int
    END_TIMESTAMP_FIELD_NUMBER: builtins.int
    SUCCESSFUL_FIELD_NUMBER: builtins.int
    EVENT_NAME_FIELD_NUMBER: builtins.int
    EVENT_TYPE_FIELD_NUMBER: builtins.int
    BODY_FIELD_NUMBER: builtins.int
    ATTACHED_MESSAGE_IDS_FIELD_NUMBER: builtins.int
    @property
    def event_id(self) -> th2_grpc_common.common_pb2.EventID:
        """Current event id"""
        pass
    @property
    def parent_event_id(self) -> th2_grpc_common.common_pb2.EventID:
        """Event id of a parent event. It is absent for root event"""
        pass
    @property
    def batch_id(self) -> th2_grpc_common.common_pb2.EventID:
        """Event id of a parent event. It is absent for root event"""
        pass
    is_batched: builtins.bool
    """Flag indicating that the event is in batch"""

    @property
    def start_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def end_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """May be absent."""
        pass
    successful: th2_grpc_common.common_pb2.EventStatus.ValueType
    """Aggregated status of current and children events which sync written."""

    event_name: typing.Text
    event_type: typing.Text
    """May be absent."""

    body: builtins.bytes
    """May be absent."""

    @property
    def attached_message_ids(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[th2_grpc_common.common_pb2.MessageID]:
        """id of messages depending on this event"""
        pass
    def __init__(self,
        *,
        event_id: typing.Optional[th2_grpc_common.common_pb2.EventID] = ...,
        parent_event_id: typing.Optional[th2_grpc_common.common_pb2.EventID] = ...,
        batch_id: typing.Optional[th2_grpc_common.common_pb2.EventID] = ...,
        is_batched: builtins.bool = ...,
        start_timestamp: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        end_timestamp: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        successful: th2_grpc_common.common_pb2.EventStatus.ValueType = ...,
        event_name: typing.Text = ...,
        event_type: typing.Text = ...,
        body: builtins.bytes = ...,
        attached_message_ids: typing.Optional[typing.Iterable[th2_grpc_common.common_pb2.MessageID]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["batch_id",b"batch_id","end_timestamp",b"end_timestamp","event_id",b"event_id","parent_event_id",b"parent_event_id","start_timestamp",b"start_timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["attached_message_ids",b"attached_message_ids","batch_id",b"batch_id","body",b"body","end_timestamp",b"end_timestamp","event_id",b"event_id","event_name",b"event_name","event_type",b"event_type","is_batched",b"is_batched","parent_event_id",b"parent_event_id","start_timestamp",b"start_timestamp","successful",b"successful"]) -> None: ...
global___EventData = EventData

class EventMetadata(google.protobuf.message.Message):
    """Event metadata

    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    EVENT_ID_FIELD_NUMBER: builtins.int
    PARENT_EVENT_ID_FIELD_NUMBER: builtins.int
    START_TIMESTAMP_FIELD_NUMBER: builtins.int
    SUCCESSFUL_FIELD_NUMBER: builtins.int
    EVENT_NAME_FIELD_NUMBER: builtins.int
    EVENT_TYPE_FIELD_NUMBER: builtins.int
    @property
    def event_id(self) -> th2_grpc_common.common_pb2.EventID:
        """Current event id"""
        pass
    @property
    def parent_event_id(self) -> th2_grpc_common.common_pb2.EventID:
        """Event id of a parent event. It is absent for root event"""
        pass
    @property
    def start_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    successful: th2_grpc_common.common_pb2.EventStatus.ValueType
    """Aggregated status of current and children events which sync written."""

    event_name: typing.Text
    event_type: typing.Text
    def __init__(self,
        *,
        event_id: typing.Optional[th2_grpc_common.common_pb2.EventID] = ...,
        parent_event_id: typing.Optional[th2_grpc_common.common_pb2.EventID] = ...,
        start_timestamp: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        successful: th2_grpc_common.common_pb2.EventStatus.ValueType = ...,
        event_name: typing.Text = ...,
        event_type: typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["event_id",b"event_id","parent_event_id",b"parent_event_id","start_timestamp",b"start_timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["event_id",b"event_id","event_name",b"event_name","event_type",b"event_type","parent_event_id",b"parent_event_id","start_timestamp",b"start_timestamp","successful",b"successful"]) -> None: ...
global___EventMetadata = EventMetadata

class EventIds(google.protobuf.message.Message):
    """List of event ids

    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    IDS_FIELD_NUMBER: builtins.int
    @property
    def ids(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[th2_grpc_common.common_pb2.EventID]: ...
    def __init__(self,
        *,
        ids: typing.Optional[typing.Iterable[th2_grpc_common.common_pb2.EventID]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["ids",b"ids"]) -> None: ...
global___EventIds = EventIds

class Events(google.protobuf.message.Message):
    """List of event data

    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    EVENTS_FIELD_NUMBER: builtins.int
    @property
    def events(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___EventData]: ...
    def __init__(self,
        *,
        events: typing.Optional[typing.Iterable[global___EventData]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["events",b"events"]) -> None: ...
global___Events = Events

class MessageData(google.protobuf.message.Message):
    """Full event data

    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    MESSAGE_ID_FIELD_NUMBER: builtins.int
    SESSION_ID_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    MESSAGE_TYPE_FIELD_NUMBER: builtins.int
    BODY_FIELD_NUMBER: builtins.int
    BODY_BASE64_FIELD_NUMBER: builtins.int
    ATTACHED_EVENT_IDS_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    @property
    def message_id(self) -> th2_grpc_common.common_pb2.MessageID:
        """Message id should be unique in session"""
        pass
    @property
    def session_id(self) -> th2_grpc_common.common_pb2.ConnectionID:
        """Session alias"""
        pass
    direction: th2_grpc_common.common_pb2.Direction.ValueType
    """Transport direction."""

    @property
    def timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """Message creation timestamp"""
        pass
    message_type: typing.Text
    """Message type by dictionary"""

    body: typing.Text
    """May be absent."""

    body_base64: typing.Text
    """May be absent."""

    @property
    def attached_event_ids(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[th2_grpc_common.common_pb2.EventID]:
        """id of events depending on this message"""
        pass
    @property
    def message(self) -> th2_grpc_common.common_pb2.Message:
        """May be absent."""
        pass
    def __init__(self,
        *,
        message_id: typing.Optional[th2_grpc_common.common_pb2.MessageID] = ...,
        session_id: typing.Optional[th2_grpc_common.common_pb2.ConnectionID] = ...,
        direction: th2_grpc_common.common_pb2.Direction.ValueType = ...,
        timestamp: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        message_type: typing.Text = ...,
        body: typing.Text = ...,
        body_base64: typing.Text = ...,
        attached_event_ids: typing.Optional[typing.Iterable[th2_grpc_common.common_pb2.EventID]] = ...,
        message: typing.Optional[th2_grpc_common.common_pb2.Message] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["message",b"message","message_id",b"message_id","session_id",b"session_id","timestamp",b"timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["attached_event_ids",b"attached_event_ids","body",b"body","body_base64",b"body_base64","direction",b"direction","message",b"message","message_id",b"message_id","message_type",b"message_type","session_id",b"session_id","timestamp",b"timestamp"]) -> None: ...
global___MessageData = MessageData

class LastScannedObjectInfo(google.protobuf.message.Message):
    """Message and last scanned object. With a certain frequency (this can be configured in the configuration options),

    it is sent along with the elements found when searching via searchMessages

    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    ID_FIELD_NUMBER: builtins.int
    TIMESTAMP_MILLIS_FIELD_NUMBER: builtins.int
    SCAN_COUNTER_FIELD_NUMBER: builtins.int
    id: typing.Text
    """Id of last scanned message or event"""

    timestamp_millis: builtins.int
    """Timestamp of message or event"""

    scan_counter: builtins.int
    """Number of objects already scanned"""

    def __init__(self,
        *,
        id: typing.Text = ...,
        timestamp_millis: builtins.int = ...,
        scan_counter: builtins.int = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["id",b"id","scan_counter",b"scan_counter","timestamp_millis",b"timestamp_millis"]) -> None: ...
global___LastScannedObjectInfo = LastScannedObjectInfo

class StringList(google.protobuf.message.Message):
    """List of strings

    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    LIST_STRING_FIELD_NUMBER: builtins.int
    @property
    def list_string(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]: ...
    def __init__(self,
        *,
        list_string: typing.Optional[typing.Iterable[typing.Text]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["list_string",b"list_string"]) -> None: ...
global___StringList = StringList

class IsMatched(google.protobuf.message.Message):
    """Response of match request

    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    IS_MATCHED_FIELD_NUMBER: builtins.int
    is_matched: builtins.bool
    def __init__(self,
        *,
        is_matched: builtins.bool = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["is_matched",b"is_matched"]) -> None: ...
global___IsMatched = IsMatched

class FilterName(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    FILTER_NAME_FIELD_NUMBER: builtins.int
    filter_name: typing.Text
    def __init__(self,
        *,
        filter_name: typing.Text = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["filter_name",b"filter_name"]) -> None: ...
global___FilterName = FilterName

class ListFilterName(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    FILTER_NAMES_FIELD_NUMBER: builtins.int
    @property
    def filter_names(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FilterName]: ...
    def __init__(self,
        *,
        filter_names: typing.Optional[typing.Iterable[global___FilterName]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["filter_names",b"filter_names"]) -> None: ...
global___ListFilterName = ListFilterName

class Parameter(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    DEFAULT_VALUE_FIELD_NUMBER: builtins.int
    HINT_FIELD_NUMBER: builtins.int
    name: typing.Text
    type: global___FilterParameterType.ValueType
    @property
    def default_value(self) -> google.protobuf.any_pb2.Any: ...
    hint: typing.Text
    def __init__(self,
        *,
        name: typing.Text = ...,
        type: global___FilterParameterType.ValueType = ...,
        default_value: typing.Optional[google.protobuf.any_pb2.Any] = ...,
        hint: typing.Text = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["default_value",b"default_value"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["default_value",b"default_value","hint",b"hint","name",b"name","type",b"type"]) -> None: ...
global___Parameter = Parameter

class FilterInfo(google.protobuf.message.Message):
    """Complete information about a specific filter

    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NAME_FIELD_NUMBER: builtins.int
    HINT_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    @property
    def name(self) -> global___FilterName: ...
    hint: typing.Text
    @property
    def parameters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Parameter]: ...
    def __init__(self,
        *,
        name: typing.Optional[global___FilterName] = ...,
        hint: typing.Text = ...,
        parameters: typing.Optional[typing.Iterable[global___Parameter]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["name",b"name"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["hint",b"hint","name",b"name","parameters",b"parameters"]) -> None: ...
global___FilterInfo = FilterInfo

class Filter(google.protobuf.message.Message):
    """A filter object passed in a message or an event search request

    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    NAME_FIELD_NUMBER: builtins.int
    NEGATIVE_FIELD_NUMBER: builtins.int
    VALUES_FIELD_NUMBER: builtins.int
    CONJUNCT_FIELD_NUMBER: builtins.int
    @property
    def name(self) -> global___FilterName: ...
    @property
    def negative(self) -> google.protobuf.wrappers_pb2.BoolValue: ...
    @property
    def values(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[typing.Text]: ...
    @property
    def conjunct(self) -> google.protobuf.wrappers_pb2.BoolValue: ...
    def __init__(self,
        *,
        name: typing.Optional[global___FilterName] = ...,
        negative: typing.Optional[google.protobuf.wrappers_pb2.BoolValue] = ...,
        values: typing.Optional[typing.Iterable[typing.Text]] = ...,
        conjunct: typing.Optional[google.protobuf.wrappers_pb2.BoolValue] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["conjunct",b"conjunct","name",b"name","negative",b"negative"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["conjunct",b"conjunct","name",b"name","negative",b"negative","values",b"values"]) -> None: ...
global___Filter = Filter

class Stream(google.protobuf.message.Message):
    """The object containing the data of the last message in the stream on which
    the search stopped, it is necessary to continue the search from the same place

    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    SESSION_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    LAST_ID_FIELD_NUMBER: builtins.int
    session: typing.Text
    direction: th2_grpc_common.common_pb2.Direction.ValueType
    @property
    def last_id(self) -> th2_grpc_common.common_pb2.MessageID:
        """May be absent if there are no more messages in the stream with the specified session and direction"""
        pass
    def __init__(self,
        *,
        session: typing.Text = ...,
        direction: th2_grpc_common.common_pb2.Direction.ValueType = ...,
        last_id: typing.Optional[th2_grpc_common.common_pb2.MessageID] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["last_id",b"last_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["direction",b"direction","last_id",b"last_id","session",b"session"]) -> None: ...
global___Stream = Stream

class StreamsInfo(google.protobuf.message.Message):
    """List of Stream objects containing information about all the streams

    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    STREAMS_FIELD_NUMBER: builtins.int
    @property
    def streams(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Stream]: ...
    def __init__(self,
        *,
        streams: typing.Optional[typing.Iterable[global___Stream]] = ...,
        ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["streams",b"streams"]) -> None: ...
global___StreamsInfo = StreamsInfo

class MatchRequest(google.protobuf.message.Message):
    """Checks that an event or a message with the specified id is matched by the filters

    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    EVENT_ID_FIELD_NUMBER: builtins.int
    MESSAGE_ID_FIELD_NUMBER: builtins.int
    FILTERS_FIELD_NUMBER: builtins.int
    @property
    def event_id(self) -> th2_grpc_common.common_pb2.EventID: ...
    @property
    def message_id(self) -> th2_grpc_common.common_pb2.MessageID: ...
    @property
    def filters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Filter]: ...
    def __init__(self,
        *,
        event_id: typing.Optional[th2_grpc_common.common_pb2.EventID] = ...,
        message_id: typing.Optional[th2_grpc_common.common_pb2.MessageID] = ...,
        filters: typing.Optional[typing.Iterable[global___Filter]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["event_id",b"event_id","id",b"id","message_id",b"message_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["event_id",b"event_id","filters",b"filters","id",b"id","message_id",b"message_id"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["id",b"id"]) -> typing.Optional[typing_extensions.Literal["event_id","message_id"]]: ...
global___MatchRequest = MatchRequest

class EventSearchRequest(google.protobuf.message.Message):
    """Event search request

    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    START_TIMESTAMP_FIELD_NUMBER: builtins.int
    END_TIMESTAMP_FIELD_NUMBER: builtins.int
    PARENT_EVENT_FIELD_NUMBER: builtins.int
    SEARCH_DIRECTION_FIELD_NUMBER: builtins.int
    RESUME_FROM_ID_FIELD_NUMBER: builtins.int
    RESULT_COUNT_LIMIT_FIELD_NUMBER: builtins.int
    KEEP_OPEN_FIELD_NUMBER: builtins.int
    LIMIT_FOR_PARENT_FIELD_NUMBER: builtins.int
    METADATA_ONLY_FIELD_NUMBER: builtins.int
    ATTACHED_MESSAGES_FIELD_NUMBER: builtins.int
    FILTERS_FIELD_NUMBER: builtins.int
    @property
    def start_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """unix timestamp - Sets the search starting point. One of the 'start_timestamp' or 'resume_from_id' must not absent"""
        pass
    @property
    def end_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """unix timestamp - Sets the timestamp to which the search will be performed, starting with 'start_timestamp'. When 'search_direction' is previous, end_timestamp must be less than start_timestamp. By default it is absent (the search is carried out endlessly into the past or into the future)."""
        pass
    @property
    def parent_event(self) -> th2_grpc_common.common_pb2.EventID:
        """Will match events with the specified parent element."""
        pass
    search_direction: global___TimeRelation.ValueType
    """Sets the lookup direction. Can be used for pagination. Set by default to NEXT."""

    @property
    def resume_from_id(self) -> th2_grpc_common.common_pb2.EventID:
        """last event id. In order to continue the execution of an interrupted sse request, you need to send exactly the same request with an indication of the element ID, from which the data transfer will be resumed. By default it is absent. One of the 'start_timestamp' or 'resume_from_id' must not absent"""
        pass
    @property
    def result_count_limit(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """Sets the maximum amount of events to return. By default it is absent (unlimited)."""
        pass
    @property
    def keep_open(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """If the search has reached the current moment, it is necessary to wait further for the appearance of new data. Set to false by default."""
        pass
    @property
    def limit_for_parent(self) -> google.protobuf.wrappers_pb2.Int64Value:
        """How many children events for each parent do we want to request. By default it is absent (unlimited)."""
        pass
    @property
    def metadata_only(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """ Receive only metadata (true) or entire event (false) (without attachedMessageIds). Set by default to true."""
        pass
    @property
    def attached_messages(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """If the metadataOnly is false, it will additionally load attachedMessageIds. Set by default to false."""
        pass
    @property
    def filters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Filter]:
        """List of event search filters. (See 'search/sse/events' HTTP method https://github.com/th2-net/th2-rpt-data-provider)"""
        pass
    def __init__(self,
        *,
        start_timestamp: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        end_timestamp: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        parent_event: typing.Optional[th2_grpc_common.common_pb2.EventID] = ...,
        search_direction: global___TimeRelation.ValueType = ...,
        resume_from_id: typing.Optional[th2_grpc_common.common_pb2.EventID] = ...,
        result_count_limit: typing.Optional[google.protobuf.wrappers_pb2.Int32Value] = ...,
        keep_open: typing.Optional[google.protobuf.wrappers_pb2.BoolValue] = ...,
        limit_for_parent: typing.Optional[google.protobuf.wrappers_pb2.Int64Value] = ...,
        metadata_only: typing.Optional[google.protobuf.wrappers_pb2.BoolValue] = ...,
        attached_messages: typing.Optional[google.protobuf.wrappers_pb2.BoolValue] = ...,
        filters: typing.Optional[typing.Iterable[global___Filter]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["attached_messages",b"attached_messages","end_timestamp",b"end_timestamp","keep_open",b"keep_open","limit_for_parent",b"limit_for_parent","metadata_only",b"metadata_only","parent_event",b"parent_event","result_count_limit",b"result_count_limit","resume_from_id",b"resume_from_id","start_timestamp",b"start_timestamp"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["attached_messages",b"attached_messages","end_timestamp",b"end_timestamp","filters",b"filters","keep_open",b"keep_open","limit_for_parent",b"limit_for_parent","metadata_only",b"metadata_only","parent_event",b"parent_event","result_count_limit",b"result_count_limit","resume_from_id",b"resume_from_id","search_direction",b"search_direction","start_timestamp",b"start_timestamp"]) -> None: ...
global___EventSearchRequest = EventSearchRequest

class MessageSearchRequest(google.protobuf.message.Message):
    """Message search request

    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    START_TIMESTAMP_FIELD_NUMBER: builtins.int
    END_TIMESTAMP_FIELD_NUMBER: builtins.int
    RESUME_FROM_ID_FIELD_NUMBER: builtins.int
    SEARCH_DIRECTION_FIELD_NUMBER: builtins.int
    RESULT_COUNT_LIMIT_FIELD_NUMBER: builtins.int
    STREAM_FIELD_NUMBER: builtins.int
    KEEP_OPEN_FIELD_NUMBER: builtins.int
    MESSAGE_ID_FIELD_NUMBER: builtins.int
    ATTACHED_EVENTS_FIELD_NUMBER: builtins.int
    FILTERS_FIELD_NUMBER: builtins.int
    @property
    def start_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """unix timestamp - Sets the search starting point. One of the 'start_timestamp' or 'resume_from_id' or 'message_id' must not absent"""
        pass
    @property
    def end_timestamp(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """unix timestamp - Sets the timestamp to which the search will be performed, starting with 'start_timestamp'. When search_direction is 'previous', 'end_timestamp' must be less than 'start_timestamp'. By default it is absent (the search is carried out endlessly into the past or into the future)."""
        pass
    @property
    def resume_from_id(self) -> th2_grpc_common.common_pb2.MessageID:
        """last message id. In order to continue the execution of an interrupted search request, you need to send exactly the same request with an indication of the element ID, from which the data transfer will be resumed.  By default it is absent. One of the 'start_timestamp' or 'resume_fromId' or 'message_id' must not absent"""
        pass
    search_direction: global___TimeRelation.ValueType
    """Sets the lookup direction. Can be used for pagination. Set by default to NEXT."""

    @property
    def result_count_limit(self) -> google.protobuf.wrappers_pb2.Int32Value:
        """Sets the maximum amount of messages to return. By default it is absent (unlimited)"""
        pass
    @property
    def stream(self) -> global___StringList:
        """Sets the stream ids to search in. Case-sensitive. Required."""
        pass
    @property
    def keep_open(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """ If the search has reached the current moment, it is necessary to wait further for the appearance of new data. Set by default to false."""
        pass
    @property
    def message_id(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[th2_grpc_common.common_pb2.MessageID]:
        """List of message IDs to restore the search. If given, it has the highest priority and ignores 'stream' (uses streams from the ids), 'start_timestamp' and 'resume_fromId'. By default it is absent."""
        pass
    @property
    def attached_events(self) -> google.protobuf.wrappers_pb2.BoolValue:
        """If true, it will additionally load attachedEventsIds. Set by default to false."""
        pass
    @property
    def filters(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Filter]:
        """List of message search filters. (See 'search/sse/message' HTTP method https://github.com/th2-net/th2-rpt-data-provider)"""
        pass
    def __init__(self,
        *,
        start_timestamp: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        end_timestamp: typing.Optional[google.protobuf.timestamp_pb2.Timestamp] = ...,
        resume_from_id: typing.Optional[th2_grpc_common.common_pb2.MessageID] = ...,
        search_direction: global___TimeRelation.ValueType = ...,
        result_count_limit: typing.Optional[google.protobuf.wrappers_pb2.Int32Value] = ...,
        stream: typing.Optional[global___StringList] = ...,
        keep_open: typing.Optional[google.protobuf.wrappers_pb2.BoolValue] = ...,
        message_id: typing.Optional[typing.Iterable[th2_grpc_common.common_pb2.MessageID]] = ...,
        attached_events: typing.Optional[google.protobuf.wrappers_pb2.BoolValue] = ...,
        filters: typing.Optional[typing.Iterable[global___Filter]] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["attached_events",b"attached_events","end_timestamp",b"end_timestamp","keep_open",b"keep_open","result_count_limit",b"result_count_limit","resume_from_id",b"resume_from_id","start_timestamp",b"start_timestamp","stream",b"stream"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["attached_events",b"attached_events","end_timestamp",b"end_timestamp","filters",b"filters","keep_open",b"keep_open","message_id",b"message_id","result_count_limit",b"result_count_limit","resume_from_id",b"resume_from_id","search_direction",b"search_direction","start_timestamp",b"start_timestamp","stream",b"stream"]) -> None: ...
global___MessageSearchRequest = MessageSearchRequest

class StreamResponse(google.protobuf.message.Message):
    """The object returned by the search function (searchMessages/searchEvents)

    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    EVENT_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    EVENT_METADATA_FIELD_NUMBER: builtins.int
    LAST_SCANNED_OBJECT_FIELD_NUMBER: builtins.int
    STREAM_INFO_FIELD_NUMBER: builtins.int
    @property
    def event(self) -> global___EventData: ...
    @property
    def message(self) -> global___MessageData: ...
    @property
    def event_metadata(self) -> global___EventMetadata: ...
    @property
    def last_scanned_object(self) -> global___LastScannedObjectInfo: ...
    @property
    def stream_info(self) -> global___StreamsInfo: ...
    def __init__(self,
        *,
        event: typing.Optional[global___EventData] = ...,
        message: typing.Optional[global___MessageData] = ...,
        event_metadata: typing.Optional[global___EventMetadata] = ...,
        last_scanned_object: typing.Optional[global___LastScannedObjectInfo] = ...,
        stream_info: typing.Optional[global___StreamsInfo] = ...,
        ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["data",b"data","event",b"event","event_metadata",b"event_metadata","last_scanned_object",b"last_scanned_object","message",b"message","stream_info",b"stream_info"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["data",b"data","event",b"event","event_metadata",b"event_metadata","last_scanned_object",b"last_scanned_object","message",b"message","stream_info",b"stream_info"]) -> None: ...
    def WhichOneof(self, oneof_group: typing_extensions.Literal["data",b"data"]) -> typing.Optional[typing_extensions.Literal["event","message","event_metadata","last_scanned_object","stream_info"]]: ...
global___StreamResponse = StreamResponse
