"""
    Keycloak Admin REST API

    This is a REST API reference for the Keycloak Admin  # noqa: E501

    The version of the OpenAPI document: 17.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from keycloak_api.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from keycloak_api.exceptions import ApiAttributeError


def lazy_import():
    from keycloak_api.model.access_token_access import AccessTokenAccess
    from keycloak_api.model.access_token_authorization import AccessTokenAuthorization
    from keycloak_api.model.access_token_cert_conf import AccessTokenCertConf
    from keycloak_api.model.address_claim_set import AddressClaimSet
    globals()['AccessTokenAccess'] = AccessTokenAccess
    globals()['AccessTokenAuthorization'] = AccessTokenAuthorization
    globals()['AccessTokenCertConf'] = AccessTokenCertConf
    globals()['AddressClaimSet'] = AddressClaimSet


class AccessToken(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('category',): {
            'INTERNAL': "INTERNAL",
            'ACCESS': "ACCESS",
            'ID': "ID",
            'ADMIN': "ADMIN",
            'USERINFO': "USERINFO",
            'LOGOUT': "LOGOUT",
            'AUTHORIZATION_RESPONSE': "AUTHORIZATION_RESPONSE",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'acr': (str,),  # noqa: E501
            'address': (AddressClaimSet,),  # noqa: E501
            'allowed_origins': ([str],),  # noqa: E501
            'at_hash': (str,),  # noqa: E501
            'auth_time': (int,),  # noqa: E501
            'authorization': (AccessTokenAuthorization,),  # noqa: E501
            'azp': (str,),  # noqa: E501
            'birthdate': (str,),  # noqa: E501
            'c_hash': (str,),  # noqa: E501
            'category': (str,),  # noqa: E501
            'claims_locales': (str,),  # noqa: E501
            'cnf': (AccessTokenCertConf,),  # noqa: E501
            'email': (str,),  # noqa: E501
            'email_verified': (bool,),  # noqa: E501
            'exp': (int,),  # noqa: E501
            'family_name': (str,),  # noqa: E501
            'gender': (str,),  # noqa: E501
            'given_name': (str,),  # noqa: E501
            'iat': (int,),  # noqa: E501
            'iss': (str,),  # noqa: E501
            'jti': (str,),  # noqa: E501
            'locale': (str,),  # noqa: E501
            'middle_name': (str,),  # noqa: E501
            'name': (str,),  # noqa: E501
            'nbf': (int,),  # noqa: E501
            'nickname': (str,),  # noqa: E501
            'nonce': (str,),  # noqa: E501
            'other_claims': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),  # noqa: E501
            'phone_number': (str,),  # noqa: E501
            'phone_number_verified': (bool,),  # noqa: E501
            'picture': (str,),  # noqa: E501
            'preferred_username': (str,),  # noqa: E501
            'profile': (str,),  # noqa: E501
            'realm_access': (AccessTokenAccess,),  # noqa: E501
            's_hash': (str,),  # noqa: E501
            'scope': (str,),  # noqa: E501
            'session_state': (str,),  # noqa: E501
            'sid': (str,),  # noqa: E501
            'sub': (str,),  # noqa: E501
            'trusted_certs': ([str],),  # noqa: E501
            'typ': (str,),  # noqa: E501
            'updated_at': (int,),  # noqa: E501
            'website': (str,),  # noqa: E501
            'zoneinfo': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'acr': 'acr',  # noqa: E501
        'address': 'address',  # noqa: E501
        'allowed_origins': 'allowed-origins',  # noqa: E501
        'at_hash': 'at_hash',  # noqa: E501
        'auth_time': 'auth_time',  # noqa: E501
        'authorization': 'authorization',  # noqa: E501
        'azp': 'azp',  # noqa: E501
        'birthdate': 'birthdate',  # noqa: E501
        'c_hash': 'c_hash',  # noqa: E501
        'category': 'category',  # noqa: E501
        'claims_locales': 'claims_locales',  # noqa: E501
        'cnf': 'cnf',  # noqa: E501
        'email': 'email',  # noqa: E501
        'email_verified': 'email_verified',  # noqa: E501
        'exp': 'exp',  # noqa: E501
        'family_name': 'family_name',  # noqa: E501
        'gender': 'gender',  # noqa: E501
        'given_name': 'given_name',  # noqa: E501
        'iat': 'iat',  # noqa: E501
        'iss': 'iss',  # noqa: E501
        'jti': 'jti',  # noqa: E501
        'locale': 'locale',  # noqa: E501
        'middle_name': 'middle_name',  # noqa: E501
        'name': 'name',  # noqa: E501
        'nbf': 'nbf',  # noqa: E501
        'nickname': 'nickname',  # noqa: E501
        'nonce': 'nonce',  # noqa: E501
        'other_claims': 'otherClaims',  # noqa: E501
        'phone_number': 'phone_number',  # noqa: E501
        'phone_number_verified': 'phone_number_verified',  # noqa: E501
        'picture': 'picture',  # noqa: E501
        'preferred_username': 'preferred_username',  # noqa: E501
        'profile': 'profile',  # noqa: E501
        'realm_access': 'realm_access',  # noqa: E501
        's_hash': 's_hash',  # noqa: E501
        'scope': 'scope',  # noqa: E501
        'session_state': 'session_state',  # noqa: E501
        'sid': 'sid',  # noqa: E501
        'sub': 'sub',  # noqa: E501
        'trusted_certs': 'trusted-certs',  # noqa: E501
        'typ': 'typ',  # noqa: E501
        'updated_at': 'updated_at',  # noqa: E501
        'website': 'website',  # noqa: E501
        'zoneinfo': 'zoneinfo',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """AccessToken - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            acr (str): [optional]  # noqa: E501
            address (AddressClaimSet): [optional]  # noqa: E501
            allowed_origins ([str]): [optional]  # noqa: E501
            at_hash (str): [optional]  # noqa: E501
            auth_time (int): [optional]  # noqa: E501
            authorization (AccessTokenAuthorization): [optional]  # noqa: E501
            azp (str): [optional]  # noqa: E501
            birthdate (str): [optional]  # noqa: E501
            c_hash (str): [optional]  # noqa: E501
            category (str): [optional]  # noqa: E501
            claims_locales (str): [optional]  # noqa: E501
            cnf (AccessTokenCertConf): [optional]  # noqa: E501
            email (str): [optional]  # noqa: E501
            email_verified (bool): [optional]  # noqa: E501
            exp (int): [optional]  # noqa: E501
            family_name (str): [optional]  # noqa: E501
            gender (str): [optional]  # noqa: E501
            given_name (str): [optional]  # noqa: E501
            iat (int): [optional]  # noqa: E501
            iss (str): [optional]  # noqa: E501
            jti (str): [optional]  # noqa: E501
            locale (str): [optional]  # noqa: E501
            middle_name (str): [optional]  # noqa: E501
            name (str): [optional]  # noqa: E501
            nbf (int): [optional]  # noqa: E501
            nickname (str): [optional]  # noqa: E501
            nonce (str): [optional]  # noqa: E501
            other_claims ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]  # noqa: E501
            phone_number (str): [optional]  # noqa: E501
            phone_number_verified (bool): [optional]  # noqa: E501
            picture (str): [optional]  # noqa: E501
            preferred_username (str): [optional]  # noqa: E501
            profile (str): [optional]  # noqa: E501
            realm_access (AccessTokenAccess): [optional]  # noqa: E501
            s_hash (str): [optional]  # noqa: E501
            scope (str): [optional]  # noqa: E501
            session_state (str): [optional]  # noqa: E501
            sid (str): [optional]  # noqa: E501
            sub (str): [optional]  # noqa: E501
            trusted_certs ([str]): [optional]  # noqa: E501
            typ (str): [optional]  # noqa: E501
            updated_at (int): [optional]  # noqa: E501
            website (str): [optional]  # noqa: E501
            zoneinfo (str): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """AccessToken - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            acr (str): [optional]  # noqa: E501
            address (AddressClaimSet): [optional]  # noqa: E501
            allowed_origins ([str]): [optional]  # noqa: E501
            at_hash (str): [optional]  # noqa: E501
            auth_time (int): [optional]  # noqa: E501
            authorization (AccessTokenAuthorization): [optional]  # noqa: E501
            azp (str): [optional]  # noqa: E501
            birthdate (str): [optional]  # noqa: E501
            c_hash (str): [optional]  # noqa: E501
            category (str): [optional]  # noqa: E501
            claims_locales (str): [optional]  # noqa: E501
            cnf (AccessTokenCertConf): [optional]  # noqa: E501
            email (str): [optional]  # noqa: E501
            email_verified (bool): [optional]  # noqa: E501
            exp (int): [optional]  # noqa: E501
            family_name (str): [optional]  # noqa: E501
            gender (str): [optional]  # noqa: E501
            given_name (str): [optional]  # noqa: E501
            iat (int): [optional]  # noqa: E501
            iss (str): [optional]  # noqa: E501
            jti (str): [optional]  # noqa: E501
            locale (str): [optional]  # noqa: E501
            middle_name (str): [optional]  # noqa: E501
            name (str): [optional]  # noqa: E501
            nbf (int): [optional]  # noqa: E501
            nickname (str): [optional]  # noqa: E501
            nonce (str): [optional]  # noqa: E501
            other_claims ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): [optional]  # noqa: E501
            phone_number (str): [optional]  # noqa: E501
            phone_number_verified (bool): [optional]  # noqa: E501
            picture (str): [optional]  # noqa: E501
            preferred_username (str): [optional]  # noqa: E501
            profile (str): [optional]  # noqa: E501
            realm_access (AccessTokenAccess): [optional]  # noqa: E501
            s_hash (str): [optional]  # noqa: E501
            scope (str): [optional]  # noqa: E501
            session_state (str): [optional]  # noqa: E501
            sid (str): [optional]  # noqa: E501
            sub (str): [optional]  # noqa: E501
            trusted_certs ([str]): [optional]  # noqa: E501
            typ (str): [optional]  # noqa: E501
            updated_at (int): [optional]  # noqa: E501
            website (str): [optional]  # noqa: E501
            zoneinfo (str): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
