"""
    Keycloak Admin REST API

    This is a REST API reference for the Keycloak Admin  # noqa: E501

    The version of the OpenAPI document: 17.0
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from keycloak_api.api_client import ApiClient, Endpoint as _Endpoint
from keycloak_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from keycloak_api.model.authentication_execution_info_representation import AuthenticationExecutionInfoRepresentation
from keycloak_api.model.authentication_execution_representation import AuthenticationExecutionRepresentation
from keycloak_api.model.authentication_flow_representation import AuthenticationFlowRepresentation
from keycloak_api.model.authenticator_config_info_representation import AuthenticatorConfigInfoRepresentation
from keycloak_api.model.authenticator_config_representation import AuthenticatorConfigRepresentation
from keycloak_api.model.required_action_provider_representation import RequiredActionProviderRepresentation


class AuthenticationManagementApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.realm_authentication_authenticator_providers_get_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}],),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/authenticator-providers',
                'operation_id': 'realm_authentication_authenticator_providers_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                ],
                'required': [
                    'realm',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                },
                'location_map': {
                    'realm': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_authentication_client_authenticator_providers_get_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}],),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/client-authenticator-providers',
                'operation_id': 'realm_authentication_client_authenticator_providers_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                ],
                'required': [
                    'realm',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                },
                'location_map': {
                    'realm': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_authentication_config_description_provider_id_get_endpoint = _Endpoint(
            settings={
                'response_type': (AuthenticatorConfigInfoRepresentation,),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/config-description/{providerId}',
                'operation_id': 'realm_authentication_config_description_provider_id_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'provider_id',
                ],
                'required': [
                    'realm',
                    'provider_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'provider_id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'provider_id': 'providerId',
                },
                'location_map': {
                    'realm': 'path',
                    'provider_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_authentication_config_id_delete_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/config/{id}',
                'operation_id': 'realm_authentication_config_id_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                ],
                'required': [
                    'realm',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_authentication_config_id_get_endpoint = _Endpoint(
            settings={
                'response_type': (AuthenticatorConfigRepresentation,),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/config/{id}',
                'operation_id': 'realm_authentication_config_id_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                ],
                'required': [
                    'realm',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_authentication_config_id_put_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/config/{id}',
                'operation_id': 'realm_authentication_config_id_put',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                    'authenticator_config_representation',
                ],
                'required': [
                    'realm',
                    'id',
                    'authenticator_config_representation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                    'authenticator_config_representation':
                        (AuthenticatorConfigRepresentation,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                    'authenticator_config_representation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.realm_authentication_executions_execution_id_config_post_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/executions/{executionId}/config',
                'operation_id': 'realm_authentication_executions_execution_id_config_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'execution_id',
                    'authenticator_config_representation',
                ],
                'required': [
                    'realm',
                    'execution_id',
                    'authenticator_config_representation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'execution_id':
                        (str,),
                    'authenticator_config_representation':
                        (AuthenticatorConfigRepresentation,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'execution_id': 'executionId',
                },
                'location_map': {
                    'realm': 'path',
                    'execution_id': 'path',
                    'authenticator_config_representation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.realm_authentication_executions_execution_id_delete_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/executions/{executionId}',
                'operation_id': 'realm_authentication_executions_execution_id_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'execution_id',
                ],
                'required': [
                    'realm',
                    'execution_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'execution_id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'execution_id': 'executionId',
                },
                'location_map': {
                    'realm': 'path',
                    'execution_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_authentication_executions_execution_id_get_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/executions/{executionId}',
                'operation_id': 'realm_authentication_executions_execution_id_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'execution_id',
                ],
                'required': [
                    'realm',
                    'execution_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'execution_id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'execution_id': 'executionId',
                },
                'location_map': {
                    'realm': 'path',
                    'execution_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_authentication_executions_execution_id_lower_priority_post_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/executions/{executionId}/lower-priority',
                'operation_id': 'realm_authentication_executions_execution_id_lower_priority_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'execution_id',
                ],
                'required': [
                    'realm',
                    'execution_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'execution_id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'execution_id': 'executionId',
                },
                'location_map': {
                    'realm': 'path',
                    'execution_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_authentication_executions_execution_id_raise_priority_post_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/executions/{executionId}/raise-priority',
                'operation_id': 'realm_authentication_executions_execution_id_raise_priority_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'execution_id',
                ],
                'required': [
                    'realm',
                    'execution_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'execution_id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'execution_id': 'executionId',
                },
                'location_map': {
                    'realm': 'path',
                    'execution_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_authentication_executions_post_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/executions',
                'operation_id': 'realm_authentication_executions_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'authentication_execution_representation',
                ],
                'required': [
                    'realm',
                    'authentication_execution_representation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'authentication_execution_representation':
                        (AuthenticationExecutionRepresentation,),
                },
                'attribute_map': {
                    'realm': 'realm',
                },
                'location_map': {
                    'realm': 'path',
                    'authentication_execution_representation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.realm_authentication_flows_flow_alias_copy_post_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/flows/{flowAlias}/copy',
                'operation_id': 'realm_authentication_flows_flow_alias_copy_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'flow_alias',
                    'request_body',
                ],
                'required': [
                    'realm',
                    'flow_alias',
                    'request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'flow_alias':
                        (str,),
                    'request_body':
                        ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'flow_alias': 'flowAlias',
                },
                'location_map': {
                    'realm': 'path',
                    'flow_alias': 'path',
                    'request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.realm_authentication_flows_flow_alias_executions_execution_post_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/flows/{flowAlias}/executions/execution',
                'operation_id': 'realm_authentication_flows_flow_alias_executions_execution_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'flow_alias',
                    'request_body',
                ],
                'required': [
                    'realm',
                    'flow_alias',
                    'request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'flow_alias':
                        (str,),
                    'request_body':
                        ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'flow_alias': 'flowAlias',
                },
                'location_map': {
                    'realm': 'path',
                    'flow_alias': 'path',
                    'request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.realm_authentication_flows_flow_alias_executions_flow_post_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/flows/{flowAlias}/executions/flow',
                'operation_id': 'realm_authentication_flows_flow_alias_executions_flow_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'flow_alias',
                    'request_body',
                ],
                'required': [
                    'realm',
                    'flow_alias',
                    'request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'flow_alias':
                        (str,),
                    'request_body':
                        ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'flow_alias': 'flowAlias',
                },
                'location_map': {
                    'realm': 'path',
                    'flow_alias': 'path',
                    'request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.realm_authentication_flows_flow_alias_executions_get_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/flows/{flowAlias}/executions',
                'operation_id': 'realm_authentication_flows_flow_alias_executions_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'flow_alias',
                ],
                'required': [
                    'realm',
                    'flow_alias',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'flow_alias':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'flow_alias': 'flowAlias',
                },
                'location_map': {
                    'realm': 'path',
                    'flow_alias': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_authentication_flows_flow_alias_executions_put_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/flows/{flowAlias}/executions',
                'operation_id': 'realm_authentication_flows_flow_alias_executions_put',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'flow_alias',
                    'authentication_execution_info_representation',
                ],
                'required': [
                    'realm',
                    'flow_alias',
                    'authentication_execution_info_representation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'flow_alias':
                        (str,),
                    'authentication_execution_info_representation':
                        (AuthenticationExecutionInfoRepresentation,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'flow_alias': 'flowAlias',
                },
                'location_map': {
                    'realm': 'path',
                    'flow_alias': 'path',
                    'authentication_execution_info_representation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.realm_authentication_flows_get_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}],),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/flows',
                'operation_id': 'realm_authentication_flows_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                ],
                'required': [
                    'realm',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                },
                'location_map': {
                    'realm': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_authentication_flows_id_delete_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/flows/{id}',
                'operation_id': 'realm_authentication_flows_id_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                ],
                'required': [
                    'realm',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_authentication_flows_id_get_endpoint = _Endpoint(
            settings={
                'response_type': (AuthenticationFlowRepresentation,),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/flows/{id}',
                'operation_id': 'realm_authentication_flows_id_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                ],
                'required': [
                    'realm',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_authentication_flows_id_put_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/flows/{id}',
                'operation_id': 'realm_authentication_flows_id_put',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'id',
                    'authentication_flow_representation',
                ],
                'required': [
                    'realm',
                    'id',
                    'authentication_flow_representation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'id':
                        (str,),
                    'authentication_flow_representation':
                        (AuthenticationFlowRepresentation,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'id': 'id',
                },
                'location_map': {
                    'realm': 'path',
                    'id': 'path',
                    'authentication_flow_representation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.realm_authentication_flows_post_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/flows',
                'operation_id': 'realm_authentication_flows_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'authentication_flow_representation',
                ],
                'required': [
                    'realm',
                    'authentication_flow_representation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'authentication_flow_representation':
                        (AuthenticationFlowRepresentation,),
                },
                'attribute_map': {
                    'realm': 'realm',
                },
                'location_map': {
                    'realm': 'path',
                    'authentication_flow_representation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.realm_authentication_form_action_providers_get_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}],),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/form-action-providers',
                'operation_id': 'realm_authentication_form_action_providers_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                ],
                'required': [
                    'realm',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                },
                'location_map': {
                    'realm': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_authentication_form_providers_get_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}],),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/form-providers',
                'operation_id': 'realm_authentication_form_providers_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                ],
                'required': [
                    'realm',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                },
                'location_map': {
                    'realm': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_authentication_per_client_config_description_get_endpoint = _Endpoint(
            settings={
                'response_type': ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/per-client-config-description',
                'operation_id': 'realm_authentication_per_client_config_description_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                ],
                'required': [
                    'realm',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                },
                'location_map': {
                    'realm': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_authentication_register_required_action_post_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/register-required-action',
                'operation_id': 'realm_authentication_register_required_action_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'request_body',
                ],
                'required': [
                    'realm',
                    'request_body',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'request_body':
                        ({str: (bool, date, datetime, dict, float, int, list, str, none_type)},),
                },
                'attribute_map': {
                    'realm': 'realm',
                },
                'location_map': {
                    'realm': 'path',
                    'request_body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.realm_authentication_required_actions_alias_delete_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/required-actions/{alias}',
                'operation_id': 'realm_authentication_required_actions_alias_delete',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'alias',
                ],
                'required': [
                    'realm',
                    'alias',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'alias':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'alias': 'alias',
                },
                'location_map': {
                    'realm': 'path',
                    'alias': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_authentication_required_actions_alias_get_endpoint = _Endpoint(
            settings={
                'response_type': (RequiredActionProviderRepresentation,),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/required-actions/{alias}',
                'operation_id': 'realm_authentication_required_actions_alias_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'alias',
                ],
                'required': [
                    'realm',
                    'alias',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'alias':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'alias': 'alias',
                },
                'location_map': {
                    'realm': 'path',
                    'alias': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_authentication_required_actions_alias_lower_priority_post_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/required-actions/{alias}/lower-priority',
                'operation_id': 'realm_authentication_required_actions_alias_lower_priority_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'alias',
                ],
                'required': [
                    'realm',
                    'alias',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'alias':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'alias': 'alias',
                },
                'location_map': {
                    'realm': 'path',
                    'alias': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_authentication_required_actions_alias_put_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/required-actions/{alias}',
                'operation_id': 'realm_authentication_required_actions_alias_put',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'alias',
                    'required_action_provider_representation',
                ],
                'required': [
                    'realm',
                    'alias',
                    'required_action_provider_representation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'alias':
                        (str,),
                    'required_action_provider_representation':
                        (RequiredActionProviderRepresentation,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'alias': 'alias',
                },
                'location_map': {
                    'realm': 'path',
                    'alias': 'path',
                    'required_action_provider_representation': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.realm_authentication_required_actions_alias_raise_priority_post_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/required-actions/{alias}/raise-priority',
                'operation_id': 'realm_authentication_required_actions_alias_raise_priority_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                    'alias',
                ],
                'required': [
                    'realm',
                    'alias',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                    'alias':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                    'alias': 'alias',
                },
                'location_map': {
                    'realm': 'path',
                    'alias': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_authentication_required_actions_get_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}],),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/required-actions',
                'operation_id': 'realm_authentication_required_actions_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                ],
                'required': [
                    'realm',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                },
                'location_map': {
                    'realm': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.realm_authentication_unregistered_required_actions_get_endpoint = _Endpoint(
            settings={
                'response_type': ([{str: (bool, date, datetime, dict, float, int, list, str, none_type)}],),
                'auth': [
                    'access_token'
                ],
                'endpoint_path': '/{realm}/authentication/unregistered-required-actions',
                'operation_id': 'realm_authentication_unregistered_required_actions_get',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'realm',
                ],
                'required': [
                    'realm',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'realm':
                        (str,),
                },
                'attribute_map': {
                    'realm': 'realm',
                },
                'location_map': {
                    'realm': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def realm_authentication_authenticator_providers_get(
        self,
        realm,
        **kwargs
    ):
        """Get authenticator providers   Returns a stream of authenticator providers.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_authenticator_providers_get(realm, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        return self.realm_authentication_authenticator_providers_get_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_client_authenticator_providers_get(
        self,
        realm,
        **kwargs
    ):
        """Get client authenticator providers   Returns a stream of client authenticator providers.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_client_authenticator_providers_get(realm, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        return self.realm_authentication_client_authenticator_providers_get_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_config_description_provider_id_get(
        self,
        realm,
        provider_id,
        **kwargs
    ):
        """Get authenticator provider’s configuration description  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_config_description_provider_id_get(realm, provider_id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            provider_id (str):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AuthenticatorConfigInfoRepresentation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['provider_id'] = \
            provider_id
        return self.realm_authentication_config_description_provider_id_get_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_config_id_delete(
        self,
        realm,
        id,
        **kwargs
    ):
        """Delete authenticator configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_config_id_delete(realm, id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): Configuration id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        return self.realm_authentication_config_id_delete_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_config_id_get(
        self,
        realm,
        id,
        **kwargs
    ):
        """Get authenticator configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_config_id_get(realm, id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): Configuration id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AuthenticatorConfigRepresentation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        return self.realm_authentication_config_id_get_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_config_id_put(
        self,
        realm,
        id,
        authenticator_config_representation,
        **kwargs
    ):
        """Update authenticator configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_config_id_put(realm, id, authenticator_config_representation, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): Configuration id
            authenticator_config_representation (AuthenticatorConfigRepresentation): JSON describing new state of authenticator configuration

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        kwargs['authenticator_config_representation'] = \
            authenticator_config_representation
        return self.realm_authentication_config_id_put_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_executions_execution_id_config_post(
        self,
        realm,
        execution_id,
        authenticator_config_representation,
        **kwargs
    ):
        """Update execution with new configuration  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_executions_execution_id_config_post(realm, execution_id, authenticator_config_representation, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            execution_id (str): Execution id
            authenticator_config_representation (AuthenticatorConfigRepresentation): JSON with new configuration

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['execution_id'] = \
            execution_id
        kwargs['authenticator_config_representation'] = \
            authenticator_config_representation
        return self.realm_authentication_executions_execution_id_config_post_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_executions_execution_id_delete(
        self,
        realm,
        execution_id,
        **kwargs
    ):
        """Delete execution  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_executions_execution_id_delete(realm, execution_id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            execution_id (str): Execution id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['execution_id'] = \
            execution_id
        return self.realm_authentication_executions_execution_id_delete_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_executions_execution_id_get(
        self,
        realm,
        execution_id,
        **kwargs
    ):
        """Get Single Execution  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_executions_execution_id_get(realm, execution_id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            execution_id (str): Execution id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['execution_id'] = \
            execution_id
        return self.realm_authentication_executions_execution_id_get_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_executions_execution_id_lower_priority_post(
        self,
        realm,
        execution_id,
        **kwargs
    ):
        """Lower execution’s priority  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_executions_execution_id_lower_priority_post(realm, execution_id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            execution_id (str): Execution id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['execution_id'] = \
            execution_id
        return self.realm_authentication_executions_execution_id_lower_priority_post_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_executions_execution_id_raise_priority_post(
        self,
        realm,
        execution_id,
        **kwargs
    ):
        """Raise execution’s priority  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_executions_execution_id_raise_priority_post(realm, execution_id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            execution_id (str): Execution id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['execution_id'] = \
            execution_id
        return self.realm_authentication_executions_execution_id_raise_priority_post_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_executions_post(
        self,
        realm,
        authentication_execution_representation,
        **kwargs
    ):
        """Add new authentication execution  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_executions_post(realm, authentication_execution_representation, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            authentication_execution_representation (AuthenticationExecutionRepresentation): JSON model describing authentication execution

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['authentication_execution_representation'] = \
            authentication_execution_representation
        return self.realm_authentication_executions_post_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_flows_flow_alias_copy_post(
        self,
        realm,
        flow_alias,
        request_body,
        **kwargs
    ):
        """Copy existing authentication flow under a new name   The new name is given as 'newName' attribute of the passed JSON object  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_flows_flow_alias_copy_post(realm, flow_alias, request_body, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            flow_alias (str): Name of the existing authentication flow
            request_body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): JSON containing 'newName' attribute

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['flow_alias'] = \
            flow_alias
        kwargs['request_body'] = \
            request_body
        return self.realm_authentication_flows_flow_alias_copy_post_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_flows_flow_alias_executions_execution_post(
        self,
        realm,
        flow_alias,
        request_body,
        **kwargs
    ):
        """Add new authentication execution to a flow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_flows_flow_alias_executions_execution_post(realm, flow_alias, request_body, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            flow_alias (str): Alias of parent flow
            request_body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): New execution JSON data containing 'provider' attribute

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['flow_alias'] = \
            flow_alias
        kwargs['request_body'] = \
            request_body
        return self.realm_authentication_flows_flow_alias_executions_execution_post_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_flows_flow_alias_executions_flow_post(
        self,
        realm,
        flow_alias,
        request_body,
        **kwargs
    ):
        """Add new flow with new execution to existing flow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_flows_flow_alias_executions_flow_post(realm, flow_alias, request_body, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            flow_alias (str): Alias of parent authentication flow
            request_body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): New authentication flow / execution JSON data containing 'alias', 'type', 'provider', and 'description' attributes

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['flow_alias'] = \
            flow_alias
        kwargs['request_body'] = \
            request_body
        return self.realm_authentication_flows_flow_alias_executions_flow_post_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_flows_flow_alias_executions_get(
        self,
        realm,
        flow_alias,
        **kwargs
    ):
        """Get authentication executions for a flow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_flows_flow_alias_executions_get(realm, flow_alias, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            flow_alias (str): Flow alias

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['flow_alias'] = \
            flow_alias
        return self.realm_authentication_flows_flow_alias_executions_get_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_flows_flow_alias_executions_put(
        self,
        realm,
        flow_alias,
        authentication_execution_info_representation,
        **kwargs
    ):
        """Update authentication executions of a Flow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_flows_flow_alias_executions_put(realm, flow_alias, authentication_execution_info_representation, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            flow_alias (str): Flow alias
            authentication_execution_info_representation (AuthenticationExecutionInfoRepresentation): AuthenticationExecutionInfoRepresentation

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['flow_alias'] = \
            flow_alias
        kwargs['authentication_execution_info_representation'] = \
            authentication_execution_info_representation
        return self.realm_authentication_flows_flow_alias_executions_put_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_flows_get(
        self,
        realm,
        **kwargs
    ):
        """Get authentication flows   Returns a stream of authentication flows.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_flows_get(realm, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        return self.realm_authentication_flows_get_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_flows_id_delete(
        self,
        realm,
        id,
        **kwargs
    ):
        """Delete an authentication flow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_flows_id_delete(realm, id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): Flow id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        return self.realm_authentication_flows_id_delete_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_flows_id_get(
        self,
        realm,
        id,
        **kwargs
    ):
        """Get authentication flow for id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_flows_id_get(realm, id, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): Flow id

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            AuthenticationFlowRepresentation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        return self.realm_authentication_flows_id_get_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_flows_id_put(
        self,
        realm,
        id,
        authentication_flow_representation,
        **kwargs
    ):
        """Update an authentication flow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_flows_id_put(realm, id, authentication_flow_representation, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            id (str): Flow id
            authentication_flow_representation (AuthenticationFlowRepresentation): Authentication flow representation

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['id'] = \
            id
        kwargs['authentication_flow_representation'] = \
            authentication_flow_representation
        return self.realm_authentication_flows_id_put_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_flows_post(
        self,
        realm,
        authentication_flow_representation,
        **kwargs
    ):
        """Create a new authentication flow  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_flows_post(realm, authentication_flow_representation, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            authentication_flow_representation (AuthenticationFlowRepresentation): Authentication flow representation

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['authentication_flow_representation'] = \
            authentication_flow_representation
        return self.realm_authentication_flows_post_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_form_action_providers_get(
        self,
        realm,
        **kwargs
    ):
        """Get form action providers   Returns a stream of form action providers.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_form_action_providers_get(realm, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        return self.realm_authentication_form_action_providers_get_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_form_providers_get(
        self,
        realm,
        **kwargs
    ):
        """Get form providers   Returns a stream of form providers.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_form_providers_get(realm, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        return self.realm_authentication_form_providers_get_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_per_client_config_description_get(
        self,
        realm,
        **kwargs
    ):
        """Get configuration descriptions for all clients  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_per_client_config_description_get(realm, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            {str: (bool, date, datetime, dict, float, int, list, str, none_type)}
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        return self.realm_authentication_per_client_config_description_get_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_register_required_action_post(
        self,
        realm,
        request_body,
        **kwargs
    ):
        """Register a new required actions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_register_required_action_post(realm, request_body, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            request_body ({str: (bool, date, datetime, dict, float, int, list, str, none_type)}): JSON containing 'providerId', and 'name' attributes.

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['request_body'] = \
            request_body
        return self.realm_authentication_register_required_action_post_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_required_actions_alias_delete(
        self,
        realm,
        alias,
        **kwargs
    ):
        """Delete required action  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_required_actions_alias_delete(realm, alias, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            alias (str): Alias of required action

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['alias'] = \
            alias
        return self.realm_authentication_required_actions_alias_delete_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_required_actions_alias_get(
        self,
        realm,
        alias,
        **kwargs
    ):
        """Get required action for alias  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_required_actions_alias_get(realm, alias, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            alias (str): Alias of required action

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            RequiredActionProviderRepresentation
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['alias'] = \
            alias
        return self.realm_authentication_required_actions_alias_get_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_required_actions_alias_lower_priority_post(
        self,
        realm,
        alias,
        **kwargs
    ):
        """Lower required action’s priority  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_required_actions_alias_lower_priority_post(realm, alias, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            alias (str): Alias of required action

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['alias'] = \
            alias
        return self.realm_authentication_required_actions_alias_lower_priority_post_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_required_actions_alias_put(
        self,
        realm,
        alias,
        required_action_provider_representation,
        **kwargs
    ):
        """Update required action  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_required_actions_alias_put(realm, alias, required_action_provider_representation, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            alias (str): Alias of required action
            required_action_provider_representation (RequiredActionProviderRepresentation): JSON describing new state of required action

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['alias'] = \
            alias
        kwargs['required_action_provider_representation'] = \
            required_action_provider_representation
        return self.realm_authentication_required_actions_alias_put_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_required_actions_alias_raise_priority_post(
        self,
        realm,
        alias,
        **kwargs
    ):
        """Raise required action’s priority  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_required_actions_alias_raise_priority_post(realm, alias, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)
            alias (str): Alias of required action

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            None
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        kwargs['alias'] = \
            alias
        return self.realm_authentication_required_actions_alias_raise_priority_post_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_required_actions_get(
        self,
        realm,
        **kwargs
    ):
        """Get required actions   Returns a stream of required actions.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_required_actions_get(realm, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        return self.realm_authentication_required_actions_get_endpoint.call_with_http_info(**kwargs)

    def realm_authentication_unregistered_required_actions_get(
        self,
        realm,
        **kwargs
    ):
        """Get unregistered required actions   Returns a stream of unregistered required actions.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.realm_authentication_unregistered_required_actions_get(realm, async_req=True)
        >>> result = thread.get()

        Args:
            realm (str): realm name (not id!)

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            [{str: (bool, date, datetime, dict, float, int, list, str, none_type)}]
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_spec_property_naming'] = kwargs.get(
            '_spec_property_naming', False
        )
        kwargs['_content_type'] = kwargs.get(
            '_content_type')
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['_request_auths'] = kwargs.get('_request_auths', None)
        kwargs['realm'] = \
            realm
        return self.realm_authentication_unregistered_required_actions_get_endpoint.call_with_http_info(**kwargs)

